package WebService::Async::Onfido::Base::Check;

use strict;
use warnings;

use utf8;

our $VERSION = '0.007';    # VERSION

=head1 NAME

WebService::Async::Onfido::Base::Check - represents data for Onfido

=head1 DESCRIPTION

This is autogenerated from the documentation in L<https://documentation.onfido.com>.

=cut

sub new {
    my ($class, %args) = @_;
    Scalar::Util::weaken($args{onfido}) if $args{onfido};
    return bless \%args, $class;
}

=head1 METHODS
=head2 id

The unique identifier for the check..

=cut

sub id : method { return shift->{id} }

=head2 created_at

The date and time at which the check was initiated..

=cut

sub created_at : method { return shift->{created_at} }

=head2 href

The API endpoint to retrieve the check..

=cut

sub href : method { return shift->{href} }

=head2 status

The current state of the check in the checking process..

=cut

sub status : method { return shift->{status} }

=head2 tags

A list of tags associated with this check..

=cut

sub tags : method { return shift->{tags} }

=head2 result

The overall result of the check, based on the results of the constituent reports..

=cut

sub result : method { return shift->{result} }

=head2 download_uri

A link to a PDF output of the check results. Append .pdf to get the pdf file..

Since v3 this PDF is meant to be downloaded from the API.

=cut

sub download_uri : method {
    my $self = shift;

    return $self->onfido->endpoint('check_download', check_id => $self->id);
}

=head2 form_uri

A link to the applicant form, if the check is of type standard.

=cut

sub form_uri : method { return shift->{form_uri} }

=head2 redirect_uri

For standard checks, redirect to this URI when the applicant has submitted their data..

=cut

sub redirect_uri : method { return shift->{redirect_uri} }

=head2 results_uri

A link to the corresponding results page on the Onfido dashboard.

=cut

sub results_uri : method { return shift->{results_uri} }

=head2 reports_ids

The list of report ids associated with the check..

=cut

sub reports_ids : method { return shift->{reports_ids} }

=head2 applicant_id

The applicant the check belongs to

=cut

sub applicant_id : method { return shift->{applicant_id} }

1;

__END__

=head1 AUTHOR

deriv.com C<< DERIV@cpan.org >>

=head1 LICENSE

Copyright deriv.com 2019. Licensed under the same terms as Perl itself.

