package Test::MethodFixtures::Storage::File;

use strict;
use warnings;
use Carp;

our $VERSION = '0.04';

use Carp;
use Data::Dump qw( dump );
use Digest::MD5 qw( md5_hex );
use Path::Tiny;

use base 'Test::MethodFixtures::Storage';

__PACKAGE__->mk_accessors(qw/ dir /);

sub new {
    my ( $class, $args ) = @_;

    $args ||= {};
    $args->{dir} ||= 't/.methodfixtures';

    croak "Unable to access " . $args->{dir}
        unless -d $args->{dir} && -w $args->{dir};

    return $class->SUPER::new($args);
}

sub store {
    my ( $self, $args ) = @_;

    my $method = delete $args->{method};
    my $key    = delete $args->{key};

    # for now only store on disk
    my $storage = path( $self->dir, $method );
    $storage->mkpath;
    $storage->child( $self->filename($key) )->spew_utf8( dump $args );

    return $self;
}

sub retrieve {
    my ( $self, $args ) = @_;

    my $method = $args->{method};
    my $key    = $args->{key};

    my $storage = path( $self->dir, $method )->child( $self->filename($key) );
    return unless $storage->is_file;

    my $data = eval $storage->slurp_utf8();;

    return $data;
}

sub filename {
    my $self = shift;
    return md5_hex dump shift;
}

1;

__END__

=pod

=head1 NAME

Test::MethodFixtures::Storage::File - Simple file storage for method mocking with Test::MethodFixtures

=head1 SYNOPSIS

    my $storage = Test::MethodFixtures::Storage::File->new(
        {   dir => 't/.methodfixtures'    # default
        }
    );

=head1 DESCRIPTION

Subclass of L<Test::MethodFixtures::Storage>. Implements C<store> and C<retrieve>

=head1 METHODS

=head2 store

=head2 retrieve

=cut

