/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.sis.util.ArraysExt;

public abstract class SetOfUnknownSize<E>
extends AbstractSet<E> {
    protected SetOfUnknownSize() {
    }

    protected boolean isSizeKnown() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.isSizeKnown() ? super.isEmpty() : !this.iterator().hasNext();
    }

    @Override
    public int size() {
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            if (++n != Integer.MAX_VALUE) continue;
            break;
        }
        return n;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.remove(iterator.next());
        }
        return bl;
    }

    @Override
    public Object[] toArray() {
        return this.isSizeKnown() ? super.toArray() : this.toArray(new Object[32], true);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.isSizeKnown() ? super.toArray(TArray) : this.toArray(TArray, false);
    }

    private <T> T[] toArray(T[] TArray, boolean bl) {
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (n >= TArray.length) {
                if (n >= 0x3FFFFFFF) {
                    throw new OutOfMemoryError("Required array size too large");
                }
                TArray = Arrays.copyOf(TArray, Math.max(16, TArray.length) << 1);
                bl = true;
            }
            TArray[n++] = iterator.next();
        }
        if (bl) {
            TArray = ArraysExt.resize(TArray, n);
        } else {
            Arrays.fill(TArray, n, TArray.length, null);
        }
        return TArray;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!set.contains(iterator.next())) {
                return false;
            }
            ++n;
        }
        return n == set.size();
    }
}

