/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.metadata.NameMeaning;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.AuthorityFactories;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.Properties;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.NoSuchAuthorityFactoryException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;

public final class IdentifiedObjects
extends Static {
    private IdentifiedObjects() {
    }

    public static Map<String, ?> getProperties(IdentifiedObject identifiedObject, String ... stringArray) {
        ArgumentChecks.ensureNonNull("object", identifiedObject);
        ArgumentChecks.ensureNonNull("excludes", stringArray);
        return new Properties(identifiedObject, stringArray);
    }

    public static Set<String> getNames(IdentifiedObject identifiedObject, Citation citation) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(8);
        IdentifiedObjects.getName(identifiedObject, citation, linkedHashSet);
        return linkedHashSet;
    }

    public static String getName(IdentifiedObject identifiedObject, Citation citation) {
        return IdentifiedObjects.getName(identifiedObject, citation, null);
    }

    private static String getName(IdentifiedObject identifiedObject, Citation citation, Collection<String> collection) {
        block11: {
            Object object;
            Identifier identifier;
            block12: {
                Object object2;
                if (identifiedObject == null) break block11;
                identifier = identifiedObject.getName();
                if (citation != null) break block12;
                if (identifier != null && (object2 = identifier.getCode()) != null) {
                    if (collection == null) {
                        return object2;
                    }
                    collection.add((String)object2);
                }
                if ((object2 = Citations.iterator(identifiedObject.getAlias())) == null) break block11;
                while (object2.hasNext()) {
                    String string;
                    GenericName genericName = (GenericName)object2.next();
                    if (genericName == null || (string = genericName instanceof Identifier ? ((Identifier)((Object)genericName)).getCode() : genericName.toString()) == null) continue;
                    if (collection == null) {
                        return string;
                    }
                    collection.add(string);
                }
                break block11;
            }
            if (identifier != null && Citations.identifierMatches(citation, identifier.getAuthority()) && (object = identifier.getCode()) != null) {
                if (collection == null) {
                    return object;
                }
                collection.add((String)object);
            }
            if ((object = Citations.iterator(identifiedObject.getAlias())) != null) {
                while (object.hasNext()) {
                    String string;
                    GenericName genericName;
                    Object object3;
                    GenericName genericName2 = (GenericName)object.next();
                    if (genericName2 == null) continue;
                    if (genericName2 instanceof Identifier) {
                        identifier = (Identifier)((Object)genericName2);
                        if (!Citations.identifierMatches(citation, identifier.getAuthority()) || (object3 = identifier.getCode()) == null) continue;
                        if (collection == null) {
                            return object3;
                        }
                        collection.add((String)object3);
                        continue;
                    }
                    object3 = genericName2.scope();
                    if (object3 == null || (genericName = object3.name()) == null || !Citations.identifierMatches(citation, null, genericName.toString()) || (string = genericName2.toString()) == null) continue;
                    if (collection == null) {
                        return string;
                    }
                    collection.add(string);
                }
            }
        }
        return null;
    }

    public static Identifier getIdentifier(IdentifiedObject identifiedObject, Citation citation) {
        Iterator<ReferenceIdentifier> iterator;
        if (identifiedObject != null && (iterator = Citations.iterator(identifiedObject.getIdentifiers())) != null) {
            while (iterator.hasNext()) {
                Identifier identifier = iterator.next();
                if (identifier == null || citation != null && !Citations.identifierMatches(citation, identifier.getAuthority())) continue;
                return identifier;
            }
        }
        return null;
    }

    public static String getIdentifierOrName(IdentifiedObject identifiedObject) {
        if (identifiedObject != null) {
            String string;
            Iterator<ReferenceIdentifier> iterator = Citations.iterator(identifiedObject.getIdentifiers());
            if (iterator != null) {
                while (iterator.hasNext()) {
                    string = IdentifiedObjects.toString(iterator.next());
                    if (string == null) continue;
                    return string;
                }
            }
            if ((string = IdentifiedObjects.toString(identifiedObject.getName())) != null) {
                return string;
            }
        }
        return null;
    }

    public static String getUnicodeIdentifier(IdentifiedObject identifiedObject) {
        if (identifiedObject != null) {
            String string;
            Object object;
            Iterator<GenericName> iterator;
            Identifier identifier = identifiedObject.getName();
            if (identifier != null && CharSequences.isUnicodeIdentifier((CharSequence)((Object)(iterator = identifier.getCode())))) {
                return iterator;
            }
            iterator = Citations.iterator(identifiedObject.getAlias());
            if (iterator != null) {
                while (iterator.hasNext()) {
                    object = (GenericName)iterator.next();
                    if (object == null || (object = object.tip()) == null || !CharSequences.isUnicodeIdentifier(string = object.toString())) continue;
                    return string;
                }
            }
            if ((object = Citations.iterator(identifiedObject.getIdentifiers())) != null) {
                while (object.hasNext()) {
                    identifier = (Identifier)object.next();
                    if (identifier == null || !CharSequences.isUnicodeIdentifier(string = identifier.getCode())) continue;
                    return string;
                }
            }
        }
        return null;
    }

    public static String lookupURN(IdentifiedObject identifiedObject, Citation citation) throws FactoryException {
        List<IdentifiedObject> list;
        IdentifiedObjectFinder identifiedObjectFinder;
        if (identifiedObject == null) {
            return null;
        }
        try {
            identifiedObjectFinder = IdentifiedObjects.newFinder(org.apache.sis.metadata.iso.citation.Citations.getCodeSpace(citation));
        }
        catch (NoSuchAuthorityFactoryException noSuchAuthorityFactoryException) {
            IdentifiedObjects.warning("lookupURN", noSuchAuthorityFactoryException);
            identifiedObjectFinder = IdentifiedObjects.newFinder(null);
        }
        String string = IdentifiedObjects.lookupURN(identifiedObject, citation, identifiedObjectFinder);
        if (string != null) {
            return string;
        }
        if (identifiedObject instanceof CompoundCRS) {
            list = CRS.getSingleComponents((CompoundCRS)identifiedObject);
        } else if (identifiedObject instanceof ConcatenatedOperation) {
            list = ((ConcatenatedOperation)identifiedObject).getOperations();
        } else {
            return null;
        }
        StringBuilder stringBuilder = null;
        for (IdentifiedObject identifiedObject2 : list) {
            string = IdentifiedObjects.lookupURN(identifiedObject2, citation, identifiedObjectFinder);
            if (string == null) {
                return null;
            }
            assert (string.startsWith("urn:ogc:def")) : string;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(40).append("urn:ogc:def").append(':').append(NameMeaning.toObjectType(identifiedObject.getClass()));
            }
            stringBuilder.append(',').append(string, "urn:ogc:def".length() + 1, string.length());
        }
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    private static String lookupURN(IdentifiedObject identifiedObject, Citation citation, IdentifiedObjectFinder identifiedObjectFinder) throws FactoryException {
        String string = null;
        if (identifiedObject != null) {
            for (IdentifiedObject identifiedObject2 : identifiedObjectFinder.find(identifiedObject)) {
                String string2 = IdentifiedObjects.toURN(identifiedObject2.getClass(), IdentifiedObjects.getIdentifier(identifiedObject2, citation));
                if (string2 == null && citation == null) {
                    for (Identifier identifier : identifiedObject2.getIdentifiers()) {
                        string2 = IdentifiedObjects.toURN(identifiedObject2.getClass(), identifier);
                        if (string2 == null) continue;
                        break;
                    }
                }
                if (string2 == null) continue;
                if (string != null && !string.equals(string2)) {
                    return null;
                }
                string = string2;
            }
        }
        return string;
    }

    public static Integer lookupEPSG(IdentifiedObject identifiedObject) throws FactoryException {
        Integer n = null;
        if (identifiedObject != null) {
            for (IdentifiedObject identifiedObject2 : IdentifiedObjects.newFinder("EPSG").find(identifiedObject)) {
                Identifier identifier = IdentifiedObjects.getIdentifier(identifiedObject2, org.apache.sis.metadata.iso.citation.Citations.EPSG);
                if (identifier == null) continue;
                try {
                    Integer n2 = n;
                    n = Integer.valueOf(identifier.getCode());
                    if (n2 == null || n2.equals(n)) continue;
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    IdentifiedObjects.warning("lookupEPSG", numberFormatException);
                }
            }
        }
        return n;
    }

    private static void warning(String string, Exception exception) {
        Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing"), IdentifiedObjects.class, string, exception);
    }

    public static IdentifiedObjectFinder newFinder(String string) throws NoSuchAuthorityFactoryException, FactoryException {
        GeodeticAuthorityFactory geodeticAuthorityFactory = string == null ? AuthorityFactories.ALL : AuthorityFactories.ALL.getAuthorityFactory(GeodeticAuthorityFactory.class, string, null);
        return ((GeodeticAuthorityFactory)geodeticAuthorityFactory).newIdentifiedObjectFinder();
    }

    public static boolean isHeuristicMatchForName(IdentifiedObject identifiedObject, String string) {
        ArgumentChecks.ensureNonNull("name", string);
        if (identifiedObject == null) {
            return false;
        }
        if (identifiedObject instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)identifiedObject).isHeuristicMatchForName(string);
        }
        return NameToIdentifier.isHeuristicMatchForName(identifiedObject.getName(), identifiedObject.getAlias(), string, NameToIdentifier.Simplifier.DEFAULT);
    }

    public static String toURN(Class<?> clazz, Identifier identifier) {
        ArgumentChecks.ensureNonNull("type", clazz);
        if (identifier == null) {
            return null;
        }
        String string = null;
        if (identifier instanceof ReferenceIdentifier) {
            string = ((ReferenceIdentifier)identifier).getCodeSpace();
        }
        if (string == null || string.isEmpty()) {
            string = Citations.getIdentifier(identifier.getAuthority(), true);
        }
        return NameMeaning.toURN(clazz, string, identifier instanceof ReferenceIdentifier ? ((ReferenceIdentifier)identifier).getVersion() : null, identifier.getCode());
    }

    public static String toString(Identifier identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier instanceof GenericName) {
            return identifier.toString();
        }
        String string = identifier.getCode();
        String string2 = null;
        if (identifier instanceof ReferenceIdentifier) {
            string2 = ((ReferenceIdentifier)identifier).getCodeSpace();
        }
        if (string2 == null || string2.isEmpty()) {
            string2 = Citations.getIdentifier(identifier.getAuthority(), true);
        }
        if (string2 != null) {
            return string2 + ':' + string;
        }
        return string;
    }
}

