/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2;

import java.io.EOFException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.jbig2.JBIG2Globals;
import org.apache.pdfbox.jbig2.JBIG2Page;
import org.apache.pdfbox.jbig2.SegmentHeader;
import org.apache.pdfbox.jbig2.io.SubInputStream;
import org.apache.pdfbox.jbig2.util.log.Logger;
import org.apache.pdfbox.jbig2.util.log.LoggerFactory;

class JBIG2Document {
    private static final Logger log = LoggerFactory.getLogger(JBIG2Document.class);
    private int[] FILE_HEADER_ID = new int[]{151, 74, 66, 50, 13, 10, 26, 10};
    private final Map<Integer, JBIG2Page> pages = new TreeMap<Integer, JBIG2Page>();
    private short fileHeaderLength = (short)9;
    private short organisationType = 1;
    public static final int RANDOM = 0;
    public static final int SEQUENTIAL = 1;
    private boolean amountOfPagesUnknown = true;
    private int amountOfPages;
    private boolean gbUseExtTemplate;
    private final SubInputStream subInputStream;
    private JBIG2Globals globalSegments;

    protected JBIG2Document(ImageInputStream imageInputStream) throws IOException {
        this(imageInputStream, null);
    }

    protected JBIG2Document(ImageInputStream imageInputStream, JBIG2Globals jBIG2Globals) throws IOException {
        if (imageInputStream == null) {
            throw new IllegalArgumentException("imageInputStream must not be null");
        }
        this.subInputStream = new SubInputStream(imageInputStream, 0L, Long.MAX_VALUE);
        this.globalSegments = jBIG2Globals;
        this.mapStream();
    }

    SegmentHeader getGlobalSegment(int n) {
        if (null != this.globalSegments) {
            return this.globalSegments.getSegment(n);
        }
        if (log.isErrorEnabled()) {
            log.error("Segment not found. Returning null.");
        }
        return null;
    }

    protected JBIG2Page getPage(int n) {
        return this.pages.get(n);
    }

    protected int getAmountOfPages() throws IOException {
        if (this.amountOfPagesUnknown || this.amountOfPages == 0) {
            if (this.pages.size() == 0) {
                this.mapStream();
            }
            return this.pages.size();
        }
        return this.amountOfPages;
    }

    private void mapStream() throws IOException {
        LinkedList<SegmentHeader> linkedList = new LinkedList<SegmentHeader>();
        long l = 0L;
        int n = 0;
        if (this.isFileHeaderPresent()) {
            this.parseFileHeader();
            l += (long)this.fileHeaderLength;
        }
        if (this.globalSegments == null) {
            this.globalSegments = new JBIG2Globals();
        }
        JBIG2Page jBIG2Page = null;
        while (n != 51 && !this.reachedEndOfStream(l)) {
            SegmentHeader segmentHeader = new SegmentHeader(this, this.subInputStream, l, this.organisationType);
            int n2 = segmentHeader.getPageAssociation();
            n = segmentHeader.getSegmentType();
            if (n2 != 0) {
                jBIG2Page = this.getPage(n2);
                if (jBIG2Page == null) {
                    jBIG2Page = new JBIG2Page(this, n2);
                    this.pages.put(n2, jBIG2Page);
                }
                jBIG2Page.add(segmentHeader);
            } else {
                this.globalSegments.addSegment(segmentHeader.getSegmentNr(), segmentHeader);
            }
            linkedList.add(segmentHeader);
            l = this.subInputStream.getStreamPosition();
            if (this.organisationType != 1) continue;
            l += segmentHeader.getSegmentDataLength();
        }
        this.determineRandomDataOffsets(linkedList, l);
    }

    private boolean isFileHeaderPresent() throws IOException {
        SubInputStream subInputStream = this.subInputStream;
        subInputStream.mark();
        for (int n : this.FILE_HEADER_ID) {
            if (n == subInputStream.read()) continue;
            subInputStream.reset();
            return false;
        }
        subInputStream.reset();
        return true;
    }

    private void determineRandomDataOffsets(List<SegmentHeader> list, long l) {
        if (this.organisationType == 0) {
            for (SegmentHeader segmentHeader : list) {
                segmentHeader.setSegmentDataStartOffset(l);
                l += segmentHeader.getSegmentDataLength();
            }
        }
    }

    private void parseFileHeader() throws IOException {
        this.subInputStream.seek(0L);
        this.subInputStream.skipBytes(8);
        this.subInputStream.readBits(5);
        if (this.subInputStream.readBit() == 1) {
            this.gbUseExtTemplate = true;
        }
        if (this.subInputStream.readBit() != 1) {
            this.amountOfPagesUnknown = false;
        }
        this.organisationType = (short)this.subInputStream.readBit();
        if (!this.amountOfPagesUnknown) {
            this.amountOfPages = (int)this.subInputStream.readUnsignedInt();
            this.fileHeaderLength = (short)13;
        }
    }

    private boolean reachedEndOfStream(long l) throws IOException {
        try {
            this.subInputStream.seek(l);
            this.subInputStream.readBits(32);
            return false;
        }
        catch (EOFException eOFException) {
            return true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return true;
        }
    }

    protected JBIG2Globals getGlobalSegments() {
        return this.globalSegments;
    }

    protected boolean isAmountOfPagesUnknown() {
        return this.amountOfPagesUnknown;
    }

    boolean isGbUseExtTemplate() {
        return this.gbUseExtTemplate;
    }
}

