package WebService::Mattermost::V4::API::Object::Role::Props;

# ABSTRACT: Adds a "props" field to an object.

use Moo::Role;
use Types::Standard qw(HashRef Maybe);

################################################################################

has props => (is => 'ro', isa => Maybe[HashRef], lazy => 1, builder => 1);

################################################################################

sub _build_props {
    my $self = shift;

    return $self->raw_data->{props};
}

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Object::Role::Props - Adds a "props" field to an object.

=head1 VERSION

version 0.31

=head1 DESCRIPTION

Attach a props HashRef to a v4::Object object.

=head2 ATTRIBUTES

=over 4

=item C<props>

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2023 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
