#!/usr/bin/perl

package eBay::API::XML::Call::GetPictureManagerDetails::GetPictureManagerDetailsRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetPictureManagerDetailsRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetPictureManagerDetails::GetPictureManagerDetailsRequestType

=head1 DESCRIPTION

Requests information about folders or pictures in a Picture Manager account
or the account settings.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetPictureManagerDetails::GetPictureManagerDetailsRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::Enum::PictureManagerDetailLevelCodeType;


my @gaProperties = ( [ 'FolderID', 'xs:int', '', '', '' ]
	, [ 'PictureManagerDetailLevel', 'ns:PictureManagerDetailLevelCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::PictureManagerDetailLevelCodeType', '' ]
	, [ 'PictureURL', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setFolderID()

The ID of a folder in the user's Picture Manager album for which you want information.
If you specify both FolderID and PictureURL, the picture must exist
in the folder.

  RequiredInput: No
#    Argument: 'xs:int'

=cut

sub setFolderID {
  my $self = shift;
  $self->{'FolderID'} = shift
}

=head2 getFolderID()

#    Returns: 'xs:int'

=cut

sub getFolderID {
  my $self = shift;
  return $self->{'FolderID'};
}


=head2 setPictureManagerDetailLevel()

The type of information you want returned, about pictures and folders,
the account subscription, or both. Use this element rather than the generic DetailLevel element defined in AbstractRequestType. You can use the following values: ReturnAll, ReturnSubscription, or ReturnPicture.

PresentDetails: Yes

  RequiredInput: No
#    Argument: 'ns:PictureManagerDetailLevelCodeType'

=cut

sub setPictureManagerDetailLevel {
  my $self = shift;
  $self->{'PictureManagerDetailLevel'} = shift
}

=head2 getPictureManagerDetailLevel()

#    Returns: 'ns:PictureManagerDetailLevelCodeType'

=cut

sub getPictureManagerDetailLevel {
  my $self = shift;
  return $self->{'PictureManagerDetailLevel'};
}


=head2 setPictureURL()

The URL of a picture in the user's Picture Manager album.
If you specify both FolderID and PictureURL, the picture must
exist in the folder.

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setPictureURL {
  my $self = shift;
  $self->{'PictureURL'} = shift
}

=head2 getPictureURL()

#    Returns: 'xs:string'

=cut

sub getPictureURL {
  my $self = shift;
  return $self->{'PictureURL'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
