use 5.012003;
use ExtUtils::MakeMaker;
use ExtUtils::Constant 0.23 'WriteConstants';

my $gcc = system("gcc --print-file-name=");

WriteMakefile(
    NAME              => 'sparse',
    VERSION_FROM      => 'lib/sparse.pm', # finds $VERSION
    PREREQ_PM         => {}, # e.g., Module::Name => 1.1
    ($] >= 5.005 ?
      (ABSTRACT_FROM  => 'lib/sparse.pm', # retrieve abstract from module
       AUTHOR         => 'Konrad Eisele <eiselekd@gmail.com>') : ()),
    LICENSE  => ['perl','BSD' ],
    LIBS              => ['-L./src/sparse-0.4.4 '], # e.g., '-lm'
    DEFINE            => '-DGCC_BASE="\"'.$gcc.'\""',
    INC               => '-I. -Isrc/sparse-0.4.4', 
    OBJECT            => 'sparse.o src/sparse-0.4.4/libsparse.a', # link all the C files too
    realclean         => {FILES=> 'const-c.inc const-xs.inc'},
);

my @names =
  (
   qw(
	TOKEN_EOF
	TOKEN_ERROR
	TOKEN_IDENT
	TOKEN_ZERO_IDENT
	TOKEN_NUMBER
	TOKEN_CHAR
	TOKEN_CHAR_EMBEDDED_0
	TOKEN_CHAR_EMBEDDED_1
	TOKEN_CHAR_EMBEDDED_2
	TOKEN_CHAR_EMBEDDED_3
	TOKEN_WIDE_CHAR
	TOKEN_WIDE_CHAR_EMBEDDED_0
	TOKEN_WIDE_CHAR_EMBEDDED_1
	TOKEN_WIDE_CHAR_EMBEDDED_2
	TOKEN_WIDE_CHAR_EMBEDDED_3
	TOKEN_STRING
	TOKEN_WIDE_STRING
	TOKEN_SPECIAL
	TOKEN_STREAMBEGIN
	TOKEN_STREAMEND
	TOKEN_MACRO_ARGUMENT
	TOKEN_STR_ARGUMENT
	TOKEN_QUOTED_ARGUMENT
	TOKEN_CONCAT
	TOKEN_GNU_KLUDGE
	TOKEN_UNTAINT
	TOKEN_ARG_COUNT
	TOKEN_IF
	TOKEN_SKIP_GROUPS
	TOKEN_ELSE

	SPECIAL_BASE
	SPECIAL_ADD_ASSIGN
	SPECIAL_INCREMENT
	SPECIAL_SUB_ASSIGN
	SPECIAL_DECREMENT
	SPECIAL_DEREFERENCE
	SPECIAL_MUL_ASSIGN
	SPECIAL_DIV_ASSIGN
	SPECIAL_MOD_ASSIGN
	SPECIAL_LTE
	SPECIAL_GTE
	SPECIAL_EQUAL
	SPECIAL_NOTEQUAL
	SPECIAL_LOGICAL_AND
	SPECIAL_AND_ASSIGN
	SPECIAL_LOGICAL_OR
	SPECIAL_OR_ASSIGN
	SPECIAL_XOR_ASSIGN
	SPECIAL_HASHHASH
	SPECIAL_LEFTSHIFT
	SPECIAL_RIGHTSHIFT
	SPECIAL_DOTDOT
	SPECIAL_SHL_ASSIGN
	SPECIAL_SHR_ASSIGN
	SPECIAL_ELLIPSIS
	SPECIAL_ARG_SEPARATOR
	SPECIAL_UNSIGNED_LT
	SPECIAL_UNSIGNED_GT
	SPECIAL_UNSIGNED_LTE
	SPECIAL_UNSIGNED_GTE

	EXPANSION_CMDLINE
	EXPANSION_STREAM
	EXPANSION_MACRO
	EXPANSION_MACROARG
	EXPANSION_CONCAT
	EXPANSION_PREPRO

        CONSTANT_FILE_MAYBE
        CONSTANT_FILE_IFNDEF
        CONSTANT_FILE_NOPE
        CONSTANT_FILE_YES
      )
  );

WriteConstants(
    DEFAULT_TYPE => 'IV',
    NAME => 'sparse',
    NAMES => \@names,
);
