use v6.d;
use Test;

use FileSystem::Parent;

my $verbose 
= %*ENV< VERBOSE > 
?? True 
!! False
;

my $append  = 'lib';
my $filter  = 'dir';

my $pass0  = scan-up :$verbose, :$filter, :$append, :!skip-root;
ok $pass0,  'scan-up with want dir';

my $pass1  = scan-up :$verbose  :$filter, :$append, :skip-root;
ok $pass1,  'scan-up with want dir and start';

my @include   = $pass0.eager;
my @exclude   = $pass1.eager;

put "# include:\t", @include;
put "# exclude:\t", @exclude;

ok @include[0] = @exclude[0], 'Same start directory.';
ok 1 == @include - @exclude,  'Include one more.';

done-testing;
