use v6.d;
use Test;

  
ok !  MY::<&Bin>     , 'Bin not installed before use.';
ok !  MY::<&Script>  , 'Script not installed before use.';

ok ! MY::<_FindBin_RESOLVE-DEF>, '_FindBin_RESOLVE-DEF false before use.';
ok ! MY::<_FindBin_VERBOSE-DEF>, '_FindBin_VERBOSE-DEF false before use.';

do
{
    note '# FindBin';
   
    use FindBin;

    ok   MY::<&Bin>     , 'Bin installed by default.';
    ok   MY::<&Script>  , 'Script installed by default.';

    ok ! MY::<_FindBin_RESOLVE-DEF>, '_FindBin_RESOLVE-DEF false by default.';
    ok ! MY::<_FindBin_VERBOSE-DEF>, '_FindBin_VERBOSE-DEF false by default.';

    note '# Bin is:    ' ~ Bin;
    note '# Script is: ' ~ Script;
};
    
ok ! MY::<&Bin>     , 'Bin is lexicaly scoped.';
ok ! MY::<&Script>  , 'Script is lexicaly scoped.';

ok ! MY::<_FindBin_RESOLVE-DEF>, 'Resolve is lexically scoped.';
ok ! MY::<_FindBin_VERBOSE-DEF>, 'Verbose is lexically scoped.';

do
{
    note '# FindBin :Bin';

    use FindBin :Bin;

    ok   MY::<&Bin>     , 'Bin installed.';
    ok ! MY::<&Script>  , 'Script not installed.';

    ok ! MY::<_FindBin_RESOLVE-DEF>,   'Resolve not installed';
    ok ! MY::<_FindBin_VERBOSE-DEF>,   'Verbose not installed';

    note '# Bin is:    ' ~ Bin;
};

do
{
    note '# FindBin :Script ';
   
    use FindBin :Script;

    ok ! MY::<&Bin>     , 'Bin not installed.';
    ok   MY::<&Script>  , 'Script installed.';

    ok ! MY::<_FindBin_RESOLVE-DEF>,   'Resolve not installed';
    ok ! MY::<_FindBin_VERBOSE-DEF>,   'Verbose not installed';

    note '# Script is: ' ~ Script;
};

do
{
    note '# FindBin :resolve, :verbose';
   
    use FindBin :resolve, :verbose;

    ok   MY::<&Bin>     , 'Bin installed with :resolve :verboose.';
    ok   MY::<&Script>  , 'Script installed with :resolve :verboose.';

    ok   MY::<_FindBin_RESOLVE-DEF>, 'Resolve is true.';
    ok   MY::<_FindBin_VERBOSE-DEF>, 'Verbose is true.';

    note '# Bin is:    ' ~ Bin;
    note '# Script is: ' ~ Script;
};


do
{
    note '# FindBin :verbose';

    use FindBin :verbose;

    ok   MY::<&Bin>     , 'Bin installed.';
    ok   MY::<&Script>  , 'Script not installed.';

    ok ! MY::<_FindBin_RESOLVE-DEF>,   'Resolve not installed';
    ok   MY::<_FindBin_VERBOSE-DEF>,   'Verbose installed';
};

do
{
    note 'FindBin :resolve';

    use FindBin :resolve;

    ok   MY::<&Bin>     , 'Bin installed.';
    ok   MY::<&Script>  , 'Script not installed.';

    ok   MY::<_FindBin_RESOLVE-DEF>,   'Resolve not installed';
    ok ! MY::<_FindBin_VERBOSE-DEF>,   'Verbose installed';
};

ok ! MY::<&Bin>     , 'Bin is lexicaly scoped.';
ok ! MY::<&Script>  , 'Script is lexicaly scoped.';

ok ! MY::<_FindBin_RESOLVE-DEF>,   'Resolve not installed globally';
ok ! MY::<_FindBin_VERBOSE-DEF>,   'Verbose not installed globally';

done-testing;
