use v6.d;
use Test;

use FindBin::Dirs;

my $verbose 
= %*ENV< VERBOSE > 
?? True 
!! False
;

my $pick_all    := -> IO $path { True };

my $append  = 'lib';

my $pass0   = Dirs :$verbose, filter => $pick_all;
ok $pass0,   'Dirs with filter';

my $pass1   = Dirs :$verbose, filter => $pick_all, :start( $*PROGRAM-NAME );
ok $pass1,   'Dirs with filter and start';

put '# Pass0', $pass0;
put '# Pass1', $pass1;

ok $pass0 ~~ $pass1, 'Bin and $*Program-Name return same list.';

done-testing;
