use v6.d;

# CompUnit::RepositoryRegistray is built-in,
# no need to "use" it.

sub EXPORT
(
    Bool()  :$resolve   = False,
    Bool()  :$verbose   = False
    --> Map
)
{
    use FileSystem::Parent;

    my %fixed   =
    (
        append      => 'lib',
        filter      => 'dir',
        skip-root   => True
    );

    my @found   
    = scan-up( :$resolve, :$verbose, |%fixed ).reverse;

    for @found -> $prefix
    {
        CompUnit::RepositoryRegistry.use-repository:
            CompUnit::Repository::FileSystem.new:
                :$prefix
    }

    # caller can look up what's there.

   %( '@FindBin-libs-installed-dirs' => @found )
}

unit module FindBin::libs:ver<0.1.2>:auth<CPAN:lembark>;
