use strict;
use warnings;
use lib 't/lib';
use File::chdir;
use Test::Bif;
use Test::Fatal;
use Test::More;

run_in_tempdir {

    isa_ok exception { bif(qw/pull hub/) }, 'OptArgs::Usage';

    isa_ok exception { bif(qw/pull hub hub.bifhub/) },
      'Bif::Error::UserRepoNotFound';

    bif(qw/init/);
    isa_ok exception { bif(qw/pull hub hub.bifhub/) },
      'Bif::Error::HubNotFound';

    bif(qw/init hub/);
    isa_ok bif(qw/pull hub hub.bifhub/), 'Bif::OK::PullHub';
    isa_ok bif(qw/pull hub hub.bifhub/), 'Bif::OK::PullHub';

    bifcheck;
};

# Check that we can pull two hubs with projects

run_in_tempdir {

    bif(qw/init hub/);
    hub(qw!new project hub.bifhub/a title -m m1!);

    bif(qw/init hub2/);
    hub2(qw!new project hub2.bifhub/a title -m m1!);

    bif(qw/init/);

    isa_ok bif(qw/pull hub hub.bifhub/),       'Bif::OK::PullHub';
    isa_ok bif(qw!show project hub.bifhub/a!), 'Bif::OK::ShowProject';

    isa_ok bif(qw/pull hub hub2.bifhub/),       'Bif::OK::PullHub';
    isa_ok bif(qw!show project hub2.bifhub/a!), 'Bif::OK::ShowProject';
};

run_in_tempdir {
    bif(qw/init/);
    bif(qw/init hub/);

    bif2(qw/init/);

    my $pinfo = bif2(qw/new project todo title -m m1/);
    bif2(qw/update todo -m m2/);

    my $tinfo = bif2(qw/new task -m m3 -p todo tasktitle/);
    bif2( qw/update/, $tinfo->{id}, qw/-m m4/ );
    my $ref = bif2( qw/sql --noprint/,
        "select uuid from nodes where id='$tinfo->{id}'" );
    $tinfo->{uuid} = $ref->[0][0];

    $ref = bif2( qw/sql --noprint/,
        "select id from nodes where uuid='$tinfo->{uuid}'" );
    is $ref->[0][0], $tinfo->{id}, 'uuid -> id';

    my $iinfo = bif2(qw/new issue -m m5 -p todo issuetitle/);

    bif2( qw/update/, $iinfo->{id}, qw/-m m6/ );
    $ref = bif2( qw/sql --noprint/,
        "select uuid from nodes where id='$iinfo->{id}'" );

    $iinfo->{uuid} = $ref->[0][0];

    $ref = bif2( qw/sql --noprint/,
        "select id from nodes where uuid='$iinfo->{uuid}'" );
    is $ref->[0][0], $iinfo->{id}, 'uuid -> id';

    isa_ok bif2(qw{pull hub ../hub.bifhub}), 'Bif::OK::PullHub';
    bif2(qw/push project todo hub.bifhub/);

    isa_ok bif(qw/pull hub hub.bifhub/), 'Bif::OK::PullHub';
    my $list = bif(qw/list hubs/);
    isa_ok $list, 'Bif::OK::ListHubs';    # TODO need to do better than this

    isa_ok bif(qw{show project todo}), 'Bif::OK::ShowProject';

    $ref = bif( qw/sql --noprint/,
        "select id from nodes where uuid='$tinfo->{uuid}'" );
    is $ref->[0][0], undef, 'pull not include tasks';

    $ref = bif( qw/sql --noprint/,
        "select id from nodes where uuid='$iinfo->{uuid}'" );
    is $ref->[0][0], undef, 'pull not include issues';

    bifcheck;
};

done_testing();
