package App::bif::LAA;
use strict;
use warnings;
use parent qw/Log::Any::Adapter::Base/;
use Log::Any::Adapter::Util ();

our $VERSION = '0.1.5_7';

my $trace_level = Log::Any::Adapter::Util::numeric_level('trace');

sub init {
    my ($self) = @_;
    if ( exists $self->{log_level} ) {
        $self->{log_level} =
          Log::Any::Adapter::Util::numeric_level( $self->{log_level} )
          unless $self->{log_level} =~ /^\d+$/;
    }
    else {
        $self->{log_level} = $trace_level;
    }
}

foreach my $method ( Log::Any::Adapter::Util::logging_methods() ) {
    no strict 'refs';
    my $method_level = Log::Any::Adapter::Util::numeric_level($method);
    *{$method} = sub {
        my ( $self, $text ) = @_;
        return if $method_level > $self->{log_level};
        print "$text\n";
    };
}

foreach my $method ( Log::Any::Adapter::Util::detection_methods() ) {
    no strict 'refs';
    my $base = substr( $method, 3 );
    my $method_level = Log::Any::Adapter::Util::numeric_level($base);
    *{$method} = sub {
        return !!( $method_level <= $_[0]->{log_level} );
    };
}

1;

__END__

=head1 NAME

=for bif-doc #perl

App::bif::LAA - Simple adapter for logging to current filehandle

=head1 VERSION

0.1.5_7 (2015-11-25)

=head1 SYNOPSIS

    use Log::Any::Adapter ('+App::bif::LAA');

    # or

    use Log::Any::Adapter;
    ...
    Log::Any::Adapter->set('+App::bif::LAA');

=head1 DESCRIPTION

This is a simple adapter for L<Log::Any> that logs each message to the
currently selected filehandle with a newline appended.  It is basically
the same as L<Log::Any::Adapter::Stdout> but does not explicitly print
to STDOUT.

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2014-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

