package App::bif::new::hub;
use strict;
use warnings;
use Bif::Mo;
use IO::Prompt::Tiny qw/prompt/;

our $VERSION = '0.1.5_7';
extends 'App::bif';

sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $dbw  = $self->dbw;

    $dbw->txn(
        sub {
            my $start = time;
            $self->pause_work;

            $opts->{name} ||= prompt( 'Name:', '' )
              || return $self->err( 'NameRequired', 'name is required' );

            $opts->{location} ||= prompt( 'Location:', '' )
              || return $self->err( 'LocationRequired',
                'location is required' );

            $opts->{title}   ||= $opts->{name};
            $opts->{message} ||= "New hub $opts->{name}";
            $opts->{id}        = $dbw->nextval('nodes');
            $opts->{change_id} = $self->new_change;

            $self->new_hub;

            $dbw->xdo(
                insert_into => 'bifkv',
                values      => { key => 'local', hub_id => $opts->{id} },
            ) if $opts->{default};

            $self->save_new_work(
                change_id => $opts->{change_id},
                node_id   => $opts->{id},
                start     => $start,
                stop      => time,
                comment   => "new hub",
                bill      => 1,
            );

            $self->end_change(
                id               => $opts->{change_id},
                message          => $opts->{message},
                action_format    => "new hub $opts->{name} (%s)",
                action_node_id_1 => $opts->{id},
            );

            printf( "Hub created: %s\n", $opts->{name} );

            $self->resume_work;
        }
    );

    return $self->ok('NewHub');
}

sub new_hub {
    my $self = shift;
    my $opts = $self->opts;
    my $dbw  = $self->dbw;

    $self->new_cmd(
        'App::bif::new::project',
        opts => {
            change_id => $opts->{change_id},
            id        => $opts->{id},
            name      => $opts->{name},
            title     => $opts->{title},
            bill      => $opts->{bill} // 1,
        }
    )->new_project;

    $dbw->xdo(
        insert_into => 'func_new_hub',
        values      => {
            change_id => $opts->{change_id},
            id        => $opts->{id},
            location  => $opts->{location},
            bill      => $opts->{bill} // 1,
        },
    );

    return 1;
}

1;
__END__

=head1 NAME

=for bif-doc #hubadmin

bif-new-hub - create a new hub in the repository

=head1 VERSION

0.1.5_7 (2015-11-25)

=head1 SYNOPSIS

    bif new hub [NAME] [LOCATIONS...] [OPTIONS...]

=head1 DESCRIPTION

The B<bif-new-hub> command creates a new hub representing an a project
organisation.

=head1 ARGUMENTS & OPTIONS

=over

=item NAME

The name of the hub.

=item LOCATIONS

The locations of the hub repositories.

=item --default

Mark this hub as local/default.

=item --message, -m MESSAGE

The creation message, set to "" by default.

=back

=head1 SEE ALSO

L<bif>(1)

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2013-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

