CREATE TABLE func_new_link_topic(
    change_id INTEGER NOT NULL,
    id INTEGER NOT NULL,
    uuid VARCHAR(40)
);


CREATE TRIGGER
    func_new_link_topic_bi_1
BEFORE INSERT ON
    func_new_link_topic
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.id,
        NEW.change_id
    );


    INSERT INTO deltas(
        id,
        change_id,
        action
    )
    VALUES(
        nextval('deltas'),
        NEW.change_id,
        'new_link_topic'
    );


    UPDATE
        changes
    SET
        yaml = yaml
            || '-' || x'0A'
            || '  _delta: new_link_topic' || x'0A'
    WHERE
        id = NEW.change_id
    ;


    INSERT INTO
        func_new_node(
            change_id,
            id,
            name,
            kind,
            bill
        )
    SELECT
        NEW.change_id,
        NEW.id,
        NEW.id,
        'link_topic',
        0
    ;


    INSERT INTO link_topics(
        id
    )
    VALUES(
        NEW.id
    );


    INSERT INTO
        node_deltas(
            id,
            change_id,
            node_id,
            name,
            bill
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        NEW.id,
        0
    );


    SELECT RAISE(IGNORE);
END;
