CREATE TABLE topic_status_tomerge(
    topic_status_id INTEGER NOT NULL UNIQUE,
    status INTEGER DEFAULT 0,
    rank INTEGER DEFAULT 0,
    def INTEGER DEFAULT 0,
    resolve INTEGER,
    FOREIGN KEY(topic_status_id) REFERENCES topic_status(id) ON DELETE CASCADE
);


CREATE TRIGGER
    topic_status_tomerge_bu_4
BEFORE UPDATE OF
    resolve
ON
    topic_status_tomerge
FOR EACH ROW WHEN
    NEW.resolve = 1 AND
    OLD.def != 0
BEGIN

    SELECT debug(
        OLD.topic_status_id
    );

    /*
        This is the most complicated of the merge updates, because we
        are actually looking for the latest id, not the latest value.
    */

    UPDATE
        topic_status
    SET
        def = 1
    WHERE
        id = (
            SELECT
                tsd.topic_status_id

            -- First of all get the topic_status
            FROM
                topic_status ts

            -- Then all the topic_status for the same project
            INNER JOIN
                topic_status ts2
            ON
                ts2.project_id = ts.project_id AND
                ts2.tkind = ts.tkind
            
            -- Then all their deltas
            INNER JOIN
                topic_status_deltas tsd
            ON
                tsd.topic_status_id = ts2.id AND
                ts2.def = 1
            INNER JOIN
                changes c
            ON
                c.id = tsd.change_id
            WHERE
                ts.id = OLD.topic_status_id
            ORDER BY
                c.mtime DESC,
                c.uuid
                -- TODO: tsd2.id?
            LIMIT
                1
        )
    ;

END;


CREATE TRIGGER
    topic_status_tomerge_bu_3
BEFORE UPDATE OF
    resolve
ON
    topic_status_tomerge
FOR EACH ROW WHEN
    NEW.resolve = 1 AND
    OLD.rank != 0
BEGIN

    SELECT debug(
        OLD.topic_status_id
    );

    UPDATE
        topic_status
    SET
        rank = (
            SELECT
                tsd.rank
            FROM
                topic_status_deltas tsd
            INNER JOIN
                changes c
            ON
                c.id = tsd.change_id
            WHERE
                tsd.topic_status_id = OLD.topic_status_id AND
                tsd.rank IS NOT NULL
            ORDER BY
                c.mtime DESC,
                c.uuid
            LIMIT
                1
        )
    WHERE
        id = OLD.topic_status_id
    ;

END;


CREATE TRIGGER
    topic_status_tomerge_bu_1
BEFORE UPDATE OF
    resolve
ON
    topic_status_tomerge
FOR EACH ROW WHEN
    NEW.resolve = 1 AND
    OLD.status != 0
BEGIN

    SELECT debug(
        OLD.topic_status_id
    );

    UPDATE
        topic_status
    SET
        status = (
            SELECT
                tsd.status
            FROM
                topic_status_deltas tsd
            INNER JOIN
                changes c
            ON
                c.id = tsd.change_id
            WHERE
                tsd.topic_status_id = OLD.topic_status_id AND
                tsd.status IS NOT NULL
            ORDER BY
                c.mtime DESC,
                c.uuid
            LIMIT
                1
        )
    WHERE
        id = OLD.topic_status_id
    ;

END;


CREATE TRIGGER
    topic_status_tomerge_au_1
AFTER UPDATE OF
    resolve
ON
    topic_status_tomerge
FOR EACH ROW WHEN
    NEW.resolve = 1
BEGIN

    SELECT debug(
        OLD.topic_status_id
    );


    DELETE FROM
        topic_status_tomerge
    WHERE
        topic_status_id = OLD.topic_status_id
    ;

    SELECT RAISE(IGNORE);

END;
