CREATE TABLE topic_status (
    id INTEGER NOT NULL PRIMARY KEY,
    project_id INTEGER NOT NULL,
    tkind VARCHAR NOT NULL,
    status VARCHAR(40) NOT NULL,
    rank INTEGER NOT NULL,
    def INTEGER NOT NULL,
    CONSTRAINT project_id_tkind_id UNIQUE (project_id,tkind,id), -- topics FK
    CONSTRAINT def_constraint CHECK (def BETWEEN 0 AND 1),
    FOREIGN KEY (id) REFERENCES nodes(id) ON DELETE CASCADE,
    FOREIGN KEY (project_id) REFERENCES projects(id) ON DELETE CASCADE
);

CREATE TRIGGER
    topic_status_ai_1
AFTER INSERT ON
    topic_status
FOR EACH ROW WHEN
    NEW.def = 1
BEGIN

    SELECT debug(
        NEW.id,
        NEW.project_id,
        NEW.tkind,
        NEW.status
    );

    UPDATE
        topic_status
    SET
        def = 0
    WHERE
        project_id = NEW.project_id AND
        tkind = NEW.tkind AND
        def = 1 AND
        id != NEW.id
    ;

END;


CREATE TRIGGER
    topic_status_au_1
AFTER UPDATE ON
    topic_status
FOR EACH ROW WHEN
    NEW.def = 1 AND OLD.def != 1
BEGIN

    SELECT debug(
        NEW.id,
        NEW.status
    );

    UPDATE
        topic_status
    SET
        def = 0
    WHERE
        project_id = NEW.project_id AND
        tkind = NEW.tkind AND
        def = 1 AND
        id != NEW.id
    ;

END;


CREATE TRIGGER
    topic_status_ad_1
AFTER DELETE ON
    topic_status
FOR EACH ROW
BEGIN
    SELECT debug(
        OLD.id,
        OLD.status
    );

    /*
        The following is necessary, because although FK relationships
        do result in the remove of rows from topic_status_tomerge, the
        deletion of rows from topic_status_deltas just inserts more
        rows.
    */

    DELETE FROM
        topic_status_tomerge
    WHERE
        topic_status_id = OLD.id
    ;

END;
