use strict;
use warnings;
use lib 't/lib';
use Test::Bif;
use Test::Fatal;
use Test::More;

run_in_tempdir {

    like exception { bif(qw/list topic-types/) }, qr/^usage:/, 'usage';

    bif(qw/init/);
    bif(qw/ new project todo --message m1 title /);

    isa_ok bif(qw/list topic-types todo/), 'ARRAY';

    isa_ok exception { bif(qw/list topic-types noproject/) },
      'Bif::Error::ProjectNotFound';
};

done_testing();
