BEGIN { $| = 1; print "1..44\n"; }

use common::sense;
use Convert::BER::XS ':all';

# finally, the "löonger" testcase

our $test;
sub ok($;$) {
   print $_[0] ? "" : "not ", "ok ", ++$test, " # $_[1]\n";
}

while (<DATA>) { # comment
   chop;
   chop (my $mode = readline DATA);
   my $hex = do { local $/ = "\n\n"; readline DATA };
   $hex =~ y/0-9a-f//cd;
   my $bin = pack "H*", $hex;

   my $emptyprofile = new Convert::BER::XS::Profile;

   $emptyprofile->set (ASN_UNIVERSAL, $_, BER_TYPE_BYTES) for 0..50;

   for my $profile (
      $Convert::BER::XS::DEFAULT_PROFILE,
      $Convert::BER::XS::SNMP_PROFILE,
      $emptyprofile,
      new Convert::BER::XS::Profile,
   ) {
      if ($mode eq "fail") {
         ok (!eval { ber_decode $bin, $profile; 1 }, "fail $_");
      } else {
	 my $ber = ber_decode $bin, $profile;
	 ok ($ber, "encode $_");

	 my $enc = ber_encode $ber, $profile;

	 ok ($mode eq "roundtrip" ? $enc eq $bin : 1, "decode $_");
      }
   }
}

__DATA__
# 512b-rsa-example-cert.der
roundtrip
3082 0212 3082 017b 0202 0dfa 300d 0609
2a86 4886 f70d 0101 0505 0030 819b 310b
3009 0603 5504 0613 024a 5031 0e30 0c06
0355 0408 1305 546f 6b79 6f31 1030 0e06
0355 0407 1307 4368 756f 2d6b 7531 1130
0f06 0355 040a 1308 4672 616e 6b34 4444
3118 3016 0603 5504 0b13 0f57 6562 4365
7274 2053 7570 706f 7274 3118 3016 0603
5504 0313 0f46 7261 6e6b 3444 4420 5765
6220 4341 3123 3021 0609 2a86 4886 f70d
0109 0116 1473 7570 706f 7274 4066 7261
6e6b 3464 642e 636f 6d30 1e17 0d31 3230
3832 3230 3532 3635 345a 170d 3137 3038
3231 3035 3236 3534 5a30 4a31 0b30 0906
0355 0406 1302 4a50 310e 300c 0603 5504
080c 0554 6f6b 796f 3111 300f 0603 5504
0a0c 0846 7261 6e6b 3444 4431 1830 1606
0355 0403 0c0f 7777 772e 6578 616d 706c
652e 636f 6d30 5c30 0d06 092a 8648 86f7
0d01 0101 0500 034b 0030 4802 4100 9bfc
6690 7984 42bb ab13 fd2b 7bf8 de15 12e5
f193 e306 8a7b b8b1 e19e 26bb 9501 bfe7
30ed 6485 02dd 1569 a834 b006 ec3f 353c
1e1b 2b8f fa8f 001b df07 c6ac 5307 0203
0100 0130 0d06 092a 8648 86f7 0d01 0105
0500 0381 8100 14b6 4cbb 8179 33e6 71a4
da51 6fcb 081d 8d60 ecbc 18c7 7347 59b1
f220 48bb 61fa fc4d ad89 8dd1 21eb d5d8
e5ba d6a6 36fd 7450 83b6 0fc7 1ddf 7de5
2e81 7f45 e09f e23e 79ee d730 31c7 2072
d958 2e2a fe12 5a34 45a1 1908 7c89 475f
4a95 be23 214a 5372 da2a 052f 2ec9 70f6
5bfa fddf b431 b2c1 4a9c 0625 43a1 e6b4
1e7f 869b 1640

# wireshark ldap test pcap

3084 0000 0542 0201 0760 8400 0005 3902
0103 0400 a384 0000 052e 040a 4753 532d
5350 4e45 474f 0482 051e 6082 051a 0606
2b06 0105 0502 a082 050e 3082 050a a024
3022 0609 2a86 4882 f712 0102 0206 092a
8648 86f7 1201 0202 060a 2b06 0104 0182
3702 020a a282 04e0 0482 04dc 6082 04d8
0609 2a86 4886 f712 0102 0201 006e 8204
c730 8204 c3a0 0302 0105 a103 0201 0ea2
0703 0500 2000 0000 a382 03e0 6182 03dc
3082 03d8 a003 0201 05a1 151b 1357 324b
332e 564d 4e45 5431 2e56 4d2e 4241 5345
a22f 302d a003 0201 02a1 2630 241b 046c
6461 701b 1c77 326b 332d 3130 312e 7732
6b33 2e76 6d6e 6574 312e 766d 2e62 6173
65a3 8203 8730 8203 83a0 0302 0117 a103
0201 07a2 8203 7504 8203 716a 61c8 86ba
58d1 6211 3db4 268f 7743 a17e b476 183b
c0c5 19ad dea7 6556 a370 1de3 4903 e6bd
3f3f dca0 b01b bccb 9a86 93b2 3fa8 d198
5e14 922e 4ca1 9b05 a907 6984 5a58 5851
5bba 4af2 d7e5 9bfa 8634 285a 2e95 4fb5
1837 8b8d 3f27 44b9 bbf8 842b 4807 879f
f28e 55bf ba49 67e8 c1d3 b6c4 e358 a561
c54a bbc1 cb7c 97b6 503f e59b 7fee 6423
dffe 66fe 6dcb 8af0 0e69 c53d 6b57 6f55
0699 0438 310f b7dd 1468 a32f d8e0 deab
40b1 5ecf d438 5683 7014 0a1e dafe e701
a4a4 b4e7 b3aa efdc 4b1a ff58 68ae fe5a
3629 4d5d d687 d5a6 4931 43d3 ade8 031c
98d2 8f6c 7f3d cea4 1435 132f 675f 2694
0d1f 69e5 73e5 ece6 ed5a 6611 1ff9 f4b0
2a8d dd19 086e 5b9d c0ad c86a 0bc1 230f
1b71 5ffc 4004 dfc4 a7d5 f78a 4dc3 1abf
830a e6e3 bfd2 1c87 fa51 9654 9e13 0f6a
081b afcf 4170 ae20 1c78 a382 9a01 dba5
78a2 ef96 8f2a b666 8d81 14df cc65 d703
8f55 58be 7cdd 9246 d522 4791 5260 a40e
59c4 8b08 a1ed 6142 7fd3 0391 7c6b 34b7
01a4 ba9a 3815 d482 8a22 8cd2 09da 1376
26e2 029a abf6 c200 bf7f d63c f6d4 3bb6
18b3 1ac4 8e09 6135 89d7 4a69 542e 909c
e0dc 9c57 c77f 7d89 b966 de20 0053 a58e
a58f 2374 5139 6163 8a30 ca49 ef0e ec67
9d92 7e38 5b5d a7d4 d3c1 a591 69b4 630b
874a 1d96 9e45 d1fe 3782 089f 4385 0249
5509 3b30 8e19 64d3 0791 5271 aa88 6c3d
9b64 d846 c88c a134 1fd2 f72b 7667 9d4f
258f 647b c048 20e4 2776 c9ec 0d01 4646
5276 3a49 d822 c9d2 5b60 3903 ebd6 3389
5225 9b83 a740 a420 d69d 23ae bbdf 06a9
2d88 a46f fcd8 d81a 47b6 ec99 b6ce a048
9cc8 3ef1 5757 c405 3d53 8446 f2e6 b9eb
a12c e496 9b8d 6df9 b3ef 574b 7d40 1341
c2f5 55a0 0f02 9164 e5d3 8728 2c0c 8791
ba8c 6981 6248 e2e5 44a9 c12b 7aeb a629
fdee a2e1 1165 5e44 b9c2 1592 4c54 55ea
a4ab 32ae a1d9 cef1 d86e 8acf 6b0f f4dc
abaf 4f0e 2d9a e65c 8bb1 065e 0418 ff12
d462 6930 3159 38bf e00a 8d03 e8e7 0e9d
ea9d c9ff 7485 4cbb 4dbd f700 a62e 77b2
6e50 b13e 2d39 60c9 1336 0c84 c87e 801e
d3df 3db0 e276 0450 8cb7 30c5 a052 c068
abe5 826b 01be 9f62 e33b 9af8 edb6 667c
57cb 1aa8 7974 3b77 a743 2f75 fe3a e211
f96a f41a def1 e1c5 0725 6fe5 fa2b ccab
e52c f821 6d34 10e6 3785 06d4 2734 3458
332d 153a 77a1 62c4 c5f1 8d9f 31b0 c142
880c ad22 2998 1720 615a b26b 7c13 442e
4317 8aad ee43 6510 c91b c9d5 d735 eb94
53cf 39ce f512 0e28 6037 75f0 483f 01c3
c48b 5b06 0ca7 f3a5 4d7c 7c99 a481 c930
81c6 a003 0201 17a2 81be 0481 bb03 ab65
6760 a351 2fec c703 2da8 b201 4659 f0fb
34eb 76b4 61e4 044d a24d 16d4 58e3 e1c5
8919 c74c 4c07 20aa fb87 a948 1523 72a2
483a 4d1a e9b9 5b85 8a52 abaa 94e7 aa64
1a8b 997d 7e6c 6e57 0b59 08cc 5491 55f5
e6f1 10c9 8d64 8978 727a bae3 921d a52a
4c1f d76b eb12 1bf3 396b e8f9 8e4a cf1e
bfc3 b6fb 7a13 54c1 2187 3e59 185d b900
3008 4d97 8647 98d7 9eb9 df30 756c a1fa
a7a8 0880 f74f 7d93 642d 9ceb 5e01 28ce
d6ab 096a 4f01 5e5a 032b 4270 231e 7ff1
bcd0 87e8 b527 027d

# wireshark snmp pcap dump
roundtrip
3081 9f02 0100 0406 7075 626c 6963 a281
9102 013c 0201 0002 0100 3081 8530 2206
122b 0601 0401 817d 0833 0a02 0107 0a86
deb7 3504 0c31 3732 2e33 312e 3139 2e37
3330 1706 122b 0601 0401 817d 0833 0a02
0105 0a86 deb9 6002 0102 3023 0612 2b06
0104 0181 7d08 330a 0201 070a 86de b736
040d 3235 352e 3235 352e 3235 352e 3030
2106 122b 0601 0401 817d 0833 0a02 0107
0a86 deb7 3804 0b31 3732 2e33 312e 3139
2e32

# wireshark snmp usm pcap dump
roundtrip
3082 0139 0201 0330 1102 0458 9bab 6802
0300 ffe3 0401 0102 0103 0430 302e 040d
8000 1f88 8059 dc48 6145 a263 2202 0108
0202 0abb 0406 7069 7070 6f34 040c c5c3
691b 3d4d c57c e248 c853 0400 3081 ee04
0d80 001f 8880 59dc 4861 45a2 6322 0400
a281 da02 045d 4459 dc02 0100 0201 0030
81cb 3081 9506 082b 0601 0201 0101 0004
8188 4461 7277 696e 2069 642d 6573 742e
6c6f 6361 6c20 382e 382e 3020 4461 7277
696e 204b 6572 6e65 6c20 5665 7273 696f
6e20 382e 382e 303a 2046 7269 2053 6570
2020 3820 3137 3a31 383a 3537 2050 4454
2032 3030 363b 2072 6f6f 743a 786e 752d
3739 322e 3132 2e36 2e6f 626a 7e31 2f52
454c 4541 5345 5f50 5043 2050 6f77 6572
204d 6163 696e 746f 7368 300f 0608 2b06
0102 0101 0300 4303 0431 5230 0f06 082b
0601 0201 0403 0041 0302 9945 300f 0608
2b06 0102 0104 0a00 4103 020d 8b

# wireshark snmp usm pcap dump
roundtrip
3082 014b 0201 0330 1102 0465 5e21 2202
0300 ffe3 0401 0302 0103 0438 3036 040d
8000 1f88 8059 dc48 6145 a263 2202 0108
0202 0aba 0406 7069 7070 6f32 040c 55ef
d50a e247 d453 ead9 8927 0408 0000 0008
7da0 6263 0481 f8bd e254 43f6 3f33 edd1
4424 a9ab ff75 e11c 2f77 1985 ce69 689c
ae26 ac43 82f1 6f17 43ef aabc fc3c 2fc3
bd9c 149a c2ee 3f9d 278b d947 8d38 b7d9
fcb1 ddf6 bf6e d4ec 51dd 13c3 d9e9 3c39
b63c 0a60 f75d 1ee6 c8b4 70a8 a0a1 842b
7bd4 08a0 65b7 1a97 307d bbc5 d6ae 6ac5
1d52 dce7 7de6 4b4a fe7d 54cc b6f5 bd12
f7a0 1d10 c4e4 6c6d c260 23d4 c787 a40f
17da eca4 9ca2 6ce5 69ea 1be3 457e 9a74
5707 9382 732a 83ce a8cd 3ece ff46 7451
83c6 84a0 2c69 288d 1bb3 d5d0 6b6f 240c
02d6 cc81 e949 4a69 22c1 375f a9df 926e
45fc da76 b5b3 a7c7 d280 d7e9 8f46 afa5
cf17 4d35 9cf5 d325 a551 d321 33a6 f647
4f64 b7c2 3a12 0a6f 6481 5ea3 c3e9 04

# https://misc.daniel-marschall.de/asn.1/oid-overflow-check/
fail
3082 0c33 3082 0b9c a003 0201 0202 110
ce21 83f6 58bb 2e80 e355 b81b 8de0 42d
300d 0609 2a86 4886 f70d 0101 0505 003
8202 a831 0b30 0906 0355 0406 1302 444
3115 3013 0603 5504 0a13 0c56 6961 546
696e 6b53 6f66 7431 1130 0f06 0355 040
1308 5265 7365 6172 6368 3133 3031 060
5504 0313 2a56 6961 5468 696e 6b53 6f6
7420 4f49 442d 4f76 6572 666c 6f77 205
6573 7420 4365 7274 6966 6963 6174 653
1b30 1906 0355 0403 1312 6261 6467 757
2e65 7861 6d70 6c65 2e63 6f6d 312f 302
0609 2a86 4886 f70d 0109 0116 2064 616
6965 6c2d 6d61 7273 6368 616c 6c40 766
6174 6869 6e6b 736f 6674 2e64 6531 333
3106 0355 0403 132a 5669 6154 6869 6e6
536f 6674 204f 4944 2d4f 7665 7266 6c6
7720 5465 7374 2043 6572 7469 6669 636
7465 311b 3019 0603 5504 0313 1262 616
6775 792e 6578 616d 706c 652e 636f 6d3
2c30 2a06 0790 8080 8055 0403 131f 333
6269 742e 6f76 6572 666c 6f77 2e61 726
322e 6578 616d 706c 652e 636f 6d31 2c3
2a06 0755 9080 8080 0403 131f 3332 626
742e 6f76 6572 666c 6f77 2e61 7263 312
6578 616d 706c 652e 636f 6d31 2c30 2a0
0755 0490 8080 8003 131f 3332 6269 742
6f76 6572 666c 6f77 2e72 6f6f 742e 657
616d 706c 652e 636f 6d31 3330 3106 0f9
8080 8055 9080 8080 0490 8080 8003 131
3332 6269 742e 6f76 6572 666c 6f77 2e6
6c6c 2e65 7861 6d70 6c65 2e63 6f6d 313
302f 060c 8280 8080 8080 8080 8055 040
131f 3634 6269 742e 6f76 6572 666c 6f7
2e61 7263 322e 6578 616d 706c 652e 636
6d31 3130 2f06 0c55 8280 8080 8080 808
8004 0313 1f36 3462 6974 2e6f 7665 726
6c6f 772e 6172 6331 2e65 7861 6d70 6c6
2e63 6f6d 3131 302f 060c 5504 8280 808
8080 8080 8003 131f 3634 6269 742e 6f7
6572 666c 6f77 2e72 6f6f 742e 6578 616
706c 652e 636f 6d31 4230 4006 1e82 808
8080 8080 8080 5582 8080 8080 8080 808
0482 8080 8080 8080 8080 0313 1e36 346
6974 2e6f 7665 7266 6c6f 772e 616c 6c2
6578 616d 706c 652e 636f 6d30 1e17 0d3
3431 3131 3532 3335 3432 375a 170d 313
3131 3136 3233 3534 3237 5a30 8202 a83
0b30 0906 0355 0406 1302 4445 3115 301
0603 5504 0a13 0c56 6961 5468 696e 6b5
6f66 7431 1130 0f06 0355 040b 1308 526
7365 6172 6368 3133 3031 0603 5504 031
2a56 6961 5468 696e 6b53 6f66 7420 4f4
442d 4f76 6572 666c 6f77 2054 6573 742
4365 7274 6966 6963 6174 6531 1b30 190
0355 0403 1312 6261 6467 7579 2e65 786
6d70 6c65 2e63 6f6d 312f 302d 0609 2a8
4886 f70d 0109 0116 2064 616e 6965 6c2
6d61 7273 6368 616c 6c40 7669 6174 686
6e6b 736f 6674 2e64 6531 3330 3106 035
0403 132a 5669 6154 6869 6e6b 536f 667
204f 4944 2d4f 7665 7266 6c6f 7720 546
7374 2043 6572 7469 6669 6361 7465 311
3019 0603 5504 0313 1262 6164 6775 792
6578 616d 706c 652e 636f 6d31 2c30 2a0
0790 8080 8055 0403 131f 3332 6269 742
6f76 6572 666c 6f77 2e61 7263 322e 657
616d 706c 652e 636f 6d31 2c30 2a06 075
9080 8080 0403 131f 3332 6269 742e 6f7
6572 666c 6f77 2e61 7263 312e 6578 616
706c 652e 636f 6d31 2c30 2a06 0755 049
8080 8003 131f 3332 6269 742e 6f76 657
666c 6f77 2e72 6f6f 742e 6578 616d 706
652e 636f 6d31 3330 3106 0f90 8080 805
9080 8080 0490 8080 8003 131e 3332 626
742e 6f76 6572 666c 6f77 2e61 6c6c 2e6
7861 6d70 6c65 2e63 6f6d 3131 302f 060
8280 8080 8080 8080 8055 0403 131f 363
6269 742e 6f76 6572 666c 6f77 2e61 726
322e 6578 616d 706c 652e 636f 6d31 313
2f06 0c55 8280 8080 8080 8080 8004 031
1f36 3462 6974 2e6f 7665 7266 6c6f 772
6172 6331 2e65 7861 6d70 6c65 2e63 6f6
3131 302f 060c 5504 8280 8080 8080 808
8003 131f 3634 6269 742e 6f76 6572 666
6f77 2e72 6f6f 742e 6578 616d 706c 652
636f 6d31 4230 4006 1e82 8080 8080 808
8080 5582 8080 8080 8080 8080 0482 808
8080 8080 8080 0313 1e36 3462 6974 2e6
7665 7266 6c6f 772e 616c 6c2e 6578 616
706c 652e 636f 6d30 819f 300d 0609 2a8
4886 f70d 0101 0105 0003 818d 0030 818
0281 8100 afaf 7ef9 fd97 fca5 fcba e1d
52d7 77c3 9036 e9e7 8f15 d8c7 73d4 a49
92f0 1766 927a 6004 0d77 841c 4d66 e96
b7a4 bae4 0a4a 4d1a 230a 5303 da20 1a9
d554 0acf 4283 ebf2 c986 1dd6 3a5b 3fd
cc77 1129 7235 f57d 391e a750 2d18 2c4
a04d 0246 b23f 94ff 3782 f024 8b7d c81
b11b 6090 5d7a 2e0c b780 fd11 9425 e20
7f14 9a15 0203 0100 01a3 8205 5730 820
5330 1d06 0355 1d0e 0416 0414 352d b75
32a2 7623 80c0 fa55 8e4a 450c d4e2 060
3082 02ea 0603 551d 2304 8202 e130 820
dd80 1435 2db7 5532 a276 2380 c0fa 558
4a45 0cd4 e206 0da1 8202 b0a4 8202 ac3
8202 a831 0b30 0906 0355 0406 1302 444
3115 3013 0603 5504 0a13 0c56 6961 546
696e 6b53 6f66 7431 1130 0f06 0355 040
1308 5265 7365 6172 6368 3133 3031 060
5504 0313 2a56 6961 5468 696e 6b53 6f6
7420 4f49 442d 4f76 6572 666c 6f77 205
6573 7420 4365 7274 6966 6963 6174 653
1b30 1906 0355 0403 1312 6261 6467 757
2e65 7861 6d70 6c65 2e63 6f6d 312f 302
0609 2a86 4886 f70d 0109 0116 2064 616
6965 6c2d 6d61 7273 6368 616c 6c40 766
6174 6869 6e6b 736f 6674 2e64 6531 333
3106 0355 0403 132a 5669 6154 6869 6e6
536f 6674 204f 4944 2d4f 7665 7266 6c6
7720 5465 7374 2043 6572 7469 6669 636
7465 311b 3019 0603 5504 0313 1262 616
6775 792e 6578 616d 706c 652e 636f 6d3
2c30 2a06 0790 8080 8055 0403 131f 333
6269 742e 6f76 6572 666c 6f77 2e61 726
322e 6578 616d 706c 652e 636f 6d31 2c3
2a06 0755 9080 8080 0403 131f 3332 626
742e 6f76 6572 666c 6f77 2e61 7263 312
6578 616d 706c 652e 636f 6d31 2c30 2a0
0755 0490 8080 8003 131f 3332 6269 742
6f76 6572 666c 6f77 2e72 6f6f 742e 657
616d 706c 652e 636f 6d31 3330 3106 0f9
8080 8055 9080 8080 0490 8080 8003 131
3332 6269 742e 6f76 6572 666c 6f77 2e6
6c6c 2e65 7861 6d70 6c65 2e63 6f6d 313
302f 060c 8280 8080 8080 8080 8055 040
131f 3634 6269 742e 6f76 6572 666c 6f7
2e61 7263 322e 6578 616d 706c 652e 636
6d31 3130 2f06 0c55 8280 8080 8080 808
8004 0313 1f36 3462 6974 2e6f 7665 726
6c6f 772e 6172 6331 2e65 7861 6d70 6c6
2e63 6f6d 3131 302f 060c 5504 8280 808
8080 8080 8003 131f 3634 6269 742e 6f7
6572 666c 6f77 2e72 6f6f 742e 6578 616
706c 652e 636f 6d31 4230 4006 1e82 808
8080 8080 8080 5582 8080 8080 8080 808
0482 8080 8080 8080 8080 0313 1e36 346
6974 2e6f 7665 7266 6c6f 772e 616c 6c2
6578 616d 706c 652e 636f 6d82 1100 ce2
83f6 58bb 2e80 e355 b81b 8de0 42d6 300
0603 551d 1301 01ff 0405 3003 0101 ff3
0e06 0355 1d0f 0101 ff04 0403 0201 063
819d 0603 551d 2501 01ff 0481 9230 818
0608 2b06 0105 0507 0301 0608 2b06 010
0507 0302 0603 5504 0306 0790 8080 805
0403 0607 5590 8080 8004 0306 0755 049
8080 8003 060f 9080 8080 5590 8080 800
9080 8080 0306 0c82 8080 8080 8080 808
5504 0306 0c55 8280 8080 8080 8080 800
0306 0c55 0482 8080 8080 8080 8080 030
1e82 8080 8080 8080 8080 5582 8080 808
8080 8080 0482 8080 8080 8080 8080 033
7306 0355 1d11 046c 306a 8120 6461 6e6
656c 2d6d 6172 7363 6861 6c6c 4076 696
7468 696e 6b73 6f66 742e 6465 8642 687
7470 733a 2f2f 7777 772e 7669 6174 686
6e6b 736f 6674 2e64 652f 7e64 616e 696
6c2d 6d61 7273 6368 616c 6c2f 6173 6e2
312f 6f69 645f 6661 6374 732e 6874 6d6
8802 8837 3073 0603 551d 1204 6c30 6a8
2064 616e 6965 6c2d 6d61 7273 6368 616
6c40 7669 6174 6869 6e6b 736f 6674 2e6
6586 4268 7474 7073 3a2f 2f77 7777 2e7
6961 7468 696e 6b73 6f66 742e 6465 2f7
6461 6e69 656c 2d6d 6172 7363 6861 6c6
2f61 736e 2e31 2f6f 6964 5f66 6163 747
2e68 746d 6c88 0288 3730 8198 0603 551
2004 8190 3081 8d30 0506 0355 0403 300
0607 9080 8080 5504 0330 0906 0755 908
8080 0403 3009 0607 5504 9080 8080 033
1106 0f90 8080 8055 9080 8080 0490 808
8003 300e 060c 8280 8080 8080 8080 805
0403 300e 060c 5582 8080 8080 8080 808
0403 300e 060c 5504 8280 8080 8080 808
8003 3020 061e 8280 8080 8080 8080 805
8280 8080 8080 8080 8004 8280 8080 808
8080 8003 300d 0609 2a86 4886 f70d 010
0505 0003 8181 0091 c12b e0e9 d89c 234
bc4d 2975 ecb9 4ecd 66a8 16ce 46c1 1f5
d5bd d08d 2969 14bf 56d6 e49f 9b54 b18
d08d 549e b622 c12f 3842 5fa3 7485 3ff
8f88 81bf d9ae 9895 0766 38cb e7f2 1d0
61f5 bd17 1d64 2c49 59bd cb93 6b70 11f
51bf d2f8 5f90 dc5d 91a0 d498 e655 ef6
7a82 41a2 70ff 3238 bc7d 8a6b 7441 a96
80af 2b1b 6e7a 98

