#
# $Header: /cvsroot/gtk2-perl/gtk2-perl-xs/Gtk2/Makefile.PL,v 1.26 2003/08/20 01:25:48 rwmcfa1 Exp $
#

use 5.008;
use strict;
use ExtUtils::MakeMaker;
use File::Spec;
use Config;
use Cwd;

# minimum required version of Glib with which we can work.
my $req_glib_ver = 0.92;

# Writing a fake Makefile ensures that CPAN will pick up the correct
# dependencies and install them.
unless (eval "use ExtUtils::Depends;"
           . "use Glib::PkgConfig;"
           # just seeing if Glib is available isn't enough, make sure
           # it's recent enough, too 
           . "use Glib $req_glib_ver;"
           . "1") {
   warn "$@\n";
   WriteMakefile(
         PREREQ_FATAL => 1,
         PREREQ_PM    => {
            Glib::              => $req_glib_ver, # keep this in sync
            ExtUtils::Depends:: => 0.1,
         },
   );
   exit 1; # not reached
}

require 'CodeGen.pm'; # other modules can just 'use Gtk2::CodeGen;' -- we
                      # can't because it's not installed yet.

my %pkgcfg = Glib::PkgConfig->find ('gtk+-2.0');

mkdir 'build', 0777;

#
# autogeneration
#
# we have a whole lot of types which need cast macros, typemap entries,
# and package mapping registration; instead of writing this by hand, we
# use a map file which defines how things are laid out, and then use
# some boilerplate code to convert that map into a header, typemap, and
# xsh file.  see the docs for Gtk2::CodeGen for more info.
#
# we'll use all the default filenames.
#
Gtk2::CodeGen->parse_maps ('gtk2perl');

# one more command generates code to boot all the various extra XS modules.
# we need this because we have lots of XS files without corresponding PMs to
# bootstrap them.
Gtk2::CodeGen->write_boot;

# this one turns the long list of #defines in gdkkeysyms.h into a large
# hash of key names and values, %Gtk2::Gdk::Keysyms.
system "$Config{perlpath} genkeysyms.pl >\"build/Keysyms.pm\""; # the "" are essential for command.com

#
# since we've started down the dark path of breaking from standard 
# MakeMaker, forever will it dominate our destiny; we must specify
# install paths for the modules and man files by hand.
#
my %pm_files = (
	'Gtk2.pm'          => '$(INST_LIBDIR)/Gtk2.pm',
	'build/Keysyms.pm' => '$(INST_LIBDIR)/Gtk2/Gdk/Keysyms.pm',
	'CodeGen.pm'       => '$(INST_LIBDIR)/Gtk2/CodeGen.pm',
	'pm/Helper.pm'     => '$(INST_LIBDIR)/Gtk2/Helper.pm',
	'pm/Pango.pm'      => '$(INST_LIBDIR)/Gtk2/Pango.pm',
	'pm/SimpleList.pm' => '$(INST_LIBDIR)/Gtk2/SimpleList.pm',
	'pm/SimpleMenu.pm' => '$(INST_LIBDIR)/Gtk2/SimpleMenu.pm',
	'api.pod'          => '$(INST_LIBDIR)/Gtk2/api.pod',
	'devel.pod'        => '$(INST_LIBDIR)/Gtk2/devel.pod',
);
my %pod_files = (
	'Gtk2.pm'          => '$(INST_MAN3DIR)/Gtk2.$(MAN3EXT)',
	'build/Keysyms.pm' => '$(INST_MAN3DIR)/Gtk2::Gdk::Keysyms.$(MAN3EXT)',
	'CodeGen.pm'       => '$(INST_MAN3DIR)/Gtk2::CodeGen.$(MAN3EXT)',
	'pm/Helper.pm'     => '$(INST_MAN3DIR)/Gtk2::Helper.$(MAN3EXT)',
	'pm/Pango.pm'      => '$(INST_MAN3DIR)/Gtk2::Pango.$(MAN3EXT)',
	'pm/SimpleList.pm' => '$(INST_MAN3DIR)/Gtk2::SimpleList.$(MAN3EXT)',
	'pm/SimpleMenu.pm' => '$(INST_MAN3DIR)/Gtk2::SimpleMenu.$(MAN3EXT)',
	'api.pod'          => '$(INST_MAN3DIR)/Gtk2::api.$(MAN3EXT)',
	'devel.pod'        => '$(INST_MAN3DIR)/Gtk2::devel.$(MAN3EXT)',
);

# now we're ready to start creating the makefile.
# we need to use ExtUtils::Depends to get relevant information out of
# the Glib extension, and to save config information for other modules which
# will chain from this one.

my $gtk2 = ExtUtils::Depends->new ('Gtk2', 'Glib');
# Glib added -I. for us, but we'll need to add -I./build so we can get to
# the autogenerated files.  we do this kindof as a public service to client
# modules, as these will carry through via the depends mechanism.
$gtk2->set_inc ($pkgcfg{cflags} . ' -I./build ');
$gtk2->set_libs ($pkgcfg{libs} . find_extra_libs());
$gtk2->add_pm (%pm_files);
$gtk2->add_xs (<xs/*.xs>);
my $cwd = cwd();
$gtk2->add_typemaps (map {File::Spec->catfile($cwd,$_)} 'gdk.typemap', 'build/gtk2perl.typemap');
$gtk2->add_headers ('gtk2perl.h');

$gtk2->install (qw(gtk2perl.h build/gtk2perl-autogen.h));
$gtk2->save_config ('build/IFiles.pm');

WriteMakefile(
    NAME          => 'Gtk2',
    VERSION_FROM  => 'Gtk2.pm', # finds $VERSION
    ABSTRACT_FROM => 'Gtk2.pm', # retrieve abstract from module
    XSPROTOARG    => '-noprototypes',
    MAN3PODS      => \%pod_files,
    # PREREQ see beginning of file
    $gtk2->get_makefile_vars,
);

#
# there's a bug in the MakeMaker output which results in .xs files in a
# subdirectory being turned into .o files in this dir.  the bug is a missing
# -o on the compiler command line.  this is a hackish fix for it.
#
package MY;
sub const_cccmd {
	my $inherited = shift->SUPER::const_cccmd (@_);
	$inherited .= ' -o $@';
	$inherited;
}

sub postamble
{
	"
realclean ::
	-rm -Rf build
"
}
package main;

# this probably needs to go into ExtUtils::Depends.
sub find_extra_libs {
	# right now we need this terrible hack only for windows.
	return "" unless $^O eq "MSWin32";

	# win32 does not allow unresolved symbols in libraries, but
	# Gtk2 depends on symbols in the dll created for Glib.
	# so, we have to break all this nice abstraction and encapsulation
	# and find the actual Glib.dll and Glib.lib installed by perl when
	# the Glib module was built, and add it to the list of lib files.
	#
	# say it with me: "i hate win32."

	my $retstring = "";

	use File::Find;
	find (sub {
			$retstring .= " ".$File::Find::name
				if /Glib.lib/i;
		}, @INC);

	return $retstring;
}
