/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.COSObjectable;

public class PDMarkedContentReference
implements COSObjectable {
    public static final String TYPE = "MCR";
    private COSDictionary dictionary;

    protected COSDictionary getCOSDictionary() {
        return this.dictionary;
    }

    public PDMarkedContentReference() {
        this.dictionary = new COSDictionary();
        this.dictionary.setName(COSName.TYPE, TYPE);
    }

    public PDMarkedContentReference(COSDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public COSBase getCOSObject() {
        return this.dictionary;
    }

    public PDPage getPage() {
        COSDictionary pg = (COSDictionary)this.getCOSDictionary().getDictionaryObject(COSName.PG);
        if (pg != null) {
            return new PDPage(pg);
        }
        return null;
    }

    public void setPage(PDPage page) {
        this.getCOSDictionary().setItem(COSName.PG, (COSObjectable)page);
    }

    public int getMCID() {
        return this.getCOSDictionary().getInt(COSName.MCID);
    }

    public void setMCID(int mcid) {
        this.getCOSDictionary().setInt(COSName.MCID, mcid);
    }

    public String toString() {
        return "mcid=" + this.getMCID();
    }
}

