#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.09';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0105',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfoK5',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type1',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag9400',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag940e',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::mwg_coll',
	'Image::ExifTool::XMP::mwg_kw',
	'Image::ExifTool::XMP::mwg_rs',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'3dpanoramasize' => { 292 => 0x38 },
	'aberrationcorrectiondistance' => { 84 => 0x69 },
	'about' => { 340 => 'about' },
	'abspeakaudiofilepath' => { 346 => 'absPeakAudioFilePath' },
	'accessorytype' => { 235 => 0x53 },
	'actionadvised' => { 98 => 0x2a },
	'activearea' => { 91 => 0xc68d },
	'actived-lighting' => { 172 => 0x22, 200 => 0x24 },
	'actived-lightingmode' => { 200 => 0x25 },
	'addaspectratioinfo' => { 65 => 0x80e },
	'additionalmodelinformation' => { 330 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 65 => 0x80f, 66 => 0x11, 67 => 0x13, 70 => 0x14 },
	'address' => { 124 => 'Address' },
	'adjustmentmode' => { 287 => 0x15 },
	'adobe' => { 92 => 'Adobe' },
	'adultcontentwarning' => { 336 => 'AdultContentWarning', 339 => 'adultContentWarning' },
	'advancedraw' => { 202 => 0x76a43203 },
	'advancedscenetype' => { 235 => 0x3d },
	'advisory' => { 344 => 'Advisory' },
	'ae_iso' => { 240 => 0x2 },
	'aeaperture' => { 240 => 0x1 },
	'aebautocancel' => { 65 => 0x104 },
	'aebbracketvalue' => { 59 => 0x11 },
	'aebsequence' => { 65 => 0x105 },
	'aebsequenceautocancel' => { 63 => 0x9, 64 => 0x9, 66 => 0x8, 67 => 0x9, 70 => 0x9, 71 => 0x7 },
	'aebshotcount' => { 65 => 0x106 },
	'aebxv' => { 240 => 0x4 },
	'aeexposuretime' => { 240 => 0x0 },
	'aelbutton' => { 141 => 0x45 },
	'aelexposureindicator' => { 141 => 0x51 },
	'aelock' => { 141 => 0x5b, 210 => '4.2', 214 => '4.2', 216 => 0x201, 263 => 0x48, 292 => 0x86 },
	'aelockbutton' => { 209 => '16.1', 210 => '4.1', 211 => '15.1', 212 => '30.1', 213 => '16.1', 214 => '4.1', 215 => '17.1' },
	'aelockbuttonplusdials' => { 209 => '16.2', 212 => '32.1' },
	'aelockformb-d80' => { 215 => '3.1' },
	'aemaxaperture' => { 240 => 0x9 },
	'aemaxaperture2' => { 240 => 0xa },
	'aemeteringmode' => { 240 => 0xc },
	'aemeteringsegments' => { 144 => 0x628, 263 => 0x209 },
	'aemicroadjustment' => { 65 => 0x111 },
	'aeminaperture' => { 240 => 0xb },
	'aeminexposuretime' => { 240 => 0x5 },
	'aeprogrammode' => { 240 => 0x6 },
	'aesetting' => { 26 => 0x21 },
	'aexv' => { 240 => 0x3 },
	'af-cpriorityselection' => { 209 => '1.1', 212 => '1.1', 213 => '0.1' },
	'af-onformb-d10' => { 209 => '3.3', 212 => '3.2' },
	'af-onformb-d11' => { 213 => '2.2' },
	'af-spriorityselection' => { 209 => '1.2', 212 => '1.2', 213 => '0.2' },
	'afactivation' => { 209 => '2.1', 212 => '2.1' },
	'afadjustment' => { 263 => 0x72 },
	'afandmeteringbuttons' => { 65 => 0x701 },
	'afaperture' => { 168 => 0x5, 169 => 0x5 },
	'afareaheight' => { 149 => 0x1a },
	'afareaillumination' => { 141 => 0x4b, 214 => '15.3' },
	'afareamode' => { 137 => 0x33, 141 => 0xe, 148 => 0x0, 149 => 0x5, 235 => 0xf, 290 => 0x11, 291 => 0x10, 292 => 0x24 },
	'afareamodesetting' => { 210 => '11.1', 211 => '0.1', 214 => '16.1', 215 => '2.1' },
	'afareas' => { 216 => 0x304 },
	'afareawidth' => { 149 => 0x18 },
	'afareaxposition' => { 149 => 0x14 },
	'afareayposition' => { 149 => 0x16 },
	'afassist' => { 63 => 0x5, 71 => 0x5, 141 => 0x48, 209 => '2.5', 210 => '0.2', 211 => '0.2', 212 => '2.4', 213 => '1.4', 214 => '0.2', 215 => '2.3' },
	'afassistbeam' => { 65 => 0x50e, 66 => 0x4, 67 => 0x5, 68 => 0x4, 69 => 0x4, 70 => 0x5 },
	'afassistlamp' => { 235 => 0x31 },
	'afbuttonpressed' => { 292 => 0x83 },
	'afdefocus' => { 241 => 0x6 },
	'afduringliveview' => { 65 => 0x511 },
	'affinea' => { 315 => 'AffineA' },
	'affineb' => { 315 => 'AffineB' },
	'affinec' => { 315 => 'AffineC' },
	'affined' => { 315 => 'AffineD' },
	'affinetune' => { 150 => 0x0, 216 => 0x306 },
	'affinetuneadj' => { 150 => 0x2, 180 => 0x2d1, 181 => 0x2dc, 216 => 0x307 },
	'affinetuneindex' => { 150 => 0x1 },
	'affinex' => { 315 => 'AffineX' },
	'affiney' => { 315 => 'AffineY' },
	'afilluminator' => { 290 => 0x29, 301 => 0xb044 },
	'afimageheight' => { 149 => 0x12 },
	'afimagewidth' => { 149 => 0x10 },
	'afintegrationtime' => { 241 => 0x7 },
	'afmicroadj' => { 308 => 0x17d },
	'afmicroadjmode' => { 1 => 0x1, 289 => 0x131 },
	'afmicroadjregisteredlenses' => { 289 => '305.1' },
	'afmicroadjustment' => { 65 => 0x507 },
	'afmicroadjvalue' => { 1 => 0x2, 289 => 0x130 },
	'afmode' => { 88 => 0x3009, 137 => 0x16, 287 => 0x5, 301 => 0xb043, 306 => 0x17 },
	'afonaelockbuttonswitch' => { 65 => 0x702 },
	'afonbutton' => { 209 => '3.1' },
	'afpoint' => { 26 => 0x13, 87 => 0x18, 137 => 0x15, 148 => 0x1, 219 => 0x308, 287 => 0x1f, 288 => 0x20 },
	'afpointactivationarea' => { 64 => 0x11, 70 => 0x11 },
	'afpointareaexpansion' => { 65 => 0x508 },
	'afpointautoselection' => { 65 => 0x50b },
	'afpointbrightness' => { 65 => 0x50d, 209 => '2.4' },
	'afpointdisplayduringfocus' => { 65 => 0x50c },
	'afpointillumination' => { 64 => 0xa, 209 => '2.3', 212 => '2.3', 213 => '1.3', 215 => '2.4' },
	'afpointmode' => { 245 => 0x3 },
	'afpointposition' => { 88 => 0x2021, 235 => 0x4d },
	'afpointregistration' => { 63 => 0x7 },
	'afpoints' => { 140 => 0x10 },
	'afpointselected' => { 141 => 0xd, 216 => 0x305, 263 => 0xe, 288 => 0x1c, 290 => 0x12, 291 => 0x11 },
	'afpointselected2' => { 245 => 0x4 },
	'afpointselection' => { 64 => 0xb, 209 => '1.3', 212 => '1.3' },
	'afpointselectionmethod' => { 65 => 0x50f, 66 => 0xc, 67 => 0xd, 70 => 0xd },
	'afpointsinfocus' => { 59 => 0xe, 148 => 0x2, 241 => 0xb, 263 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 16 => 0x38 },
	'afpointspotmetering' => { 64 => 0xd },
	'afpointsunknown1' => { 241 => 0x0 },
	'afpointsunknown2' => { 241 => 0x2 },
	'afpointsused' => { 149 => 0x8 },
	'afpredictor' => { 241 => 0x4 },
	'afresponse' => { 172 => 0xad },
	'afresult' => { 221 => 0x1038 },
	'afsearch' => { 216 => 0x303 },
	'afsensoractive' => { 137 => 0x1 },
	'afstatusactivesensor' => { 137 => 0x2 },
	'afstatusbottom' => { 137 => 0x8 },
	'afstatusbottom-left' => { 137 => 0x12 },
	'afstatusbottom-right' => { 137 => 0x6 },
	'afstatuscenterhorizontal' => { 137 => 0x2f },
	'afstatuscentervertical' => { 137 => 0xc },
	'afstatusleft' => { 137 => 0x2d },
	'afstatusmiddlehorizontal' => { 137 => 0xa },
	'afstatusright' => { 137 => 0x31 },
	'afstatustop' => { 137 => 0xe },
	'afstatustop-left' => { 137 => 0x10 },
	'afstatustop-right' => { 137 => 0x4 },
	'afwithshutter' => { 290 => 0x2a },
	'aggregationtype' => { 337 => 'aggregationType' },
	'agreement' => { 339 => 'agreement' },
	'aiservocontinuousshooting' => { 64 => 0x15 },
	'aiservoimagepriority' => { 65 => 0x503 },
	'aiservotrackingmethod' => { 65 => 0x504 },
	'aiservotrackingsensitivity' => { 64 => 0x14, 65 => 0x502 },
	'album' => { 346 => 'album' },
	'alreadyapplied' => { 321 => 'AlreadyApplied' },
	'alternatetitle' => { 337 => 'alternateTitle' },
	'alttapename' => { 346 => 'altTapeName' },
	'alttimecode' => { 346 => 'altTimecode' },
	'alttimecodetimeformat' => { 346 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 346 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 346 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 2 => 0x1 },
	'ambienttemperature' => { 275 => 0x14, 306 => 0x4 },
	'ambienttemperaturefahrenheit' => { 275 => 0x13 },
	'analogbalance' => { 91 => 0xc627 },
	'angleadj' => { 84 => 0x8b },
	'angleinforoll' => { 317 => 'AngleInfoRoll' },
	'anti-blur' => { 301 => 0xb04b },
	'antialiasstrength' => { 91 => 0xc632 },
	'aperturerange' => { 65 => 0x10d },
	'apertureringuse' => { 245 => '1.4' },
	'aperturesetting' => { 141 => 0x7, 290 => 0x30, 291 => 0x29, 292 => 0x1 },
	'aperturevalue' => { 74 => 0x2, 91 => 0x9202, 221 => 0x1002, 325 => 'ApertureValue' },
	'applekeywords' => { 225 => 'AAPL:Keywords' },
	'applicationnotes' => { 91 => 0x2bc, 239 => 0x2bc },
	'applicationrecordversion' => { 98 => 0x0 },
	'applyshootingmeteringmode' => { 65 => 0x10e },
	'approved' => { 326 => 'Approved' },
	'approvedby' => { 326 => 'ApprovedBy' },
	'approximatefnumber' => { 231 => 0x313, 237 => 0x3406 },
	'approximatefocusdistance' => { 318 => 'ApproximateFocusDistance' },
	'armidentifier' => { 99 => 0x78 },
	'armversion' => { 99 => 0x7a },
	'artfilter' => { 216 => 0x529 },
	'artfiltereffect' => { 216 => 0x52f },
	'artist' => { 91 => 0x13b, 227 => 'Artist', 263 => 0x22e, 342 => 'Artist', 346 => 'artist' },
	'artmode' => { 88 => 0x301b },
	'artmodeparameters' => { 88 => 0x310b },
	'artworkcopyrightnotice' => { 330 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcreator' => { 330 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkdatecreated' => { 330 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworkorobject' => { 330 => 'ArtworkOrObject' },
	'artworksource' => { 330 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 330 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworktitle' => { 330 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 220 => 0x1113 },
	'aspectratio' => { 3 => 0x0, 220 => 0x1112, 263 => 0x80, 290 => 0x55, 291 => 0x55, 292 => 0xa },
	'asshoticcprofile' => { 91 => 0xc68f },
	'asshotneutral' => { 91 => 0xc628 },
	'asshotpreprofilematrix' => { 91 => 0xc690 },
	'asshotprofilename' => { 91 => 0xc6f6 },
	'asshotwhitexy' => { 91 => 0xc629 },
	'assignbktbutton' => { 209 => '4.2' },
	'assignfuncbutton' => { 65 => 0x70b },
	'assistbuttonfunction' => { 63 => 0xd },
	'attributionname' => { 319 => 'attributionName' },
	'attributionurl' => { 319 => 'attributionURL' },
	'audio' => { 235 => 0x20 },
	'audiobitrate' => { 51 => 0x6c },
	'audiochannels' => { 51 => 0x70 },
	'audiochanneltype' => { 346 => 'audioChannelType' },
	'audiocompression' => { 118 => 'Compression' },
	'audiocompressor' => { 346 => 'audioCompressor' },
	'audioduration' => { 98 => 0x99 },
	'audiomoddate' => { 346 => 'audioModDate' },
	'audiooutcue' => { 98 => 0x9a },
	'audiosamplerate' => { 51 => 0x6e, 346 => 'audioSampleRate' },
	'audiosampletype' => { 346 => 'audioSampleType' },
	'audiosamplingrate' => { 98 => 0x97 },
	'audiosamplingresolution' => { 98 => 0x98 },
	'audiotype' => { 98 => 0x96 },
	'author' => { 120 => 'Author', 225 => 'Author', 227 => 'Author', 274 => 'Author', 316 => 'author', 334 => 'Author', 344 => 'Author' },
	'authorsposition' => { 335 => 'AuthorsPosition' },
	'autoaperture' => { 254 => '0.1' },
	'autobracket' => { 287 => 0x19 },
	'autobracketing' => { 95 => 0x1100, 263 => 0x18 },
	'autobracketmodem' => { 209 => '21.2', 212 => '26.2' },
	'autobracketorder' => { 141 => 0x43, 209 => '21.3', 212 => '26.3', 213 => '12.2', 214 => '2.2', 215 => '13.2' },
	'autobracketset' => { 209 => '21.1', 211 => '11.1', 212 => '26.1', 213 => '12.1', 214 => '2.1', 215 => '13.1' },
	'autobrightness' => { 321 => 'AutoBrightness' },
	'autocontrast' => { 321 => 'AutoContrast' },
	'autodistortioncontrol' => { 157 => 0x4 },
	'autodynamicrange' => { 95 => 0x140b },
	'autoexposure' => { 321 => 'AutoExposure' },
	'autoexposurebracketing' => { 59 => 0x10 },
	'autofocus' => { 219 => 0x209 },
	'autofp' => { 214 => '7.3', 215 => '31.4' },
	'autoiso' => { 59 => 0x1, 88 => 0x3008, 210 => '1.1', 214 => '1.1' },
	'autoisomax' => { 210 => '1.2', 214 => '1.2' },
	'autoisominshutterspeed' => { 210 => '1.3', 214 => '1.3' },
	'autolateralca' => { 321 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 13 => 0xbe, 14 => 0xbf, 17 => 0xbf, 47 => 0x2, 65 => 0x204, 84 => 0x6f },
	'autolightingoptimizeron' => { 84 => 0x6e },
	'autoredeye' => { 202 => 0xfe28a44f },
	'autorotate' => { 59 => 0x1b },
	'autoshadows' => { 321 => 'AutoShadows' },
	'auxiliarylens' => { 172 => 0x82 },
	'avaperturesetting' => { 245 => 0x13 },
	'averagelv' => { 144 => 0x38 },
	'avsettingwithoutlens' => { 65 => 0x707 },
	'azimuth' => { 128 => 'Azimuth' },
	'babyage' => { 235 => [0x8010,0x33] },
	'babyname' => { 235 => 0x66 },
	'backgroundalpha' => { 341 => 'bgalpha' },
	'baseexposurecompensation' => { 245 => 0x15 },
	'baseiso' => { 59 => 0x2, 78 => 0x101c, 237 => 0x312a },
	'baselineexposure' => { 91 => 0xc62a },
	'baselinenoise' => { 91 => 0xc62b },
	'baselinesharpness' => { 91 => 0xc62c },
	'baseurl' => { 344 => 'BaseURL' },
	'batterylevel' => { 290 => 0x51, 294 => 0xc, 295 => 0x4, 296 => 0x4 },
	'batteryorder' => { 209 => '12.5', 212 => '13.2', 213 => '2.1' },
	'batterystate' => { 141 => 0x60, 296 => 0x14 },
	'batterytemperature' => { 294 => 0x1, 296 => 0x2 },
	'batteryunknown' => { 294 => 0x2, 296 => 0x0 },
	'batteryvoltage' => { 275 => 0x2a, 294 => 0x8 },
	'batteryvoltage1' => { 296 => 0x6 },
	'batteryvoltage2' => { 296 => 0x8 },
	'bayergreensplit' => { 91 => 0xc62d },
	'bayerpattern' => { 102 => 0xf902, 145 => 0x17 },
	'beatspliceparams' => { 346 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 346 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 346 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 346 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 346 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 346 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 209 => '13.1', 210 => '0.1', 211 => '2.1', 212 => '10.1', 214 => '0.1', 215 => '4.1' },
	'beeppitch' => { 213 => '3.1' },
	'beepvolume' => { 213 => '4.5' },
	'bestqualityscale' => { 91 => 0xc65c },
	'bestshotmode' => { 88 => 0x3007 },
	'bitdepth' => { 125 => 'BitDepth', 145 => 0x11, 177 => 0x41 },
	'bitspercomponent' => { 100 => 0x87 },
	'bitspersample' => { 91 => 0x102, 342 => 'BitsPerSample' },
	'blacklevel' => { 91 => 0xc61a, 221 => 0x1012 },
	'blacklevel2' => { 220 => 0x600, 224 => 0x600 },
	'blacklevelrepeatdim' => { 91 => 0xc619 },
	'blackpoint' => { 263 => 0x200 },
	'blacks2012' => { 321 => 'Blacks2012' },
	'bleachbypasstoning' => { 263 => 0x7f },
	'bluebalance' => { 156 => 0x271, 221 => 0x1018, 239 => 0x12, 263 => 0x1b },
	'bluecurvelimits' => { 83 => 0x1fe },
	'bluecurvepoints' => { 83 => 0x1d4 },
	'bluehue' => { 321 => 'BlueHue' },
	'bluesaturation' => { 321 => 'BlueSaturation' },
	'blurcontrol' => { 263 => 0x82 },
	'blurwarning' => { 95 => 0x1300 },
	'bodybatteryadload' => { 243 => 0x3 },
	'bodybatteryadnoload' => { 243 => 0x2 },
	'bodybatterystate' => { 243 => '1.1' },
	'bodybatteryvoltage1' => { 243 => 0x2 },
	'bodybatteryvoltage2' => { 243 => 0x4 },
	'bodybatteryvoltage3' => { 243 => 0x6 },
	'bodybatteryvoltage4' => { 243 => 0x8 },
	'bodyfirmware' => { 280 => 0x0 },
	'bodyfirmwareversion' => { 217 => 0x104, 218 => 0x100, 221 => 0x104 },
	'bodyserialnumber' => { 280 => 0x10 },
	'bracketmode' => { 43 => 0x3 },
	'bracketsequence' => { 88 => 0x301d },
	'bracketshotnumber' => { 43 => 0x5, 245 => 0x9, 300 => 0x2b },
	'bracketshotnumber2' => { 300 => 0x2d },
	'bracketstep' => { 138 => 0xe },
	'bracketvalue' => { 43 => 0x4 },
	'brightness' => { 91 => 0xfe53, 119 => 'Brightness', 138 => 0x2c, 174 => 0x34, 275 => 0x25, 290 => 0x22, 301 => 0x2007, 321 => 'Brightness' },
	'brightnessadj' => { 83 => 0x114, 195 => 0x0, 205 => 0x2d, 309 => 0x8018 },
	'brightnessvalue' => { 91 => 0x9203, 144 => [0x691,0x49c3], 221 => 0x1003, 325 => 'BrightnessValue' },
	'bulbduration' => { 59 => 0x18 },
	'burstmode' => { 105 => 0xa, 235 => 0x2a },
	'burstmode2' => { 105 => 0x18 },
	'burstshot' => { 287 => 0x34 },
	'buttonfunctioncontroloff' => { 65 => 0x70a },
	'bwfilter' => { 138 => 0x2a, 146 => 0x39 },
	'bwmode' => { 221 => 0x203 },
	'by-line' => { 98 => 0x50 },
	'by-linetitle' => { 98 => 0x55 },
	'bytecount' => { 337 => 'byteCount' },
	'calibration' => { 287 => [0x24,0x30] },
	'calibrationilluminant1' => { 91 => 0xc65a },
	'calibrationilluminant2' => { 91 => 0xc65b },
	'cameraangle' => { 346 => 'cameraAngle' },
	'cameracalibration1' => { 91 => 0xc623 },
	'cameracalibration2' => { 91 => 0xc624 },
	'cameracalibrationsig' => { 91 => 0xc6f3 },
	'cameracolorcalibration01' => { 28 => 0x0, 34 => 0xba },
	'cameracolorcalibration02' => { 28 => 0x4, 34 => 0xbf },
	'cameracolorcalibration03' => { 28 => 0x8, 34 => 0xc4 },
	'cameracolorcalibration04' => { 28 => 0xc, 34 => 0xc9 },
	'cameracolorcalibration05' => { 28 => 0x10, 34 => 0xce },
	'cameracolorcalibration06' => { 28 => 0x14, 34 => 0xd3 },
	'cameracolorcalibration07' => { 28 => 0x18, 34 => 0xd8 },
	'cameracolorcalibration08' => { 28 => 0x1c, 34 => 0xdd },
	'cameracolorcalibration09' => { 28 => 0x20, 34 => 0xe2 },
	'cameracolorcalibration10' => { 28 => 0x24, 34 => 0xe7 },
	'cameracolorcalibration11' => { 28 => 0x28, 34 => 0xec },
	'cameracolorcalibration12' => { 28 => 0x2c, 34 => 0xf1 },
	'cameracolorcalibration13' => { 28 => 0x30, 34 => 0xf6 },
	'cameracolorcalibration14' => { 28 => 0x34, 34 => 0xfb },
	'cameracolorcalibration15' => { 28 => 0x38, 34 => 0x100 },
	'cameraid' => { 221 => 0x209, 286 => 0x209 },
	'cameraiso' => { 26 => 0x10 },
	'cameralabel' => { 346 => 'cameraLabel' },
	'cameramodel' => { 346 => 'cameraModel' },
	'cameramove' => { 346 => 'cameraMove' },
	'cameraorientation' => { 4 => 0x30, 6 => 0x7a, 8 => 0x30, 10 => 0x35, 11 => 0x30, 12 => 0x30, 13 => 0x31, 14 => 0x31, 15 => 0x35, 16 => 0x27, 17 => 0x31, 18 => 0x7d, 19 => 0x38, 20 => 0x36, 21 => 0x7d, 22 => 0x35, 265 => 0x1, 296 => 0x18, 305 => 0x28 },
	'cameraowner' => { 106 => 0xc353 },
	'cameraparameters' => { 221 => 0x2050 },
	'cameraprofile' => { 321 => 'CameraProfile' },
	'cameraprofiledigest' => { 321 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 91 => 0xc62f, 136 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 216 => 0x0 },
	'cameratemperature' => { 4 => 0x18, 6 => 0x1b, 8 => 0x18, 10 => 0x19, 11 => 0x18, 12 => 0x18, 13 => 0x19, 14 => 0x19, 15 => 0x19, 16 => 0x17, 17 => 0x19, 18 => 0x1b, 19 => 0x19, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => [0x87,0x91], 24 => [0x99,0x9f,0xa4,0xa8,0x105], 25 => [0x64,0x1d2,0x1f7,0x1fa,0x208,0x20c,0x47,0x53,0x5b,0x5c], 59 => 0xc, 231 => 0x320, 237 => 0x3402, 263 => 0x47, 284 => 0x43, 307 => 0x5 },
	'cameratemperature2' => { 266 => 0xc },
	'cameratemperature3' => { 266 => 0xe },
	'cameratemperature4' => { 266 => 0x14 },
	'cameratemperature5' => { 266 => 0x16 },
	'cameratype' => { 59 => 0x1a, 221 => 0x207 },
	'cameratype2' => { 217 => 0x100 },
	'canonexposuremode' => { 26 => 0x14 },
	'canonfiledescription' => { 78 => 0x805 },
	'canonfilelength' => { 48 => 0xe },
	'canonfirmwareversion' => { 48 => 0x7, 78 => 0x80b },
	'canonflashinfo' => { 78 => 0x1028 },
	'canonflashmode' => { 26 => 0x4 },
	'canonimagesize' => { 7 => 0x39, 26 => 0xa },
	'canonimagetype' => { 48 => 0x6, 78 => 0x815 },
	'canonmodelid' => { 48 => 0x10, 78 => 0x1834 },
	'canonvrd' => { 92 => 'CanonVRD' },
	'caption' => { 316 => 'caption' },
	'caption-abstract' => { 98 => 0x78 },
	'captionsauthornames' => { 324 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 324 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 335 => 'CaptionWriter' },
	'captureframerate' => { 88 => 0x4001 },
	'cardshutterlock' => { 141 => 0x49 },
	'casioimagesize' => { 88 => 0x9 },
	'catalogsets' => { 98 => 0xff, 312 => 'CatalogSets', 314 => 'CatalogSets' },
	'categories' => { 48 => 0x23, 316 => 'categories' },
	'category' => { 98 => 0xf, 335 => 'Category' },
	'ccdboardversion' => { 231 => 0x331 },
	'ccdscanmode' => { 221 => 0x1039 },
	'ccdsensitivity' => { 192 => 0x6 },
	'ccdversion' => { 231 => 0x330 },
	'cellglobalid' => { 320 => 'cgi' },
	'celllength' => { 91 => 0x109 },
	'cellr' => { 320 => 'r' },
	'celltowerid' => { 320 => 'cellid' },
	'cellwidth' => { 91 => 0x108 },
	'centerafarea' => { 214 => '15.1' },
	'centerfocuspoint' => { 215 => '2.2' },
	'centerweightedareasize' => { 209 => '7.1', 212 => '5.1', 213 => '7.1', 214 => '6.3', 215 => '8.1' },
	'certificate' => { 350 => 'Certificate' },
	'cfapattern' => { 91 => 0xa302, 325 => 'CFAPattern' },
	'cfapattern2' => { 91 => 0x828e },
	'cfapatterncolumns' => { 325 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 325 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 325 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 91 => 0x828d },
	'channel' => { 337 => 'channel' },
	'channels' => { 118 => 'Channels' },
	'checkmark' => { 83 => 0x26a },
	'checkmark2' => { 84 => 0x8e },
	'childfontfiles' => { 351 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 209 => '10.3' },
	'chromablurradius' => { 91 => 0xc631 },
	'chromaticaberration' => { 84 => 0x66 },
	'chromaticaberrationb' => { 321 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 84 => 0x6b },
	'chromaticaberrationcorrection' => { 253 => 0x1 },
	'chromaticaberrationon' => { 84 => 0x62 },
	'chromaticaberrationr' => { 321 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 84 => 0x6a },
	'chrominancenoisereduction' => { 84 => 0x5e, 287 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 84 => 0x60 },
	'city' => { 98 => 0x5a, 124 => 'City', 235 => 0x6d, 335 => 'City' },
	'clarity' => { 321 => 'Clarity' },
	'clarity2012' => { 321 => 'Clarity2012' },
	'classifystate' => { 98 => 0xe1 },
	'client' => { 346 => 'client' },
	'clientname' => { 326 => 'ClientName' },
	'clmodeshootingspeed' => { 209 => '10.2', 212 => '11.2', 213 => '10.2', 215 => '11.1' },
	'cmcontrast' => { 224 => 0x2022 },
	'cmexposurecompensation' => { 224 => 0x2000 },
	'cmhue' => { 224 => 0x2021 },
	'cmsaturation' => { 224 => 0x2020 },
	'cmsharpness' => { 224 => 0x2023 },
	'cmwhitebalance' => { 224 => 0x2001 },
	'cmwhitebalancecomp' => { 224 => 0x2002 },
	'cmwhitebalancegraypoint' => { 224 => 0x2010 },
	'codec' => { 132 => 'Codec' },
	'codedcharacterset' => { 99 => 0x5a },
	'collectionname' => { 331 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 331 => 'Collections' },
	'collectionuri' => { 331 => [\'Collections','CollectionsCollectionURI'] },
	'coloraberrationcontrol' => { 202 => 0xc89224b },
	'coloradjustment' => { 287 => 0x14 },
	'coloradjustmentmode' => { 286 => 0x210 },
	'coloranta' => { 351 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 351 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 351 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 351 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 351 => [\'Colorants','ColorantsCyan'] },
	'colorantgreen' => { 351 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 351 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 351 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 351 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 351 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 351 => 'Colorants' },
	'colorantswatchname' => { 351 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 351 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 351 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 351 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 119 => 'ColorBalance' },
	'colorbalanceadj' => { 202 => 0x76a43202 },
	'colorbalanceblue' => { 138 => 0x1e },
	'colorbalancegreen' => { 138 => 0x1d },
	'colorbalancered' => { 138 => 0x1c },
	'colorblur' => { 84 => 0x65 },
	'colorbooster' => { 202 => 0x5f0e7d23 },
	'colorboostlevel' => { 196 => 0x1 },
	'colorboosttype' => { 196 => 0x0 },
	'colorclass' => { 269 => 0xde },
	'colorcompensationfilter' => { 141 => [0x3a,0x5f], 143 => 0x111, 301 => 0xb022 },
	'colorcompensationfilterset' => { 290 => 0xd, 291 => 0xc, 292 => 0x18, 302 => 0xf },
	'colorcontrol' => { 221 => 0x102b },
	'colorcorrection' => { 309 => 0x8015 },
	'colordataversion' => { 32 => 0x0, 33 => 0x0, 35 => 0x0, 36 => 0x0 },
	'coloreffect' => { 235 => 0x28 },
	'colorfilter' => { 87 => 0x17, 88 => 0x3017, 138 => 0x29, 146 => [0x38,0x4d,0x4f], 268 => 0x17 },
	'colorgain' => { 177 => 0x51 },
	'colorhue' => { 172 => 0x8d },
	'colorimetricreference' => { 91 => 0xc6bf },
	'colorlabel' => { 324 => 'ColorLabel' },
	'colormatrix' => { 220 => 0x200, 221 => 0x1011, 284 => 0xa030 },
	'colormatrix1' => { 91 => 0xc621 },
	'colormatrix2' => { 91 => 0xc622, 224 => 0x200 },
	'colormatrixa' => { 263 => 0x203 },
	'colormatrixadobergb' => { 284 => 0xa032 },
	'colormatrixb' => { 263 => 0x204 },
	'colormatrixnumber' => { 221 => 0x1019 },
	'colormatrixsrgb' => { 284 => 0xa031 },
	'colormode' => { 88 => 0x3015, 95 => 0x1210, 105 => 0x66, 138 => 0x28, 141 => 0x16, 143 => 0x101, 144 => 0x36, 146 => 0x7, 172 => 0x3, 192 => 0x4, 235 => 0x32, 287 => 0x2c, 301 => 0xb029, 335 => 'ColorMode' },
	'colormoirereduction' => { 203 => 0x15 },
	'colormoirereductionmode' => { 203 => 0x5 },
	'colornoisereduction' => { 309 => 0x8029, 321 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 321 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 203 => 0x18 },
	'colornoisereductionsharpness' => { 203 => 0x1c },
	'colorplanes' => { 94 => 0x2 },
	'colorprofile' => { 138 => 0x33 },
	'colorrepresentation' => { 100 => 0x3c },
	'colorreproduction' => { 301 => 0xb020 },
	'colorsequence' => { 100 => 0x41 },
	'colorspace' => { 37 => 0x3, 48 => 0xb4, 78 => 0x10b4, 91 => 0xa001, 125 => 'ColorSpace', 139 => 0x2f, 140 => 0x25, 141 => 0x17, 172 => 0x1e, 216 => 0x507, 263 => 0x37, 284 => 0xa011, 287 => 0xb, 290 => 0x1b, 291 => 0x83, 292 => 0xe, 302 => 0x6, 325 => 'ColorSpace' },
	'colortempasshot' => { 29 => 0x4, 30 => 0x1d, 31 => 0x26, 32 => 0x43, 35 => 0x43, 36 => 0x43 },
	'colortempauto' => { 29 => 0x9, 30 => 0x22, 31 => 0x1c, 32 => 0x48, 35 => 0x48, 36 => 0x48 },
	'colortempcloudy' => { 29 => 0x22, 30 => 0x31, 31 => 0x35, 32 => 0x5c, 35 => 0x75, 36 => 0x75 },
	'colortempcustom' => { 32 => 0x84 },
	'colortempcustom1' => { 30 => 0x45 },
	'colortempcustom2' => { 30 => 0x4a },
	'colortempdaylight' => { 29 => 0x18, 30 => 0x27, 31 => 0x2b, 32 => 0x52, 35 => 0x6b, 36 => 0x6b },
	'colortemperature' => { 4 => 0x73, 5 => [0x48,0x4e], 6 => 0xb9, 7 => 0x37, 8 => 0x62, 9 => 0x37, 10 => 0x7c, 11 => 0x73, 12 => 0x73, 13 => 0x77, 14 => 0x73, 15 => 0x7c, 16 => 0x58, 17 => 0x73, 18 => 0xc0, 19 => 0x7f, 20 => 0x7d, 21 => 0xc0, 22 => 0x7b, 48 => 0xae, 57 => 0x9, 78 => 0x10ae, 95 => 0x1005, 103 => 0x846, 119 => 'ColorTemperature', 139 => [0x6e,0x49], 140 => 0x3f, 141 => [0x39,0x5e], 143 => 0x10b, 146 => [0x3c,0x4c,0x4e], 231 => 0x321, 263 => 0x50, 301 => 0xb021, 321 => 'Temperature' },
	'colortemperatureadj' => { 309 => 0x8013 },
	'colortemperaturebg' => { 221 => 0x1013 },
	'colortemperaturerg' => { 221 => 0x1014 },
	'colortemperaturesetting' => { 141 => 0x25, 290 => 0xc, 291 => 0xb, 292 => 0x17, 302 => 0xe },
	'colortempflash' => { 29 => 0x36, 30 => 0x40, 31 => 0x49, 32 => 0x70, 35 => 0x89, 36 => 0x89 },
	'colortempflashdata' => { 32 => 0x24a },
	'colortempfluorescent' => { 29 => 0x2c, 30 => 0x3b, 31 => 0x3f, 32 => 0x66, 35 => 0x7f, 36 => 0x7f },
	'colortempkelvin' => { 29 => 0x31, 31 => 0x44, 32 => 0x6b, 35 => 0x84, 36 => 0x84, 235 => 0x44 },
	'colortempmeasured' => { 29 => 0xe, 32 => 0x4d, 35 => 0x4d, 36 => 0x4d },
	'colortemppc1' => { 31 => 0x94, 32 => 0x75 },
	'colortemppc2' => { 31 => 0x99, 32 => 0x7a },
	'colortemppc3' => { 31 => 0x9e, 32 => 0x7f },
	'colortempshade' => { 29 => 0x1d, 30 => 0x2c, 31 => 0x30, 32 => 0x57, 35 => 0x70, 36 => 0x70 },
	'colortemptungsten' => { 29 => 0x27, 30 => 0x36, 31 => 0x3a, 32 => 0x61, 35 => 0x7a, 36 => 0x7a },
	'colortempunknown' => { 29 => 0x13, 31 => 0x21, 35 => 0x52, 36 => 0x52 },
	'colortempunknown10' => { 29 => 0x63, 31 => 0x76, 35 => 0xa2, 36 => 0xa2 },
	'colortempunknown11' => { 29 => 0x68, 31 => 0x7b, 35 => 0xa7, 36 => 0xa7 },
	'colortempunknown12' => { 29 => 0x6d, 31 => 0x80, 35 => 0xac, 36 => 0xac },
	'colortempunknown13' => { 29 => 0x72, 31 => 0x85, 35 => 0xb1, 36 => 0xb1 },
	'colortempunknown14' => { 31 => 0x8a, 35 => 0xb6, 36 => 0xb6 },
	'colortempunknown15' => { 31 => 0x8f, 35 => 0xbb, 36 => 0xbb },
	'colortempunknown16' => { 31 => 0xa3, 36 => 0xc0 },
	'colortempunknown17' => { 36 => 0xc5 },
	'colortempunknown18' => { 36 => 0xca },
	'colortempunknown19' => { 36 => 0xcf },
	'colortempunknown2' => { 29 => 0x3b, 31 => 0x4e, 35 => 0x57, 36 => 0x57 },
	'colortempunknown20' => { 36 => 0xd4 },
	'colortempunknown3' => { 29 => 0x40, 31 => 0x53, 35 => 0x5c, 36 => 0x5c },
	'colortempunknown4' => { 29 => 0x45, 31 => 0x58, 35 => 0x61, 36 => 0x61 },
	'colortempunknown5' => { 29 => 0x4a, 31 => 0x5d, 35 => 0x66, 36 => 0x66 },
	'colortempunknown6' => { 29 => 0x4f, 31 => 0x62, 35 => 0x8e, 36 => 0x8e },
	'colortempunknown7' => { 29 => 0x54, 31 => 0x67, 35 => 0x93, 36 => 0x93 },
	'colortempunknown8' => { 29 => 0x59, 31 => 0x6c, 35 => 0x98, 36 => 0x98 },
	'colortempunknown9' => { 29 => 0x5e, 31 => 0x71, 35 => 0x9d, 36 => 0x9d },
	'colortone' => { 7 => 0x6f, 9 => 0x77, 26 => 0x2a, 37 => 0x2 },
	'colortoneadj' => { 83 => 0x11e },
	'colortonefaithful' => { 16 => 0x107, 53 => 0x6c, 54 => 0x6c },
	'colortonelandscape' => { 16 => 0x105, 53 => 0x3c, 54 => 0x3c },
	'colortonemonochrome' => { 53 => 0x84, 54 => 0x84 },
	'colortoneneutral' => { 16 => 0x106, 53 => 0x54, 54 => 0x54 },
	'colortoneportrait' => { 16 => 0x104, 53 => 0x24, 54 => 0x24 },
	'colortonestandard' => { 16 => 0x103, 53 => 0xc, 54 => 0xc },
	'colortoneunknown' => { 54 => 0x9c },
	'colortoneuserdef1' => { 16 => 0x109, 53 => 0x9c, 54 => 0xb4 },
	'colortoneuserdef2' => { 16 => 0x10a, 53 => 0xb4, 54 => 0xcc },
	'colortoneuserdef3' => { 16 => 0x10b, 53 => 0xcc, 54 => 0xe4 },
	'commanddials' => { 214 => '5.1' },
	'commanddialsaperturesetting' => { 209 => '17.3', 212 => '33.3', 213 => '17.3' },
	'commanddialschangemainsub' => { 209 => '17.2', 212 => '33.2', 213 => '17.2' },
	'commanddialsmenuandplayback' => { 209 => '17.4', 212 => '33.4', 213 => '17.4' },
	'commanddialsreverserotation' => { 209 => '17.1', 211 => '16.2', 212 => '33.1', 213 => '17.1', 215 => '18.1' },
	'commanderchannel' => { 214 => '10.2' },
	'commandergroupa_ttl-aacomp' => { 214 => '13.1' },
	'commandergroupa_ttlcomp' => { 215 => '32.1' },
	'commandergroupamanualoutput' => { 214 => '13.2' },
	'commandergroupamode' => { 214 => '11.2' },
	'commandergroupb_ttl-aacomp' => { 214 => '14.1' },
	'commandergroupb_ttlcomp' => { 215 => '33.1' },
	'commandergroupbmanualoutput' => { 214 => '14.2' },
	'commandergroupbmode' => { 214 => '11.3' },
	'commanderinternalflash' => { 214 => '11.1' },
	'commanderinternalmanualoutput' => { 214 => '12.2' },
	'commanderinternalttlchannel' => { 212 => '18.2' },
	'commanderinternalttlcomp' => { 214 => '12.1', 215 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 212 => '20.1', 213 => '26.1' },
	'commanderinternalttlcompgroupa' => { 212 => '21.1', 213 => '27.1' },
	'commanderinternalttlcompgroupb' => { 212 => '22.1', 213 => '28.1' },
	'comment' => { 0 => 0x2, 92 => 'Comment', 120 => 'Comment', 227 => 'Comment' },
	'complianceprofile' => { 337 => 'complianceProfile' },
	'componentsconfiguration' => { 91 => 0x9101, 125 => 'Components', 325 => 'ComponentsConfiguration' },
	'componentversion' => { 78 => 0x80c },
	'composer' => { 346 => 'composer' },
	'compositionadjust' => { 262 => '0.1' },
	'compositionadjustrotation' => { 262 => 0x7 },
	'compositionadjustx' => { 262 => 0x5 },
	'compositionadjusty' => { 262 => 0x6 },
	'compressedbitsperpixel' => { 91 => 0x9102, 325 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 143 => 0x40, 221 => 0x40 },
	'compression' => { 91 => 0x103, 342 => 'Compression' },
	'compressionfactor' => { 216 => 0x50d },
	'compressionratio' => { 125 => 'Compression', 221 => 0x1034 },
	'confidencelevel' => { 317 => 'ConfidenceLevel' },
	'constrainedcropheight' => { 83 => 0x266, 269 => 0xd6 },
	'constrainedcropwidth' => { 83 => 0x262, 269 => 0xd5 },
	'contact' => { 98 => 0x76 },
	'contentlocationcode' => { 98 => 0x1a },
	'contentlocationname' => { 98 => 0x1b },
	'continuousbracketing' => { 141 => 0x20 },
	'continuousdrive' => { 26 => 0x5 },
	'continuousshootingspeed' => { 65 => 0x610 },
	'continuousshotlimit' => { 65 => 0x611 },
	'contrast' => { 7 => 0x73, 9 => 0x75, 26 => 0xd, 87 => 0xc, 88 => [0x3012,0x20], 91 => [0xa408,0xfe54], 95 => [0x1004,0x1006], 119 => 'Contrast', 138 => 0x20, 139 => 0x31, 140 => 0x27, 141 => 0x19, 146 => 0x2, 174 => 0x33, 221 => 0x1029, 235 => 0x39, 237 => 0x300a, 263 => 0x20, 268 => 0xc, 275 => 0x24, 287 => 0xd, 290 => 0x1d, 291 => 0x1a, 301 => 0x2004, 321 => 'Contrast', 325 => 'Contrast' },
	'contrast2012' => { 321 => 'Contrast2012' },
	'contrastadj' => { 83 => 0x115, 205 => 0x2c, 309 => 0x8017 },
	'contrastcurve' => { 172 => 0x8c },
	'contrastdetectaf' => { 149 => 0x4 },
	'contrastdetectafarea' => { 263 => 0x231 },
	'contrastdetectafinfocus' => { 149 => 0x1c },
	'contrastfaithful' => { 16 => 0xec, 53 => 0x60, 54 => 0x60 },
	'contrasthighlight' => { 263 => 0x6d },
	'contrasthighlightshadowadj' => { 263 => 0x6f },
	'contrastlandscape' => { 16 => 0xea, 53 => 0x30, 54 => 0x30 },
	'contrastmode' => { 235 => 0x2c },
	'contrastmonochrome' => { 16 => 0xed, 53 => 0x78, 54 => 0x78 },
	'contrastneutral' => { 16 => 0xeb, 53 => 0x48, 54 => 0x48 },
	'contrastportrait' => { 16 => 0xe9, 53 => 0x18, 54 => 0x18 },
	'contrastsetting' => { 216 => 0x505, 224 => 0x1012, 292 => 0x10, 302 => 0x8 },
	'contrastshadow' => { 263 => 0x6e },
	'contraststandard' => { 16 => 0xe8, 53 => 0x0, 54 => 0x0 },
	'contrastunknown' => { 54 => 0x90 },
	'contrastuserdef1' => { 16 => 0xee, 53 => 0x90, 54 => 0xa8 },
	'contrastuserdef2' => { 16 => 0xef, 53 => 0xa8, 54 => 0xc0 },
	'contrastuserdef3' => { 16 => 0xf0, 53 => 0xc0, 54 => 0xd8 },
	'contributedmedia' => { 346 => 'contributedMedia' },
	'contributedmediaduration' => { 346 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 346 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 346 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 346 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 346 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 346 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 346 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 346 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 346 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 346 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 322 => 'contributor' },
	'contributors' => { 120 => 'Contributors' },
	'controldialset' => { 141 => 0x46 },
	'controlledvocabularyterm' => { 330 => 'CVterm' },
	'controllerboardversion' => { 231 => 0x332 },
	'controlmode' => { 59 => 0x12 },
	'conversionlens' => { 235 => 0x35 },
	'converter' => { 91 => 0xfe4d, 192 => 0xb, 321 => 'Converter' },
	'converttograyscale' => { 321 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 91 => 0x8298, 120 => 'Copyright', 227 => 'Copyright', 263 => 0x22f, 274 => 'Copyright', 334 => 'Copyright', 337 => 'copyright', 339 => 'copyright', 342 => 'Copyright', 346 => 'copyright' },
	'copyrightflag' => { 272 => 0x40a },
	'copyrightnotice' => { 98 => 0x74 },
	'copyrightowner' => { 336 => 'CopyrightOwner' },
	'copyrightownerid' => { 336 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 336 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 336 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 336 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 336 => 'CopyrightStatus' },
	'coringfilter' => { 220 => 0x310, 221 => 0x102d, 224 => 0x310 },
	'coringvalues' => { 220 => 0x311, 224 => 0x311 },
	'corporateentity' => { 337 => 'corporateEntity' },
	'country' => { 124 => 'Country', 235 => 0x69, 335 => 'Country' },
	'country-primarylocationcode' => { 98 => 0x64 },
	'country-primarylocationname' => { 98 => 0x65 },
	'countrycode' => { 171 => 0x5, 270 => 'CountryCode', 329 => 'CountryCode' },
	'coverage' => { 322 => 'coverage' },
	'coverdate' => { 337 => 'coverDate' },
	'coverdisplaydate' => { 337 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 263 => 0x28 },
	'crc32' => { 323 => 'crc32' },
	'createdate' => { 91 => 0x9004, 120 => 'CreateDate', 225 => 'CreationDate', 227 => 'create-date', 274 => 'CreationDate', 344 => 'CreateDate' },
	'creationdate' => { 334 => 'CreationDate', 337 => 'creationDate' },
	'creationtime' => { 227 => 'Creation Time' },
	'creativestyle' => { 290 => 0x1a, 291 => 0x18, 300 => 0x41 },
	'creativestylesetting' => { 292 => 0xf, 302 => 0x7 },
	'creativestylewaschanged' => { 309 => 0x8001 },
	'creator' => { 225 => 'Creator', 274 => 'Creator', 322 => 'creator', 334 => 'Creator' },
	'creatoraddress' => { 329 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorcity' => { 329 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 329 => 'CreatorContactInfo' },
	'creatorcountry' => { 329 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatorpostalcode' => { 329 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 329 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 344 => 'CreatorTool' },
	'creatorworkemail' => { 329 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 329 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 329 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 98 => 0x6e, 335 => 'Credit' },
	'creditline' => { 339 => 'creditLine' },
	'creditlinereq' => { 349 => 'CreditLineReq' },
	'creditlinerequired' => { 336 => 'CreditLineRequired' },
	'cropactive' => { 83 => 0x244 },
	'cropangle' => { 321 => 'CropAngle' },
	'cropaspectratio' => { 83 => 0x260 },
	'cropbottom' => { 94 => 0x9, 197 => 0x36, 269 => 0xdc, 321 => 'CropBottom' },
	'cropbottommargin' => { 39 => 0x3 },
	'cropcircleactive' => { 84 => 0xd6 },
	'cropcircleradius' => { 84 => 0xd9 },
	'cropcirclex' => { 84 => 0xd7 },
	'cropcircley' => { 84 => 0xd8 },
	'cropconstraintowarp' => { 321 => 'CropConstrainToWarp' },
	'croph' => { 315 => 'CropH' },
	'cropheight' => { 83 => 0x24c, 220 => 0x615, 224 => 0x615, 321 => 'CropHeight' },
	'crophispeed' => { 172 => 0x1b },
	'cropleft' => { 83 => 0x246, 94 => 0x6, 197 => 0x1e, 220 => 0x612, 224 => 0x612, 269 => 0xd9, 321 => 'CropLeft' },
	'cropleftmargin' => { 39 => 0x0 },
	'cropoutputheight' => { 197 => 0xce },
	'cropoutputheightinches' => { 197 => 0x96 },
	'cropoutputpixels' => { 197 => 0xd6 },
	'cropoutputresolution' => { 197 => 0xb6 },
	'cropoutputscale' => { 197 => 0xbe },
	'cropoutputwidth' => { 197 => 0xc6 },
	'cropoutputwidthinches' => { 197 => 0x8e },
	'croppedimageheight' => { 3 => 0x2 },
	'croppedimageleft' => { 3 => 0x3 },
	'croppedimagetop' => { 3 => 0x4 },
	'croppedimagewidth' => { 3 => 0x1 },
	'cropright' => { 94 => 0x8, 197 => 0x2e, 269 => 0xdb, 321 => 'CropRight' },
	'croprightmargin' => { 39 => 0x1 },
	'croprotation' => { 94 => 0xb },
	'cropscaledresolution' => { 197 => 0x9e },
	'cropsourceresolution' => { 197 => 0xae },
	'croptop' => { 83 => 0x248, 94 => 0x7, 197 => 0x26, 220 => 0x613, 224 => 0x613, 269 => 0xda, 321 => 'CropTop' },
	'croptopmargin' => { 39 => 0x2 },
	'cropunit' => { 321 => 'CropUnit' },
	'cropunits' => { 321 => 'CropUnits' },
	'cropw' => { 315 => 'CropW' },
	'cropwidth' => { 83 => 0x24a, 220 => 0x614, 224 => 0x614, 321 => 'CropWidth' },
	'cropx' => { 315 => 'CropX' },
	'cropy' => { 315 => 'CropY' },
	'crossprocess' => { 263 => 0x7b },
	'crossprocessparams' => { 263 => 0x235 },
	'currenticcprofile' => { 91 => 0xc691 },
	'currentpreprofilematrix' => { 91 => 0xc692 },
	'currentversion' => { 309 => 0xd000 },
	'curve0x' => { 315 => 'Curve0x' },
	'curve0y' => { 315 => 'Curve0y' },
	'curve1x' => { 315 => 'Curve1x' },
	'curve1y' => { 315 => 'Curve1y' },
	'curve2x' => { 315 => 'Curve2x' },
	'curve2y' => { 315 => 'Curve2y' },
	'curve3x' => { 315 => 'Curve3x' },
	'curve3y' => { 315 => 'Curve3y' },
	'curve4x' => { 315 => 'Curve4x' },
	'curve4y' => { 315 => 'Curve4y' },
	'curves' => { 202 => 0x76a43201 },
	'custom1' => { 336 => 'Custom1' },
	'custom10' => { 336 => 'Custom10' },
	'custom2' => { 336 => 'Custom2' },
	'custom3' => { 336 => 'Custom3' },
	'custom4' => { 336 => 'Custom4' },
	'custom5' => { 336 => 'Custom5' },
	'custom6' => { 336 => 'Custom6' },
	'custom7' => { 336 => 'Custom7' },
	'custom8' => { 336 => 'Custom8' },
	'custom9' => { 336 => 'Custom9' },
	'customcontrast' => { 84 => 0x4e },
	'customcontrols' => { 65 => 0x70c },
	'customdefaultunsharpfineness' => { 84 => 0xbe },
	'customdefaultunsharpstrength' => { 84 => 0xbc },
	'customdefaultunsharpthreshold' => { 84 => 0xc0 },
	'customlinear' => { 84 => 0x4f },
	'customoutputhighlightpoint' => { 84 => 0x53 },
	'customoutputshadowpoint' => { 84 => 0x54 },
	'custompicturestylefilename' => { 48 => 0x4010 },
	'customrawhighlight' => { 84 => 0x7c },
	'customrawhighlightpoint' => { 84 => 0x51 },
	'customrawshadow' => { 84 => 0x85 },
	'customrawshadowpoint' => { 84 => 0x52 },
	'customrendered' => { 91 => 0xa401, 325 => 'CustomRendered' },
	'customsaturation' => { 216 => 0x503 },
	'customsettingsalldefault' => { 209 => '0.2', 212 => '0.2' },
	'customsettingsbank' => { 209 => '0.1', 212 => '0.1' },
	'customsharpness' => { 84 => 0x50 },
	'customunsharpmaskfineness' => { 84 => 0xb8 },
	'customunsharpmaskstrength' => { 84 => 0xb6 },
	'customunsharpmaskthreshold' => { 84 => 0xba },
	'customwb_rblevels' => { 302 => 0x1a },
	'customwb_rgblevels' => { 292 => 0x19 },
	'customwbbluelevel' => { 141 => 0x36 },
	'customwberror' => { 141 => 0x37 },
	'customwbgreenlevel' => { 141 => 0x35 },
	'customwbredlevel' => { 141 => 0x34 },
	'customwbsetting' => { 141 => 0x26 },
	'd-lightinghq' => { 202 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 198 => 0x2 },
	'd-lightinghqhighlight' => { 198 => 0x1 },
	'd-lightinghqselected' => { 202 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 198 => 0x0 },
	'd-lightinghs' => { 202 => 0xce5554aa },
	'd-lightinghsadjustment' => { 199 => 0x0 },
	'd-lightinghscolorboost' => { 199 => 0x1 },
	'd-rangeoptimizerhighlight' => { 309 => 0x8024 },
	'd-rangeoptimizermode' => { 309 => 0x8022 },
	'd-rangeoptimizershadow' => { 309 => 0x802d },
	'd-rangeoptimizervalue' => { 309 => 0x8023 },
	'datacompressionmethod' => { 100 => 0x6e },
	'dataimprint' => { 138 => 0x34 },
	'date' => { 263 => 0x6, 322 => 'date' },
	'dateacquired' => { 136 => 'DateAcquired' },
	'datecreated' => { 98 => 0x37, 335 => 'DateCreated' },
	'datedisplayformat' => { 194 => 0x3 },
	'dateimprint' => { 211 => '4.2' },
	'daterecieved' => { 337 => 'dateRecieved' },
	'datesent' => { 99 => 0x46 },
	'datestampmode' => { 48 => 0x1c },
	'datetime' => { 316 => 'datetime', 342 => 'DateTime' },
	'datetimedigitized' => { 325 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 81 => 0x0, 91 => 0x9003, 117 => 0x14, 120 => 'OriginalDate', 275 => 0xb, 325 => 'DateTimeOriginal' },
	'datetimestamp' => { 105 => 0x64 },
	'daylightsavings' => { 60 => 0x3, 194 => 0x2 },
	'declination' => { 128 => 'Declination' },
	'decposition' => { 138 => 0x32 },
	'defaultcroporigin' => { 91 => 0xc61f },
	'defaultcropsize' => { 91 => 0xc620 },
	'defaulteraseoption' => { 65 => 0x813 },
	'defaultscale' => { 91 => 0xc61e },
	'defringe' => { 321 => 'Defringe' },
	'deletedimagecount' => { 172 => 0xa6, 178 => 0x6e },
	'deprecatedon' => { 319 => 'deprecatedOn' },
	'derivedfrom' => { 347 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 347 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 347 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 347 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 347 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 347 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 347 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfrommanager' => { 347 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 347 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 347 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 347 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 347 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 347 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 347 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromrenditionclass' => { 347 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 347 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 347 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 347 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 227 => 'Description', 322 => 'description', 344 => 'Description' },
	'destination' => { 99 => 0x5 },
	'destinationcity' => { 263 => 0x24, 267 => 0x3 },
	'destinationcitycode' => { 268 => 0x1001 },
	'destinationdst' => { 263 => 0x26, 267 => '0.3' },
	'developmentdynamicrange' => { 95 => 0x1403 },
	'devicesettingdescription' => { 325 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 325 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 325 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 325 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'dialdirectiontvav' => { 65 => 0x706 },
	'digitalcreationdate' => { 98 => 0x3e },
	'digitalcreationtime' => { 98 => 0x3f },
	'digitaldeehighlightadj' => { 177 => 0x202 },
	'digitaldeeshadowadj' => { 177 => 0x200 },
	'digitaldeethreshold' => { 177 => 0x201 },
	'digitalfilter' => { 287 => 0x59 },
	'digitalfilter01' => { 251 => 0x5 },
	'digitalfilter02' => { 251 => 0x16 },
	'digitalfilter03' => { 251 => 0x27 },
	'digitalfilter04' => { 251 => 0x38 },
	'digitalfilter05' => { 251 => 0x49 },
	'digitalfilter06' => { 251 => 0x5a },
	'digitalfilter07' => { 251 => 0x6b },
	'digitalfilter08' => { 251 => 0x7c },
	'digitalfilter09' => { 251 => 0x8d },
	'digitalfilter10' => { 251 => 0x9e },
	'digitalfilter11' => { 251 => 0xaf },
	'digitalfilter12' => { 251 => 0xc0 },
	'digitalfilter13' => { 251 => 0xd1 },
	'digitalfilter14' => { 251 => 0xe2 },
	'digitalfilter15' => { 251 => 0xf3 },
	'digitalfilter16' => { 251 => 0x104 },
	'digitalfilter17' => { 251 => 0x115 },
	'digitalfilter18' => { 251 => 0x126 },
	'digitalfilter19' => { 251 => 0x137 },
	'digitalfilter20' => { 251 => 0x148 },
	'digitalgain' => { 57 => 0xb },
	'digitalgem' => { 164 => 0x0 },
	'digitalice' => { 177 => 0x100 },
	'digitalimageguid' => { 330 => 'DigImageGUID' },
	'digitalroc' => { 176 => 0x0 },
	'digitalsourcefiletype' => { 330 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 330 => 'DigitalSourceType' },
	'digitalzoom' => { 26 => 0xc, 87 => 0xa, 105 => 0x68, 119 => 'DigitalZoom', 138 => 0xc, 172 => 0x86, 192 => 0xa, 221 => 0x204, 263 => 0x1e, 268 => 0xa, 286 => 0x204 },
	'digitalzoomon' => { 286 => 0x21b },
	'digitalzoomratio' => { 91 => 0xa404, 325 => 'DigitalZoomRatio' },
	'director' => { 346 => 'director' },
	'directorphotography' => { 346 => 'directorPhotography' },
	'directory' => { 92 => 'Directory' },
	'directoryindex' => { 4 => 0x137, 6 => 0x2d5, 8 => 0x17e, 10 => 0x238, 11 => 0x13f, 12 => 0x133, 13 => 0x1df, 14 => 0x1a7, 15 => 0x1f0, 16 => 0xcc, 17 => 0x1c7, 18 => 0x298, 19 => 0x1e7, 20 => 0x1e5, 21 => 0x27c, 22 => 0x1f7 },
	'directoryindex2' => { 18 => 0x29c },
	'directorynumber' => { 159 => 0x6 },
	'disclaimer' => { 227 => 'Disclaimer' },
	'displayallafpoints' => { 65 => 0x514 },
	'displayaperture' => { 26 => 0x23 },
	'displayedunitsx' => { 273 => 0x2 },
	'displayedunitsy' => { 273 => 0x6 },
	'distance1' => { 105 => 0x28 },
	'distance2' => { 105 => 0x2c },
	'distance3' => { 105 => 0x30 },
	'distance4' => { 105 => 0x34 },
	'distortioncontrol' => { 178 => 0x10 },
	'distortioncorrection' => { 84 => 0x67, 216 => 0x50b, 238 => '7.1', 253 => 0x0, 301 => 0x2013 },
	'distortioncorrection2' => { 220 => 0x1011 },
	'distortioncorrectionon' => { 84 => 0x63 },
	'distortionn' => { 238 => 0xc },
	'distortionparam02' => { 238 => 0x2 },
	'distortionparam04' => { 238 => 0x4 },
	'distortionparam08' => { 238 => 0x8 },
	'distortionparam09' => { 238 => 0x9 },
	'distortionparam11' => { 238 => 0xb },
	'distortionscale' => { 238 => 0x5 },
	'distributor' => { 337 => 'distributor' },
	'dloon' => { 84 => 0xdc },
	'dlosetting' => { 84 => 0xdd },
	'dlosettingapplied' => { 84 => 0xe4 },
	'dloshootingdistance' => { 84 => 0xde },
	'dloversion' => { 84 => 0xe5 },
	'dmcomment' => { 346 => 'comment' },
	'dngbackwardversion' => { 91 => 0xc613 },
	'dnglensinfo' => { 91 => 0xc630 },
	'dngversion' => { 91 => 0xc612 },
	'document' => { 227 => 'Document' },
	'documentancestorid' => { 335 => [\'DocumentAncestors','DocumentAncestorsAncestorID'] },
	'documentancestors' => { 335 => 'DocumentAncestors' },
	'documenthistory' => { 98 => 0xe7 },
	'documentid' => { 347 => 'DocumentID' },
	'documentname' => { 91 => 0x10d },
	'documentnotes' => { 98 => 0xe6 },
	'doi' => { 337 => 'doi' },
	'dotrange' => { 91 => 0x150 },
	'dpp' => { 316 => 'dpp' },
	'drivemode' => { 88 => 0x3103, 138 => 0x6, 141 => 0x1e, 144 => 0xe, 216 => 0x600, 263 => 0x34, 287 => 0x3, 290 => 0x4, 291 => 0x7e, 292 => 0x34 },
	'drivemode2' => { 141 => 0xa, 245 => 0x7, 300 => 0xe, 302 => 0x1 },
	'drivemodesetting' => { 292 => 0x4 },
	'dspfirmwareversion' => { 263 => 0x27 },
	'duration' => { 51 => 0x6a, 118 => 'Duration', 132 => 'Duration', 346 => 'duration' },
	'durationscale' => { 346 => [\'duration','durationScale'] },
	'durationvalue' => { 346 => [\'duration','durationValue'] },
	'dustremovaldata' => { 48 => 0x97 },
	'dynamicafarea' => { 209 => '1.4', 212 => '1.4' },
	'dynamicrange' => { 95 => 0x1400 },
	'dynamicrangeexpansion' => { 263 => 0x69 },
	'dynamicrangemax' => { 83 => 0x7c },
	'dynamicrangemin' => { 83 => 0x7a },
	'dynamicrangeoptimizer' => { 141 => 0x15, 301 => [0xb025,0xb04f] },
	'dynamicrangeoptimizerbracket' => { 300 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 290 => 0x19, 291 => 0x17, 292 => 0xd, 302 => 0x5 },
	'dynamicrangeoptimizermode' => { 144 => 0x15, 290 => 0x18, 291 => 0x16, 300 => 0x15 },
	'dynamicrangeoptimizersetting' => { 141 => 0x27, 292 => 0xc, 302 => 0x4 },
	'dynamicrangesetting' => { 95 => 0x1402 },
	'e-dialinprogram' => { 245 => '1.3' },
	'easyexposurecomp' => { 215 => '6.1' },
	'easyexposurecompensation' => { 209 => '6.4', 212 => '4.4', 213 => '5.2' },
	'easymode' => { 26 => 0xb },
	'edgenoisereduction' => { 203 => 0x4, 309 => 0x8028 },
	'edition' => { 337 => 'edition' },
	'editorialupdate' => { 98 => 0x8 },
	'editstatus' => { 98 => 0x7, 270 => 'EditStatus' },
	'editversionname' => { 202 => 0x3d136244 },
	'effectivelv' => { 263 => 0x2d },
	'effectivemaxaperture' => { 168 => 0x12, 169 => 0x13 },
	'eissn' => { 337 => 'eIssn' },
	'elevation' => { 128 => 'Elevation' },
	'email' => { 120 => 'EMail' },
	'embargodate' => { 337 => 'embargoDate', 339 => 'embargoDate' },
	'encryptionkey' => { 284 => 0xa020 },
	'endingpage' => { 337 => 'endingPage' },
	'enduser' => { 336 => 'EndUser' },
	'enduserid' => { 336 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 336 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 346 => 'engineer' },
	'enhancedarktones' => { 195 => 0x8 },
	'enhancement' => { 87 => 0x16, 88 => 0x3016 },
	'enhancer' => { 220 => 0x300 },
	'enhancervalues' => { 220 => 0x301 },
	'envelopenumber' => { 99 => 0x28 },
	'envelopepriority' => { 99 => 0x3c },
	'enveloperecordversion' => { 99 => 0x0 },
	'epsonimageheight' => { 221 => 0x20c },
	'epsonimagewidth' => { 221 => 0x20b },
	'epsonsoftware' => { 221 => 0x20d },
	'equipmentinstitution' => { 311 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 311 => 'EquipmentManufacturer' },
	'equipmentversion' => { 217 => 0x0 },
	'ettlii' => { 65 => 0x304, 66 => 0xd, 67 => 0xe, 68 => 0x7, 69 => 0x7, 70 => 0xe },
	'event' => { 314 => 'Event', 330 => 'Event', 337 => 'event' },
	'eventnumber' => { 275 => 0x9 },
	'evsteps' => { 245 => '1.2', 247 => 0x0 },
	'evstepsize' => { 211 => '5.1', 214 => '0.7' },
	'exclusivityenddate' => { 339 => 'exclusivityEndDate' },
	'excursiontolerance' => { 100 => 0x82 },
	'exif' => { 92 => 'EXIF' },
	'exifbyteorder' => { 92 => 'ExifByteOrder' },
	'exifcamerainfo' => { 98 => 0xe8 },
	'exifimageheight' => { 91 => 0xa003, 325 => 'PixelYDimension' },
	'exifimagewidth' => { 91 => 0xa002, 325 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 92 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 91 => 0x9000, 325 => 'ExifVersion' },
	'exitpupilposition' => { 168 => 0x4, 169 => 0x4 },
	'expirationdate' => { 98 => 0x25, 337 => 'expirationDate', 339 => 'expirationDate' },
	'expirationtime' => { 98 => 0x26 },
	'exposure' => { 91 => 0xfe51, 321 => 'Exposure' },
	'exposure2012' => { 321 => 'Exposure2012' },
	'exposureadj' => { 200 => 0x0 },
	'exposureadj2' => { 200 => 0x12 },
	'exposureadjust' => { 287 => 0xc },
	'exposurebracketingindicatorlast' => { 141 => 0x52 },
	'exposurebracketshotnumber' => { 144 => 0x2d, 300 => 0x2f },
	'exposurebracketstepsize' => { 245 => 0x8 },
	'exposurebracketvalue' => { 172 => 0x19 },
	'exposurecompensation' => { 59 => 0x6, 74 => 0x0, 91 => 0x9204, 105 => 0x24, 119 => 'ExposureComp', 138 => 0xd, 139 => 0x53, 140 => 0x1e, 144 => 0x49c0, 221 => 0x1006, 263 => 0x16, 284 => 0xa013, 287 => [0xc,0x35,0x4d], 325 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 302 => 0x2a },
	'exposurecompensationmode' => { 141 => 0x47, 144 => 0x2a },
	'exposurecompensationset' => { 292 => 0x3, 302 => 0x1e },
	'exposurecompensationsetting' => { 141 => 0x1 },
	'exposurecompstepsize' => { 209 => '6.3', 212 => '4.3' },
	'exposurecontrolstep' => { 213 => '6.1' },
	'exposurecontrolstepsize' => { 209 => '6.2', 212 => '4.2', 215 => '7.1' },
	'exposuredelaymode' => { 209 => '10.1', 211 => '9.1', 212 => '10.4', 213 => '10.1', 214 => '6.4', 215 => '11.2' },
	'exposuredifference' => { 172 => 0xe },
	'exposureindex' => { 91 => 0xa215, 325 => 'ExposureIndex' },
	'exposureindicator' => { 141 => 0x50 },
	'exposurelevelincrements' => { 63 => 0x6, 64 => 0x6, 65 => 0x101, 66 => 0x5, 67 => 0x6, 68 => 0x5, 69 => 0x5, 70 => 0x6, 71 => 0x4, 290 => 0x58, 291 => 0x58 },
	'exposuremode' => { 91 => 0xa402, 119 => 'ExposureMode', 138 => 0x1, 139 => 0xa, 140 => 0x0, 141 => 0x0, 144 => 0x34, 216 => 0x200, 233 => 0x40d, 287 => 0x8, 301 => 0xb041, 325 => 'ExposureMode' },
	'exposuremodeinmanual' => { 65 => 0x10b },
	'exposureprogram' => { 91 => 0x8822, 290 => 0x3c, 291 => 0x3c, 292 => 0x5, 296 => 0x14, 300 => 0x3f, 302 => 0x2, 308 => 0x17e, 325 => 'ExposureProgram' },
	'exposureshift' => { 216 => 0x203 },
	'exposuretime' => { 4 => 0x4, 5 => 0x4, 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x6, 24 => 0x7, 59 => 0x16, 91 => 0x829a, 102 => 0xfd05, 105 => 0x20, 107 => 0xfa24, 109 => 0xf104, 112 => 0x12, 114 => 0x38, 117 => 0x10, 119 => 'ExposureTime', 138 => 0x9, 139 => 0x35, 140 => 0x48, 141 => 0x8, 144 => 0x49b8, 263 => 0x12, 284 => 0xa018, 287 => [0x32,0x4a], 290 => 0x0, 291 => 0x0, 302 => 0x27, 325 => 'ExposureTime' },
	'exposuretime2' => { 287 => [0x33,0x4b] },
	'exposuretuning' => { 172 => 0x1c },
	'exposurevalue' => { 103 => 0x3 },
	'exposurewarning' => { 95 => 0x1302 },
	'exrauto' => { 95 => 0x1033 },
	'exrmode' => { 95 => 0x1034 },
	'extendedwbdetect' => { 216 => 0x902 },
	'extender' => { 217 => 0x301 },
	'extenderfirmwareversion' => { 217 => 0x304 },
	'extendermagnification' => { 121 => 'Magnification' },
	'extendermake' => { 121 => 'Make' },
	'extendermodel' => { 121 => 'Model', 217 => 0x303 },
	'extenderserialnumber' => { 121 => 'SerialNumber', 217 => 0x302 },
	'externalflash' => { 219 => 0x1201 },
	'externalflashae1' => { 221 => 0x101f },
	'externalflashae1_0' => { 221 => 0x101b },
	'externalflashae2' => { 221 => 0x1020 },
	'externalflashae2_0' => { 221 => 0x101c },
	'externalflashbounce' => { 219 => 0x1204, 221 => 0x1026, 252 => 0x1a },
	'externalflashexposurecomp' => { 172 => 0x17, 252 => 0x19 },
	'externalflashfirmware' => { 160 => 0x6, 161 => 0x6, 162 => 0x6, 163 => 0x6 },
	'externalflashflags' => { 160 => 0x8, 161 => 0x8, 162 => 0x8, 163 => 0x8 },
	'externalflashguidenumber' => { 219 => 0x1203, 252 => '24.1' },
	'externalflashgvalue' => { 221 => 0x1025 },
	'externalflashmode' => { 221 => 0x1028, 252 => 0x2 },
	'externalflashzoom' => { 219 => 0x1205, 221 => 0x1027 },
	'externalsensorbrightnessvalue' => { 231 => 0x311, 237 => 0x3408 },
	'extrainfoversion' => { 294 => 0x1a },
	'eyestartaf' => { 141 => 0x40 },
	'face10position' => { 85 => 0x3f4, 86 => 0x1ec, 158 => 0x28, 249 => 0x12 },
	'face10size' => { 250 => 0x12 },
	'face11position' => { 158 => 0x2c, 249 => 0x14 },
	'face11size' => { 250 => 0x14 },
	'face12position' => { 158 => 0x30, 249 => 0x16 },
	'face12size' => { 250 => 0x16 },
	'face13position' => { 249 => 0x18 },
	'face13size' => { 250 => 0x18 },
	'face14position' => { 249 => 0x1a },
	'face14size' => { 250 => 0x1a },
	'face15position' => { 249 => 0x1c },
	'face15size' => { 250 => 0x1c },
	'face16position' => { 249 => 0x1e },
	'face16size' => { 250 => 0x1e },
	'face17position' => { 249 => 0x20 },
	'face17size' => { 250 => 0x20 },
	'face18position' => { 249 => 0x22 },
	'face18size' => { 250 => 0x22 },
	'face19position' => { 249 => 0x24 },
	'face19size' => { 250 => 0x24 },
	'face1position' => { 40 => 0x8, 85 => 0xd, 86 => 0x18, 158 => 0x4, 229 => 0x1, 249 => 0x0, 276 => 0xbc, 297 => 0x1, 298 => 0x0, 299 => 0x0 },
	'face1size' => { 250 => 0x0 },
	'face20position' => { 249 => 0x26 },
	'face20size' => { 250 => 0x26 },
	'face21position' => { 249 => 0x28 },
	'face21size' => { 250 => 0x28 },
	'face22position' => { 249 => 0x2a },
	'face22size' => { 250 => 0x2a },
	'face23position' => { 249 => 0x2c },
	'face23size' => { 250 => 0x2c },
	'face24position' => { 249 => 0x2e },
	'face24size' => { 250 => 0x2e },
	'face25position' => { 249 => 0x30 },
	'face25size' => { 250 => 0x30 },
	'face26position' => { 249 => 0x32 },
	'face26size' => { 250 => 0x32 },
	'face27position' => { 249 => 0x34 },
	'face27size' => { 250 => 0x34 },
	'face28position' => { 249 => 0x36 },
	'face28size' => { 250 => 0x36 },
	'face29position' => { 249 => 0x38 },
	'face29size' => { 250 => 0x38 },
	'face2position' => { 40 => 0xa, 85 => 0x7c, 86 => 0x4c, 158 => 0x8, 229 => 0x5, 249 => 0x2, 276 => 0xc8, 297 => 0x6, 298 => 0x20, 299 => 0x25 },
	'face2size' => { 250 => 0x2 },
	'face30position' => { 249 => 0x3a },
	'face30size' => { 250 => 0x3a },
	'face31position' => { 249 => 0x3c },
	'face31size' => { 250 => 0x3c },
	'face32position' => { 249 => 0x3e },
	'face32size' => { 250 => 0x3e },
	'face3position' => { 40 => 0xc, 85 => 0xeb, 86 => 0x80, 158 => 0xc, 229 => 0x9, 249 => 0x4, 276 => 0xd4, 297 => 0xb, 298 => 0x40, 299 => 0x4a },
	'face3size' => { 250 => 0x4 },
	'face4position' => { 40 => 0xe, 85 => 0x15a, 86 => 0xb4, 158 => 0x10, 229 => 0xd, 249 => 0x6, 276 => 0xe0, 297 => 0x10, 298 => 0x60, 299 => 0x6f },
	'face4size' => { 250 => 0x6 },
	'face5position' => { 40 => 0x10, 85 => 0x1c9, 86 => 0xe8, 158 => 0x14, 229 => 0x11, 249 => 0x8, 276 => 0xec, 297 => 0x15, 298 => 0x80, 299 => 0x94 },
	'face5size' => { 250 => 0x8 },
	'face6position' => { 40 => 0x12, 85 => 0x238, 86 => 0x11c, 158 => 0x18, 249 => 0xa, 276 => 0xf8, 297 => 0x1a, 298 => 0xa0, 299 => 0xb9 },
	'face6size' => { 250 => 0xa },
	'face7position' => { 40 => 0x14, 85 => 0x2a7, 86 => 0x150, 158 => 0x1c, 249 => 0xc, 276 => 0x104, 297 => 0x1f, 298 => 0xc0, 299 => 0xde },
	'face7size' => { 250 => 0xc },
	'face8position' => { 40 => 0x16, 85 => 0x316, 86 => 0x184, 158 => 0x20, 249 => 0xe, 276 => 0x110, 297 => 0x24, 298 => 0xe0, 299 => 0x103 },
	'face8size' => { 250 => 0xe },
	'face9position' => { 40 => 0x18, 85 => 0x385, 86 => 0x1b8, 158 => 0x24, 249 => 0x10 },
	'face9size' => { 250 => 0x10 },
	'facedetect' => { 263 => 0x76 },
	'facedetectarea' => { 220 => 0x1201 },
	'facedetectframecrop' => { 220 => 0x1207 },
	'facedetectframesize' => { 40 => 0x3, 85 => 0x1, 86 => 0x4, 158 => 0x1, 220 => 0x1203, 263 => 0x77, 276 => 0xb6 },
	'facedetection' => { 292 => 0x30, 302 => 0x19 },
	'faceid' => { 317 => 'FaceID' },
	'faceinfounknown' => { 88 => 0x2089 },
	'faceorientation' => { 86 => 0x8 },
	'faceposition' => { 248 => 0x2, 285 => 0x4 },
	'facepositions' => { 95 => 0x4103 },
	'facesdetected' => { 40 => 0x2, 41 => 0x2, 42 => 0x3, 85 => 0x0, 86 => 0x2, 88 => 0x211c, 95 => 0x4100, 158 => 0x3, 220 => 0x1200, 235 => 0x3f, 248 => 0x0, 276 => 0xb5, 285 => 0x0, 297 => 0x0, 304 => 0x30 },
	'facesrecognized' => { 230 => 0x0 },
	'facewidth' => { 41 => 0x1 },
	'faithfuloutputhighlightpoint' => { 84 => 0x38 },
	'faithfuloutputshadowpoint' => { 84 => 0x39 },
	'faithfulrawcolortone' => { 84 => 0x31 },
	'faithfulrawcontrast' => { 84 => 0x33 },
	'faithfulrawhighlight' => { 84 => 0x79 },
	'faithfulrawhighlightpoint' => { 84 => 0x36 },
	'faithfulrawlinear' => { 84 => 0x34 },
	'faithfulrawsaturation' => { 84 => 0x32 },
	'faithfulrawshadow' => { 84 => 0x82 },
	'faithfulrawshadowpoint' => { 84 => 0x37 },
	'faithfulrawsharpness' => { 84 => 0x35 },
	'faithfulunsharpmaskfineness' => { 84 => 0xac },
	'faithfulunsharpmaskstrength' => { 84 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 84 => 0xae },
	'femicroadjustment' => { 65 => 0x110 },
	'ffid' => { 323 => 'ffid' },
	'fieldcount' => { 221 => 0x103f },
	'filedatarate' => { 346 => 'fileDataRate' },
	'fileformat' => { 76 => 0x0, 99 => 0x14, 287 => [0x22,0x26], 301 => 0xb000 },
	'fileindex' => { 4 => 0x143, 6 => 0x2c9, 8 => 0x172, 10 => 0x22c, 11 => 0x133, 12 => 0x13f, 13 => 0x1d3, 14 => 0x19b, 15 => 0x1e4, 16 => 0xd0, 17 => 0x1bb, 18 => 0x28c, 19 => 0x1db, 20 => 0x1d9, 21 => 0x270, 22 => 0x1eb, 236 => 0x0 },
	'fileindex2' => { 18 => 0x290 },
	'filemodifydate' => { 92 => 'FileModifyDate' },
	'filename' => { 92 => 'FileName' },
	'filenameasdelivered' => { 336 => 'FileNameAsDelivered' },
	'filenumber' => { 43 => 0x1, 48 => 0x8, 78 => 0x1817, 89 => 'FileNumber', 159 => 0x8 },
	'filenumbermemory' => { 138 => 0x1a },
	'filenumbersequence' => { 209 => '12.2', 211 => '3.1', 212 => '11.1', 213 => '4.3', 215 => '5.2' },
	'filesource' => { 91 => 0xa300, 95 => 0x8000, 325 => 'FileSource' },
	'fileversion' => { 99 => 0x16 },
	'fillflashautoreduction' => { 63 => 0xe, 64 => 0xe, 71 => 0xa },
	'filllight' => { 321 => 'FillLight' },
	'fillorder' => { 91 => 0x10a },
	'filmmode' => { 95 => 0x1401, 233 => 0x412, 235 => 0x42 },
	'filmtype' => { 177 => 0x2 },
	'filtereffect' => { 43 => 0xe, 174 => 0x37 },
	'filtereffectfaithful' => { 53 => 0x70, 54 => 0x70 },
	'filtereffectlandscape' => { 53 => 0x40, 54 => 0x40 },
	'filtereffectmonochrome' => { 16 => 0xff, 53 => 0x88, 54 => 0x88 },
	'filtereffectneutral' => { 53 => 0x58, 54 => 0x58 },
	'filtereffectportrait' => { 53 => 0x28, 54 => 0x28 },
	'filtereffectstandard' => { 53 => 0x10, 54 => 0x10 },
	'filtereffectunknown' => { 54 => 0xa0 },
	'filtereffectuserdef1' => { 53 => 0xa0, 54 => 0xb8 },
	'filtereffectuserdef2' => { 53 => 0xb8, 54 => 0xd0 },
	'filtereffectuserdef3' => { 53 => 0xd0, 54 => 0xe8 },
	'finderdisplayduringexposure' => { 64 => 0x1 },
	'finesharpness' => { 263 => 0x70 },
	'finetuneoptcenterweighted' => { 209 => '7.2', 215 => '9.1' },
	'finetuneoptmatrixmetering' => { 209 => '8.1', 212 => '6.1', 215 => '8.2' },
	'finetuneoptspotmetering' => { 209 => '8.2', 212 => '6.2', 215 => '9.2' },
	'firmware' => { 221 => 0x405, 287 => [0x17,0x3b,0x57], 318 => 'Firmware' },
	'firmwaredate' => { 87 => 0x15, 88 => 0x2001, 275 => 0x4 },
	'firmwareid' => { 145 => 0x0 },
	'firmwarename' => { 284 => 0xa001 },
	'firmwarerevision' => { 16 => 0xa4, 48 => 0x1e, 277 => 0x0 },
	'firmwarerevision2' => { 277 => 0xc },
	'firmwareversion' => { 4 => 0x10b, 8 => 0x136, 11 => 0xff, 12 => 0x107, 103 => 0xce5, 117 => 0x57, 119 => 'FirmwareVersion', 235 => 0x2, 237 => 0x3109, 263 => 0x230, 279 => 0x2 },
	'firstpublicationdate' => { 336 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 98 => 0x16 },
	'flash' => { 89 => 'Flash', 91 => 0x9209, 139 => 0x1f, 140 => 0x15, 325 => 'Flash' },
	'flashaction' => { 292 => [0x87,0x287] },
	'flashaction2' => { 302 => 0x30 },
	'flashactivity' => { 26 => 0x1c },
	'flashbatterylevel' => { 32 => 0x249 },
	'flashbias' => { 235 => 0x24 },
	'flashbits' => { 26 => 0x1d },
	'flashbuttonfunction' => { 65 => 0x70e },
	'flashchargelevel' => { 221 => 0x1010 },
	'flashcolorfilter' => { 162 => 0x10 },
	'flashcommandermode' => { 160 => '9.1', 161 => '9.1', 162 => '9.1', 163 => '9.1' },
	'flashcompensation' => { 160 => 0xa, 161 => 0xa, 162 => 0xa, 163 => 0x1b, 318 => 'FlashCompensation' },
	'flashcontrol' => { 292 => 0x21 },
	'flashcontrolbuilt-in' => { 212 => '16.1', 213 => '23.1' },
	'flashcontrolmode' => { 160 => '9.2', 161 => '9.2', 162 => '9.2', 163 => '9.2', 216 => 0x404 },
	'flashdefault' => { 141 => 0x42 },
	'flashdevice' => { 221 => 0x1005 },
	'flashdistance' => { 88 => 0x2034 },
	'flashenergy' => { 91 => 0xa20b, 325 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 172 => 0x18 },
	'flashexposurecomp' => { 59 => 0xf, 95 => 0x1011, 122 => 'ExposureComp', 138 => 0x23, 143 => 0x104, 144 => 0x49c1, 172 => 0x12, 216 => 0x401, 221 => 0x1023, 263 => 0x4d, 287 => [0x3a,0x56], 301 => 0x104 },
	'flashexposurecompset' => { 141 => 0x10, 240 => 0xe, 292 => 0x23, 302 => 0x1f },
	'flashexposurecompset2' => { 302 => 0x2c },
	'flashexposureindicator' => { 141 => 0x54 },
	'flashexposureindicatorlast' => { 141 => 0x56 },
	'flashexposureindicatornext' => { 141 => 0x55 },
	'flashexposurelock' => { 43 => 0x19 },
	'flashfired' => { 105 => 0x5d, 122 => 'Fired', 138 => 0x14, 190 => '590.3', 235 => 0x8007, 325 => [\'Flash','FlashFired'] },
	'flashfiring' => { 65 => 0x306, 66 => 0x6, 67 => 0x7, 70 => 0x7 },
	'flashfirmwareversion' => { 217 => 0x1002 },
	'flashfocallength' => { 160 => 0xb, 161 => 0xc, 162 => 0xc },
	'flashfunction' => { 144 => 0x31, 325 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 160 => 0xe, 161 => 0xf, 162 => 0xf },
	'flashgroupacompensation' => { 160 => 0x11, 161 => 0x12, 162 => 0x13 },
	'flashgroupacontrolmode' => { 160 => 0xf, 161 => '16.1', 162 => '17.1' },
	'flashgroupaoutput' => { 160 => 0x11, 161 => 0x12, 162 => 0x13 },
	'flashgroupbcompensation' => { 160 => 0x12, 161 => 0x13, 162 => 0x14 },
	'flashgroupbcontrolmode' => { 160 => 0x10, 161 => '17.1', 162 => '18.1' },
	'flashgroupboutput' => { 160 => 0x12, 161 => 0x13, 162 => 0x14 },
	'flashgroupccompensation' => { 161 => 0x14, 162 => 0x15 },
	'flashgroupccontrolmode' => { 161 => '17.2', 162 => '18.2' },
	'flashgroupcoutput' => { 161 => 0x14, 162 => 0x15 },
	'flashguidenumber' => { 59 => 0xd, 75 => 0x0, 122 => 'GuideNumber' },
	'flashintensity' => { 87 => [0x19,0x5], 216 => 0x405 },
	'flashlevel' => { 210 => 0x9, 301 => 0xb048 },
	'flashmake' => { 122 => 'Make' },
	'flashmanufacturer' => { 136 => 'FlashManufacturer' },
	'flashmetering' => { 138 => 0x3f, 141 => 0x1c },
	'flashmeteringmode' => { 4 => 0x15, 10 => 0x15, 11 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 17 => 0x15, 19 => 0x15, 22 => 0x15 },
	'flashmeteringsegments' => { 263 => 0x20a },
	'flashmode' => { 87 => 0x4, 105 => 0x5c, 122 => 'Mode', 138 => 0x2, 139 => 0x20, 140 => 0x16, 141 => 0xf, 172 => 0x87, 216 => 0x400, 221 => 0x1004, 263 => 0xc, 268 => 0x4, 278 => 0x20, 286 => 0x225, 290 => 0x23, 291 => 0x1f, 292 => 0x20, 302 => 0x10, 325 => [\'Flash','FlashMode'] },
	'flashmodel' => { 122 => 'Model', 136 => 'FlashModel', 217 => 0x1001 },
	'flashoptions' => { 245 => 0x2 },
	'flashoptions2' => { 245 => 0x10 },
	'flashoutput' => { 32 => 0x248, 59 => 0x21, 160 => 0xa, 161 => 0xa, 162 => 0xa },
	'flashpixversion' => { 91 => 0xa000, 325 => 'FlashpixVersion' },
	'flashredeyemode' => { 325 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 216 => 0x403 },
	'flashreturn' => { 325 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 122 => 'SerialNumber', 217 => 0x1003 },
	'flashsetting' => { 172 => 0x8 },
	'flashshutterspeed' => { 209 => '20.2', 212 => '15.2', 213 => '22.2', 214 => '7.2', 215 => '23.1' },
	'flashsource' => { 160 => 0x4, 161 => 0x4, 162 => 0x4, 163 => 0x4 },
	'flashstatus' => { 252 => 0x0 },
	'flashsyncspeed' => { 209 => '20.1', 212 => '15.1', 213 => '22.1' },
	'flashsyncspeedav' => { 63 => 0x3, 65 => 0x10f, 66 => 0x2, 67 => 0x3, 68 => 0x2, 69 => 0x2, 70 => 0x3, 71 => 0x6 },
	'flashthreshold' => { 75 => 0x1 },
	'flashtype' => { 122 => 'Type', 141 => 0x59, 172 => 0x9, 217 => 0x1000 },
	'flashwarning' => { 213 => '30.1', 214 => '7.1', 215 => '31.1', 235 => 0x62 },
	'flickerreduce' => { 286 => 0x218 },
	'fliphorizontal' => { 202 => 0x76a43206 },
	'fnumber' => { 4 => 0x3, 6 => 0x3, 8 => 0x3, 10 => 0x3, 11 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x5, 24 => 0x6, 59 => 0x15, 91 => 0x829d, 102 => 0xfd04, 105 => 0x1e, 107 => 0xfa23, 109 => 0xf103, 112 => 0x13, 114 => 0x3c, 117 => 0xc, 126 => 'FNumber', 138 => 0xa, 139 => 0x36, 140 => 0x47, 141 => 0x9, 144 => 0x49c7, 263 => 0x13, 284 => 0xa019, 287 => [0x31,0x49], 290 => 0x1, 291 => 0x1, 302 => 0x26, 325 => 'FNumber' },
	'focallength' => { 4 => 0x1d, 5 => 0xa, 6 => 0x20, 7 => 0x9, 8 => 0x1d, 9 => 0x9, 10 => 0x1e, 11 => 0x1d, 12 => 0x1d, 13 => 0x1e, 14 => 0x1e, 15 => 0x1e, 16 => 0x28, 17 => 0x1e, 18 => 0x23, 19 => 0x1e, 20 => 0x1e, 21 => 0x20, 22 => 0x1e, 45 => 0x1, 88 => 0x1d, 91 => 0x920a, 112 => 0x1d, 126 => 'FocalLength', 138 => 0x12, 168 => 0xa, 169 => 0xb, 254 => 0x9, 263 => 0x1d, 288 => 0xe, 325 => 'FocalLength' },
	'focallengthin35mmformat' => { 91 => 0xa405, 284 => 0xa01a, 325 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 288 => 0x10 },
	'focalplanediagonal' => { 217 => 0x103, 221 => 0x205 },
	'focalplaneresolutionunit' => { 91 => 0xa210, 325 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 91 => 0xa20e, 325 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 45 => 0x2 },
	'focalplanexunknown' => { 45 => 0x2 },
	'focalplaneyresolution' => { 91 => 0xa20f, 325 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 45 => 0x3 },
	'focalplaneyunknown' => { 45 => 0x3 },
	'focaltype' => { 7 => 0x2d, 45 => 0x0 },
	'focalunits' => { 26 => 0x19 },
	'focus' => { 192 => 0x8 },
	'focusarea' => { 138 => 0x31 },
	'focusareaselection' => { 214 => '15.2' },
	'focuscontinuous' => { 26 => 0x20 },
	'focusdisplayaiservoandmf' => { 65 => 0x515 },
	'focusdistance' => { 126 => 'FocusDistance', 138 => 0x13, 144 => 0x49bb, 168 => 0x9, 169 => 0xa, 219 => 0x305 },
	'focusdistancelower' => { 4 => 0x45, 6 => 0x8b, 8 => 0x45, 10 => 0x56, 11 => 0x45, 12 => 0x45, 13 => 0x52, 14 => 0x52, 15 => 0x56, 17 => 0x52, 18 => 0x8e, 19 => 0x59, 20 => 0x57, 21 => 0x8e, 22 => 0x56, 59 => 0x14 },
	'focusdistanceupper' => { 4 => 0x43, 6 => 0x89, 8 => 0x43, 10 => 0x54, 11 => 0x43, 12 => 0x43, 13 => 0x50, 14 => 0x50, 15 => 0x54, 17 => 0x50, 18 => 0x8c, 19 => 0x57, 20 => 0x55, 21 => 0x8c, 22 => 0x54, 59 => 0x13 },
	'focusholdbutton' => { 141 => 0x44 },
	'focusinfoversion' => { 219 => 0x0 },
	'focusingscreen' => { 64 => 0x0, 65 => 0x80b, 70 => 0x0 },
	'focuslocked' => { 137 => 0x14 },
	'focusmode' => { 26 => 0x7, 87 => 0x3, 88 => [0x3003,0xd], 95 => 0x1021, 105 => 0x38, 119 => 'FocusMode', 138 => 0x30, 140 => 0xe, 141 => 0xc, 172 => 0x7, 216 => 0x301, 221 => 0x100b, 235 => 0x7, 263 => 0xd, 268 => 0x3, 288 => 0x1d, 290 => 0x4d, 291 => 0x4d, 301 => [0xb042,0xb04e], 302 => 0x13 },
	'focusmode2' => { 245 => '3.1', 302 => 0x32 },
	'focusmodesetting' => { 210 => '10.1', 290 => 0x10, 291 => 0xf, 292 => 0x6 },
	'focusmodeswitch' => { 141 => 0x58, 290 => 0x2e },
	'focuspixel' => { 95 => 0x1023 },
	'focuspointwrap' => { 209 => '2.2', 212 => '2.2', 213 => '1.2', 215 => '2.5' },
	'focusposition' => { 168 => 0x8, 169 => 0x8, 263 => 0x10, 300 => 0x9bb },
	'focusprocess' => { 216 => 0x302 },
	'focusrange' => { 26 => 0x12, 221 => 0x100a },
	'focussetting' => { 287 => 0x6 },
	'focusstatus' => { 288 => 0x19, 290 => 0x53, 291 => 0x53 },
	'focusstepcount' => { 219 => 0x301, 221 => 0x100e },
	'focusstepinfinity' => { 219 => 0x303, 221 => 0x103b },
	'focusstepnear' => { 219 => 0x304, 221 => 0x103c },
	'focustrackinglockon' => { 209 => ['1.5','4.1'], 212 => '3.1', 213 => '0.4' },
	'focuswarning' => { 95 => 0x1301 },
	'foldername' => { 138 => 0x27 },
	'fontcomposite' => { 351 => [\'Fonts','FontsComposite'] },
	'fontface' => { 351 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 351 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 351 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 351 => [\'Fonts','FontsFontName'] },
	'fonts' => { 351 => 'Fonts' },
	'fonttype' => { 351 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 351 => [\'Fonts','FontsVersionString'] },
	'for' => { 274 => 'For' },
	'format' => { 322 => 'format', 344 => 'Format' },
	'forwardlock' => { 341 => 'forwardlock' },
	'forwardmatrix1' => { 91 => 0xc714 },
	'forwardmatrix2' => { 91 => 0xc715 },
	'framecount' => { 51 => [0x2,0x4] },
	'framenum' => { 269 => 0xd7 },
	'framenumber' => { 95 => 0x8003, 144 => 0x3c, 263 => 0x29 },
	'framerate' => { 51 => [0x1,0x6] },
	'freebytes' => { 78 => 0x1 },
	'freememorycardimages' => { 139 => [0x37,0x54], 140 => [0x2d,0x4a], 141 => 0x32 },
	'fujiflashmode' => { 95 => 0x1010 },
	'fullimagesize' => { 301 => 0xb02b },
	'fullsizeimage' => { 125 => 'data' },
	'fullsizeimagename' => { 125 => '1Name' },
	'fullsizeimagetype' => { 125 => '0Type' },
	'funcbutton' => { 209 => ['14.1','15.1'], 212 => '28.1', 213 => '13.1', 215 => '14.1' },
	'funcbuttonplusdials' => { 209 => ['14.2','15.2'], 212 => '31.1' },
	'functionbutton' => { 214 => '5.2' },
	'gainbase' => { 220 => 0x610 },
	'gaincontrol' => { 91 => 0xa407, 325 => 'GainControl' },
	'gamma' => { 91 => 0xa500 },
	'gammacompensatedvalue' => { 100 => 0x91 },
	'geimagesize' => { 95 => 0x1304 },
	'gemake' => { 96 => 0x300 },
	'gemodel' => { 96 => 0x207 },
	'genre' => { 337 => 'genre', 346 => 'genre' },
	'geography' => { 338 => 'geography' },
	'geosync' => { 92 => 'Geosync' },
	'geotag' => { 92 => 'Geotag' },
	'geotime' => { 92 => 'Geotime' },
	'globalaltitude' => { 272 => 0x419 },
	'globalangle' => { 272 => 0x40d },
	'good' => { 346 => 'good' },
	'gpsaltitude' => { 97 => 0x6, 123 => 'Altitude', 325 => 'GPSAltitude' },
	'gpsaltituderef' => { 97 => 0x5, 325 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 97 => 0x1c, 325 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 97 => 0x1d },
	'gpsdatetime' => { 123 => 'DateTime', 325 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 97 => 0x18, 123 => 'Bearing', 325 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 97 => 0x17, 325 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 97 => 0x1a, 123 => 'Distance', 325 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 97 => 0x19, 325 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 97 => 0x14, 325 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 97 => 0x13 },
	'gpsdestlongitude' => { 97 => 0x16, 325 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 97 => 0x15 },
	'gpsdifferential' => { 97 => 0x1e, 123 => 'Differential', 325 => 'GPSDifferential' },
	'gpsdop' => { 97 => 0xb, 325 => 'GPSDOP' },
	'gpshpositioningerror' => { 97 => 0x1f },
	'gpsimgdirection' => { 97 => 0x11, 325 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 97 => 0x10, 325 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 97 => 0x2, 123 => 'Latitude', 325 => 'GPSLatitude' },
	'gpslatituderef' => { 97 => 0x1 },
	'gpslongitude' => { 97 => 0x4, 123 => 'Longitude', 325 => 'GPSLongitude' },
	'gpslongituderef' => { 97 => 0x3 },
	'gpsmapdatum' => { 97 => 0x12, 123 => 'Datum', 325 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 97 => 0xa, 123 => 'MeasureMode', 325 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 97 => 0x1b, 325 => 'GPSProcessingMethod' },
	'gpssatellites' => { 97 => 0x8, 123 => 'Satellites', 325 => 'GPSSatellites' },
	'gpsspeed' => { 97 => 0xd, 123 => 'Speed', 325 => 'GPSSpeed' },
	'gpsspeedref' => { 97 => 0xc, 325 => 'GPSSpeedRef' },
	'gpsstatus' => { 97 => 0x9, 325 => 'GPSStatus' },
	'gpstimestamp' => { 97 => 0x7 },
	'gpstrack' => { 97 => 0xf, 123 => 'Heading', 325 => 'GPSTrack' },
	'gpstrackref' => { 97 => 0xe, 325 => 'GPSTrackRef' },
	'gpsversionid' => { 97 => 0x0, 325 => 'GPSVersionID' },
	'gradation' => { 216 => 0x50f },
	'gradientbasedcorractive' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrcontrast' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrections' => { 321 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrhue' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrmaskcenterweight' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskflow' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskradius' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmasks' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmaskvalue' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskwhat' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskzerox' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrsaturation' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrsharpness' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrwhat' => { 321 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 321 => 'GrainAmount' },
	'grainfrequency' => { 321 => 'GrainFrequency' },
	'grainsize' => { 321 => 'GrainSize' },
	'graymixeraqua' => { 321 => 'GrayMixerAqua' },
	'graymixerblue' => { 321 => 'GrayMixerBlue' },
	'graymixergreen' => { 321 => 'GrayMixerGreen' },
	'graymixermagenta' => { 321 => 'GrayMixerMagenta' },
	'graymixerorange' => { 321 => 'GrayMixerOrange' },
	'graymixerpurple' => { 321 => 'GrayMixerPurple' },
	'graymixerred' => { 321 => 'GrayMixerRed' },
	'graymixeryellow' => { 321 => 'GrayMixerYellow' },
	'graypoint' => { 309 => 0x8021 },
	'grayresponseunit' => { 91 => 0x122 },
	'greencurvelimits' => { 83 => 0x1c4 },
	'greencurvepoints' => { 83 => 0x19a },
	'greenhue' => { 321 => 'GreenHue' },
	'greensaturation' => { 321 => 'GreenSaturation' },
	'griddisplay' => { 209 => '13.3', 211 => '2.2', 212 => '10.5', 213 => '3.4', 214 => '6.1', 215 => '4.2' },
	'gripbatteryadload' => { 243 => 0x5 },
	'gripbatteryadnoload' => { 243 => 0x4 },
	'gripbatterystate' => { 243 => '1.2' },
	'halftonehints' => { 91 => 0x141 },
	'hasalternative' => { 337 => 'hasAlternative' },
	'hascorrection' => { 337 => 'hasCorrection' },
	'hascrop' => { 321 => 'HasCrop' },
	'hasextendedxmp' => { 348 => 'HasExtendedXMP' },
	'haspreviousversion' => { 337 => 'hasPreviousVersion' },
	'hassettings' => { 321 => 'HasSettings' },
	'hastranslation' => { 337 => 'hasTranslation' },
	'hdr' => { 165 => 0x4, 301 => 0x200a },
	'hdrlevel' => { 165 => 0x5, 292 => 0x2e, 302 => 0x17 },
	'hdrsetting' => { 292 => 0x2d, 302 => 0x16 },
	'hdrsmoothing' => { 165 => 0x6 },
	'headline' => { 98 => 0x69, 335 => 'Headline' },
	'hierarchicalkeywords' => { 332 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 332 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 332 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 332 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 332 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 332 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 332 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 332 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 332 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 332 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 332 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 332 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 332 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 332 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 332 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 332 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 332 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 332 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 313 => 'hierarchicalSubject' },
	'highisonoisereduction' => { 13 => 0xbc, 14 => 0xbd, 17 => 0xbd, 22 => 0xc9, 65 => 0x202, 95 => 0x100e, 172 => 0xb1, 263 => 0x71, 290 => 0x2c, 291 => 0x26, 292 => 0x26, 301 => 0x2009, 302 => 0x12 },
	'highlight' => { 287 => 0xf },
	'highlightcolordistortreduct' => { 309 => 0x8026 },
	'highlightprotection' => { 201 => 0x6 },
	'highlightrecovery' => { 321 => 'HighlightRecovery' },
	'highlights' => { 315 => 'Highlights' },
	'highlights2012' => { 321 => 'Highlights2012' },
	'highlighttonepriority' => { 10 => 0x7, 13 => 0x7, 14 => 0x7, 15 => 0x7, 17 => 0x7, 19 => 0x7, 22 => 0x7, 65 => 0x203 },
	'highlowkeyadj' => { 263 => 0x6c },
	'highspeedsync' => { 141 => 0x5 },
	'histogramxml' => { 202 => 0x83a1a25 },
	'history' => { 335 => 'History', 347 => 'History' },
	'historyaction' => { 347 => [\'History','HistoryAction'] },
	'historychanged' => { 347 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 347 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 347 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 347 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 347 => [\'History','HistoryWhen'] },
	'hometowncity' => { 88 => 0x3006, 263 => 0x23, 267 => 0x2 },
	'hometowncitycode' => { 268 => 0x1000 },
	'hometowndst' => { 263 => 0x25, 267 => '0.2' },
	'hostcomputer' => { 91 => 0x13c },
	'hue' => { 146 => 0x3b, 263 => 0x67 },
	'hueadj' => { 205 => 0x2f, 309 => 0x8019 },
	'hueadjustment' => { 139 => 0x4a, 140 => 0x40, 172 => 0x92, 174 => 0x36 },
	'hueadjustmentaqua' => { 321 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 321 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 321 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 321 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 321 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 321 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 321 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 321 => 'HueAdjustmentYellow' },
	'huesetting' => { 224 => 0x1011 },
	'icc_profile' => { 92 => 'ICC_Profile' },
	'iccprofilename' => { 335 => 'ICCProfile' },
	'idccreativestyle' => { 309 => 0x8000 },
	'idcpreviewlength' => { 309 => 0x202 },
	'idcpreviewstart' => { 309 => 0x201 },
	'identifier' => { 322 => 'identifier', 344 => 'Identifier' },
	'illumination' => { 214 => '0.5' },
	'imageadjustment' => { 172 => 0x80, 192 => 0x5 },
	'imagealterationconstraints' => { 336 => 'ImageAlterationConstraints' },
	'imagearea' => { 182 => 0x10, 185 => 0x10 },
	'imageareaoffset' => { 263 => 0x38 },
	'imageauthentication' => { 172 => 0x20 },
	'imageboundary' => { 172 => 0x16 },
	'imagecount' => { 172 => 0xa5 },
	'imagecreator' => { 336 => 'ImageCreator' },
	'imagecreatorid' => { 336 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 336 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 336 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 172 => 0xa2 },
	'imagedescription' => { 91 => 0x10e, 342 => 'ImageDescription' },
	'imageduplicationconstraints' => { 336 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 202 => 0xfe443a45 },
	'imageeditcount' => { 263 => 0x41 },
	'imageediting' => { 263 => 0x32 },
	'imagefileconstraints' => { 336 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 336 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 336 => 'ImageFileSizeAsDelivered' },
	'imageheight' => { 91 => 0x101, 145 => 0xc, 342 => 'ImageLength' },
	'imagehistory' => { 91 => 0x9213 },
	'imageidnumber' => { 231 => 0x340 },
	'imagenumber' => { 91 => 0x9211, 119 => 'ImageNumber', 139 => 0xae, 140 => 0x5e, 290 => 0x9b, 292 => [0x400,0x114,0x314], 318 => 'ImageNumber' },
	'imagenumber2' => { 140 => 0x62 },
	'imageoptimization' => { 172 => 0xa9 },
	'imageorientation' => { 98 => 0x83 },
	'imageprocessing' => { 172 => 0x1a },
	'imageprocessingversion' => { 220 => 0x0 },
	'imagequality' => { 119 => 'ImageQuality', 184 => '723.2', 185 => '732.2', 190 => '708.1', 235 => 0x1 },
	'imagequality2' => { 216 => 0x603 },
	'imageref' => { 328 => 'ImageRef' },
	'imagereview' => { 210 => '0.4', 214 => '0.4' },
	'imagereviewtime' => { 210 => '2.1', 211 => '19.1', 212 => '9.2', 213 => '20.1', 215 => '21.2' },
	'imagesize' => { 125 => 'ImageSize' },
	'imagesizerestriction' => { 339 => 'imageSizeRestriction' },
	'imagesourcedata' => { 91 => 0x935c },
	'imagestabilization' => { 26 => 0x22, 88 => 0x3020, 119 => 'ImageStabilization', 139 => 0xbd, 140 => 0x71, 141 => 0x57, 142 => 0x0, 143 => [0x18,0x107,0x113], 144 => 0x49c2, 172 => 0xac, 216 => 0x604, 219 => 0x1600, 235 => 0x1a, 295 => 0x12, 296 => 0x11, 301 => 0xb026 },
	'imagestabilization2' => { 294 => 0xa },
	'imagestabilizationsetting' => { 144 => 0x14, 290 => 0x3d, 291 => 0x3d, 300 => 0x14 },
	'imagestyle' => { 290 => 0x2d, 291 => 0x27 },
	'imagesupplier' => { 336 => 'ImageSupplier' },
	'imagesupplierid' => { 336 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 336 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 336 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetone' => { 263 => 0x4f },
	'imagetype' => { 98 => 0x82, 336 => 'ImageType' },
	'imageuniqueid' => { 48 => 0x28, 91 => 0xa420, 325 => 'ImageUniqueID' },
	'imagewidth' => { 91 => 0x100, 145 => 0xe, 342 => 'ImageWidth' },
	'incrementaltemperature' => { 321 => 'IncrementalTemperature' },
	'incrementaltint' => { 321 => 'IncrementalTint' },
	'industry' => { 337 => 'industry', 338 => 'industry' },
	'infobuttonwhenshooting' => { 65 => 0x409 },
	'infraredilluminator' => { 275 => 0x28 },
	'ingredients' => { 347 => 'Ingredients' },
	'ingredientsalternatepaths' => { 347 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 347 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 347 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 347 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 347 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 347 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientsmanager' => { 347 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 347 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 347 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 347 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 347 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 347 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 347 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsrenditionclass' => { 347 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 347 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 347 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 347 => [\'Ingredients','IngredientsVersionID'] },
	'initialzoomliveview' => { 209 => '4.4' },
	'initialzoomsetting' => { 209 => '9.3', 212 => '27.3' },
	'inkset' => { 91 => 0x14c },
	'instanceid' => { 347 => 'InstanceID' },
	'instantplaybacksetup' => { 141 => 0x3e },
	'instantplaybacktime' => { 141 => 0x3d },
	'instructions' => { 335 => 'Instructions' },
	'instrument' => { 346 => 'instrument' },
	'intellectualgenre' => { 329 => 'IntellectualGenre' },
	'intelligentauto' => { 301 => 0xb052 },
	'intelligentcontrast' => { 38 => 0x4 },
	'intelligentd-range' => { 235 => 0x79 },
	'intelligentexposure' => { 235 => 0x5d },
	'intelligentresolution' => { 235 => 0x70 },
	'interchangecolorspace' => { 100 => 0x40 },
	'internalflash' => { 138 => 0x2b, 209 => '23.1', 210 => '8.1', 211 => '22.1', 214 => '8.1', 215 => '24.1', 219 => 0x1208 },
	'internalflashae1' => { 221 => 0x1021 },
	'internalflashae1_0' => { 221 => 0x101d },
	'internalflashae2' => { 221 => 0x1022 },
	'internalflashae2_0' => { 221 => 0x101e },
	'internalflashmode' => { 252 => 0x1 },
	'internalflashstrength' => { 252 => 0x3 },
	'internalflashtable' => { 221 => 0x1024 },
	'internalserialnumber' => { 48 => 0x96, 58 => 0x9, 95 => 0x10, 144 => 0x49dc, 217 => 0x102, 235 => 0x25, 244 => 0x4, 279 => 0x5 },
	'interopindex' => { 91 => 0x1 },
	'interopversion' => { 91 => 0x2 },
	'intervallength' => { 138 => 0x10 },
	'intervalmode' => { 138 => 0x26 },
	'intervalnumber' => { 138 => 0x11 },
	'introtime' => { 346 => 'introTime' },
	'introtimescale' => { 346 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 346 => [\'introTime','introTimeValue'] },
	'iptc' => { 92 => 'IPTC' },
	'iptc-naa' => { 91 => 0x83bb, 239 => 0x83bb },
	'iptcbitspersample' => { 100 => 0x56 },
	'iptcdigest' => { 272 => 0x425 },
	'iptcimageheight' => { 100 => 0x1e },
	'iptcimagerotation' => { 100 => 0x66 },
	'iptcimagewidth' => { 100 => 0x14 },
	'iptclastedited' => { 330 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 100 => 0xa },
	'iptcpixelheight' => { 100 => 0x32 },
	'iptcpixelwidth' => { 100 => 0x28 },
	'isbn' => { 337 => 'isbn' },
	'iscorrectionof' => { 337 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 84 => 0x3 },
	'iso' => { 4 => 0x6, 6 => 0x6, 7 => 0x75, 8 => 0x6, 9 => 0x79, 10 => 0x6, 11 => 0x6, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x0, 24 => 0x1, 87 => 0x14, 88 => [0x3014,0x14], 91 => 0x8827, 102 => 0xfd06, 103 => 0x1784, 105 => 0x60, 107 => [0xfa2e,0xfa46], 108 => [0x27,0x28], 109 => 0xf105, 112 => 0x14, 114 => 0x4e, 117 => 0x34, 119 => 'ISO', 138 => 0x8, 144 => 0x49ba, 166 => 0x0, 172 => 0x2, 239 => 0x17, 263 => [0x8b,0x14], 268 => 0x14, 284 => 0xa014, 325 => 'ISOSpeedRatings' },
	'iso2' => { 166 => 0x6, 179 => 0x265, 180 => 0x25c, 181 => 0x265, 182 => 0x221, 183 => 0x25d, 184 => 0x256, 185 => 0x25d, 187 => 0x2b5, 188 => 0x265, 191 => 0x2b5 },
	'isoauto' => { 245 => '14.4' },
	'isoautoparameters' => { 263 => 0x7a },
	'isodisplay' => { 211 => '2.3', 213 => '3.3', 215 => '4.3' },
	'isoexpansion' => { 65 => 0x103, 66 => 0x7, 67 => 0x8, 70 => 0x8, 166 => 0x4 },
	'isoexpansion2' => { 166 => 0xa },
	'isofloor' => { 245 => 0x6 },
	'isoselection' => { 172 => 0xf },
	'isosensitivitystep' => { 213 => '6.2' },
	'isosetting' => { 105 => 0x5e, 119 => 'ISOSetting', 138 => 0x24, 139 => 0x26, 140 => 0x1c, 141 => 0x13, 146 => 0x6, 172 => 0x13, 245 => '17.3', 278 => 0x27, 290 => 0x16, 291 => 0x14, 292 => 0x2 },
	'isospeed' => { 91 => 0x8833 },
	'isospeedexpansion' => { 64 => 0x3 },
	'isospeedincrements' => { 65 => 0x102 },
	'isospeedlatitudeyyy' => { 91 => 0x8834 },
	'isospeedlatitudezzz' => { 91 => 0x8835 },
	'isospeedrange' => { 65 => 0x103 },
	'isostepsize' => { 209 => '6.1', 212 => '4.1' },
	'isovalue' => { 221 => 0x1001 },
	'issn' => { 337 => 'issn' },
	'issueidentifier' => { 337 => 'issueIdentifier' },
	'issuename' => { 337 => 'issueName' },
	'istranslationof' => { 337 => 'isTranslationOf' },
	'jobid' => { 98 => 0xb8 },
	'jobname' => { 326 => 'JobName' },
	'jobref' => { 345 => 'JobRef' },
	'jobrefid' => { 345 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 345 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 345 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 326 => 'JobStatus' },
	'jpegquality' => { 7 => 0x66, 237 => 0x3034 },
	'jpegsize' => { 237 => 0x303a },
	'jpgfromraw' => { 78 => 0x2007, 89 => 'JpgFromRaw', 239 => 0x2e },
	'jpgfromrawlength' => { 91 => [0x117,0x202] },
	'jpgfromrawstart' => { 91 => [0x111,0x201] },
	'jpgrecordedpixels' => { 245 => '14.1' },
	'jurisdiction' => { 319 => 'jurisdiction' },
	'key' => { 346 => 'key' },
	'keyword' => { 337 => 'keyword' },
	'keywordinfo' => { 332 => 'Keywords' },
	'keywords' => { 98 => 0x19, 120 => 'Keywords', 225 => 'Keywords', 274 => 'Keywords', 316 => 'keywords', 334 => 'Keywords', 344 => 'Keywords' },
	'killdate' => { 337 => 'killDate' },
	'kodakimageheight' => { 102 => 0xf908, 105 => 0xe, 107 => [0xfa1e,0xfa52], 113 => 0x70 },
	'kodakimagewidth' => { 102 => 0xf907, 105 => 0xc, 107 => [0xfa1d,0xfa51], 113 => 0x6c },
	'kodakinfotype' => { 102 => 0xfa00 },
	'kodakmaker' => { 113 => 0x8 },
	'kodakmodel' => { 105 => 0x0, 113 => 0x28 },
	'label' => { 227 => 'Label', 344 => 'Label' },
	'labelname1' => { 328 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 328 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 328 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 328 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 328 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 328 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 235 => 0x6f },
	'landscapeoutputhighlightpoint' => { 84 => 0x26 },
	'landscapeoutputshadowpoint' => { 84 => 0x27 },
	'landscaperawcolortone' => { 84 => 0x1f },
	'landscaperawcontrast' => { 84 => 0x21 },
	'landscaperawhighlight' => { 84 => 0x77 },
	'landscaperawhighlightpoint' => { 84 => 0x24 },
	'landscaperawlinear' => { 84 => 0x22 },
	'landscaperawsaturation' => { 84 => 0x20 },
	'landscaperawshadow' => { 84 => 0x80 },
	'landscaperawshadowpoint' => { 84 => 0x25 },
	'landscaperawsharpness' => { 84 => 0x23 },
	'landscapeunsharpmaskfineness' => { 84 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 84 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 84 => 0xa2 },
	'language' => { 322 => 'language' },
	'languageidentifier' => { 98 => 0x87 },
	'lastfilenumber' => { 138 => 0x1b },
	'lastkeywordiptc' => { 136 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 136 => 'LastKeywordXMP' },
	'lasturl' => { 347 => 'LastURL' },
	'lateralchromaticaberration' => { 301 => 0x2012 },
	'lc1' => { 254 => 0x2 },
	'lc10' => { 254 => 0xb },
	'lc11' => { 254 => 0xc },
	'lc12' => { 254 => 0xd },
	'lc14' => { 254 => 0xf },
	'lc15' => { 254 => 0x10 },
	'lc2' => { 254 => 0x3 },
	'lc3' => { 254 => 0x4 },
	'lc4' => { 254 => 0x5 },
	'lc5' => { 254 => 0x6 },
	'lc6' => { 254 => 0x7 },
	'lc7' => { 254 => 0x8 },
	'lcddisplayatpoweron' => { 65 => 0x811, 69 => 0xa },
	'lcddisplayreturntoshoot' => { 70 => 0x12 },
	'lcdillumination' => { 209 => '17.5', 212 => '10.3', 213 => '4.2', 215 => '5.4' },
	'lcdilluminationduringbulb' => { 65 => 0x408 },
	'lcdpanels' => { 64 => 0x8 },
	'lcheditor' => { 202 => 0x8ae85e },
	'legacyiptcdigest' => { 335 => 'LegacyIPTCDigest' },
	'legalcode' => { 319 => 'legalcode' },
	'lens' => { 91 => 0xfdea, 172 => 0x84, 318 => 'Lens' },
	'lensafstopbutton' => { 63 => 0x11, 64 => 0x13, 65 => 0x506, 66 => 0x10, 67 => 0x12, 70 => 0x13, 71 => 0x9 },
	'lensaperturerange' => { 287 => [0x30,0x48] },
	'lensdistortionparams' => { 221 => 0x206 },
	'lensdrivenoaf' => { 65 => 0x505 },
	'lensfirmware' => { 280 => 0x20, 284 => 0xa004 },
	'lensfirmwareversion' => { 217 => 0x204 },
	'lensfocalrange' => { 287 => 0xa },
	'lensfstops' => { 167 => 0x7, 168 => 0xc, 169 => 0xd, 172 => 0x8b, 254 => '0.3' },
	'lensid' => { 318 => 'LensID' },
	'lensidnumber' => { 167 => 0x6, 168 => 0xb, 169 => 0xc },
	'lensinfo' => { 91 => 0xa432, 260 => 0x2a, 318 => 'LensInfo' },
	'lenskind' => { 254 => 0x1 },
	'lensmake' => { 91 => 0xa433, 126 => 'Make' },
	'lensmanualdistortionamount' => { 321 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 136 => 'LensManufacturer' },
	'lensmodel' => { 4 => 0x937, 11 => 0x92b, 12 => 0x933, 48 => 0x95, 91 => 0xa434, 126 => 'Model', 136 => 'LensModel', 170 => 0x18a, 217 => 0x203, 260 => 0xc },
	'lensprofilechromaticaberrationscale' => { 321 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 321 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 321 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 321 => 'LensProfileEnable' },
	'lensprofilefilename' => { 321 => 'LensProfileFilename' },
	'lensprofilename' => { 321 => 'LensProfileName' },
	'lensprofilesetup' => { 321 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 321 => 'LensProfileVignettingScale' },
	'lensproperties' => { 217 => 0x20b },
	'lensserialnumber' => { 46 => 0x0, 91 => 0xa435, 126 => 'SerialNumber', 217 => 0x202, 235 => 0x52, 280 => 0x30 },
	'lensshutterlock' => { 141 => 0x4a },
	'lensspec' => { 288 => 0x0, 289 => 0x0, 301 => 0xb02a },
	'lenstemperature' => { 221 => 0x1008 },
	'lenstype' => { 4 => 0xe2, 5 => 0xd, 6 => 0x1a0, 7 => 0xc, 8 => 0x111, 9 => 0xc, 10 => 0x14f, 11 => 0xd6, 12 => 0xde, 13 => 0xf6, 14 => 0xea, 15 => 0xff, 16 => [0xc,0x97], 17 => 0xe6, 18 => 0x153, 19 => 0xea, 20 => 0xe8, 21 => 0x127, 22 => 0x112, 26 => 0x16, 143 => 0x10c, 144 => 0x49bd, 172 => 0x83, 217 => 0x201, 228 => 0x16, 231 => 0x310, 234 => 0x303, 235 => 0x51, 237 => 0x3405, 255 => 0x0, 256 => 0x0, 257 => 0x1, 258 => 0x1, 259 => 0x1, 261 => 0x0, 284 => 0xa003, 301 => 0xb027 },
	'levelgaugepitch' => { 216 => 0x904 },
	'levelgaugeroll' => { 216 => 0x903 },
	'levelorientation' => { 262 => 0x0 },
	'license' => { 319 => 'license' },
	'licensee' => { 336 => 'Licensee' },
	'licenseeid' => { 336 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 336 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 336 => 'LicenseeImageNotes' },
	'licenseename' => { 336 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 336 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 336 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 336 => 'LicenseeTransactionID' },
	'licenseid' => { 336 => 'LicenseID' },
	'licensestartdate' => { 336 => 'LicenseStartDate' },
	'licensetransactiondate' => { 336 => 'LicenseTransactionDate' },
	'licensetype' => { 323 => 'licensetype' },
	'licensor' => { 336 => 'Licensor' },
	'licensorcity' => { 336 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 336 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 336 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 336 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 336 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 336 => 'LicensorImageID' },
	'licensorname' => { 336 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 336 => 'LicensorNotes' },
	'licensorpostalcode' => { 336 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 336 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 336 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 336 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 336 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 336 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 336 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 336 => 'LicensorTransactionID' },
	'licensorurl' => { 336 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 221 => 0x1009 },
	'lightingmode' => { 88 => 0x302a },
	'lightreading' => { 263 => 0x15 },
	'lightsource' => { 91 => 0x9208, 172 => 0x90, 224 => 0x1000, 325 => 'LightSource' },
	'lightsourcespecial' => { 286 => 0x21d },
	'lightswitch' => { 215 => '0.1' },
	'lightvaluecenter' => { 221 => 0x103d },
	'lightvalueperiphery' => { 221 => 0x103e },
	'linearizationtable' => { 91 => 0xc618 },
	'linearresponselimit' => { 91 => 0xc62e },
	'linkaetoafpoint' => { 245 => '14.2' },
	'liveviewaf' => { 211 => '32.1', 215 => '34.1' },
	'liveviewafareamode' => { 213 => '34.1' },
	'liveviewafmethod' => { 302 => 0x20 },
	'liveviewafmode' => { 213 => '34.2' },
	'liveviewafsetting' => { 292 => 0x36 },
	'liveviewexposuresimulation' => { 65 => 0x810 },
	'liveviewfocusmode' => { 292 => 0x8b },
	'liveviewmetering' => { 292 => 0x84 },
	'liveviewmonitorofftime' => { 213 => '20.2' },
	'liveviewshooting' => { 43 => 0x13 },
	'localcaption' => { 98 => 0x79 },
	'localizedcameramodel' => { 91 => 0xc615 },
	'locallocationname' => { 284 => 0x30 },
	'location' => { 171 => 0x9, 235 => 0x67, 314 => 'Location', 329 => 'Location', 337 => 'location' },
	'locationareacode' => { 320 => 'lac' },
	'locationcreated' => { 330 => 'LocationCreated' },
	'locationcreatedcity' => { 330 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 330 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 330 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedprovincestate' => { 330 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 330 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 330 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 171 => 0x0 },
	'locationname' => { 284 => 0x31 },
	'locationshown' => { 330 => 'LocationShown' },
	'locationshowncity' => { 330 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 330 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 330 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownprovincestate' => { 330 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 330 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 330 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 65 => 0x709 },
	'logcomment' => { 346 => 'logComment' },
	'longexposurenoisereduction' => { 65 => 0x201, 66 => 0x1, 67 => 0x2, 68 => 0x1, 69 => 0x1, 70 => 0x2, 71 => 0x1, 290 => 0x2b, 291 => 0x25, 292 => 0x25, 301 => [0xb04e,0x2008], 302 => 0x11 },
	'longexposurenoisereduction2' => { 43 => 0x8 },
	'loop' => { 346 => 'loop' },
	'luminanceadjustmentaqua' => { 321 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 321 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 321 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 321 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 321 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 321 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 321 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 321 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 83 => 0x150 },
	'luminancecurvepoints' => { 83 => 0x126 },
	'luminancenoisereduction' => { 84 => 0x5f, 287 => 0x1b },
	'luminancenoisereductioncontrast' => { 321 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 321 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 84 => 0x6d },
	'luminancesmoothing' => { 321 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 65 => 0x40b },
	'm16cversion' => { 231 => 0x333 },
	'macro' => { 95 => 0x1020, 96 => 0x202, 221 => 0x202, 278 => 0x21, 286 => 0x202, 301 => 0xb040 },
	'macroled' => { 219 => 0x120a },
	'macromagnification' => { 4 => 0x1b, 8 => 0x1b, 11 => 0x1b, 12 => 0x1b, 16 => 0x1b, 17 => 0x1b, 43 => 0x10 },
	'macromode' => { 26 => 0x1, 138 => 0xb, 216 => 0x300, 235 => 0x1c },
	'magicfilter' => { 216 => 0x52c },
	'magnifiedview' => { 67 => 0x11, 69 => 0x9 },
	'maindialexposurecomp' => { 214 => '0.6' },
	'make' => { 79 => 0x0, 91 => 0x10f, 119 => 'Make', 227 => 'Make', 239 => 0x10f, 342 => 'Make' },
	'makernote' => { 325 => 'MakerNote' },
	'makernotecanon' => { 90 => 'MakN', 91 => 0x927c },
	'makernotecasio' => { 90 => 'MakN', 91 => 0x927c },
	'makernotecasio2' => { 90 => 'MakN', 91 => 0x927c },
	'makernotefujifilm' => { 90 => 'MakN', 91 => 0x927c },
	'makernotege' => { 90 => 'MakN', 91 => 0x927c },
	'makernotege2' => { 90 => 'MakN', 91 => 0x927c },
	'makernotehasselblad' => { 90 => 'MakN', 91 => 0x927c },
	'makernotehp' => { 90 => 'MakN', 91 => 0x927c },
	'makernotehp2' => { 90 => 'MakN', 91 => 0x927c },
	'makernotehp4' => { 90 => 'MakN', 91 => 0x927c },
	'makernotehp6' => { 90 => 'MakN', 91 => 0x927c },
	'makernoteisl' => { 90 => 'MakN', 91 => 0x927c },
	'makernotejvc' => { 90 => 'MakN', 91 => 0x927c },
	'makernotejvctext' => { 90 => 'MakN', 91 => 0x927c },
	'makernotekodak10' => { 90 => 'MakN', 91 => 0x927c },
	'makernotekodak1a' => { 90 => 'MakN', 91 => 0x927c },
	'makernotekodak1b' => { 90 => 'MakN', 91 => 0x927c },
	'makernotekodak2' => { 90 => 'MakN', 91 => 0x927c },
	'makernotekodak3' => { 90 => 'MakN', 91 => 0x927c },
	'makernotekodak4' => { 90 => 'MakN', 91 => 0x927c },
	'makernotekodak5' => { 90 => 'MakN', 91 => 0x927c },
	'makernotekodak6a' => { 90 => 'MakN', 91 => 0x927c },
	'makernotekodak6b' => { 90 => 'MakN', 91 => 0x927c },
	'makernotekodak7' => { 90 => 'MakN', 91 => 0x927c },
	'makernotekodak8a' => { 90 => 'MakN', 91 => 0x927c },
	'makernotekodak8b' => { 90 => 'MakN', 91 => 0x927c },
	'makernotekodak9' => { 90 => 'MakN', 91 => 0x927c },
	'makernotekodakunknown' => { 90 => 'MakN', 91 => 0x927c },
	'makernotekyocera' => { 90 => 'MakN', 91 => 0x927c },
	'makernoteleica' => { 90 => 'MakN', 91 => 0x927c },
	'makernoteleica2' => { 90 => 'MakN', 91 => 0x927c },
	'makernoteleica3' => { 90 => 'MakN', 91 => 0x927c },
	'makernoteleica4' => { 90 => 'MakN', 91 => 0x927c },
	'makernoteleica5' => { 90 => 'MakN', 91 => 0x927c },
	'makernoteleica6' => { 90 => 'MakN', 91 => 0x927c },
	'makernoteminolta' => { 90 => 'MakN', 91 => 0x927c },
	'makernoteminolta2' => { 90 => 'MakN', 91 => 0x927c },
	'makernoteminolta3' => { 90 => 'MakN', 91 => 0x927c },
	'makernotenikon' => { 90 => 'MakN', 91 => 0x927c },
	'makernotenikon2' => { 90 => 'MakN', 91 => 0x927c },
	'makernotenikon3' => { 90 => 'MakN', 91 => 0x927c },
	'makernoteoffset' => { 286 => 0xff },
	'makernoteolympus' => { 90 => 'MakN', 91 => 0x927c },
	'makernoteolympus2' => { 90 => 'MakN', 91 => 0x927c },
	'makernotepanasonic' => { 90 => 'MakN', 91 => 0x927c },
	'makernotepanasonic2' => { 90 => 'MakN', 91 => 0x927c },
	'makernotepentax' => { 90 => 'MakN', 91 => 0x927c },
	'makernotepentax2' => { 90 => 'MakN', 91 => 0x927c },
	'makernotepentax3' => { 90 => 'MakN', 91 => 0x927c },
	'makernotepentax4' => { 90 => 'MakN', 91 => 0x927c },
	'makernotepentax5' => { 90 => 'MakN', 91 => 0x927c },
	'makernotepentax6' => { 90 => 'MakN', 91 => 0x927c },
	'makernotephaseone' => { 90 => 'MakN', 91 => 0x927c },
	'makernotereconyx' => { 90 => 'MakN', 91 => 0x927c },
	'makernotericoh' => { 90 => 'MakN', 91 => 0x927c },
	'makernotericohtext' => { 90 => 'MakN', 91 => 0x927c },
	'makernotesafety' => { 91 => 0xc635 },
	'makernotesamsung1a' => { 90 => 'MakN', 91 => 0x927c },
	'makernotesamsung1b' => { 90 => 'MakN', 91 => 0x927c },
	'makernotesamsung2' => { 90 => 'MakN', 91 => 0x927c },
	'makernotesanyo' => { 90 => 'MakN', 91 => 0x927c },
	'makernotesanyoc4' => { 90 => 'MakN', 91 => 0x927c },
	'makernotesanyopatch' => { 90 => 'MakN', 91 => 0x927c },
	'makernotesigma' => { 90 => 'MakN', 91 => 0x927c },
	'makernotesony' => { 90 => 'MakN', 91 => 0x927c },
	'makernotesony2' => { 90 => 'MakN', 91 => 0x927c },
	'makernotesony3' => { 90 => 'MakN', 91 => 0x927c },
	'makernotesony4' => { 90 => 'MakN', 91 => 0x927c },
	'makernotesonyericsson' => { 90 => 'MakN', 91 => 0x927c },
	'makernotesonysrf' => { 90 => 'MakN', 91 => 0x927c },
	'makernotetype' => { 279 => 0x1 },
	'makernoteunknown' => { 90 => 'MakN', 91 => 0x927c },
	'makernoteunknowntext' => { 90 => 'MakN', 91 => 0x927c },
	'makernoteversion' => { 143 => 0x0, 172 => 0x1, 221 => 0x0, 235 => 0x8000, 283 => 0x0, 284 => 0x1, 287 => [0x1d,0x1f], 293 => 0x2000 },
	'managedfrom' => { 347 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 347 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 347 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 347 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 347 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 347 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 347 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfrommanager' => { 347 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 347 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 347 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 347 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 347 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 347 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 347 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromrenditionclass' => { 347 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 347 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 347 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 347 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 347 => 'Manager' },
	'managervariant' => { 347 => 'ManagerVariant' },
	'manageto' => { 347 => 'ManageTo' },
	'manageui' => { 347 => 'ManageUI' },
	'manifest' => { 347 => 'Manifest' },
	'manifestlinkform' => { 347 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 347 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 347 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 347 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 347 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 347 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 347 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 347 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 347 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 347 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 347 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencemanager' => { 347 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 347 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 347 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 347 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 347 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 347 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 347 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferencerenditionclass' => { 347 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 347 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 347 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 347 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 216 => 0x900, 235 => 0x86 },
	'manometerreading' => { 216 => 0x901 },
	'manualafpointselectpattern' => { 65 => 0x513 },
	'manualflash' => { 219 => 0x1209 },
	'manualflashoutput' => { 26 => 0x29, 210 => '8.2', 211 => '22.2', 212 => '16.2', 213 => '23.2', 214 => '8.2', 215 => '24.2' },
	'manualflashstrength' => { 216 => 0x406 },
	'manualfocusdistance' => { 172 => 0x85, 221 => 0x100c, 286 => 0x223 },
	'manualtv' => { 64 => 0x5, 65 => 0x705 },
	'manufacturedate' => { 244 => 0x1 },
	'manufacturedate1' => { 281 => 0x4 },
	'manufacturedate2' => { 281 => 0x5 },
	'marked' => { 334 => 'Marked', 350 => 'Marked' },
	'markers' => { 346 => 'markers' },
	'markerscomment' => { 346 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 346 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 346 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 346 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 346 => [\'markers','markersCuePointType'] },
	'markersduration' => { 346 => [\'markers','markersDuration'] },
	'markerslocation' => { 346 => [\'markers','markersLocation'] },
	'markersname' => { 346 => [\'markers','markersName'] },
	'markersprobability' => { 346 => [\'markers','markersProbability'] },
	'markersspeaker' => { 346 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 346 => [\'markers','markersStartTime'] },
	'markerstarget' => { 346 => [\'markers','markersTarget'] },
	'markerstype' => { 346 => [\'markers','markersType'] },
	'maskedareas' => { 91 => 0xc68e },
	'masterdocumentid' => { 98 => 0xb9 },
	'mastergain' => { 177 => 0x50 },
	'maxaperture' => { 26 => 0x1a, 109 => 0x6103, 126 => 'MaxAperture', 138 => 0x17, 144 => 0x49c5, 217 => 0x20a, 254 => '14.1' },
	'maxapertureatmaxfocal' => { 95 => 0x1407, 126 => 'MaxApertureAtMaxFocal', 167 => 0xb, 168 => 0x10, 169 => 0x11, 217 => 0x206 },
	'maxapertureatminfocal' => { 95 => 0x1406, 167 => 0xa, 168 => 0xf, 169 => 0x10, 217 => 0x205 },
	'maxaperturevalue' => { 91 => 0x9205, 325 => 'MaxApertureValue' },
	'maxavailheight' => { 330 => 'MaxAvailHeight' },
	'maxavailwidth' => { 330 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 209 => 0xb, 212 => 0xc, 213 => 0xb },
	'maxfaces' => { 220 => 0x1202 },
	'maxfocallength' => { 4 => 0xe6, 5 => 0x10, 6 => 0x1a4, 7 => 0x13, 8 => 0x115, 9 => 0x13, 10 => 0x153, 11 => 0xda, 13 => 0xfa, 14 => 0xee, 15 => 0x103, 16 => 0x95, 17 => 0xea, 18 => 0x157, 19 => 0xee, 20 => 0xec, 21 => 0x12b, 22 => 0x116, 26 => 0x17, 95 => 0x1405, 126 => 'MaxFocalLength', 167 => 0x9, 168 => 0xe, 169 => 0xf, 217 => 0x208 },
	'maximumdensityrange' => { 100 => 0x8c },
	'maxpagesize' => { 351 => 'MaxPageSize' },
	'maxpagesizeh' => { 351 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 351 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 351 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 91 => 0x119 },
	'maxstorage' => { 341 => 'maxstorage' },
	'mb-d10batteries' => { 209 => '12.6' },
	'mb-d10batterytype' => { 212 => '13.3' },
	'mb-d11batterytype' => { 213 => '2.3' },
	'mb-d80batteries' => { 214 => '6.5' },
	'mb-d80batterytype' => { 215 => '3.2' },
	'mcuversion' => { 167 => 0xc, 168 => 0x11, 169 => 0x12 },
	'md5digest' => { 127 => 'zmd5' },
	'measuredev' => { 22 => 0x9, 59 => 0x3, 78 => 0x1814, 119 => 'MeasuredEV' },
	'measuredev2' => { 10 => 0x8, 22 => 0x8, 59 => 0x17 },
	'measuredev3' => { 10 => 0x9 },
	'measuredlv' => { 144 => 0x690, 231 => 0x312, 237 => 0x3407 },
	'measuredrggb' => { 49 => 0x1 },
	'measuredrggbdata' => { 32 => 0x287 },
	'mediaconstraints' => { 336 => 'MediaConstraints' },
	'mediasummarycode' => { 336 => 'MediaSummaryCode' },
	'memorycardconfiguration' => { 296 => 0x16 },
	'menubuttondisplayposition' => { 63 => 0xb, 66 => 0xa, 67 => 0xb, 70 => 0xb },
	'menubuttonreturn' => { 71 => 0xb },
	'menumonitorofftime' => { 212 => '8.2', 213 => '21.1', 215 => '22.1' },
	'metadatadate' => { 344 => 'MetadataDate' },
	'metadatamoddate' => { 346 => 'metadataModDate' },
	'metering' => { 210 => '6.1' },
	'meteringmode' => { 26 => 0x11, 91 => 0x9207, 105 => 0x1c, 138 => 0x7, 139 => 0x25, 141 => 0x12, 216 => 0x202, 263 => 0x17, 287 => 0x9, 290 => 0x15, 291 => 0x13, 292 => 0x7, 302 => 0x3, 325 => 'MeteringMode' },
	'meteringmode2' => { 245 => '2.1' },
	'meteringmode3' => { 245 => '16.1' },
	'meteringoffscaleindicator' => { 141 => 0x53 },
	'meteringtime' => { 209 => '22.2', 210 => '3.2', 211 => '17.1', 212 => '7.3', 213 => '18.1', 214 => '3.2', 215 => '19.1' },
	'mieversion' => { 127 => '0Vers' },
	'minaperture' => { 26 => 0x1b, 126 => 'MinAperture', 254 => '0.2' },
	'minfocallength' => { 4 => 0xe4, 5 => 0xe, 6 => 0x1a2, 7 => 0x11, 8 => 0x113, 9 => 0x11, 10 => 0x151, 11 => 0xd8, 13 => 0xf8, 14 => 0xec, 15 => 0x101, 16 => 0x93, 17 => 0xe8, 18 => 0x155, 19 => 0xec, 20 => 0xea, 21 => 0x129, 22 => 0x114, 26 => 0x18, 95 => 0x1404, 126 => 'MinFocalLength', 167 => 0x8, 168 => 0xd, 169 => 0xe, 217 => 0x207 },
	'minoltadate' => { 138 => 0x15 },
	'minoltaimagesize' => { 138 => 0x4, 139 => 0xc, 140 => 0x2, 143 => 0x103 },
	'minoltamodelid' => { 138 => 0x25 },
	'minoltaquality' => { 138 => 0x5, 139 => 0xd, 140 => 0x3, 143 => [0x102,0x103] },
	'minoltatime' => { 138 => 0x16 },
	'minormodelagedisclosure' => { 336 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 91 => 0x118 },
	'mirrorlockup' => { 63 => 0xc, 64 => 0xc, 65 => 0x60f, 66 => 0xb, 67 => 0xc, 68 => 0x6, 69 => 0x6, 70 => 0xc, 71 => 0x3 },
	'mobilecountrycode' => { 320 => 'mcc' },
	'mobilenetworkcode' => { 320 => 'mnc' },
	'moddate' => { 227 => 'modify-date', 334 => 'ModDate' },
	'modedialposition' => { 296 => 0x14 },
	'model' => { 79 => 0x6, 91 => 0x110, 119 => 'Model', 227 => 'Model', 239 => 0x110, 342 => 'Model' },
	'modelage' => { 330 => 'ModelAge' },
	'modelingflash' => { 209 => '21.4', 212 => '26.4', 213 => '30.2', 214 => '7.4', 215 => '31.3' },
	'modelreleaseid' => { 336 => 'ModelReleaseID' },
	'modelreleasestatus' => { 336 => 'ModelReleaseStatus' },
	'modificationdate' => { 337 => 'modificationDate' },
	'modifiedcolortemp' => { 50 => 0x9 },
	'modifieddigitalgain' => { 50 => 0xb },
	'modifiedparamflag' => { 44 => 0x1 },
	'modifiedpicturestyle' => { 50 => 0xa },
	'modifiedsaturation' => { 216 => 0x504 },
	'modifiedsensorbluelevel' => { 50 => 0x5 },
	'modifiedsensorredlevel' => { 50 => 0x4 },
	'modifiedsharpness' => { 50 => 0x2 },
	'modifiedsharpnessfreq' => { 50 => 0x3 },
	'modifiedtonecurve' => { 50 => 0x1 },
	'modifiedwhitebalance' => { 50 => 0x8 },
	'modifiedwhitebalanceblue' => { 50 => 0x7 },
	'modifiedwhitebalancered' => { 50 => 0x6 },
	'modifydate' => { 91 => 0x132, 120 => 'ModifyDate', 225 => 'ModDate', 226 => 'tIME', 274 => 'ModDate', 344 => 'ModifyDate' },
	'moirefilter' => { 91 => 0xfe58, 321 => 'MoireFilter' },
	'monitordisplayoff' => { 141 => 0x4c },
	'monitorofftime' => { 209 => '18.2', 210 => '3.1', 214 => '3.1' },
	'monochromecontrast' => { 84 => 0x3c },
	'monochromefiltereffect' => { 84 => 0x3a, 263 => 0x73 },
	'monochromelinear' => { 84 => 0x3d },
	'monochromeoutputhighlightpoint' => { 84 => 0x41 },
	'monochromeoutputshadowpoint' => { 84 => 0x42 },
	'monochromerawhighlight' => { 84 => 0x7a },
	'monochromerawhighlightpoint' => { 84 => 0x3f },
	'monochromerawshadow' => { 84 => 0x83 },
	'monochromerawshadowpoint' => { 84 => 0x40 },
	'monochromesharpness' => { 84 => 0x3e },
	'monochrometoning' => { 263 => 0x74 },
	'monochrometoningeffect' => { 84 => 0x3b },
	'monochromeunsharpmaskfineness' => { 84 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 84 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 84 => 0xb4 },
	'monthdaycreated' => { 105 => 0x12, 114 => 0xe },
	'moonphase' => { 275 => 0x12 },
	'morepermissions' => { 319 => 'morePermissions' },
	'motionsensitivity' => { 275 => 0x29 },
	'multiburstimageheight' => { 301 => 0x1002 },
	'multiburstimagewidth' => { 301 => 0x1001 },
	'multiburstmode' => { 301 => 0x1000 },
	'multicontrollerwhilemetering' => { 65 => 0x517 },
	'multiexposureautogain' => { 173 => 0x3 },
	'multiexposuremode' => { 173 => 0x1 },
	'multiexposureshots' => { 173 => 0x2 },
	'multiframenoisereduction' => { 292 => 0x35, 301 => 0x200b, 302 => 0x15 },
	'multifunctionlock' => { 65 => 0x70f },
	'multipleexposuremode' => { 220 => 0x101c },
	'multipleexposureset' => { 245 => '10.1' },
	'multisample' => { 177 => 0x40 },
	'multiselector' => { 209 => '9.4', 212 => '27.4' },
	'multiselectorliveview' => { 209 => '4.3' },
	'multiselectorplaybackmode' => { 209 => ['13.5','9.2'], 212 => '27.2' },
	'multiselectorshootmode' => { 209 => '9.1', 212 => '27.1' },
	'mycolormode' => { 52 => 0x2 },
	'nativedigest' => { 325 => 'NativeDigest', 342 => 'NativeDigest' },
	'ncdfileinfo' => { 103 => 0x414 },
	'ndfilter' => { 59 => 0x1c },
	'nefbitdepth' => { 172 => 0xe22 },
	'nefcompression' => { 172 => 0x93 },
	'neflinearizationtable' => { 172 => 0x96 },
	'neutraldensityfilter' => { 263 => 0x88 },
	'neutraloutputhighlightpoint' => { 84 => 0x2f },
	'neutraloutputshadowpoint' => { 84 => 0x30 },
	'neutralrawcolortone' => { 84 => 0x28 },
	'neutralrawcontrast' => { 84 => 0x2a },
	'neutralrawhighlight' => { 84 => 0x78 },
	'neutralrawhighlightpoint' => { 84 => 0x2d },
	'neutralrawlinear' => { 84 => 0x2b },
	'neutralrawsaturation' => { 84 => 0x29 },
	'neutralrawshadow' => { 84 => 0x81 },
	'neutralrawshadowpoint' => { 84 => 0x2e },
	'neutralrawsharpness' => { 84 => 0x2c },
	'neutralunsharpmaskfineness' => { 84 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 84 => 0xa8 },
	'neutraunsharpmaskstrength' => { 84 => 0xa4 },
	'newsphotoversion' => { 100 => 0x0 },
	'nickname' => { 344 => 'Nickname' },
	'nikoncapturedata' => { 172 => 0xe01 },
	'nikoncaptureeditversions' => { 172 => 0xe13 },
	'nikoncaptureoutput' => { 172 => 0xe1e },
	'nikoncaptureversion' => { 172 => 0xe09 },
	'nikoniccprofile' => { 172 => 0xe1d },
	'nikonimagesize' => { 184 => '723.1', 185 => '732.1', 190 => 0x2c4 },
	'noisefilter' => { 216 => 0x527 },
	'noisereduction' => { 95 => 0x100b, 139 => 0xb0, 140 => 0x60, 141 => 0x3f, 172 => 0x95, 202 => 0x753dcbc0, 203 => 0x17, 216 => 0x50a, 221 => 0x103a, 235 => 0x2d, 263 => 0x49, 281 => 0x2a },
	'noisereduction2' => { 220 => 0x1010 },
	'noisereductionapplied' => { 91 => 0xc6f7 },
	'noisereductionintensity' => { 203 => 0x9 },
	'noisereductionmethod' => { 203 => 0x11 },
	'noisereductionmode' => { 309 => 0x801e },
	'noisereductionsharpness' => { 203 => 0xd },
	'noisereductionvalue' => { 309 => 0x8027 },
	'nomemorycard' => { 209 => '22.1', 210 => '0.3', 211 => '2.4', 212 => '33.7', 213 => '3.2', 214 => '0.3', 215 => '4.5' },
	'nominalmaxaperture' => { 254 => 0xa },
	'nominalminaperture' => { 254 => '10.1' },
	'notes' => { 310 => 'Notes', 316 => 'notes' },
	'npages' => { 351 => 'NPages' },
	'nrwdata' => { 172 => 0x14 },
	'nullrecord' => { 78 => 0x0 },
	'number' => { 337 => 'number' },
	'numberofbeats' => { 346 => 'numberOfBeats' },
	'numberoffocuspoints' => { 213 => '0.3' },
	'numfacepositions' => { 229 => 0x0 },
	'numindexentries' => { 100 => 0x54 },
	'object' => { 337 => 'object' },
	'objectattributereference' => { 98 => 0x4 },
	'objectcycle' => { 98 => 0x4b },
	'objectdistance' => { 87 => 0x6, 88 => 0x2022 },
	'objectname' => { 98 => 0x5 },
	'objectpreviewdata' => { 98 => 0xca },
	'objectpreviewfileformat' => { 98 => 0xc8 },
	'objectpreviewfileversion' => { 98 => 0xc9 },
	'objecttypereference' => { 98 => 0x3 },
	'oecfcolumns' => { 325 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 325 => [\'OECF','OECFNames'] },
	'oecfrows' => { 325 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 325 => [\'OECF','OECFValues'] },
	'offsetschema' => { 91 => 0xea1d },
	'okbutton' => { 213 => '15.1', 215 => '16.1' },
	'oldsubfiletype' => { 91 => 0xff },
	'olympusimageheight' => { 221 => 0x102f },
	'olympusimagewidth' => { 221 => 0x102e },
	'onetouchwb' => { 221 => 0x302 },
	'opticalzoom' => { 107 => 0xfa3d, 109 => [0x6006,0xf006], 110 => 0x1000, 111 => 0xf, 114 => 0x1e, 126 => 'OpticalZoom' },
	'opticalzoomcode' => { 59 => 0xa },
	'opticalzoommode' => { 235 => 0x34 },
	'opticalzoomon' => { 286 => 0x219 },
	'optionenddate' => { 339 => 'optionEndDate' },
	'opto-electricconvfactor' => { 325 => 'OECF' },
	'ordernumber' => { 95 => 0x8002 },
	'organisationinimagecode' => { 330 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 330 => 'OrganisationInImageName' },
	'organization' => { 337 => 'organization' },
	'orientation' => { 91 => 0x112, 239 => 0x112, 342 => 'Orientation' },
	'orientation2' => { 302 => 0x2e },
	'orientationlinkedafpoint' => { 65 => 0x516 },
	'originaldecisiondata' => { 89 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 48 => 0x83 },
	'originaldirectory' => { 233 => 0x408 },
	'originaldocumentid' => { 347 => 'OriginalDocumentID' },
	'originalfilename' => { 78 => 0x816, 103 => 0x3e9, 115 => 0x20, 233 => 0x407 },
	'originalimageheight' => { 61 => 0xc, 94 => 0x1 },
	'originalimagewidth' => { 61 => 0xb, 94 => 0x0 },
	'originalrawfiledata' => { 91 => 0xc68c },
	'originalrawfiledigest' => { 91 => 0xc71d },
	'originalrawfilename' => { 91 => 0xc68b },
	'originaltransmissionreference' => { 98 => 0x67 },
	'originatingprogram' => { 98 => 0x41 },
	'originplatform' => { 337 => 'originPlatform' },
	'os' => { 323 => 'os' },
	'otherconditions' => { 336 => 'OtherConditions' },
	'otherconstraints' => { 336 => 'OtherConstraints' },
	'otherimage' => { 89 => 'OtherImage' },
	'otherimageinfo' => { 336 => 'OtherImageInfo' },
	'otherimagelength' => { 91 => 0x202 },
	'otherimagestart' => { 91 => 0x201 },
	'otherlicensedocuments' => { 336 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 336 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 336 => 'OtherLicenseRequirements' },
	'outcue' => { 346 => 'outCue' },
	'outcuescale' => { 346 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 346 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 151 => 0x3 },
	'outputimagewidth' => { 151 => 0x2 },
	'outputresolution' => { 151 => 0x4 },
	'owner' => { 350 => 'Owner' },
	'ownerid' => { 98 => 0xbc },
	'ownername' => { 12 => 0x10f, 48 => 0x9, 78 => 0x810, 91 => [0xa430,0xfde8], 119 => 'OwnerName', 318 => 'OwnerName' },
	'padding' => { 91 => 0xea1c },
	'pageimage' => { 344 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 344 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 344 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 344 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 344 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 344 => 'PageInfo' },
	'pagename' => { 91 => 0x11d },
	'pagenumber' => { 91 => 0x129 },
	'pagerange' => { 337 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 321 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectioncontrast' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectionexposure' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionhue' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionmaskcenterweight' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskflow' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskradius' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskvalue' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskwhat' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskzerox' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionsaturation' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionsharpness' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectionwhat' => { 321 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 235 => 0x26 },
	'panasonicimageheight' => { 235 => 0x4c },
	'panasonicimagewidth' => { 235 => 0x4b },
	'panasonicrawversion' => { 239 => 0x1 },
	'panasonictitle' => { 91 => 0xc6d2 },
	'panasonictitle2' => { 91 => 0xc6d3 },
	'panoramacropbottom' => { 303 => 0x7 },
	'panoramacropleft' => { 303 => 0x4 },
	'panoramacropright' => { 303 => 0x6 },
	'panoramacroptop' => { 303 => 0x5 },
	'panoramadirection' => { 55 => 0x5, 303 => 0x3 },
	'panoramaframeheight' => { 303 => 0x9 },
	'panoramaframenumber' => { 55 => 0x2 },
	'panoramaframewidth' => { 303 => 0x8 },
	'panoramafullheight' => { 303 => 0x2 },
	'panoramafullwidth' => { 303 => 0x1 },
	'panoramamode' => { 105 => 0x3c, 216 => 0x601 },
	'panoramasourceheight' => { 303 => 0xb },
	'panoramasourcewidth' => { 303 => 0xa },
	'panoramicstitchcameramotion' => { 134 => 'PanoramicStitchCameraMotion', 135 => 0x1 },
	'panoramicstitchmaptype' => { 134 => 'PanoramicStitchMapType', 135 => 0x2 },
	'panoramicstitchphi0' => { 134 => 'PanoramicStitchPhi0', 135 => 0x5 },
	'panoramicstitchphi1' => { 134 => 'PanoramicStitchPhi1', 135 => 0x6 },
	'panoramicstitchtheta0' => { 134 => 'PanoramicStitchTheta0', 135 => 0x3 },
	'panoramicstitchtheta1' => { 134 => 'PanoramicStitchTheta1', 135 => 0x4 },
	'panoramicstitchversion' => { 135 => 0x0 },
	'pantry' => { 347 => 'Pantry' },
	'parallax' => { 95 => 0xb211 },
	'parametricdarks' => { 321 => 'ParametricDarks' },
	'parametrichighlights' => { 321 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 321 => 'ParametricHighlightSplit' },
	'parametriclights' => { 321 => 'ParametricLights' },
	'parametricmidtonesplit' => { 321 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 321 => 'ParametricShadows' },
	'parametricshadowsplit' => { 321 => 'ParametricShadowSplit' },
	'parentreference1' => { 328 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 328 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 328 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 328 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 328 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 328 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'patientbirthdate' => { 311 => 'PatientDOB' },
	'patientid' => { 311 => 'PatientID' },
	'patientname' => { 311 => 'PatientName' },
	'patientsex' => { 311 => 'PatientSex' },
	'pdfversion' => { 334 => 'PDFVersion' },
	'pentaximagesize' => { 263 => 0x9 },
	'pentaxmodelid' => { 244 => 0x0, 263 => 0x5 },
	'pentaxmodeltype' => { 263 => 0x1 },
	'pentaxversion' => { 263 => 0x0 },
	'people' => { 314 => 'People' },
	'peripheralillumcentralradius' => { 309 => 0x8030 },
	'peripheralillumcentralvalue' => { 309 => 0x8031 },
	'peripheralillumination' => { 84 => 0x68 },
	'peripheralilluminationon' => { 84 => 0x64 },
	'peripheralillumperiphvalue' => { 309 => 0x8032 },
	'peripherallighting' => { 61 => 0x2 },
	'peripherallightingsetting' => { 62 => 0x5 },
	'peripherallightingvalue' => { 61 => 0x6 },
	'permissions' => { 339 => 'permissions' },
	'permits' => { 319 => 'permits' },
	'person' => { 337 => 'person' },
	'personinimage' => { 330 => 'PersonInImage' },
	'perspectivehorizontal' => { 321 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 321 => 'PerspectiveRotate' },
	'perspectivescale' => { 321 => 'PerspectiveScale' },
	'perspectivevertical' => { 321 => 'PerspectiveVertical' },
	'pf0customfuncregistration' => { 73 => 0x1 },
	'pf10retainprogramshift' => { 73 => 0xb },
	'pf13drivepriority' => { 73 => 0xe },
	'pf14disablefocussearch' => { 73 => 0xf },
	'pf15disableafassistbeam' => { 73 => 0x10 },
	'pf16autofocuspointshoot' => { 73 => 0x11 },
	'pf17disableafpointsel' => { 73 => 0x12 },
	'pf18enableautoafpointsel' => { 73 => 0x13 },
	'pf19continuousshootspeed' => { 73 => 0x14 },
	'pf19shootingspeedhigh' => { 72 => 0xa },
	'pf19shootingspeedlow' => { 72 => 0x9 },
	'pf1disableshootingmodes' => { 73 => 0x2 },
	'pf1value' => { 72 => 0x1 },
	'pf20limitcontinousshots' => { 73 => 0x15 },
	'pf20maxcontinousshots' => { 72 => 0xb },
	'pf21enablequietoperation' => { 73 => 0x16 },
	'pf23felocktime' => { 72 => 0xd },
	'pf23postreleasetime' => { 72 => 0xe },
	'pf23settimerlengths' => { 73 => 0x18 },
	'pf23shutterbuttontime' => { 72 => 0xc },
	'pf24lightlcdduringbulb' => { 73 => 0x19 },
	'pf25aemode' => { 72 => 0xf },
	'pf25afmode' => { 72 => 0x12 },
	'pf25afpointsel' => { 72 => 0x13 },
	'pf25colormatrix' => { 72 => 0x17 },
	'pf25defaultclearsettings' => { 73 => 0x1a },
	'pf25drivemode' => { 72 => 0x11 },
	'pf25imagesize' => { 72 => 0x14 },
	'pf25meteringmode' => { 72 => 0x10 },
	'pf25parameters' => { 72 => 0x16 },
	'pf25wbmode' => { 72 => 0x15 },
	'pf26shortenreleaselag' => { 73 => 0x1b },
	'pf27reversedialrotation' => { 73 => 0x1c },
	'pf27value' => { 72 => 0x18 },
	'pf28noquickdialexpcomp' => { 73 => 0x1d },
	'pf29quickdialswitchoff' => { 73 => 0x1e },
	'pf2disablemeteringmodes' => { 73 => 0x3 },
	'pf2value' => { 72 => 0x2 },
	'pf30enlargementmode' => { 73 => 0x1f },
	'pf31originaldecisiondata' => { 73 => 0x20 },
	'pf3manualexposuremetering' => { 73 => 0x4 },
	'pf3value' => { 72 => 0x3 },
	'pf4exposuretimelimits' => { 73 => 0x5 },
	'pf4exposuretimemax' => { 72 => 0x5 },
	'pf4exposuretimemin' => { 72 => 0x4 },
	'pf5aperturelimits' => { 73 => 0x6 },
	'pf5aperturemax' => { 72 => 0x7 },
	'pf5aperturemin' => { 72 => 0x6 },
	'pf6presetshootingmodes' => { 73 => 0x7 },
	'pf7bracketcontinuousshoot' => { 73 => 0x8 },
	'pf8bracketshots' => { 72 => 0x8 },
	'pf8setbracketshots' => { 73 => 0x9 },
	'pf9changebracketsequence' => { 73 => 0xa },
	'phasedetectaf' => { 149 => 0x6 },
	'phonenumber' => { 120 => 'Phone' },
	'photoeffect' => { 26 => 0x28 },
	'photoeffecthistoryxml' => { 202 => 0xe9651831 },
	'photoeffects' => { 202 => 0xab5eca5e },
	'photoeffectsblue' => { 204 => 0x8 },
	'photoeffectsgreen' => { 204 => 0x6 },
	'photoeffectsred' => { 204 => 0x4 },
	'photoeffectstype' => { 204 => 0x0 },
	'photoinfoplayback' => { 209 => '17.6', 212 => '33.6' },
	'photometricinterpretation' => { 91 => 0x106, 342 => 'PhotometricInterpretation' },
	'photoshopquality' => { 271 => 0x0 },
	'picklabel' => { 324 => 'PickLabel' },
	'pictinfo' => { 286 => 0x208 },
	'picturecontrol' => { 202 => 0xe2173c47 },
	'picturecontrolactive' => { 205 => 0x0 },
	'picturecontroladjust' => { 174 => 0x30 },
	'picturecontrolbase' => { 174 => 0x18 },
	'picturecontroldata' => { 172 => [0xbd,0x23] },
	'picturecontrolmode' => { 205 => 0x13 },
	'picturecontrolname' => { 174 => 0x4 },
	'picturecontrolquickadjust' => { 174 => 0x31 },
	'pictureeffect' => { 301 => 0x200e },
	'picturefinish' => { 139 => 0x71 },
	'picturemode' => { 95 => 0x1031, 216 => 0x520, 263 => [0xb,0x33], 287 => 0x3d },
	'picturemode2' => { 245 => 0x0 },
	'picturemodebwfilter' => { 216 => 0x525 },
	'picturemodecontrast' => { 216 => 0x523 },
	'picturemodeeffect' => { 216 => 0x52d },
	'picturemodehue' => { 216 => 0x522 },
	'picturemodesaturation' => { 216 => 0x521 },
	'picturemodesharpness' => { 216 => 0x524 },
	'picturemodetone' => { 216 => 0x526 },
	'picturestyle' => { 5 => [0x4b,0x51], 6 => 0xed, 7 => 0x6c, 8 => 0x86, 9 => 0x73, 13 => 0xab, 14 => 0xa7, 15 => 0xb0, 16 => 0x6c, 17 => 0xa7, 18 => 0xf4, 19 => 0xb3, 21 => 0xf4, 57 => 0xa, 84 => 0x2 },
	'picturewizard' => { 284 => 0x21 },
	'picturewizardcolor' => { 282 => 0x1 },
	'picturewizardcontrast' => { 282 => 0x4 },
	'picturewizardmode' => { 282 => 0x0 },
	'picturewizardsaturation' => { 282 => 0x2 },
	'picturewizardsharpness' => { 282 => 0x3 },
	'pitchangle' => { 262 => 0x2 },
	'planarconfiguration' => { 91 => 0x11c, 342 => 'PlanarConfiguration' },
	'platenames' => { 351 => 'PlateNames' },
	'playbackmenustime' => { 211 => '20.1' },
	'playbackmonitorofftime' => { 212 => '8.1', 213 => '35.1', 215 => '21.1' },
	'playdisplay' => { 141 => 0x4e },
	'plusversion' => { 336 => 'Version' },
	'pngwarning' => { 227 => 'Warning' },
	'portraitoutputhighlightpoint' => { 84 => 0x1d },
	'portraitoutputshadowpoint' => { 84 => 0x1e },
	'portraitrawcolortone' => { 84 => 0x16 },
	'portraitrawcontrast' => { 84 => 0x18 },
	'portraitrawhighlight' => { 84 => 0x76 },
	'portraitrawhighlightpoint' => { 84 => 0x1b },
	'portraitrawlinear' => { 84 => 0x19 },
	'portraitrawsaturation' => { 84 => 0x17 },
	'portraitrawshadow' => { 84 => 0x7f },
	'portraitrawshadowpoint' => { 84 => 0x1c },
	'portraitrawsharpness' => { 84 => 0x1a },
	'portraitrefiner' => { 88 => 0x302b },
	'portraitunsharpmaskfineness' => { 84 => 0x9a },
	'portraitunsharpmaskstrength' => { 84 => 0x98 },
	'portraitunsharpmaskthreshold' => { 84 => 0x9c },
	'postalcode' => { 124 => 'PostalCode' },
	'postcropvignetteamount' => { 321 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 321 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 321 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 321 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 321 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 321 => 'PostCropVignetteStyle' },
	'powersource' => { 243 => '0.1' },
	'poweruptime' => { 172 => 0xb6 },
	'precaptureframes' => { 221 => 0x300 },
	'predictor' => { 91 => 0x13d },
	'preflashreturnstrength' => { 185 => 0x28a },
	'prefs' => { 98 => 0xdd, 270 => 'Prefs' },
	'preservedfilename' => { 347 => 'PreservedFileName' },
	'presetwhitebalance' => { 141 => 0x24, 309 => 0x8002 },
	'presetwhitebalanceadj' => { 309 => 0x8014 },
	'previewapplicationname' => { 91 => 0xc716 },
	'previewapplicationversion' => { 91 => 0xc717 },
	'previewbutton' => { 209 => ['14.1','15.1'], 212 => '29.1', 213 => '14.1' },
	'previewbuttonplusdials' => { 209 => ['14.2','15.2'], 212 => '31.2' },
	'previewcolorspace' => { 91 => 0xc71a },
	'previewcropbottom' => { 269 => 0xef },
	'previewcropleft' => { 269 => 0xec },
	'previewcropright' => { 269 => 0xee },
	'previewcroptop' => { 269 => 0xed },
	'previewdatetime' => { 91 => 0xc71b },
	'previewimage' => { 88 => 0x2000, 89 => 'PreviewImage', 92 => 'PreviewImage', 93 => 0x4, 129 => 'data', 143 => 0x81, 221 => 0x280, 234 => 0x300, 301 => 0x2001 },
	'previewimageborders' => { 263 => 0x3e },
	'previewimageheight' => { 56 => 0x4, 107 => 0xfa58 },
	'previewimagelength' => { 56 => 0x2, 88 => 0x3, 91 => [0x117,0x202], 143 => 0x89, 175 => 0x202, 216 => 0x102, 221 => 0x1037, 263 => 0x3, 278 => 0x1e, 283 => 0x3, 287 => [0x1b,0x1d], 293 => 0x202 },
	'previewimagename' => { 129 => '1Name' },
	'previewimagesize' => { 88 => 0x2, 112 => 0x2, 129 => 'ImageSize', 263 => 0x2, 287 => 0x1c, 301 => 0xb02c },
	'previewimagestart' => { 56 => 0x5, 88 => 0x4, 91 => [0x111,0x201], 143 => 0x88, 175 => 0x201, 216 => 0x101, 221 => 0x1036, 263 => 0x4, 278 => 0x1c, 283 => 0x2, 287 => [0x1a,0x1c], 293 => 0x201 },
	'previewimagetype' => { 129 => '0Type' },
	'previewimagevalid' => { 216 => 0x100, 221 => 0x1035 },
	'previewimagewidth' => { 56 => 0x3, 107 => 0xfa57 },
	'previewquality' => { 56 => 0x1 },
	'previewsettingsdigest' => { 91 => 0xc719 },
	'previewsettingsname' => { 91 => 0xc718 },
	'primaryafpoint' => { 149 => 0x7 },
	'primarychromaticities' => { 91 => 0x13f, 342 => 'PrimaryChromaticities' },
	'printim' => { 91 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 141 => 0x1d, 290 => 0x28 },
	'privatertkinfo' => { 313 => 'privateRTKInfo' },
	'processingsoftware' => { 91 => 0xb },
	'processversion' => { 321 => 'ProcessVersion' },
	'producer' => { 225 => 'Producer', 334 => 'Producer' },
	'productid' => { 99 => 0x32 },
	'productioncode' => { 244 => 0x2 },
	'productorserviceconstraints' => { 336 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 91 => 0xc6f4 },
	'profilecopyright' => { 91 => 0xc6fe },
	'profileembedpolicy' => { 91 => 0xc6fd },
	'profilehuesatmapdata1' => { 91 => 0xc6fa },
	'profilehuesatmapdata2' => { 91 => 0xc6fb },
	'profilehuesatmapdims' => { 91 => 0xc6f9 },
	'profilelooktabledata' => { 91 => 0xc726 },
	'profilelooktabledims' => { 91 => 0xc725 },
	'profilename' => { 91 => 0xc6f8 },
	'profiletonecurve' => { 91 => 0xc6fc },
	'programiso' => { 235 => 0x3c },
	'programline' => { 245 => '1.1' },
	'programmode' => { 146 => 0x5 },
	'programshift' => { 172 => 0xd },
	'programversion' => { 98 => 0x46 },
	'prohibits' => { 319 => 'prohibits' },
	'projectname' => { 346 => 'projectName' },
	'projectref' => { 346 => 'projectRef' },
	'projectrefpath' => { 346 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 346 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 336 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 336 => 'PropertyReleaseStatus' },
	'province-state' => { 98 => 0x5f },
	'publicationdate' => { 337 => 'publicationDate' },
	'publicationname' => { 337 => 'publicationName' },
	'publisher' => { 322 => 'publisher' },
	'pulldown' => { 346 => 'pullDown' },
	'quality' => { 0 => 0x1, 26 => 0x3, 87 => 0x2, 88 => 0x3002, 95 => 0x1000, 105 => 0x9, 172 => 0x4, 192 => 0x3, 221 => 0x201, 231 => 0x300, 263 => 0x8, 268 => 0x2, 287 => 0x16, 290 => 0x56, 291 => 0x56, 292 => 0xb, 301 => [0x102,0xb047] },
	'quality2' => { 305 => 0x29 },
	'qualitymode' => { 88 => 0x8 },
	'quantizationmethod' => { 100 => 0x78 },
	'quickadjust' => { 205 => 0x2a },
	'quickcontroldialinmeter' => { 65 => 0x703 },
	'quickshot' => { 286 => 0x213 },
	'rangefinder' => { 211 => '4.1' },
	'rasterizedcaption' => { 98 => 0x7d },
	'rating' => { 91 => 0x4746, 269 => 0xdf, 301 => 0x2002, 316 => 'rating', 323 => 'rating', 344 => 'Rating' },
	'ratingpercent' => { 91 => 0x4749, 136 => 'Rating' },
	'rawandjpgrecording' => { 63 => 0x8, 143 => 0x109, 245 => 0xd },
	'rawbrightnessadj' => { 83 => 0x38 },
	'rawcoloradj' => { 83 => 0x2e },
	'rawcropbottom' => { 269 => 0xd4 },
	'rawcropleft' => { 269 => 0xd1 },
	'rawcropright' => { 269 => 0xd3 },
	'rawcroptop' => { 269 => 0xd2 },
	'rawcustomsaturation' => { 83 => 0x30 },
	'rawcustomtone' => { 83 => 0x34 },
	'rawdatauniqueid' => { 91 => 0xc65d },
	'rawdepth' => { 145 => 0x10 },
	'rawdevautogradation' => { 223 => 0x119 },
	'rawdevcolorspace' => { 222 => 0x108, 223 => 0x109 },
	'rawdevcontrastvalue' => { 222 => 0x106, 223 => 0x105 },
	'rawdeveditstatus' => { 222 => 0x10b },
	'rawdevengine' => { 222 => 0x109, 223 => 0x10b },
	'rawdevexposurebiasvalue' => { 222 => 0x100, 223 => 0x100 },
	'rawdevgradation' => { 223 => 0x112 },
	'rawdevgraypoint' => { 222 => 0x103, 223 => 0x104 },
	'rawdevmemorycoloremphasis' => { 222 => 0x105, 223 => 0x108 },
	'rawdevnoisereduction' => { 222 => 0x10a, 223 => 0x10a },
	'rawdevpicturemode' => { 223 => 0x10c },
	'rawdevpm_bwfilter' => { 223 => 0x110 },
	'rawdevpmcontrast' => { 223 => 0x10e },
	'rawdevpmnoisefilter' => { 223 => 0x120 },
	'rawdevpmpicturetone' => { 223 => 0x111 },
	'rawdevpmsaturation' => { 223 => 0x10d },
	'rawdevpmsharpness' => { 223 => 0x10f },
	'rawdevsaturation3' => { 223 => 0x113 },
	'rawdevsaturationemphasis' => { 222 => 0x104, 223 => 0x107 },
	'rawdevsettings' => { 222 => 0x10c },
	'rawdevsharpnessvalue' => { 222 => 0x107, 223 => 0x106 },
	'rawdevversion' => { 222 => 0x0, 223 => 0x0 },
	'rawdevwbfineadjustment' => { 222 => 0x102, 223 => 0x103 },
	'rawdevwhitebalance' => { 223 => 0x101 },
	'rawdevwhitebalancevalue' => { 222 => 0x101, 223 => 0x102 },
	'rawfile' => { 91 => 0xfe4c },
	'rawfilename' => { 321 => 'RawFileName' },
	'rawimagecenter' => { 172 => 0x99 },
	'rawimagedigest' => { 91 => 0xc71c },
	'rawimagesize' => { 263 => 0x39 },
	'rawinfoversion' => { 224 => 0x0 },
	'rawjpgheight' => { 80 => 0x4 },
	'rawjpgquality' => { 43 => 0x6, 80 => 0x1 },
	'rawjpgsize' => { 43 => 0x7, 80 => 0x2 },
	'rawjpgwidth' => { 80 => 0x3 },
	'rawmeasuredrggb' => { 31 => 0x26a, 33 => 0x280, 35 => 0x194, 36 => 0x1ad },
	'rawrppused' => { 316 => 'rawrppused' },
	'reardisplay' => { 209 => '12.3' },
	'recognizedface1age' => { 230 => 0x20 },
	'recognizedface1name' => { 230 => 0x4 },
	'recognizedface1position' => { 230 => 0x18 },
	'recognizedface2age' => { 230 => 0x50 },
	'recognizedface2name' => { 230 => 0x34 },
	'recognizedface2position' => { 230 => 0x48 },
	'recognizedface3age' => { 230 => 0x80 },
	'recognizedface3name' => { 230 => 0x64 },
	'recognizedface3position' => { 230 => 0x78 },
	'recognizedfaceflags' => { 235 => 0x63 },
	'recommendedexposureindex' => { 91 => 0x8832 },
	'recorddisplay' => { 141 => 0x4d },
	'recordid' => { 78 => 0x1804 },
	'recordingmode' => { 87 => 0x1, 268 => 0x1 },
	'recordmode' => { 26 => 0x9, 88 => 0x3000 },
	'recordshutterrelease' => { 286 => 0x217 },
	'redbalance' => { 156 => 0x270, 221 => 0x1017, 239 => 0x11, 263 => 0x1c },
	'redcurvelimits' => { 83 => 0x18a },
	'redcurvepoints' => { 83 => 0x160 },
	'redeyecorrection' => { 206 => 0x0 },
	'redeyeinfo' => { 321 => 'RedEyeInfo' },
	'redeyereduction' => { 141 => 0x41, 292 => 0x28 },
	'redhue' => { 321 => 'RedHue' },
	'redsaturation' => { 321 => 'RedSaturation' },
	'reductionmatrix1' => { 91 => 0xc625 },
	'reductionmatrix2' => { 91 => 0xc626 },
	'reference1' => { 328 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 328 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 328 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 328 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 328 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 328 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 91 => 0x214, 342 => 'ReferenceBlackWhite' },
	'referencedate' => { 98 => 0x2f },
	'referencenumber' => { 98 => 0x32 },
	'references' => { 120 => 'References' },
	'referenceservice' => { 98 => 0x2d },
	'regionappliedtodimensions' => { 333 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 333 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 333 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 333 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 333 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 333 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 333 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 333 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 333 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 333 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 333 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 333 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 336 => 'RegionConstraints' },
	'regiondescription' => { 333 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 333 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 333 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 333 => 'Regions' },
	'regioninfodateregionsvalid' => { 133 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 133 => 'RegionInfo' },
	'regioninforegions' => { 133 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 333 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 333 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 133 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 133 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 133 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 133 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 133 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionseealso' => { 333 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 333 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 330 => 'RegistryId' },
	'registryitemid' => { 330 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 330 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 118 => 'data' },
	'relatedaudiofilename' => { 118 => '1Name' },
	'relatedaudiofiletype' => { 118 => '0Type' },
	'relatedimagefileformat' => { 91 => 0x1000 },
	'relatedimageheight' => { 91 => 0x1002 },
	'relatedimagewidth' => { 91 => 0x1001 },
	'relatedsoundfile' => { 91 => 0xa004, 325 => 'RelatedSoundFile' },
	'relatedvideofile' => { 132 => 'data' },
	'relatedvideofilename' => { 132 => '1Name' },
	'relatedvideofiletype' => { 132 => '0Type' },
	'relation' => { 322 => 'relation' },
	'relativepeakaudiofilepath' => { 346 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 346 => 'relativeTimestamp' },
	'relativetimestampscale' => { 346 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 346 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 209 => '17.8', 212 => '33.8', 213 => '17.6' },
	'releasedate' => { 98 => 0x1e, 346 => 'releaseDate' },
	'releasemode' => { 88 => 0x3001, 301 => 0xb049 },
	'releasemode2' => { 305 => 0x10 },
	'releasemode3' => { 305 => 0x22 },
	'releasesetting' => { 78 => 0x1016 },
	'releasetime' => { 98 => 0x23 },
	'remoteonduration' => { 210 => '3.4', 211 => '17.2', 213 => '18.2', 214 => '4.3', 215 => '19.2' },
	'renditionclass' => { 347 => 'RenditionClass' },
	'renditionof' => { 347 => 'RenditionOf' },
	'renditionofalternatepaths' => { 347 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 347 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 347 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 347 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 347 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 347 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionofmanager' => { 347 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 347 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 347 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 347 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 347 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 347 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 347 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofrenditionclass' => { 347 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 347 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 347 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 347 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 347 => 'RenditionParams' },
	'repeatingflashcount' => { 160 => 0xd, 161 => 0xe, 162 => 0xe, 212 => '17.2', 213 => '24.2', 214 => '9.2', 215 => '25.2' },
	'repeatingflashoutput' => { 212 => '17.1', 213 => '24.1', 214 => '9.1', 215 => '25.1' },
	'repeatingflashrate' => { 160 => 0xc, 161 => 0xd, 162 => 0xd, 212 => '18.1', 213 => '25.1', 214 => '10.1', 215 => '26.1' },
	'requires' => { 319 => 'requires' },
	'resampleparams' => { 346 => 'resampleParams' },
	'resampleparamsquality' => { 346 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 286 => 0x21e },
	'resolution' => { 125 => 'Resolution' },
	'resolutionmode' => { 287 => 0x4 },
	'resolutionunit' => { 91 => 0x128, 101 => 0x2, 342 => 'ResolutionUnit' },
	'restrictions' => { 339 => 'restrictions' },
	'retouchhistory' => { 172 => 0x9e },
	'retouchinfo' => { 321 => 'RetouchInfo' },
	'reuse' => { 336 => 'Reuse' },
	'reuseallowed' => { 349 => 'ReuseAllowed' },
	'reuseprohibited' => { 339 => 'reuseProhibited' },
	'reverseindicators' => { 209 => '12.1', 211 => '4.3', 212 => '33.5', 213 => '5.1', 215 => '6.2' },
	'revision' => { 323 => 'revision' },
	'rgbcurvelimits' => { 83 => 0x238 },
	'rgbcurvepoints' => { 83 => 0x20e },
	'richtextcomment' => { 327 => 'RichTextComment' },
	'ricohdate' => { 278 => 0x6 },
	'ricohimageheight' => { 278 => 0x2 },
	'ricohimagewidth' => { 278 => 0x0 },
	'rightascension' => { 128 => 'RightAscension' },
	'rights' => { 322 => 'rights' },
	'rightsagent' => { 337 => 'rightsAgent', 339 => 'rightsAgent' },
	'rightsowner' => { 339 => 'rightsOwner' },
	'rollangle' => { 262 => 0x1 },
	'romoperationmode' => { 78 => 0x80d },
	'rotation' => { 23 => 0x17, 24 => 0x18, 77 => 0x3, 83 => 0x26e, 94 => 0x4, 128 => 'Rotation', 139 => [0x65,0x50], 140 => 0x46, 141 => 0x5a, 144 => 0x10, 190 => '590.1', 202 => 0x76a43207, 235 => 0x30, 245 => '17.2', 269 => 0xd8, 290 => 0x3f, 291 => 0x3f, 300 => 0x10 },
	'routedto' => { 326 => 'RoutedTo' },
	'routing' => { 274 => 'Routing' },
	'routingnotes' => { 326 => 'RoutingNotes' },
	'rowsperstrip' => { 91 => 0x116 },
	'rpp' => { 316 => 'rpp' },
	'safetyshift' => { 65 => 0x108 },
	'safetyshiftinavortv' => { 63 => 0x10, 64 => 0x10, 66 => 0xf, 67 => 0x10, 70 => 0x10 },
	'samplebits' => { 118 => 'SampleBits' },
	'samplerate' => { 118 => 'SampleRate' },
	'samplesperpixel' => { 91 => 0x115, 342 => 'SamplesPerPixel' },
	'samplestructure' => { 100 => 0x5a },
	'sanyoquality' => { 286 => 0x201 },
	'sanyothumbnail' => { 286 => 0x100 },
	'saturation' => { 7 => 0x6e, 9 => 0x76, 26 => 0xe, 37 => 0x1, 87 => 0xd, 88 => [0x3013,0x1f], 91 => [0xa409,0xfe55], 95 => 0x1003, 119 => 'Saturation', 138 => 0x1f, 139 => 0x32, 140 => 0x28, 141 => 0x1a, 146 => 0x1, 172 => [0x94,0xaa], 174 => 0x35, 235 => 0x40, 237 => 0x300d, 263 => 0x1f, 268 => 0xd, 275 => 0x27, 278 => 0x28, 287 => 0x10, 290 => 0x1e, 291 => 0x1b, 301 => 0x2005, 321 => 'Saturation', 325 => 'Saturation' },
	'saturationadj' => { 83 => 0x116, 201 => 0x1, 205 => 0x2e, 309 => 0x8016 },
	'saturationadjustmentaqua' => { 321 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 321 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 321 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 321 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 321 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 321 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 321 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 321 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 16 => 0xfe, 53 => 0x68, 54 => 0x68 },
	'saturationlandscape' => { 16 => 0xfc, 53 => 0x38, 54 => 0x38 },
	'saturationmonochrome' => { 53 => 0x80, 54 => 0x80 },
	'saturationneutral' => { 16 => 0xfd, 53 => 0x50, 54 => 0x50 },
	'saturationportrait' => { 16 => 0xfb, 53 => 0x20, 54 => 0x20 },
	'saturationsetting' => { 224 => 0x1010, 292 => 0x11, 302 => 0x9 },
	'saturationstandard' => { 16 => 0xfa, 53 => 0x8, 54 => 0x8 },
	'saturationunknown' => { 54 => 0x98 },
	'saturationuserdef1' => { 16 => 0x100, 53 => 0x98, 54 => 0xb0 },
	'saturationuserdef2' => { 16 => 0x101, 53 => 0xb0, 54 => 0xc8 },
	'saturationuserdef3' => { 16 => 0x102, 53 => 0xc8, 54 => 0xe0 },
	'saveid' => { 347 => 'SaveID' },
	'scaletype' => { 346 => 'scaleType' },
	'scanimageenhancer' => { 177 => 0x60 },
	'scanningdirection' => { 100 => 0x64 },
	'scene' => { 329 => 'Scene', 346 => 'scene' },
	'scenearea' => { 219 => 0x211, 221 => 0x1031 },
	'sceneassist' => { 172 => 0x9c },
	'scenecapturetype' => { 91 => 0xa406, 325 => 'SceneCaptureType' },
	'scenedetect' => { 219 => 0x210, 221 => 0x1030 },
	'scenedetectdata' => { 219 => 0x212, 221 => 0x1033 },
	'scenemode' => { 107 => 0xfa02, 143 => 0x100, 172 => 0x8f, 216 => 0x509, 221 => 0x403, 235 => 0x8001, 301 => 0xb023 },
	'scenemodeused' => { 109 => [0x6002,0xf002] },
	'sceneselect' => { 286 => 0x21f },
	'scenetype' => { 91 => 0xa301, 325 => 'SceneType' },
	'screentips' => { 209 => '12.7', 212 => '13.1', 213 => '4.4', 215 => '5.1' },
	'section' => { 337 => 'section' },
	'securityclassification' => { 91 => 0x9212 },
	'selectableafpoint' => { 65 => 0x509 },
	'selectafareaselectmode' => { 65 => 0x512 },
	'selftimer' => { 26 => 0x2, 235 => 0x2e, 286 => 0x214 },
	'selftimer2' => { 59 => 0x1d },
	'selftimerinterval' => { 213 => '19.2' },
	'selftimermode' => { 91 => 0x882b },
	'selftimershotcount' => { 211 => '18.2', 213 => '19.3', 215 => '20.2' },
	'selftimertime' => { 78 => 0x1806, 141 => 0x1f, 209 => '18.1', 210 => '3.3', 211 => '18.1', 212 => '7.2', 213 => '19.1', 214 => '3.3', 215 => '20.1' },
	'seminfo' => { 91 => 0x8546 },
	'sensingmethod' => { 91 => 0xa217, 325 => 'SensingMethod' },
	'sensitivityadjust' => { 263 => 0x40 },
	'sensitivitysteps' => { 245 => ['14.3','17.4'], 247 => 0x1 },
	'sensitivitytype' => { 91 => 0x8830 },
	'sensorareas' => { 284 => 0xa010 },
	'sensorbitdepth' => { 237 => 0x312d },
	'sensorbluelevel' => { 57 => 0x5 },
	'sensorcleaning' => { 71 => 0xd },
	'sensorfullheight' => { 102 => 0xf904 },
	'sensorfullwidth' => { 102 => 0xf903 },
	'sensorheight' => { 102 => 0xf901, 107 => 0xfa21, 145 => 0x8, 237 => 0x312c },
	'sensorpixelsize' => { 172 => 0x9a },
	'sensorredlevel' => { 57 => 0x4 },
	'sensorsize' => { 119 => 'SensorSize', 263 => 0x35 },
	'sensortemperature' => { 219 => 0x1500, 221 => 0x1007, 287 => [0x39,0x55] },
	'sensorwidth' => { 102 => 0xf900, 107 => 0xfa20, 145 => 0xa, 237 => 0x312b },
	'sequence' => { 275 => 0x7 },
	'sequencefilenumber' => { 305 => 0xc },
	'sequenceimagenumber' => { 305 => 0x8 },
	'sequencenumber' => { 59 => 0x9, 88 => 0x301c, 95 => 0x1101, 105 => 0x1d, 235 => 0x2b, 292 => [0x10c,0x30c], 301 => 0xb04a },
	'sequenceshotinterval' => { 286 => 0x224 },
	'sequentialshot' => { 286 => 0x20e },
	'serialnumber' => { 48 => 0xc, 78 => 0x180b, 91 => [0xa431,0xfde9], 102 => 0xfa04, 104 => 0xfa00, 106 => 0xc354, 107 => 0xfa19, 116 => 0x0, 119 => 'SerialNumber', 172 => [0xa0,0x1d], 217 => 0x101, 221 => [0x404,0x101a], 231 => 0x303, 237 => 0x3103, 263 => 0x229, 275 => 0x15, 279 => 0x5, 287 => 0x2, 318 => 'SerialNumber' },
	'serialnumberformat' => { 48 => 0x15, 78 => 0x183b },
	'seriesdatetime' => { 311 => 'SeriesDateTime' },
	'seriesdescription' => { 311 => 'SeriesDescription' },
	'seriesmodality' => { 311 => 'SeriesModality' },
	'seriesnumber' => { 311 => 'SeriesNumber' },
	'serviceidentifier' => { 99 => 0x1e },
	'setbuttoncrosskeysfunc' => { 68 => 0x0, 69 => 0x0 },
	'setbuttonwhenshooting' => { 63 => 0x1, 65 => 0x704, 71 => 0xc },
	'setfunctionwhenshooting' => { 66 => 0x0, 67 => 0x1, 70 => 0x1 },
	'shadingcompensation' => { 216 => 0x50c },
	'shadingcompensation2' => { 220 => 0x1012 },
	'shadow' => { 287 => 0xe },
	'shadowcompensation' => { 263 => 0x79 },
	'shadowprotection' => { 201 => 0x0 },
	'shadows' => { 91 => 0xfe52, 315 => 'Shadows', 321 => 'Shadows' },
	'shadows2012' => { 321 => 'Shadows2012' },
	'shadowscale' => { 91 => 0xc633 },
	'shadowtint' => { 321 => 'ShadowTint' },
	'shakereduction' => { 264 => 0x1 },
	'sharpendetail' => { 321 => 'SharpenDetail' },
	'sharpenedgemasking' => { 321 => 'SharpenEdgeMasking' },
	'sharpening' => { 237 => 0x300b },
	'sharpeningadj' => { 205 => 0x2b },
	'sharpenradius' => { 321 => 'SharpenRadius' },
	'sharpness' => { 5 => [0x42,0x48], 7 => 0x72, 9 => 0x74, 26 => 0xf, 57 => 0x2, 87 => 0xb, 88 => [0x3011,0x21], 91 => [0xa40a,0xfe56], 95 => 0x1001, 105 => 0x6b, 114 => 0x37, 119 => 'Sharpness', 138 => 0x21, 139 => 0x30, 140 => 0x26, 141 => 0x18, 146 => 0x3, 172 => 0x6, 174 => 0x32, 221 => 0x100f, 235 => 0x41, 263 => 0x21, 268 => 0xb, 275 => 0x26, 278 => 0x22, 279 => 0x1003, 287 => 0x11, 290 => 0x1c, 291 => 0x19, 301 => 0x2006, 321 => 'Sharpness', 325 => 'Sharpness' },
	'sharpnessadj' => { 83 => 0x25a, 309 => 0x801a },
	'sharpnessfactor' => { 221 => 0x102a },
	'sharpnessfaithful' => { 16 => 0xf5, 53 => 0x64, 54 => 0x64 },
	'sharpnessfrequency' => { 5 => [0x41,0x47], 57 => 0x3 },
	'sharpnesslandscape' => { 16 => 0xf3, 53 => 0x34, 54 => 0x34 },
	'sharpnessmonochrome' => { 16 => 0xf6, 53 => 0x7c, 54 => 0x7c },
	'sharpnessneutral' => { 16 => 0xf4, 53 => 0x4c, 54 => 0x4c },
	'sharpnessovershoot' => { 309 => 0x801b },
	'sharpnessportrait' => { 16 => 0xf2, 53 => 0x1c, 54 => 0x1c },
	'sharpnesssetting' => { 216 => 0x506, 224 => 0x1013, 292 => 0x12, 302 => 0xa },
	'sharpnessstandard' => { 16 => 0xf1, 53 => 0x4, 54 => 0x4 },
	'sharpnessthreshold' => { 309 => 0x801d },
	'sharpnessundershoot' => { 309 => 0x801c },
	'sharpnessunknown' => { 54 => 0x94 },
	'sharpnessuserdef1' => { 16 => 0xf7, 53 => 0x94, 54 => 0xac },
	'sharpnessuserdef2' => { 16 => 0xf8, 53 => 0xac, 54 => 0xc4 },
	'sharpnessuserdef3' => { 16 => 0xf9, 53 => 0xc4, 54 => 0xdc },
	'shootinginfodisplay' => { 209 => '13.2', 212 => '10.2', 213 => '4.1', 215 => '5.3' },
	'shootinginfomonitorofftime' => { 212 => '9.1', 213 => '21.2', 215 => '22.2' },
	'shootingmode' => { 119 => 'ShootingMode', 172 => 0x89, 235 => 0x1f },
	'shootingmodesetting' => { 210 => '5.1' },
	'shortdescription' => { 323 => 'shortdescription' },
	'shortdocumentid' => { 98 => 0xba },
	'shortownername' => { 16 => 0xac },
	'shortreleasetimelag' => { 65 => 0x80d },
	'shotdate' => { 346 => 'shotDate' },
	'shotday' => { 346 => 'shotDay' },
	'shotlocation' => { 346 => 'shotLocation' },
	'shotname' => { 346 => 'shotName' },
	'shotnumber' => { 346 => 'shotNumber' },
	'shotnumbersincepowerup' => { 305 => 0x1a },
	'shotsize' => { 346 => 'shotSize' },
	'shutter-aelock' => { 63 => 0x4, 65 => 0x701, 66 => 0x3, 67 => 0x4, 68 => 0x3, 69 => 0x3, 70 => 0x4, 71 => 0x2 },
	'shutteraelbutton' => { 64 => 0x4 },
	'shutterbuttonafonbutton' => { 65 => 0x701 },
	'shuttercount' => { 8 => 0x176, 43 => 0x1, 172 => 0xa7, 178 => [0x6a,0x157,0x24d], 179 => 0x286, 180 => 0x279, 181 => 0x284, 182 => 0x242, 183 => 0x280, 184 => 0x276, 185 => [0x27d,0x27f], 186 => 0x246, 187 => 0x2d6, 188 => 0x287, 189 => 0x320, 190 => 0x24a, 191 => 0x2d5, 263 => 0x5d },
	'shuttercurtainsync' => { 63 => 0xf, 64 => 0xf, 65 => 0x305, 66 => 0xe, 67 => 0xf, 68 => 0x8, 69 => 0x8, 70 => 0xf, 71 => 0x8 },
	'shuttermode' => { 105 => 0x1b },
	'shutterreleasebuttonae-l' => { 209 => '17.7', 211 => '16.1', 212 => '7.1', 213 => '17.5', 215 => '18.2' },
	'shutterreleasemethod' => { 78 => 0x1010 },
	'shutterreleasenocfcard' => { 63 => 0x2, 64 => 0x2, 71 => 0xf },
	'shutterreleasetiming' => { 78 => 0x1011 },
	'shutterspeedrange' => { 65 => 0x10c },
	'shutterspeedsetting' => { 141 => 0x6, 290 => 0x2f, 291 => 0x28, 292 => 0x0 },
	'shutterspeedvalue' => { 74 => 0x1, 91 => 0x9201, 221 => 0x1000, 325 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 335 => 'SidecarForExtension' },
	'similarityindex' => { 98 => 0xe4 },
	'singleframebracketing' => { 141 => 0x21 },
	'slaveflashmeteringsegments' => { 263 => 0x20b },
	'slowshutter' => { 59 => 0x8 },
	'slowsync' => { 95 => 0x1030 },
	'smartrange' => { 284 => 0xa012 },
	'smileshutter' => { 292 => 0x31 },
	'smileshuttermode' => { 292 => 0x27 },
	'smoothness' => { 91 => 0xfe57, 321 => 'Smoothness' },
	'softskineffect' => { 301 => 0x200f },
	'software' => { 91 => 0x131, 120 => 'Software', 227 => 'Software', 287 => 0x18, 342 => 'Software' },
	'softwareversion' => { 286 => 0x207 },
	'sonydatetime' => { 304 => 0x6 },
	'sonyimageheight' => { 304 => 0x1a },
	'sonyimagesize' => { 141 => 0x3b, 290 => 0x54, 291 => 0x54, 292 => 0x9 },
	'sonyimagewidth' => { 304 => 0x1c },
	'sonymodelid' => { 301 => 0xb001 },
	'sonyquality' => { 141 => 0x3c },
	'source' => { 98 => 0x73, 227 => 'Source', 322 => 'source', 323 => 'source', 335 => 'Source' },
	'sourcedirectoryindex' => { 251 => 0x0 },
	'sourcefileindex' => { 251 => 0x2 },
	'spatialfrequencyresponse' => { 325 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 325 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 325 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 325 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 325 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 346 => 'speakerPlacement' },
	'specialeffectlevel' => { 88 => 0x3030 },
	'specialeffectmode' => { 88 => 0x2076 },
	'specialeffectsetting' => { 88 => 0x3031 },
	'specialinstructions' => { 98 => 0x28 },
	'specialmode' => { 221 => 0x200, 286 => 0x200 },
	'spectralsensitivity' => { 91 => 0x8824, 325 => 'SpectralSensitivity' },
	'splittoningbalance' => { 321 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 321 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 321 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 321 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 321 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 138 => 0x2d },
	'spotfocuspointy' => { 138 => 0x2e },
	'spotmeteringmode' => { 26 => 0x27 },
	'spotmeterlinktoafpoint' => { 65 => 0x107 },
	'sractive' => { 245 => '17.1' },
	'srawquality' => { 26 => 0x2e },
	'srfocallength' => { 264 => 0x3 },
	'srhalfpresstime' => { 264 => 0x2 },
	'srresult' => { 264 => 0x0 },
	'standardoutputhighlightpoint' => { 84 => 0x14 },
	'standardoutputsensitivity' => { 91 => 0x8831 },
	'standardoutputshadowpoint' => { 84 => 0x15 },
	'standardrawcolortone' => { 84 => 0xd },
	'standardrawcontrast' => { 84 => 0xf },
	'standardrawhighlight' => { 84 => 0x75 },
	'standardrawhighlightpoint' => { 84 => 0x12 },
	'standardrawlinear' => { 84 => 0x10 },
	'standardrawsaturation' => { 84 => 0xe },
	'standardrawshadow' => { 84 => 0x7e },
	'standardrawshadowpoint' => { 84 => 0x13 },
	'standardrawsharpness' => { 84 => 0x11 },
	'standardunsharpmaskfineness' => { 84 => 0x94 },
	'standardunsharpmaskstrength' => { 84 => 0x92 },
	'standardunsharpmaskthreshold' => { 84 => 0x96 },
	'startingpage' => { 337 => 'startingPage' },
	'startmovieshooting' => { 65 => 0x70d },
	'starttimecode' => { 346 => 'startTimecode' },
	'starttimecodetimeformat' => { 346 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 346 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 346 => [\'startTimecode','startTimecodeValue'] },
	'state' => { 124 => 'State', 235 => 0x6b, 335 => 'State' },
	'status' => { 314 => 'Status' },
	'storagemethod' => { 145 => 0x12 },
	'straightenangle' => { 202 => 0x2fc08431 },
	'stretchmode' => { 346 => 'stretchMode' },
	'studydatetime' => { 311 => 'StudyDateTime' },
	'studydescription' => { 311 => 'StudyDescription' },
	'studyid' => { 311 => 'StudyID' },
	'studyphysician' => { 311 => 'StudyPhysician' },
	'sub-location' => { 98 => 0x5c },
	'subfiledata' => { 127 => 'data' },
	'subfiledirectory' => { 127 => '1Directory' },
	'subfilemimetype' => { 127 => '2MIME' },
	'subfilename' => { 127 => '1Name' },
	'subfileresource' => { 127 => 'rsrc' },
	'subfiletype' => { 91 => 0xfe, 127 => '0Type' },
	'subject' => { 225 => 'Subject', 274 => 'Subject', 322 => 'subject', 334 => 'Subject', 347 => 'subject' },
	'subjectarea' => { 91 => 0x9214, 325 => 'SubjectArea' },
	'subjectcode' => { 329 => 'SubjectCode' },
	'subjectdistance' => { 91 => 0x9206, 105 => 0x3e, 325 => 'SubjectDistance' },
	'subjectdistancerange' => { 91 => 0xa40c, 325 => 'SubjectDistanceRange' },
	'subjectlocation' => { 91 => 0xa214, 325 => 'SubjectLocation' },
	'subjectprogram' => { 138 => 0x22 },
	'subjectreference' => { 98 => 0xc },
	'sublabels4' => { 328 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 328 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 328 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 328 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 328 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subsectime' => { 91 => 0x9290 },
	'subsectimedigitized' => { 91 => 0x9292 },
	'subsectimeoriginal' => { 91 => 0x9291 },
	'subsection1' => { 337 => 'subsection1' },
	'subsection2' => { 337 => 'subsection2' },
	'subsection3' => { 337 => 'subsection3' },
	'subsection4' => { 337 => 'subsection4' },
	'subversionfilename' => { 328 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 328 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 328 => 'SubVersions' },
	'superimposeddisplay' => { 63 => 0xa, 65 => 0x510, 66 => 0x9, 67 => 0xa, 70 => 0xa, 71 => 0xe },
	'supermacro' => { 48 => 0x1a },
	'supplementalcategories' => { 98 => 0x14, 335 => 'SupplementalCategories' },
	'supplementaltype' => { 100 => 0x37 },
	'svisosetting' => { 245 => 0x14 },
	'sweeppanoramadirection' => { 292 => 0x33 },
	'sweeppanoramasize' => { 292 => 0x32 },
	'switchtoregisteredafpoint' => { 64 => 0x12, 65 => 0x50a },
	'tagged' => { 269 => 0xdd, 316 => 'tagged' },
	'tagslist' => { 324 => 'TagsList' },
	'tagstructure' => { 328 => 'TagStructure' },
	'takenumber' => { 346 => 'takeNumber' },
	'tapename' => { 346 => 'tapeName' },
	'targetaperture' => { 59 => 0x4 },
	'targetcompressionratio' => { 76 => 0x1 },
	'targetdistancesetting' => { 78 => 0x1807 },
	'targetexposuretime' => { 59 => 0x5 },
	'targetimagetype' => { 78 => 0x100a },
	'teaser' => { 337 => 'teaser' },
	'teleconverter' => { 143 => 0x105, 301 => 0x105 },
	'tempo' => { 346 => 'tempo' },
	'termsandconditionstext' => { 336 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 336 => 'TermsAndConditionsURL' },
	'textencoding' => { 171 => 0x4 },
	'textlayername' => { 335 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 335 => 'TextLayers' },
	'textlayertext' => { 335 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 235 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 91 => 0x107 },
	'thumbnailfilename' => { 78 => 0x817 },
	'thumbnailformat' => { 344 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 107 => 0xfa55, 344 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 78 => 0x2008, 89 => 'ThumbnailImage', 93 => 0x3, 130 => 'data', 221 => 0x100, 344 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 130 => '1Name' },
	'thumbnailimagesize' => { 130 => 'ImageSize' },
	'thumbnailimagetype' => { 130 => '0Type' },
	'thumbnailimagevalidarea' => { 48 => 0x13 },
	'thumbnaillength' => { 91 => 0x202 },
	'thumbnailoffset' => { 91 => 0x201 },
	'thumbnails' => { 344 => 'Thumbnails' },
	'thumbnailwidth' => { 107 => 0xfa54, 344 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 337 => 'ticker' },
	'tilelength' => { 91 => 0x143 },
	'tilewidth' => { 91 => 0x142 },
	'time' => { 103 => 0x401, 263 => 0x7 },
	'timecreated' => { 98 => 0x3c, 105 => 0x14, 114 => 0x10, 270 => 'TimeCreated' },
	'timeperiod' => { 337 => 'timePeriod' },
	'timerfunctionbutton' => { 210 => '5.2', 211 => '12.1' },
	'timerlength' => { 65 => 0x80c },
	'timescaleparams' => { 346 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 346 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 346 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 346 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 99 => 0x50 },
	'timesignature' => { 346 => 'timeSignature' },
	'timesincepoweron' => { 235 => 0x29 },
	'timestamp' => { 8 => 0x45e, 16 => 0x11c, 227 => 'TimeStamp', 317 => 'Timestamp' },
	'timestamp1' => { 8 => 0x45a },
	'timezone' => { 60 => 0x1, 194 => 0x0 },
	'timezonecity' => { 60 => 0x2 },
	'timezonecode' => { 81 => 0x1 },
	'timezoneinfo' => { 81 => 0x2 },
	'timezoneoffset' => { 91 => 0x882a },
	'tint' => { 321 => 'Tint' },
	'title' => { 120 => 'Title', 225 => 'Title', 227 => 'Title', 235 => 0x65, 274 => 'Title', 322 => 'title', 334 => 'Title', 344 => 'Title' },
	'tonecomp' => { 172 => 0x81 },
	'tonecurve' => { 57 => 0x1, 263 => 0x402, 321 => 'ToneCurve' },
	'tonecurve1' => { 284 => 0xa040 },
	'tonecurve2' => { 284 => 0xa041 },
	'tonecurve3' => { 284 => 0xa042 },
	'tonecurve4' => { 284 => 0xa043 },
	'tonecurveactive' => { 83 => 0x110 },
	'tonecurveblue' => { 321 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 309 => 0x9003 },
	'tonecurvebluey' => { 309 => 0x9007 },
	'tonecurvebrightnessx' => { 309 => 0x9000 },
	'tonecurvebrightnessy' => { 309 => 0x9004 },
	'tonecurvefilename' => { 103 => 0x1391 },
	'tonecurvegreen' => { 321 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 309 => 0x9002 },
	'tonecurvegreeny' => { 309 => 0x9006 },
	'tonecurveinterpolation' => { 83 => 0x159 },
	'tonecurvemode' => { 83 => 0x113 },
	'tonecurvename' => { 321 => 'ToneCurveName' },
	'tonecurvename2012' => { 321 => 'ToneCurveName2012' },
	'tonecurveproperty' => { 83 => 0x3c },
	'tonecurvepv2012' => { 321 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 321 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 321 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 321 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 321 => 'ToneCurveRed' },
	'tonecurveredx' => { 309 => 0x9001 },
	'tonecurveredy' => { 309 => 0x9005 },
	'tonecurves' => { 263 => 0x403 },
	'toningeffect' => { 43 => 0xf, 172 => 0xb3, 174 => 0x38 },
	'toningeffectfaithful' => { 53 => 0x74, 54 => 0x74 },
	'toningeffectlandscape' => { 53 => 0x44, 54 => 0x44 },
	'toningeffectmonochrome' => { 16 => 0x108, 53 => 0x8c, 54 => 0x8c },
	'toningeffectneutral' => { 53 => 0x5c, 54 => 0x5c },
	'toningeffectportrait' => { 53 => 0x2c, 54 => 0x2c },
	'toningeffectstandard' => { 53 => 0x14, 54 => 0x14 },
	'toningeffectunknown' => { 54 => 0xa4 },
	'toningeffectuserdef1' => { 53 => 0xa4, 54 => 0xbc },
	'toningeffectuserdef2' => { 53 => 0xbc, 54 => 0xd4 },
	'toningeffectuserdef3' => { 53 => 0xd4, 54 => 0xec },
	'toningsaturation' => { 174 => 0x39 },
	'totalzoom' => { 105 => 0x62 },
	'tracknumber' => { 346 => 'trackNumber' },
	'tracks' => { 346 => 'Tracks' },
	'tracksframerate' => { 346 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 346 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 346 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 346 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 346 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 346 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 346 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 346 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 346 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 346 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 346 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 346 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 346 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 346 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 346 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 346 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 346 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 127 => 'zmie' },
	'transferfunction' => { 91 => 0x12d, 342 => 'TransferFunction' },
	'transform' => { 235 => [0x8012,0x59] },
	'transmissionreference' => { 335 => 'TransmissionReference' },
	'trapped' => { 225 => 'Trapped', 334 => 'Trapped' },
	'travelday' => { 235 => 0x36 },
	'triggermode' => { 275 => 0x6 },
	'ttl_da_adown' => { 252 => 0x5 },
	'ttl_da_aup' => { 252 => 0x4 },
	'ttl_da_bdown' => { 252 => 0x7 },
	'ttl_da_bup' => { 252 => 0x6 },
	'tungstenawb' => { 242 => 0x1 },
	'tvexposuretimesetting' => { 245 => 0x12 },
	'type' => { 322 => 'type', 341 => 'type' },
	'uniquecameramodel' => { 91 => 0xc614 },
	'uniquedocumentid' => { 98 => 0xbb },
	'uniqueobjectname' => { 99 => 0x64 },
	'unknownblock' => { 220 => 0x1103 },
	'unknowncontrast' => { 84 => 0x45 },
	'unknownev' => { 103 => 0x1 },
	'unknownlinear' => { 84 => 0x46 },
	'unknownnumber' => { 78 => 0x180b, 117 => [0xa8,0xc4] },
	'unknownoutputhighlightpoint' => { 84 => 0x4a },
	'unknownoutputshadowpoint' => { 84 => 0x4b },
	'unknownrawhighlight' => { 84 => 0x7b },
	'unknownrawhighlightpoint' => { 84 => 0x48 },
	'unknownrawshadow' => { 84 => 0x84 },
	'unknownrawshadowpoint' => { 84 => 0x49 },
	'unknownsharpness' => { 84 => 0x47 },
	'unsharp1color' => { 207 => 0x13 },
	'unsharp1halowidth' => { 207 => 0x19 },
	'unsharp1intensity' => { 207 => 0x17 },
	'unsharp1threshold' => { 207 => 0x1b },
	'unsharp2color' => { 207 => 0x2e },
	'unsharp2halowidth' => { 207 => 0x34 },
	'unsharp2intensity' => { 207 => 0x32 },
	'unsharp2threshold' => { 207 => 0x36 },
	'unsharp3color' => { 207 => 0x49 },
	'unsharp3halowidth' => { 207 => 0x4f },
	'unsharp3intensity' => { 207 => 0x4d },
	'unsharp3threshold' => { 207 => 0x51 },
	'unsharp4color' => { 207 => 0x64 },
	'unsharp4halowidth' => { 207 => 0x6a },
	'unsharp4intensity' => { 207 => 0x68 },
	'unsharp4threshold' => { 207 => 0x6c },
	'unsharpcount' => { 207 => 0x0 },
	'unsharpmask' => { 84 => 0x90, 202 => 0x76a43200 },
	'urgency' => { 98 => 0xa, 335 => 'Urgency' },
	'url' => { 120 => 'URL', 227 => 'URL', 272 => 0x40b, 337 => 'url' },
	'usablemeteringmodes' => { 65 => 0x10a },
	'usableshootingmodes' => { 65 => 0x109 },
	'usage' => { 338 => 'usage' },
	'usagefee' => { 339 => 'usageFee' },
	'usageterms' => { 350 => 'UsageTerms' },
	'useguidelines' => { 319 => 'useGuidelines' },
	'usercomment' => { 78 => 0x805, 91 => 0x9286, 325 => 'UserComment' },
	'userdef1picturestyle' => { 16 => 0x10c, 53 => 0xd8, 54 => 0xf0 },
	'userdef2picturestyle' => { 16 => 0x10e, 53 => 0xda, 54 => 0xf2 },
	'userdef3picturestyle' => { 16 => 0x110, 53 => 0xdc, 54 => 0xf4 },
	'userfields' => { 314 => 'UserFields' },
	'userlabel' => { 275 => 0x2b },
	'userprofile' => { 231 => 0x302, 237 => 0x3038 },
	'usmlenselectronicmf' => { 64 => 0x7, 65 => 0x501 },
	'utmeasting' => { 131 => 'Easting' },
	'utmmapdatum' => { 131 => 'Datum' },
	'utmnorthing' => { 131 => 'Northing' },
	'utmzone' => { 131 => 'Zone' },
	'uv-irfiltercorrection' => { 231 => 0x325 },
	'validbits' => { 220 => 0x611, 221 => 0x102c },
	'validpixeldepth' => { 224 => 0x611 },
	'variousmodes' => { 105 => 0x26 },
	'variousmodes2' => { 105 => 0x3a },
	'variprogram' => { 172 => 0xab },
	'version' => { 95 => 0x0, 274 => 'Version', 321 => 'Version' },
	'versioncreatedate' => { 309 => 0xd100 },
	'versionid' => { 347 => 'VersionID' },
	'versionidentifier' => { 337 => 'versionIdentifier' },
	'versionmodifydate' => { 309 => 0xd101 },
	'versions' => { 347 => 'Versions' },
	'versionscomments' => { 347 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 347 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 347 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 347 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 347 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 347 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 347 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 347 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 347 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 347 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 347 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 209 => '3.2' },
	'vfdisplayillumination' => { 65 => 0x510 },
	'vibrance' => { 315 => 'Vibrance', 321 => 'Vibrance' },
	'vibrationreduction' => { 178 => [0x75,0x82,0x1ae], 186 => '586.1', 190 => '590.2', 193 => 0x4 },
	'videoalphamode' => { 346 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 346 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 346 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 346 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 346 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 346 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 346 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgreen' => { 346 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 346 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 346 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 346 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 346 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 346 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 346 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 346 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 346 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 346 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 51 => 0x74 },
	'videocolorspace' => { 346 => 'videoColorSpace' },
	'videocompressor' => { 346 => 'videoCompressor' },
	'videofieldorder' => { 346 => 'videoFieldOrder' },
	'videoframerate' => { 346 => 'videoFrameRate' },
	'videoframesize' => { 346 => 'videoFrameSize' },
	'videoframesizeh' => { 346 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 346 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 346 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 346 => 'videoModDate' },
	'videopixelaspectratio' => { 346 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 346 => 'videoPixelDepth' },
	'videoquality' => { 88 => 0x4003 },
	'viewfinderdisplay' => { 209 => '12.4' },
	'viewfinderwarning' => { 209 => '13.4', 213 => '3.5', 214 => '6.2', 215 => '4.4' },
	'viewfinderwarnings' => { 65 => 0x40a },
	'viewinfoduringexposure' => { 65 => 0x407 },
	'viewingmode' => { 292 => 0x2f, 302 => 0x18 },
	'viewingmode2' => { 292 => 0x85 },
	'vignetteamount' => { 321 => 'VignetteAmount' },
	'vignettecontrol' => { 172 => 0x2a, 202 => 0x76a43205 },
	'vignettecontrolintensity' => { 202 => 0xac6bd5c0 },
	'vignettemidpoint' => { 321 => 'VignetteMidpoint' },
	'vignettingcorrection' => { 301 => 0x2011 },
	'voicememo' => { 286 => 0x216 },
	'volume' => { 337 => 'volume' },
	'vr_0x66' => { 178 => 0x66 },
	'vrdoffset' => { 48 => 0xd0 },
	'wb_bluelevel3500k' => { 144 => 0x19a },
	'wb_bluelevel6500k' => { 144 => 0x18a },
	'wb_bluelevelcustom' => { 144 => 0x18e },
	'wb_bluelevelscloudy' => { 144 => 0x106 },
	'wb_bluelevelsdaylight' => { 144 => 0xea },
	'wb_bluelevelsflash' => { 144 => 0x122 },
	'wb_bluelevelsfluorescent' => { 144 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 144 => 0x254 },
	'wb_bluelevelsshade' => { 144 => 0x176 },
	'wb_bluelevelstungsten' => { 144 => 0xce },
	'wb_gbrglevels' => { 144 => 0xae, 147 => 0x4 },
	'wb_glevel' => { 220 => 0x11f },
	'wb_glevel3000k' => { 220 => 0x113 },
	'wb_glevel3300k' => { 220 => 0x114 },
	'wb_glevel3600k' => { 220 => 0x115 },
	'wb_glevel3900k' => { 220 => 0x116 },
	'wb_glevel4000k' => { 220 => 0x117 },
	'wb_glevel4300k' => { 220 => 0x118 },
	'wb_glevel4500k' => { 220 => 0x119 },
	'wb_glevel4800k' => { 220 => 0x11a },
	'wb_glevel5300k' => { 220 => 0x11b },
	'wb_glevel6000k' => { 220 => 0x11c },
	'wb_glevel6600k' => { 220 => 0x11d },
	'wb_glevel7500k' => { 220 => 0x11e },
	'wb_grbglevels' => { 155 => 0x0 },
	'wb_rbgglevels' => { 152 => 0x0 },
	'wb_rblevels' => { 172 => 0xc, 220 => 0x100 },
	'wb_rblevels3000k' => { 220 => 0x102 },
	'wb_rblevels3300k' => { 220 => 0x103 },
	'wb_rblevels3500k' => { 144 => 0x430 },
	'wb_rblevels3600k' => { 220 => 0x104 },
	'wb_rblevels3900k' => { 220 => 0x105 },
	'wb_rblevels4000k' => { 220 => 0x106 },
	'wb_rblevels4300k' => { 220 => 0x107 },
	'wb_rblevels4500k' => { 220 => 0x108 },
	'wb_rblevels4800k' => { 220 => 0x109 },
	'wb_rblevels5300k' => { 220 => 0x10a },
	'wb_rblevels6000k' => { 220 => 0x10b },
	'wb_rblevels6500k' => { 144 => 0x420 },
	'wb_rblevels6600k' => { 220 => 0x10c },
	'wb_rblevels7500k' => { 220 => 0x10d },
	'wb_rblevelsauto' => { 224 => 0x110 },
	'wb_rblevelscloudy' => { 144 => 0x3f0, 146 => 0x10, 224 => 0x121 },
	'wb_rblevelscoolwhitef' => { 144 => 0x308, 146 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 224 => 0x132 },
	'wb_rblevelscustom' => { 144 => 0x424 },
	'wb_rblevelscwb1' => { 220 => 0x10e },
	'wb_rblevelscwb2' => { 220 => 0x10f },
	'wb_rblevelscwb3' => { 220 => 0x110 },
	'wb_rblevelscwb4' => { 220 => 0x111 },
	'wb_rblevelsdaylight' => { 144 => [0x3ec,0x528], 146 => 0xc },
	'wb_rblevelsdaylightf' => { 146 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 224 => 0x130 },
	'wb_rblevelsdaywhitef' => { 146 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 224 => 0x131 },
	'wb_rblevelseveningsunlight' => { 224 => 0x124 },
	'wb_rblevelsfineweather' => { 224 => 0x122 },
	'wb_rblevelsflash' => { 144 => [0x3f4,0x304], 146 => 0x18 },
	'wb_rblevelsshade' => { 144 => 0x418, 146 => 0x20, 224 => 0x120 },
	'wb_rblevelstungsten' => { 144 => 0x3e8, 146 => 0x8, 224 => 0x123 },
	'wb_rblevelsunknown' => { 146 => 0x1c },
	'wb_rblevelsused' => { 224 => 0x100 },
	'wb_rblevelswhitef' => { 146 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 224 => 0x133 },
	'wb_redlevel3500k' => { 144 => 0x198 },
	'wb_redlevel6500k' => { 144 => 0x188 },
	'wb_redlevelcustom' => { 144 => 0x18c },
	'wb_redlevelscloudy' => { 144 => 0xf8 },
	'wb_redlevelsdaylight' => { 144 => 0xdc },
	'wb_redlevelsflash' => { 144 => 0x114 },
	'wb_redlevelsfluorescent' => { 144 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 144 => 0x1be },
	'wb_redlevelsshade' => { 144 => 0x168 },
	'wb_redlevelstungsten' => { 144 => 0xc0 },
	'wb_rgbglevels' => { 154 => 0x0 },
	'wb_rgblevels' => { 144 => [0x546,0x96], 232 => 0xd, 233 => 0x413, 237 => 0x3036 },
	'wb_rggblevels' => { 147 => 0x4, 153 => 0x0 },
	'wb_rggblevelsasshot' => { 29 => 0x0, 30 => 0x19, 31 => 0x22, 32 => 0x3f, 35 => 0x3f, 36 => 0x3f },
	'wb_rggblevelsauto' => { 27 => 0x0, 29 => 0x5, 30 => 0x1e, 31 => 0x18, 32 => 0x44, 35 => 0x44, 36 => 0x44, 284 => 0xa022 },
	'wb_rggblevelsblack' => { 284 => 0xa028 },
	'wb_rggblevelscloudy' => { 27 => 0xc, 29 => 0x1e, 30 => 0x2d, 31 => 0x31, 32 => 0x58, 35 => 0x71, 36 => 0x71, 263 => 0x20f },
	'wb_rggblevelscustom' => { 27 => 0x1c, 32 => 0x80 },
	'wb_rggblevelscustom1' => { 30 => 0x41 },
	'wb_rggblevelscustom2' => { 30 => 0x46 },
	'wb_rggblevelsdaylight' => { 27 => 0x4, 29 => 0x14, 30 => 0x23, 31 => 0x27, 32 => 0x4e, 35 => 0x67, 36 => 0x67, 263 => 0x20d },
	'wb_rggblevelsflash' => { 27 => 0x18, 29 => 0x32, 30 => 0x3c, 31 => 0x45, 32 => 0x6c, 35 => 0x85, 36 => 0x85, 263 => 0x214 },
	'wb_rggblevelsfluorescent' => { 27 => 0x14, 29 => 0x28, 30 => 0x37, 31 => 0x3b, 32 => 0x62, 35 => 0x7b, 36 => 0x7b },
	'wb_rggblevelsfluorescentd' => { 263 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 263 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 263 => 0x213 },
	'wb_rggblevelsilluminator1' => { 284 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 284 => 0xa024 },
	'wb_rggblevelskelvin' => { 27 => 0x20, 29 => 0x2d, 31 => 0x40, 32 => 0x67, 35 => 0x80, 36 => 0x80 },
	'wb_rggblevelsmeasured' => { 29 => 0xa, 32 => 0x49, 35 => 0x49, 36 => 0x49 },
	'wb_rggblevelspc1' => { 31 => 0x90, 32 => 0x71 },
	'wb_rggblevelspc2' => { 31 => 0x95, 32 => 0x76 },
	'wb_rggblevelspc3' => { 31 => 0x9a, 32 => 0x7b },
	'wb_rggblevelsshade' => { 27 => 0x8, 29 => 0x19, 30 => 0x28, 31 => 0x2c, 32 => 0x53, 35 => 0x6c, 36 => 0x6c, 263 => 0x20e },
	'wb_rggblevelstungsten' => { 27 => 0x10, 29 => 0x23, 30 => 0x32, 31 => 0x36, 32 => 0x5d, 35 => 0x76, 36 => 0x76, 263 => 0x210 },
	'wb_rggblevelsuncorrected' => { 284 => 0xa021 },
	'wb_rggblevelsunknown' => { 29 => 0xf, 31 => 0x1d, 35 => 0x4e, 36 => 0x4e },
	'wb_rggblevelsunknown10' => { 29 => 0x5f, 31 => 0x72, 35 => 0x9e, 36 => 0x9e },
	'wb_rggblevelsunknown11' => { 29 => 0x64, 31 => 0x77, 35 => 0xa3, 36 => 0xa3 },
	'wb_rggblevelsunknown12' => { 29 => 0x69, 31 => 0x7c, 35 => 0xa8, 36 => 0xa8 },
	'wb_rggblevelsunknown13' => { 29 => 0x6e, 31 => 0x81, 35 => 0xad, 36 => 0xad },
	'wb_rggblevelsunknown14' => { 31 => 0x86, 35 => 0xb2, 36 => 0xb2 },
	'wb_rggblevelsunknown15' => { 31 => 0x8b, 35 => 0xb7, 36 => 0xb7 },
	'wb_rggblevelsunknown16' => { 31 => 0x9f, 36 => 0xbc },
	'wb_rggblevelsunknown17' => { 36 => 0xc1 },
	'wb_rggblevelsunknown18' => { 36 => 0xc6 },
	'wb_rggblevelsunknown19' => { 36 => 0xcb },
	'wb_rggblevelsunknown2' => { 29 => 0x37, 31 => 0x4a, 35 => 0x53, 36 => 0x53 },
	'wb_rggblevelsunknown20' => { 36 => 0xd0 },
	'wb_rggblevelsunknown3' => { 29 => 0x3c, 31 => 0x4f, 35 => 0x58, 36 => 0x58 },
	'wb_rggblevelsunknown4' => { 29 => 0x41, 31 => 0x54, 35 => 0x5d, 36 => 0x5d },
	'wb_rggblevelsunknown5' => { 29 => 0x46, 31 => 0x59, 35 => 0x62, 36 => 0x62 },
	'wb_rggblevelsunknown6' => { 29 => 0x4b, 31 => 0x5e, 35 => 0x8a, 36 => 0x8a },
	'wb_rggblevelsunknown7' => { 29 => 0x50, 31 => 0x63, 35 => 0x8f, 36 => 0x8f },
	'wb_rggblevelsunknown8' => { 29 => 0x55, 31 => 0x68, 35 => 0x94, 36 => 0x94 },
	'wb_rggblevelsunknown9' => { 29 => 0x5a, 31 => 0x6d, 35 => 0x99, 36 => 0x99 },
	'wbadjbluebalance' => { 208 => 0x8 },
	'wbadjcolortemp' => { 83 => 0x1a },
	'wbadjlighting' => { 208 => 0x15 },
	'wbadjlightingsubtype' => { 208 => 0x14 },
	'wbadjmode' => { 208 => 0x10 },
	'wbadjredbalance' => { 208 => 0x0 },
	'wbadjrggblevels' => { 83 => 0x6 },
	'wbadjtemperature' => { 208 => 0x18 },
	'wbadjtint' => { 208 => 0x25 },
	'wbbluelevel' => { 231 => 0x324, 235 => 0x8006, 239 => 0x26 },
	'wbbracketmode' => { 43 => 0x9 },
	'wbbracketshotnumber' => { 144 => 0x2b },
	'wbbracketvalueab' => { 43 => 0xc },
	'wbbracketvaluegm' => { 43 => 0xd },
	'wbfinetuneactive' => { 83 => 0x24 },
	'wbfinetunesaturation' => { 83 => 0x28 },
	'wbfinetunetone' => { 83 => 0x2c },
	'wbgreenlevel' => { 231 => 0x323, 235 => 0x8005, 239 => 0x25 },
	'wbmediaimagesizesetting' => { 65 => 0x708 },
	'wbmode' => { 146 => 0x4, 221 => 0x1015 },
	'wbredlevel' => { 231 => 0x322, 235 => 0x8004, 239 => 0x24 },
	'wbscale' => { 147 => 0x0 },
	'wbshiftab' => { 57 => 0xc, 235 => 0x46, 246 => 0x10 },
	'wbshiftab_gm' => { 301 => 0x2014 },
	'wbshiftgm' => { 57 => 0xd, 235 => 0x47, 246 => 0x11 },
	'webstatement' => { 350 => 'WebStatement' },
	'whitebalance' => { 4 => 0x6f, 5 => [0x44,0x4a], 6 => 0xb5, 7 => 0x36, 8 => 0x5e, 9 => 0x36, 10 => 0x78, 11 => 0x6f, 12 => 0x6f, 13 => 0x73, 14 => 0x6f, 15 => 0x78, 16 => 0x54, 17 => 0x6f, 18 => 0xbc, 19 => 0x7b, 21 => 0xbc, 22 => 0x77, 57 => 0x8, 59 => 0x7, 87 => 0x7, 88 => [0x19,0x2012], 91 => [0xa403,0xfe4e], 95 => 0x1002, 103 => 0x3fc, 104 => 0xfa0d, 105 => 0x40, 138 => 0x3, 139 => 0xe, 140 => 0x4, 141 => 0xb, 143 => 0x115, 172 => 0x5, 192 => 0x7, 231 => 0x304, 235 => 0x3, 237 => 0x3033, 263 => 0x19, 268 => 0x7, 278 => 0x26, 287 => [0x3c,0x7,0x58], 301 => [0x115,0xb054], 321 => 'WhiteBalance', 325 => 'WhiteBalance' },
	'whitebalance2' => { 216 => 0x500 },
	'whitebalanceadj' => { 83 => 0x18, 202 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 242 => 0x0 },
	'whitebalancebias' => { 88 => 0x2011, 221 => 0x304, 235 => 0x23 },
	'whitebalanceblue' => { 57 => 0x7 },
	'whitebalancebracket' => { 216 => 0x502, 221 => 0x303 },
	'whitebalancebracketing' => { 141 => 0x22, 144 => 0x2c, 300 => 0x2c },
	'whitebalancecomp' => { 224 => 0x1001 },
	'whitebalancefinetune' => { 95 => 0x100a, 141 => 0x38, 143 => 0x112, 172 => 0xb, 290 => 0x6, 301 => 0x112 },
	'whitebalancemode' => { 263 => 0x1a },
	'whitebalancered' => { 57 => 0x6 },
	'whitebalanceset' => { 245 => 0xa },
	'whitebalancesetting' => { 141 => 0x23, 292 => 0x16, 302 => 0xd },
	'whitebalancetemperature' => { 216 => 0x501 },
	'whiteboard' => { 221 => 0x301 },
	'whitelevel' => { 91 => 0xc61d },
	'whitepoint' => { 91 => 0x13e, 263 => 0x201, 342 => 'WhitePoint' },
	'whites2012' => { 321 => 'Whites2012' },
	'widefocuszone' => { 138 => 0x2f },
	'widerange' => { 286 => 0x20f },
	'wordcount' => { 337 => 'wordCount' },
	'workcolorspace' => { 83 => 0x270 },
	'worktodo' => { 326 => 'WorkToDo' },
	'worldtimelocation' => { 235 => 0x3a, 263 => 0x22, 267 => '0.1' },
	'writer-editor' => { 98 => 0x7a },
	'x3filllight' => { 287 => 0x12 },
	'xmp' => { 82 => 0xffff00f6, 92 => 'XMP' },
	'xmptoolkit' => { 343 => 'xmptk' },
	'xpauthor' => { 91 => 0x9c9d },
	'xpcomment' => { 91 => 0x9c9c },
	'xpkeywords' => { 91 => 0x9c9e },
	'xposition' => { 91 => 0x11e },
	'xpsubject' => { 91 => 0x9c9f },
	'xptitle' => { 91 => 0x9c9b },
	'xresolution' => { 91 => 0x11a, 101 => 0x3, 273 => 0x0, 342 => 'XResolution' },
	'xyresolution' => { 94 => 0x3 },
	'ycbcrcoefficients' => { 91 => 0x211, 342 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 91 => 0x213, 342 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 91 => 0x212, 342 => 'YCbCrSubSampling' },
	'yearcreated' => { 105 => 0x10, 114 => 0xc },
	'yposition' => { 91 => 0x11f },
	'yresolution' => { 91 => 0x11b, 101 => 0x5, 273 => 0x4, 342 => 'YResolution' },
	'zonematching' => { 143 => 0x10a, 146 => [0x3a,0x4a], 301 => 0xb024 },
	'zonematchingmode' => { 141 => 0x14 },
	'zonematchingon' => { 140 => 0x75 },
	'zonematchingvalue' => { 290 => 0x1f },
	'zoomedpreviewlength' => { 221 => 0xf05 },
	'zoomedpreviewsize' => { 221 => 0xf06 },
	'zoomedpreviewstart' => { 221 => 0xf04 },
	'zoomsourcewidth' => { 26 => 0x24 },
	'zoomstepcount' => { 219 => 0x300, 221 => 0x100d },
	'zoomtargetwidth' => { 26 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'35mmfocallength' => 1,
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abstract' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfounknown' => 1,
	'aeunknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsselected' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'animationiterations' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectinfo' => 1,
	'aspectratiotype' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachedfile' => 1,
	'attachedfiledata' => 1,
	'attachedfiledescription' => 1,
	'attachedfilemimetype' => 1,
	'attachedfilename' => 1,
	'attachedfilereferral' => 1,
	'attachedfileuid' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavgbitrate' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiodelay' => 1,
	'audioencoding' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomode' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiovendorid' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autoportraitframed' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'balance' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'batteryinfo' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'block' => 1,
	'blockaddid' => 1,
	'blockadditional' => 1,
	'blockadditionalid' => 1,
	'blockadditions' => 1,
	'blockduration' => 1,
	'blockgroup' => 1,
	'blocklocation' => 1,
	'blockmore' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blockvirtual' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'booktitle' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfoa100' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelpositions' => 1,
	'chapter' => 1,
	'chapteratom' => 1,
	'chaptercountry' => 1,
	'chapterdisplay' => 1,
	'chapterflagenabled' => 1,
	'chapterflaghidden' => 1,
	'chapterlanguage' => 1,
	'chapterlist' => 1,
	'chapternum' => 1,
	'chapterphysicalequivalent' => 1,
	'chapterprocess' => 1,
	'chapterprocesscodecid' => 1,
	'chapterprocesscommand' => 1,
	'chapterprocessdata' => 1,
	'chapterprocessprivate' => 1,
	'chapterprocesstime' => 1,
	'chapters' => 1,
	'chaptersegmenteditionuid' => 1,
	'chaptersegmentuid' => 1,
	'chapterstring' => 1,
	'chaptertimeend' => 1,
	'chaptertimestart' => 1,
	'chaptertrack' => 1,
	'chaptertracknumber' => 1,
	'chaptertranslate' => 1,
	'chaptertranslatecodec' => 1,
	'chaptertranslateeditionuid' => 1,
	'chaptertranslateid' => 1,
	'chapteruid' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperturedimensions' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cluster' => 1,
	'clusterduration' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'codecdecodeall' => 1,
	'codecdownloadurl' => 1,
	'codecflavorid' => 1,
	'codecid' => 1,
	'codecinfourl' => 1,
	'codeclist' => 1,
	'codecname' => 1,
	'codecprivate' => 1,
	'codecsettings' => 1,
	'codecstate' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcompression' => 1,
	'contentcompressionalgorithm' => 1,
	'contentcompressionsettings' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencoding' => 1,
	'contentencodingorder' => 1,
	'contentencodings' => 1,
	'contentencodingscope' => 1,
	'contentencodingtype' => 1,
	'contentencryption' => 1,
	'contentencryptionalgorithm' => 1,
	'contentencryptionkeyid' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentsignature' => 1,
	'contentsignaturealgorithm' => 1,
	'contentsignaturehashalgorithm' => 1,
	'contentsignaturekeyid' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc-32' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorappid' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatorinfo' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cueblocknumber' => 1,
	'cueclusterposition' => 1,
	'cuecodecstate' => 1,
	'cuepoint' => 1,
	'cuerefcluster' => 1,
	'cuerefcodecstate' => 1,
	'cuereference' => 1,
	'cuerefnumber' => 1,
	'cuereftime' => 1,
	'cues' => 1,
	'cuesheet' => 1,
	'cuetime' => 1,
	'cuetrack' => 1,
	'cuetrackpositions' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custompicturestyledata' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd40' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcmd' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultduration' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayheight' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunit' => 1,
	'displayunits' => 1,
	'displaywidth' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dngadobedata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'doctypereadversion' => 1,
	'doctypeversion' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dvdid' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'ebmlheader' => 1,
	'ebmlmaxidlength' => 1,
	'ebmlmaxsizelength' => 1,
	'ebmlreadversion' => 1,
	'ebmlversion' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editionentry' => 1,
	'editionflagdefault' => 1,
	'editionflaghidden' => 1,
	'editionflagordered' => 1,
	'editionuid' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryptedblock' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'episodename' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionanimation' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionicc' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensionxmp' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepermissions' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0105' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'focallength35efl' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameheight' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'framewidth' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'givenname' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highisonoisereduction2' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'identification' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'insertmode' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesu' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keys' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'lacenumber' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'layercomps' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturer' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxblockadditionid' => 1,
	'maxcache' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mcdi' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'mean' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacreatedate' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medialanguagecode' => 1,
	'mediamodifydate' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'middlename' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'mincache' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'muxingapp' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nextfilename' => 1,
	'nexttrackid' => 1,
	'nextuid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noiseprofile' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputaudiosamplerate' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parameter' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'participants' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestyleinfo2' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'prevfilename' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'prevsize' => 1,
	'prevuid' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profession' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'rawcodecversion' => 1,
	'rawdata' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawimagefullsize' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'readstatus' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referenceblock' => 1,
	'referencepriority' => 1,
	'referencevirtual' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohrdc2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'runwindow' => 1,
	'sampledegradationpriority' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seek' => 1,
	'seekable' => 1,
	'seekhead' => 1,
	'seekid' => 1,
	'seekpoint' => 1,
	'seekposition' => 1,
	'seektable' => 1,
	'segmentfamily' => 1,
	'segmentfilename' => 1,
	'segmentheader' => 1,
	'segmentuid' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod40' => 1,
	'shotinfod5000' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signaturealgo' => 1,
	'signatureelementlist' => 1,
	'signatureelements' => 1,
	'signaturehash' => 1,
	'signaturepublickey' => 1,
	'signatureslot' => 1,
	'signatureusagerights' => 1,
	'signedelement' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'silenttracknumber' => 1,
	'silenttracks' => 1,
	'simpleblock' => 1,
	'simpleindex' => 1,
	'simpletag' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundschemetitle' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereo3dmode' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyrictext' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag' => 1,
	'tag9400' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag940e' => 1,
	'tagattachmentuid' => 1,
	'tagbinary' => 1,
	'tagchapteruid' => 1,
	'tagdefault' => 1,
	'tageditionuid' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'taglanguage' => 1,
	'tagname' => 1,
	'tags' => 1,
	'tagstring' => 1,
	'tagtrackuid' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetprinter' => 1,
	'targets' => 1,
	'targettype' => 1,
	'targettypevalue' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfok5' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimage' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timecodescale' => 1,
	'timeinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timeslice' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackattachmentuid' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackdefault' => 1,
	'trackduration' => 1,
	'trackentry' => 1,
	'trackerdata' => 1,
	'trackforced' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklacing' => 1,
	'tracklanguage' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackname' => 1,
	'trackoffset' => 1,
	'trackoverlay' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktimecodescale' => 1,
	'tracktranslate' => 1,
	'tracktranslatecodec' => 1,
	'tracktranslateeditionuid' => 1,
	'tracktranslatetrackid' => 1,
	'tracktype' => 1,
	'trackuid' => 1,
	'trackused' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_cndb' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'ur3' => 1,
	'url_list' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userlastplayedtime' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'void' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8version' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wb_grblevels' => 1,
	'wb_grgblevels' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbinfoa100' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writers' => 1,
	'writingapp' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtra' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yawangle' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $lc = $$tagTablePtr{$id} ? lc $$tagTablePtr{$id}{Name} : $lcTag . lc($field);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        my $fieldInfo = $$strTable{$field};
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2012, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
