/* This file holds constants for use with the WD ethernet controllers. */

#define CREG         0x00                      // 8003 status/control register
#define LAAR         0x05                      // LAN access register
#define ADDROM       0x08                      // LAN address ROM
#define CMDR         0x10                      // command register for read & write

 
// Page 0 register offset for read and write
#define CLDA0        0x11                      // current local dma addr 0 for read
#define PSTART       0x11                      // page start register for write
#define CLDA1        0x12                      // current local dma addr 1 for read
#define PSTOP        0x12                      // page stop register for write
#define BNRY         0x13                      // boundary reg for rd and wr
#define TSR          0x14                      // tx status reg for rd
#define TPSR         0x14                      // tx start page start reg for wr        
#define NCR          0x15                      // number of collision reg for rd
#define TBCR0        0x15                      // tx byte count 0 reg for wr
#define FIFO         0x16                      // FIFO for rd
#define TBCR1        0x16                      // tx byte count 1 reg for wr
#define ISR          0x17                      // interrupt status reg for rd and wr
#define CRDA0        0x18                      // current remote dma address 0 for rd
#define RSAR0        0x18                      // remote start address reg 0  for wr
#define CRDA1        0x19                      // current remote dma address 1 for rd
#define RSAR1        0x19                      // remote start address reg 1 for wr
#define RBCR0        0x1A                      // remote byte count reg 0 for wr
#define RBCR1        0x1B                      // remote byte count reg 1 for wr
#define RSR          0x1C                      // rx status reg for rd
#define RCVR         0x1C                      // rx configuration reg for wr
#define CNTR0        0x1D                      // tally cnt 0 for frm alg err for rd
#define TCR          0x1D                      // tx configuration reg for wr
#define CNTR1        0x1E                      // tally cnt 1 for crc err for rd
#define DCR          0x1E                      // data configuration reg for wr
#define CNTR2        0x1F                      // tally cnt 2 for missed pkt for rd
#define IMR          0x1F                      // interrupt mask reg for wr

// Page 1 register offset for read and write
#define PAR0         0x11                      // physical addr reg 0 for rd and wr
#define PAR1         0x12                      // physical addr reg 1 for rd and wr
#define PAR2         0x13                      // physical addr reg 2 for rd and wr
#define PAR3         0x14                      // physical addr reg 3 for rd and wr
#define PAR4         0x15                      // physical addr reg 4 for rd and wr
#define PAR5         0x16                      // physical addr reg 5 for rd and wr
#define CURR         0x17                      // current page reg for rd and wr
#define MAR0         0x18                      // multicast addr reg 0 fro rd and WR
#define MAR1         0x19                      // multicast addr reg 1 fro rd and WR
#define MAR2         0x1A                      // multicast addr reg 2 fro rd and WR
#define MAR3         0x1B                      // multicast addr reg 3 fro rd and WR
#define MAR4         0x1C                      // multicast addr reg 4 fro rd and WR
#define MAR5         0x1D                      // multicast addr reg 5 fro rd and WR
#define MAR6         0x1E                      // multicast addr reg 6 fro rd and WR
#define MAR7         0x1F                      // multicast addr reg 7 fro rd and WR

//***********************************************************************
//
//       8003 control register operations
//***********************************************************************
 
#define MSK_RESET    0x80                      // reset LAN controller
#define MSK_ENASH    0x40                      // enable PC access to shared mem
#define MSK_DECOD    0x3F                      // ???? memory decode bits, corresponding
                                               // to SA 18-13. SA 19 assumed to be 1

//***********************************************************************
//
//       8390 CMDR MASK
//***********************************************************************

#define MSK_STP      0x01                      // software reset, take 8390 off line
#define MSK_STA      0x02                      // activate the 8390 NIC
#define MSK_TXP      0x04                      // initial txing of a frm
#define MSK_RD2      0x20                      // abort remote DMA
#define MSK_PG0      0x00                      // select register page 0
#define MSK_PG1      0x40                      // select register page 1

//***********************************************************************
//
//       8390 ISR & IMR MASK
//***********************************************************************

#define MSK_PRX      0x01                      // rx with no error
#define MSK_PTX      0x02                      // tx with no error
#define MSK_RXE      0x04                      // rx with error
#define MSK_TXE      0x08                      // tx with error
#define MSK_OVW      0x10                      // overwrite warning
#define MSK_CNT      0x20                      // MSB of one of the tally counters is set
#define MSK_RDC      0x40                      // remote dma completed
#define MSK_RST      0x80                      // reset state indicator

//***********************************************************************
//
//       8390 DCR MASK
//***********************************************************************

#define MSK_WTS      0x01                      // word transfer mode selection
#define MSK_BOS      0x02                      // byte order selection
#define MSK_LAS      0x04                      // long addr selection
#define MSK_BMS      0x08                      // burst mode selection
#define MSK_ARM      0x10                      // atuoinitialize remote
#define MSK_FT00     0x00                      // burst lrngth selection
#define MSK_FT01     0x20                      // burst lrngth selection
#define MSK_FT10     0x40                      // burst lrngth selection
#define MSK_FT11     0x60                      // burst lrngth selection

//***********************************************************************
//
//       8390 RCVR MASK
//***********************************************************************

#define MSK_SEP      0x01                      // save error pkts
#define MSK_AR       0x02                      // accept runt pkt
#define MSK_AB       0x04                      // accept broadcast 
#define MSK_AM       0x08                      // accept multicast 
#define MSK_PRO      0x10                      // promiscuous physical
                                               // accept all pkt with physical adr
#define MSK_MON      0x20                      // monitor mode

//***********************************************************************
//
//       8390 TCR MASK
//***********************************************************************

#define MSK_CRC      0x01                      // inhibit CRC, do not append crc
#define MSK_LB01     0x06                      // encoded loopback control
#define MSK_ATD      0x08                      // auto tx disable
#define MSK_OFST     0x10                      // collision offset enable

//***********************************************************************
//
//       8390 RSR MASK
//***********************************************************************

#define SMK_PRX      0x01                      // rx without error
#define SMK_CRC      0x02                      // CRC error
#define SMK_FAE      0x04                      // frame alignment error
#define SMK_FO       0x08                      // FIFO overrun
#define SMK_MPA      0x10                      // missed pkt
#define SMK_PHY      0x20                      // physical/multicase address
#define SMK_DIS      0x40                      // receiver disable. set in monitor mode
#define SMK_DEF      0x80                      // deferring

//***********************************************************************
//
//       8390 TSR MASK
//***********************************************************************

#define SMK_PTX      0x01                      // tx without error
#define SMK_DFR      0x02                      // non deferred tx
#define SMK_COL      0x04                      // tx collided
#define SMK_ABT      0x08                      // tx aboort because of excessive collisions
#define SMK_CRS      0x10                      // carrier sense lost
#define SMK_FU       0x20                      // FIFO underrun
#define SMK_CDH      0x40                      // collision detect heartbeat
#define SMK_OWC      0x80                      // out of window collision

//***********************************************************************
//
//       Setting up the LAN access.
//***********************************************************************
#define MEM16ENB     0x81                      // Enable 16K of memory
#define LAN16ENB     0x41                      // Enable 16 bit LAN access.


//***********************************************************************
//
//       Miscellaneous Constants
//***********************************************************************

//
// PIC (8259) Information 
//
#define EOI          0x20                      // End Of Interrupt
#define INTA00       0x20                      // 8259 port
#define INTA01       0x21                      // 8259 port


//
// Buffer Length and Field Definition Info
//
#define BPNA           6                       // Bytes Per Network Address
#define MIN_DATA       52 + BPNA               // 52 bytes data + 6 bytes address
#define TX_BLK_LEN     2                       // Offset to Dest Address in TX Block
#define TX_BLK_ADD     BPNA                    // Length of TX block dest addr field
#define TX_HDR_LEN     TX_BLK_LEN + TX_BLK_ADD // Offset to Data in TX Block
#define RX_TRAIL       02                      // Trailer def for Received Frame Status
#define RX_HDR_LEN     12                      // Offset to Data in Received Frame

//***********************************************************************
//
//       shared memory constant definition
//***********************************************************************
// for rcv buff ring of shr mem
#define STRT_PG        12                       // start at page 12
#define TB_SIZE        2                       // number of tb buff in shr mem
#define TB_PGNO        6                       // number of pages in one tb buff
