/*
    Filter Manager - Management software for the Drawbridge package
    Copyright (C) 1993 David K. Hess, Douglas Lee Schales, David R. Safford

    Please see the file `COPYING' for the complete copyright notice.

    crypt.c - Version 1.0 - 4/21/93
*/
#include <memory.h>

int genMethod(unsigned long *method,unsigned char *key)
{
#ifdef DES
    int DesMethod(unsigned long *method,unsigned char *key);
    return DesMethod(method,key);
#else
    memset(method,0,128);
    return 0;
#endif
}

void encrypt(unsigned char *cipher,unsigned long *method,unsigned char *plain)
{
#ifdef DES
    void DesSmallCoreEncrypt(unsigned char *cipher,
			     unsigned long *method,
			     unsigned char *plain);
    DesSmallCoreEncrypt(cipher,method,plain);
#else
    memcpy(cipher,plain,8);
#endif
}

void decrypt(unsigned char *plain,unsigned long *method,unsigned char *cipher)
{
#ifdef DES
    void DesSmallCoreDecrypt(unsigned char *plain,
			     unsigned long *method,
			     unsigned char *cipher);
    DesSmallCoreDecrypt(plain,method,cipher);
#else
    memcpy(plain,cipher,8);
#endif
}
