/*
 * monMutex.h --
 *
 *      This header file describes the mutex interface used by Monitor.
 *
 * Copyright(C) 1995, 1996 NEC Corporation. All rights reserved.
 * This is a genuine component of Socks5Toolkit(TM).
 *
 * $Header: /insg/project/socks/s5watch/include/monMutex.h,v 1.1.1.1 1996/08/30 02:43:49 miked Exp $
 * $Log: monMutex.h,v $
 * Revision 1.1.1.1  1996/08/30 02:43:49  miked
 * Initial version.
 *
 * Revision 1.3  1996/07/30  21:01:01  miked
 * Yet another copyright notice.
 *
 * Revision 1.2  1996/07/09  23:57:48  miked
 * Added new copyright notice.
 *
 * Revision 1.1.1.1  1996/07/08  15:09:43  miked
 * Initial version for Socks5 API.
 */

#ifndef _H_MONMUTEX
#define _H_MONMUTEX

#include "monPort.h"

/*
 *----------------------------------------------------------------------
 *    P R O C E D U R E S
 *----------------------------------------------------------------------
 */

#ifdef __cplusplus
extern "C" {
#endif

EXTERN int FAR
MonMutexOpen _ANSI_ARGS_((          /* Returns 0 on success; -1 on failure */
    CONST char FAR*    mutexName,   /* IN -- Name of mutex */
    Boolean_t          create,      /* IN -- If TRUE, create mutex */
    S5MonHandle FAR*   handlePtr    /* OUT -- Ptr to opaque handle returned */
));

EXTERN int FAR
MonMutexClose _ANSI_ARGS_((
    S5MonHandle        handle       /* IN -- Opaque handle */
));

EXTERN int FAR
MonMutexRequest _ANSI_ARGS_((       /* Returns 0 on success; -1 on failure */
    S5MonHandle        handle       /* IN -- Opaque handle */
));

EXTERN int FAR
MonMutexRelease _ANSI_ARGS_((       /* Returns 0 on success; -1 on failure */
    S5MonHandle        handle       /* IN -- Opaque handle */
));

EXTERN int FAR
MonMutexQuery _ANSI_ARGS_((         /* Returns N on success; -1 on failure */
    S5MonHandle        handle       /* IN -- Opaque handle */
));

#ifdef __cplusplus
}
#endif

#endif /* _H_MONMUTEX */
