/*
     fc - Filter compiler software for the Drawbridge package
     Copyright (C) 1993 David K. Hess, Douglas Lee Schales, David R. Safford

     Please see the file `COPYING' for the complete copyright notice.
*/
#ifndef __PROTOCOLS_H__
#define __PROTOCOLS_H__

#include "ports.h"

#define SRC_OR_DST 2
typedef enum { FP_SRC, FP_DST } srcdst;

#define IN_OR_OUT 2
typedef enum { FP_IN, FP_OUT } inout;

#define ACC_OR_REJ 2
typedef enum { FP_ACC, FP_REJ } accrej;

struct filt_protocols {
     struct filt_protocols *fp_next;
     int fp_id;
     struct port_range *fp_pr[ACC_OR_REJ][IN_OR_OUT][SRC_OR_DST];
};

#endif
