#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/errno.h>
#include <stdio.h>
#include <netdb.h>
#include <arpa/nameser.h>
#include <resolv.h>
#include <pwd.h>
#include <syslog.h>
#include "socks.h"

#define NAMELEN	128

extern int 			errno;
extern char			*getenv();
static struct sockaddr_in	cursin;
static unsigned long		SocksHost;
u_short socks_port;
u_short	socks_conn_port = 0;

struct sockaddr_in	nsin;
struct passwd		*pw;

extern	char	*porttoserv();
extern	char	*saddrtoname();

/* >>> Anthony Shipman, als@cpsg.com.au */
#ifdef ultrix
#include <strings.h>
#endif

#ifdef hpux

#include <unistd.h>

/*
**	sysconf() is a POSIX function.
*/
size_t
getdtablesize()
{
	long	n;

	n = sysconf(_SC_OPEN_MAX);
	if (n < 0)
	    n = 64;
}

#endif
/* <<< Anthony Shipman, als@cpsg.com.au */

int	check_result(code)
char code;
{
	switch (code) {
		case SOCKS_FAIL:
			errno = ETIMEDOUT;
			return -1;
		case SOCKS_NO_IDENTD:
			errno = ECONNREFUSED;
			fprintf(stderr, "Error: SOCKS proxy server cannot connect to identd on your machine.\n");
			return -1;
		case SOCKS_BAD_ID:
			errno = ECONNREFUSED;
			fprintf(stderr, "Error: user-id does not agree with the one reported by identd on your machine.\n");
			return -1;
		default:
			return 0;
	}
}

/*
	SOCKSinit() must be called once in the application program.
 */

SOCKSinit(Progname)
char *Progname; /* name of the calling program, "rfinger", "rftp", etc. */
{
#ifdef SOCKS_DEFAULT_NS
	static char	defaultNS[] = SOCKS_DEFAULT_NS;
#endif
	static char	defaultSERVER[] = SOCKS_DEFAULT_SERVER;
	char		*cp, *ns = (char *)0;
	struct hostent	*hp;
	struct servent	*sp;
	int		v,uid;

	socks_port = htons(SOCKS_DEF_PORT);

	/* skip the path if included in Progname */
	if( (cp = rindex(Progname, '/')) == NULL)
		cp = Progname;
	else
		cp++;

#ifndef LOG_DAEMON
	(void) openlog(cp, LOG_PID);
#else
	(void) openlog(cp, LOG_PID, LOG_DAEMON);
#endif

	res_init();

	if ((cp = getenv("SOCKS_NS")) != NULL) {
		ns = cp;
#ifdef SOCKS_DEFAULT_NS
	} else {
		ns = defaultNS;
#endif
	}

	if (ns != NULL) {
		_res.nsaddr_list[0].sin_addr.s_addr = inet_addr(ns);
		_res.nscount = 1;
	}

	if ((cp = getenv("SOCKS_SERVER")) == NULL) {
		ns = defaultSERVER;
	} else {
		ns = cp;
	}

	if ((hp = gethostbyname(ns)) == NULL) {
		SocksHost = inet_addr(ns);
	} else {
		bcopy(hp->h_addr_list[0], &SocksHost, hp->h_length);
	}
	fprintf(stderr, "Using SOCKS protocol ver. %d to proxy server %s\n",
		SOCKS_VERSION, ns);

	if ((sp = getservbyname("socks", "tcp")) != NULL)
		socks_port = sp->s_port;

	if ((pw = getpwuid(uid=geteuid())) == NULL) {
		fprintf(stderr, "Unknown user-id %d\n",uid);
		return (1);
	}

	nsin.sin_family = AF_INET;
	nsin.sin_port = socks_port;
	nsin.sin_addr.s_addr = SocksHost;
	
}

Rconnect(sock, sin, size)
int			sock;
struct sockaddr_in	*sin;
int			size;
{
	Socks_t			dst;
	char servname[NAMELEN];
	char dst_name[NAMELEN];

	if ((size != sizeof(struct sockaddr_in))||(sin->sin_family != AF_INET)){
		errno = EAFNOSUPPORT;
		return -1;
	}


	syslog(LOG_NOTICE, "connect() from %s to %s (%s)", pw->pw_name, 
		saddrtoname(&sin->sin_addr, dst_name, sizeof(dst_name)),
		porttoserv(sin->sin_port, servname, sizeof(servname)));
	if (connect(sock, &nsin, sizeof(struct sockaddr_in)) < 0) {
		errno = ETIMEDOUT;
		return -1;
	}

	dst.version = SOCKS_VERSION;
	dst.cmd = SOCKS_CONNECT;
	dst.port = sin->sin_port;
	dst.host = sin->sin_addr.s_addr;

	SendDst(sock, &dst);
	write(sock, pw->pw_name, strlen(pw->pw_name) + 1);

	GetDst(sock, &dst);

	if (dst.cmd == SOCKS_RESULT)
		socks_conn_port = sin->sin_port;
	return (check_result(dst.cmd));
}

/*
**  Set up a bind for a remote host, add fill 'cursin' in with the
**   remote server information.
*/
Rbind(sock, sin, size, remhost)
int			sock;
struct sockaddr_in	*sin;
int			size;
unsigned long		remhost; /* as in sin_addr.s_addr */
{
	Socks_t			dst;
	char dst_name[NAMELEN];

	syslog(LOG_NOTICE, "bind() from %s for %s", pw->pw_name,
		saddrtoname(&remhost, dst_name, sizeof(dst_name)));

	if (connect(sock, &nsin, sizeof(struct sockaddr_in)) < 0)
		return -1;

	dst.version = SOCKS_VERSION;
	dst.cmd     = SOCKS_BIND;
	dst.port    = socks_conn_port;
	dst.host    = remhost;

	SendDst(sock, &dst);
	write(sock, pw->pw_name, strlen(pw->pw_name) + 1);

	GetDst(sock, &dst);

	cursin.sin_family = AF_INET;
	cursin.sin_port = dst.port;
	cursin.sin_addr.s_addr = SocksHost;

	return (check_result(dst.cmd));
}

/*
**  Stub routine since the listen will have alread succeded on the
**   server.
*/
Rlisten(s, n)
int	s, n;
{
	return 0;
}

/*
**  Well we know where we got a connection from.
*/
Rgetsockname(sock, sin, size)
int			sock;
struct sockaddr_in	*sin;
int			*size;
{
	*size = sizeof(struct sockaddr_in);
	*sin = cursin;

	return 0;
}

/*
**  Do an accept, which is really a select for some data on
**    the present socket.
*/
Raccept(sock, sin, size)
int			sock;
struct sockaddr_in	*sin;
int			*size;
{
	fd_set		fds;
	Socks_t		dst;

	FD_ZERO(&fds);
	FD_SET(sock, &fds);

	if (select(getdtablesize(), &fds, NULL, NULL, NULL) > 0)
		if (FD_ISSET(sock, &fds)) {
			GetDst(sock, &dst);
			sin->sin_family = AF_INET;
			sin->sin_port = dst.port;
			sin->sin_addr.s_addr = dst.host;

			return dup(sock);
		}
	return -1;
}

/*===========================================================*/
