/*-
 * Copyright (c) 1996, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */

/*
 *      Author: Kelly Djahandari, Trusted Information Systems, Inc.
 */

/*
	mbone-gw.h

	This file contains information shared between the mbone 
	firewall proxy and the wrapper run on the inside client.

*/

/**  INSIDE_INTERFACE and OUTSIDE_INTERFACE is specific for each firewall **/
/**           This MUST be changed for your Firewall           **/
/*
 Define the OUTSIDE_INTERFACE to be the network address of the outside 
 ethernet interface.  Define the INSIDE_INTERFACE to be the network address
 of the inside ethernet interface.  If you have only one ethernet interface
 define them both to be the firewall ethernet address. 
 */
#define OUTSIDE_INTERFACE "10.1.1.1"   /* addr of nw i/f to outside */
#define INSIDE_INTERFACE  "10.2.2.2"     /* addr of nw i/f to inside  */

/* 
 If using fwtk version 1.3, define this.  If using FWTK Version 2, don't 
 define this.
 */
/* #define FWTK1_3 */


/* 
 The following is the port number used for the TCP connection to 
 the firewall to specify multicast group address and port. 
 This CAN be changed to another port number. 
 */
#define MBONESRV_PORT	8765	/* mbonesrv port on firewall */


/*
 The following is the port used for debugging the mbone proxy.  
 This port can be changed.
 */
#ifdef BINDDEBUG
#define BINDDEBUGPORT   6565
#endif


/*
 The following are the well known address and port for the session 
 directory SDR.  Do not modify them.
 */
#define SDR_ADDR "224.2.127.254"
#define SDR_PORT "9875"


/* 
 The following is the number of seconds between reading the 
 inside_client_file.  Change this as necessary for your system.
 */
#define ALARM_SECONDS 10


/* 
 The following is the maximum number of inside clients participating in the
 same conference.  Change this as necessary for your system.
 */
#define MAXHOSTS 20


/*
 The following are defines for the mcast_info type.  No need to change.
 */
#define MCAST_ADD	1		/* mcast_info.type = Add Membership */
#define MCAST_DROP	2		/* mcast_info.type = Drop Membership */


/*
 The maximum application string length is the maximum length of the filename 
 with path of the real application.  
 Modify this as appropriate for your system.
 */
#define MAXAPPLSTR 	50 		/* Maximum application string length */


/*
 The maximum user string length is the maximum length of the username used 
 for logging and comparing if user has another proxy.
 Modify this as appropriate for your system.
 */
#define MAXUSRSTR 	12 		/* Maximum user string length */


/* 
 The information about the application, group addr, port is sent to the
 firewall using the mcast_info structure.  This structure is used by 
 the proxy and the wrapper.
 */
struct mcast_info {
	unsigned short	type;		/* MCAST_ENABLE or MCAST_DISABLE */
	unsigned long	mcast_group;	/* Multicast group address */
	unsigned short	mcast_port;	/* Multicast destination port */
	unsigned short ttl;		/* TTL value from command line */
	unsigned short rtp;		/* 1 = RTPv1 or 0 used */
					/* 2 = RTPv2 used (even data port) */
					/* 0 = No RTCP control channel needed */
	char mcast_appl[MAXAPPLSTR];	/* Multicast application */
	char mcast_user[MAXUSRSTR];	/* User's login name */
};

/* 
 The following are used when the mbone proxy sends a reply to the client.
 Modify if appropriate.
 */
#define REPLY_SIZE 50
#define GOOD_REPLY "Success"
#define BAD_REPLY "Failure"
#define ERROR_REPLY "Firewall Proxy exited."

struct mcast_reply {
	char reply[REPLY_SIZE];
	unsigned short fw_ucast_port;	/* UDP port to send to firewall */
};



