/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*   (c) 1993.  The Regents of the University of California.  All rights   */
/*   reserved.                                                             */
/*                                                                         */
/*   This work was produced at the University of California, Lawrence      */
/*   Livermore National Laboratory (UC LLNL) under contract no.            */
/*   W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy     */
/*   (DOE) and The Regents of the University of California (University)    */
/*   for the operation of UC LLNL.  Copyright is reserved to the           */
/*   University for purposes of controlled dissemination,                  */
/*   commercialization through formal licensing, or other disposition      */
/*   under terms of Contract 48; DOE policies, regulations and orders;     */
/*   and U.S. statutes.  The rights of the Federal Government are          */
/*   reserved under Contract 48 subject to the restrictions agreed upon    */
/*   by the DOE and University.                                            */
/*                                                                         */
/*                                                                         */
/*                              DISCLAIMER                                 */
/*                                                                         */
/*   This software was prepared as an account of work sponsored by an      */
/*   agency of the United States Government.  Neither the United States    */
/*   Government nor the University of California nor any of their          */
/*   employees, makes any warranty, express or implied, or assumes any     */
/*   liability or responsibility for the accuracy, completeness, or        */
/*   usefulness of any information, apparatus, product, or process         */
/*   disclosed, or represents that its specific commercial products,       */
/*   process, or service by trade name, trademark, manufacturer, or        */
/*   otherwise, does not necessarily constitute or imply its               */
/*   endorsement, recommendation, or favoring by the United States         */
/*   Government or the University of California. The views and opinions    */
/*   of the authors expressed herein do not necessarily state or reflect   */
/*   those of the United States Government or the University of            */
/*   California, and shall not be used for advertising or product          */
/*   endorsement purposes.                                                 */
/*                                                                         */
/*   Permission to use, copy, modify and distribute this software and its  */
/*   documentation for any non-commercial purpose, without fee, is         */
/*   hereby granted, provided that the above copyright notice and this     */
/*   permission notice appear in all copies of the software and            */
/*   supporting documentation, and that all UC LLNL identification in      */
/*   the user interface remain unchanged.  The title to copyright LLNL     */
/*   XFTP shall at all times remain with The Regents of the University     */
/*   of California and users agree to preserve same. Users seeking the     */
/*   right to make derivative works with LLNL XFTP for commercial          */
/*   purposes may obtain a license from the Lawrence Livermore National    */
/*   Laboratory's Technology Transfer Office, P.O. Box 808, L-795,         */
/*   Livermore, CA 94550.                                                  */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/

#include <X11/cursorfont.h>
#include <Xm/Xm.h>
#include <Xm/PanedW.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/PushB.h>
#include <Xm/Form.h>
#include <Xm/Label.h>

static struct {
	Widget w_dialog;
	Widget w_pane;
	Widget w_controlArea;
	Widget w_topic;
	Widget w_text;
	Widget w_actionArea;
	Widget w_closeButton;
} help;

static int modal_dialog_active = False;

extern Widget w_toplev;
extern Display *display;

void cb_help_close();
void cb_set_modal_flag();
Widget vertical_sb();


/*
 * cb_contextual_help - Callback to put main window into "contextual help"
 *                      mode in which the cursor changes to a hand until
 *                      the user clicks on a graphical element in the
 *                      main window he/she wishes to know more about.
 */
void
cb_contextual_help(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	Cursor cursor;
	Widget help_widget;

    /* Clear error flag */
    raise_okflag();

	/* Change cursor and wait for user to select widget */
	cursor = XCreateFontCursor(display, XC_hand2);
	if (help_widget = XmTrackingLocate(w_toplev, cursor, True))
		XtCallCallbacks(help_widget, XmNhelpCallback, (XtPointer)NULL);
	XFreeCursor(display, cursor);
}


/*
 * help_dialog - Pops up a dialog that display the help message specified by
 *               "text" in a scrolled text window.  "topic" identifies the
 *               help topic to the user.
 */
help_dialog(topic, text)
char *topic;
char **text;
{
	int index = 0;
	char *ptr;
	char *buf;
	int len = 0;
	int i;
	XmString string;

    create_help_dialog();

    XtManageChild(help.w_dialog);
    add_dialog_to_list(help.w_dialog);

	/* Make help dialog accessible if a modal dialog is active */
	if (modal_dialog_active)
		XtAddGrab(help.w_dialog, False, False);

	/* Insert help topic */
	string = XmStringCreateSimple(topic);
	XtVaSetValues(help.w_topic, XmNlabelString, string, NULL);
	XmStringFree(string);

	/* Insert help message */
	for (i=0; text[i]; i++)
		len += strlen(text[i])+1;
	len++;
	buf = XtMalloc(len+1);
	for (i=0; text[i]; i++) {
		ptr = text[i];
		while (*ptr)
			buf[index++] = *ptr++;
		if (!isspace(buf[index-1]))
			buf[index++] = ' ';
	}
	buf[index] = '\0';
	XtVaSetValues(help.w_text, XmNvalue, buf, NULL);
	XtFree(buf);
}


/*
 * create_help_dialog - Create dialog go display a scrollable help message.
 */
create_help_dialog()
{
	static int initialized = False;
	Arg args[5];
	XmString string;
	int i;
	Dimension height;

	/* Create dialog only once */
	if (initialized)
		return;
	initialized = True;

	/* Create form dialog*/
	help.w_dialog = XmCreateFormDialog(w_toplev, "help", NULL, 0);

	/* Add callback for the WM_DELETE_WINDOW protocol */
	add_wm_delete_window_cb(help.w_dialog, cb_help_close, NULL);

    /* Kludge to add title bar under OLWM */
    AddOLWMDialogFrame(help.w_dialog);

	/* Create paned window */
	help.w_pane = XtVaCreateWidget(
		"pane",
		xmPanedWindowWidgetClass,
		help.w_dialog,
		XmNsashWidth,			1,
		XmNsashHeight,			1,
		XmNtopAttachment,		XmATTACH_FORM,
		XmNbottomAttachment,	XmATTACH_FORM,
		XmNleftAttachment,		XmATTACH_FORM,
		XmNrightAttachment,		XmATTACH_FORM,
		NULL
	);

	/* Create form widget for control area */
	help.w_controlArea = XtVaCreateWidget(
		"controlArea",
		xmFormWidgetClass,
		help.w_pane,
		XmNmarginWidth,		6,
		XmNmarginHeight,	5,
		NULL
	);

    /* Create label to display topic */
    string = XmStringCreateSimple(" ");
    help.w_topic= XtVaCreateManagedWidget(
        "topic",
        xmLabelWidgetClass,
        help.w_controlArea,
        XmNlabelString,         string,
        XmNtopAttachment,       XmATTACH_FORM,
        XmNtopOffset,           10,
        XmNleftAttachment,      XmATTACH_FORM,
		XmNleftOffset,			13,
        NULL
    );
    XmStringFree(string);

	/* Create scrolled text widget to hold message */
	i = 0;
	XtSetArg(args[i], XmNeditable, False); i++;
	XtSetArg(args[i], XmNeditMode, XmMULTI_LINE_EDIT); i++;
	XtSetArg(args[i], XmNwordWrap, True); i++;
	XtSetArg(args[i], XmNscrollHorizontal, False); i++;
	XtSetArg(args[i], XmNcursorPositionVisible, False); i++;
	help.w_text = XmCreateScrolledText(help.w_controlArea, "text", args, i);
	XtVaSetValues(
		XtParent(help.w_text),
		XmNtopAttachment,		XmATTACH_WIDGET,
		XmNtopWidget,			help.w_topic,
		XmNtopOffset,			10,
		XmNbottomAttachment,	XmATTACH_FORM,
		XmNleftAttachment,		XmATTACH_FORM,
		XmNrightAttachment,		XmATTACH_FORM,
		NULL
	);
	XtManageChild(help.w_text);
	fix_vertical_text_sb_color(help.w_text);
	set_bg_to_sb_trough_color(help.w_text, vertical_sb(XtParent(help.w_text)));

	XtManageChild(help.w_controlArea);

	/* Create form widget for action area */
	help.w_actionArea = XtVaCreateWidget(
		"actionArea",
		xmFormWidgetClass,
		help.w_pane,
		NULL
	);

	/* Create Close button */
	string = XmStringCreateSimple("Close");
	help.w_closeButton = XtVaCreateManagedWidget(
		"closeButton",
		xmPushButtonWidgetClass,
		help.w_actionArea,
		XmNlabelString,						string,
		XmNshowAsDefault,					True,
		XmNdefaultButtonShadowThickness,	1,
		XmNleftAttachment,					XmATTACH_POSITION,
		XmNleftPosition,					40,
		XmNrightAttachment,					XmATTACH_POSITION,
		XmNrightPosition,					60,
		NULL
	);
	XmStringFree(string);
	XtAddCallback(help.w_closeButton, XmNactivateCallback, cb_help_close, NULL);

	XtManageChild(help.w_actionArea);

	/* Freeze height of action area */
	XtVaGetValues(help.w_closeButton, XmNheight, &height, NULL);
	XtVaSetValues(
		help.w_actionArea,
		XmNpaneMaximum,	height,
		XmNpaneMinimum,	height,
		NULL
	);

	XtManageChild(help.w_pane);
}


/*
 * cb_help_close - Callback to close "Help" dialog.
 */
void
cb_help_close(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	XtUnmanageChild(help.w_dialog);
}


/*
 * register_as_modal - Register the shell of the specifed widget as being
 *                     modal.  It is necessary to know when a modal dialog
 *                     is active so that the help dialog can be given the
 *                     correct modality.
 */
register_as_modal(widget)
Widget widget;
{
	Widget shell;

    /* First find the dialog's shell widget */
    for (shell = widget; !XtIsShell(shell); shell = XtParent(shell));

	/* Add callbacks for monitoring use of modal dialog */
	XtAddCallback(shell, XmNpopupCallback, cb_set_modal_flag, (XtPointer)True);
	XtAddCallback(shell, XmNpopdownCallback, cb_set_modal_flag,
		(XtPointer)False);
}


/*
 * cb_set_modal_flag - Callback to register the shell of the indicated widget
 *                     as being modal.  It is necessary to know when a modal
 *                     dialog is active so that the help dialog can be given
 *                     the correct modality.
 */
void
cb_set_modal_flag(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	int flag = (int)client_data;
	
	if (flag == modal_dialog_active)
		fatal_error("Bug in cb_set_modal_flag()\n");

	modal_dialog_active = flag;
}

