/* popres.h
   popup positioning resources. */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#ifndef POPRES_H
#define POPRES_H

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>


#define POPUP_POS_CLASS	"Popup"

#define XgRJustification	"Centering"
typedef enum {
		justify_top_left, justify_center, justify_bottom_right}
	 posCenterType;

#define XgRPositionFrom	"PositionFrom"
typedef enum {
		from_none, from_pointer, from_main, from_screen, from_widget}
	 posFromType;


typedef struct {
	posFromType	positionFrom;
	int		xPosition;
	int		yPosition;
	posCenterType	horizontalJustification;
	posCenterType	verticalJustification;
	Boolean		xPercent;
	Boolean		yPercent;
	} popupPosResources, *popupPosResourcesP;

#define PE_FROM		0
#define PE_X		1
#define PE_Y		2
#define PE_HJUST	3
#define PE_VJUST	4
#define PE_XPERCENT	5
#define PE_YPERCENT	6

#define GOffset(x) XtOffset(popupPosResourcesP, x)

static XtResource popupPosEntry[] = {
    {"positionFrom", "PositionFrom", XgRPositionFrom, sizeof(int),
		GOffset(positionFrom),
		XtRImmediate, (XtPointer) from_none},
    {"xPosition", "Position", XtRInt, sizeof(int),
		GOffset(xPosition),
		XtRImmediate, (XtPointer) 0},
    {"yPosition", "Position", XtRInt, sizeof(int),
		GOffset(yPosition),
		XtRImmediate, (XtPointer) 0},
    {"horizontalJustification", "Justification", XgRJustification, sizeof(int),
		GOffset(horizontalJustification),
		XtRImmediate, (XtPointer) justify_top_left},
    {"verticalJustification", "Justification", XgRJustification, sizeof(int),
		GOffset(verticalJustification),
		XtRImmediate, (XtPointer) justify_top_left},
    {"xPercent", "Percent", XtRBoolean, sizeof(Boolean),
		GOffset(xPercent),
		XtRImmediate, (XtPointer) True},
    {"yPercent", "Percent", XtRBoolean, sizeof(Boolean),
		GOffset(yPercent),
		XtRImmediate, (XtPointer) True},
    };

#undef GOffset

popupPosResources *getPopupPosResources(
#ifdef PROTO
	String,			/* name */
	String,			/* class */
	popupPosResources *	/* defaults */
#endif
);

#endif   /* POPRES_H */
