/* sc_tn3270.c
   gopher item subclass procedures for tn3270 sessions */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#include "conf.h"
#include "globals.h"
#include "gopher.h"
#include "appres.h"
#include "util.h"
#include "status.h"
#include "subst.h"
#include "sc_tn3270.h"
#include "sc_tn3270P.h"




/* giveTn3270Session
   provide an Xterm session running a tn3270 (or x3270) command */

static BOOLEAN
giveTn3270Session(gi)
gopherItemP	gi;
{
	char	*tn3270Cmd;	
	char	message[MESSAGE_STRING_LEN];


	if ((int) strlen ( appResources->tn3270Command ) <= 0 ) {
		showError("Cannot execute the tn3270 command");
		return FALSE;
	}

	if (gi->host == NULL || (int) strlen ( gi->host ) <= 0 ) {
		showError("There is no host to telnet (tn3270) to.");
		return FALSE;
	}

	tn3270Cmd = editCommand(gi, appResources->tn3270Command,
				(char *) NULL, (char *) NULL);

	showStatus("starting a tn3270 session window", STAT_TEMP_MESSAGE,
			gi->host, gi->port);
	
	system(tn3270Cmd);
	free (tn3270Cmd);

	if ((int) strlen(vStringValue(&(gi->selector))) > 0) {
	    sprintf(message,
		"If a login name is required, try:\n\'%s\'",
		vStringValue(&(gi->selector)));
	    showInfo(message);
	}

	return TRUE;
}


/* GITn3270_init
   initialize tn3270 session class - prefix string */

void
GITn3270_init()
{
	GU_makePrefix(prefixTn3270,  appResources->prefixTn3270);
	GU_registerNewType(A_TN3270, &tn3270Subclass);

	return;
}


/* GITn3270_access
   check the accessability of a tn3270 session item */

BOOLEAN
GITn3270_access(gi)
gopherItemP	gi;
{
	BOOLEAN	result;

	if (appResources->allowTn3270) { 
		result = TRUE;
	}else {
		result = FALSE;
	}

	return result;
}


/* GITn3270_process
   process a tn3270 session selection. */

BOOLEAN
GITn3270_process(gi)
gopherItemP	gi;
{
	BOOLEAN	result;

	result = giveTn3270Session(gi);

	return result;
}
