/* status.h
   header file for status.c. */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#ifndef STATUS_H
#define STATUS_H

#include "gopher.h"
#ifdef PROTO
#include <X11/Intrinsic.h>
#endif

typedef enum {STAT_USER, STAT_CONNECT, STAT_ROOT, STAT_DIRECTORY, STAT_ASCII,
	      STAT_BINARY, STAT_PROCESS, STAT_TEMP_MESSAGE} statusType;

static void cancelProc(
#ifdef PROTO
	Widget,		/* w */
	XtPointer,	/* client_data */
	XtPointer	/* call_data */
#endif
);

static void statusCancelAction(
#ifdef PROTO
	Widget,		/* w */
	XEvent *,	/* event */
	String *,	/* parms */
	Cardinal *	/* nparms */
#endif
);

void displayStatusPanel(
#ifdef PROTO
	statusType,	/* thisType */
	char *,		/* text */
	char *,		/* host */
	int		/* port */
#endif
);

BOOLEAN removeStatusPanel(
);

BOOLEAN updateStatusPanel(
#ifdef PROTO
	int,		/* value1 */
	int		/* value2 */
#endif
);

void makeStatusPanel(
#ifdef PROTO
	Widget		/* top */
#endif
);

#endif
