      INTEGER FUNCTION IGAIN4(KOP,DELTA,BETA,FMC,SIGMA,ER,PHI,EL,H,
     1EX,RAIN,EFF,RIN)
C
C     POWER GAIN OF ANTENNA AND GROUND REFLECTION LOSS.
C
      DIMENSION EX(4)
      COMPLEX ACSQ,CSZ1,DELZ,DIF,HRATIO,QPAR,QPER,SQRD,ZM,ZT,ZTR
      COMMON /CON/ D2R,DCL,GAMA,PI,PI2,PIO2,R2D,RO,VOFL
      COMMON /MUT/ CFAC,CT,H2,PROD1,RHI2,R21,X21,Y0,Z0
      COMMON /WATES/ HH(48),XI(48)
      DATA XI/-0.99877100725,-0.99353017227,-0.98412458372,
     1-0.97059159255,-0.95298770316,-0.93138669071,-0.90587913672,-0.876
     257202027,-0.84358826162,-0.80706620403,-0.76715903252,-0.724034130
     392,-0.67787237963,-0.62886739678,-0.57722472608,-0.52316097472,-0.
     446690290475,-0.40868648199,-0.34875588629,-0.28736248736,-0.224763
     579039,-0.16122235607,-0.097004699209,-0.032380170963,0.03238017096
     63,0.097004699209,0.16122235607,0.22476379039,0.28736248736,0.34875
     7588629,0.40868648199,0.46690290475,0.52316097472,0.57722472608,0.6
     82886739678,0.67787237963,0.72403413092,0.76715903252,0.80706620403
     9,0.84358826162,0.87657202027,0.90587913672,0.93138669071,0.9529877
     $0316,0.97059159255,0.98412458372,0.99353017227,0.99877100725/
      DATA HH/0.0031533460523,0.007327553901,0.011477234579
     1,0.015579315723,0.019616160457,0.023570760839,0.027426509708,0.031
     2167227833,0.034777222565,0.038241351066,0.041545082943,0.044674560
     3857,0.047616658492,0.050359035554,0.052890189485,0.055199503700,0.
     4057277292100,0.059114839698,0.060704439166,0.062039423160,0.063114
     5192286,0.063924238585,0.064466164436,0.064737696813,0.064737696813
     6,0.064466164436,0.063924238585,0.063114192286,0.062039423160,0.060
     7704439166,0.059114839698,0.057277292100,0.055199503700,0.052890189
     8485,0.050359035554,0.047616658492,0.044674560857,0.041545082943,0.
     9038241351066,0.034777222565,0.031167227833,0.027426509708,0.023570
     $760839,0.019616160457,0.015579315723,0.011477234579,0.007327553901
     $3,0.0031533460523/
C
      RATIO=1000.
      IF (EX(1).GT.0) RATIO=EX(1)
      WAVE=(VOFL*.001)/FMC
      Q=SIN(DELTA)
      T=COS(DELTA)
      DIF=CMPLX(ER,-60.*SIGMA*WAVE)
      ACSQ=CSQRT(DIF-T*T)
      QPER=(DIF*Q-ACSQ)/(DIF*Q+ACSQ)
      CV=CABS(QPER)
      PSIV=CANG(QPER)
      QPAR=(Q-ACSQ)/(Q+ACSQ)
      CH=CABS(QPAR)
      PSIH=CANG(QPAR)
      EL1=EL/WAVE
      IF (EL.LT.0.) EL1=ABS(EL)
      FAC=PI*EL1
      FAC2=PI2*EL1
      FAC4=2.*FAC2
      X=H/WAVE
      IF (H.LT.0.) X=ABS(H)
      HWAVE=PI2*X
      HQWAVE=2.*HWAVE*Q
      RHI=PHI*D2R
      SR=SIN(RHI)
      CR=COS(RHI)
      RETA=BETA*D2R
      SB=SIN(RETA)
      CB=COS(RETA)
      GOTO (87,9,87,87,27,87,87,87,87,87,87,87,87,75,87),IABS(KOP)
C
C     VERTICAL ANTENNA, KOP=2
C
9     IF (ABS(DELTA-PIO2).LT..00001) GOTO 83
      SFAC2=SIN(FAC2)
      CFAC2=COS(FAC2)
      HQ=FAC2*Q
      A=COS(HQ)-CFAC2
      AS=SIN(HQ)-Q*SFAC2
      FLOG=ALOG(FAC2)
      C2KEL=2.*CFAC2*CFAC2-1.
      S2KEL=2.*CFAC2*SFAC2
      ZT=CSZ1(4.*FAC2)
      RZERO=.5*(C2KEL*(REAL(ZT)-FLOG-1.3862943612-GAMA)-S2KEL*AIMAG(ZT))
      ZT=CSZ1(FAC4)
      RZERO=30.*(RZERO+(1.+C2KEL)*(REAL(-ZT)+FLOG+.6931471806+GAMA)+S
     12KEL*AIMAG(ZT))
      IF (EX(2).GT.0.) GOTO 10
      RIN=RZERO
      EFF=0.
      IF (EL1.GE..35) GOTO 6
      EFF=-((((6416.702*EL1-6091.33)*EL1+2179.89)*EL1-364.817)*EL1+25.64
     16)
6     W3=COS(PSIV-HQWAVE)
      W4=SIN(PSIV-HQWAVE)
      RAIN=30.*((A*(1.+CV*W3)+AS*CV*W4)**2+(A*CV*W4+AS*(1.-CV*W3))**2
     1)/(RIN*RIN*T*T)
      GOTO 82
C
C     VERTICAL ANTENNA WITH A RADIAL CONDUCTOR GROUND SYSTEM.
C
10    IF (KOP.LT.0) GOTO 12
      AA=PHI/WAVE
      IF (PHI.LT.0.) AA=ABS(PHI)
      CAYA=PI2*AA
      ETA=CSQRT(CMPLX(0.,8.*PI*PI*FMC*0.1)/CMPLX(SIGMA,FMC*ER*.001/18.))
      ALPHA=CANG(ETA)+PIO2
      RZ=SQRT(AA*AA+EL1*EL1)
      R1=AA+RZ
      ZTR=CMPLX(0.,PIO2)
      DELZ=(CSZ1(2.*PI2*(RZ+EL1))+ZTR)*CMPLX(C2KEL,S2KEL)
      DELZ=DELZ+(CSZ1(2.*PI2*(RZ-EL1))+ZTR)*CMPLX(C2KEL,-S2KEL)
      DELZ=DELZ+(CSZ1(2.*CAYA)+ZTR)*2.*CFAC2*CFAC2
      DELZ=DELZ+(CSZ1(PI2*R1)+ZTR)*4.*CFAC2
      DELZ=DELZ-(CSZ1(PI2*(R1-EL1))+ZTR)*4.*CFAC2*CMPLX(CFAC2,-SFAC2)
      DELZ=DELZ-(CSZ1(PI2*(R1+EL1))+ZTR)*4.*CFAC2*CMPLX(CFAC2,SFAC2)
      DELR1=REAL(DELZ*ETA/(2.*PI2))
      ETA1=REAL(ETA)
      ETA2=AIMAG(ETA)
      DELR2=0.
      DP=AA/2.
      QU=240.*PI*PI/EX(2)
      CW=RATIO*WAVE/2.
      DO 11 J=1,48
      P=DP*(XI(J)+1.)
      RQ=PI2*SQRT(P*P+EL1*EL1)
      PLOG=ALOG(P*CW)
      QQ=QU*P*PLOG
      EQ=ETA2+QQ
      TA=ATAN2(EQ,ETA1)
11    DELR2=DELR2+(COS(ALPHA-TA-2.*RQ)+CFAC2*CFAC2*COS(ALPHA-TA-4.*PI*
     1P)-2.*CFAC2*COS(ALPHA-TA-PI2*P-RQ))/SQRT(ETA1*ETA1+EQ*EQ)*PLOG*D
     2P*HH(J)
      DELR2=-120.*PI*CABS(ETA)/EX(2)*DELR2
      RIN=RZERO+DELR1+DELR2
      EFF=0.
      IF (EL1.GE.0.35) GOTO 12
      EFF=-((((6416.702*EL1-6091.33)*EL1+2179.89)*EL1-364.817)*EL1+25.64
     16)
12    HRATIO=CMPLX(0.,0.)
      DO 13 J=1,48
      XX=CAYA/2.*(XI(J)+1.)
      TD=SQRT(XX*XX+FAC2*FAC2)
      TS=ONEJ(XX*T)
13    HRATIO=HRATIO+HH(J)*TS*CMPLX(COS(TD)-COS(XX)*CFAC2,-SIN(TD)+SIN
     1(XX)*CFAC2)
      HRATIO=1.-HRATIO*CAYA*ETA*T/(120.*PI2*A)
      IF (ABS(REAL(HRATIO)).GT.2..OR.ABS(AIMAG(HRATIO)).GT.1.) GOTO 8
     13
      BP=ATAN2(AS,A)
      CAYVH=1.+CV*CV+2.*CV*COS(PSIV-2.*BP)
      TB=A/(T*COS(BP))
      RAIN=30./RIN*TB*TB*CAYVH*HRATIO*CONJG(HRATIO)
      GOTO 82
C
C     VERTICAL DIPOLE ANTENNA, KOP=5
C
27    TIP=0.5*EL1
      IF (TIP.GT.X) GOTO 87
      CFAC=COS(FAC)
      SPHI2=1.-Q*Q
      IF (SPHI2.EQ.0.) GOTO 83
      GI=(COS(FAC*Q)-CFAC)/SPHI2
      W3=COS(PSIV-HQWAVE)
      ETHTA1=-T*GI*(1.+CV*W3)
      W4=SIN(PSIV-HQWAVE)
      ETHTA2=-T*GI*CV*W4
      IF (KOP.LT.0) GOTO 28
      H2=.5*EL1
      Y0=SQRT(2.)/RATIO*EL1
      Z0=0.
      RHI2=0.
      CALL MUTUAL
      R11=R21
      Y0=SQRT(2.)/RATIO*EL1
      Z0=2.*X
      RHI2=PI
      CALL MUTUAL
      ZM=CMPLX(R21,X21)
      SQRD=CSQRT(DIF)
      CXC=REAL(-ZM*(DIF-SQRD)/(DIF+SQRD))
      RIN=R11+CXC
      EFF=0.
28    RAIN=120.*(ETHTA1*ETHTA1+ETHTA2*ETHTA2)/RIN
      GOTO 82
C
C     ARBITARY TILTED DIPOLE ANTENNA, KOP=14
C
75    CFAC=COS(FAC)
      W1=COS(PSIH-HQWAVE)
      W2=SIN(PSIH-HQWAVE)
      W3=COS(PSIV-HQWAVE)
      W4=SIN(PSIV-HQWAVE)
      TIP=0.5*EL1*SR
      IF (TIP.GT.X) GOTO 87
      CSB=CR*SB
      CPHI=Q*SR+T*CSB
      SPHI2=1.-CPHI*CPHI
      CPHIP=-Q*SR+T*CSB
      SPHIP2=1.-CPHIP*CPHIP
      IF (SPHI2.EQ.0.) GOTO 76
      GI=(COS(FAC*CPHI)-CFAC)/SPHI2
      ETHTA1=(CSB*Q-SR*T)*GI
      EPHI1=CR*CB*GI
      GOTO 77
C
76    ETHTA1=0.
      EPHI1=0.
77    IF (SPHIP2.EQ.0.) GOTO 78
      DI=(COS(FAC*CPHIP)-CFAC)/SPHIP2
      ETHTA1=ETHTA1-((CSB*Q+SR*T)*DI*CV*W3)
      EPHI1=EPHI1+DI*CH*W1*CR*CB
      ETHTA2=-(CSB*Q+SR*T)*DI*CV*W4
      EPHI2=CR*CB*DI*CH*W2
      GOTO 79
C
78    ETHTA2=0.
      EPHI2=0.
79    IF (KOP.LT.0) GOTO 80
      H2=.5*EL1
      Y0=SQRT(2.)/RATIO*EL1
      Z0=0.
      RHI2=0.
      CALL MUTUAL
      R11=R21
      Y0=2.*X*CR
      Z0=2.*X*SR
      RHI2=2.*RHI
      CALL MUTUAL
      ZM=CMPLX(R21,X21)
      IF (RHI2.GT.PIO2) ZM=-ZM
      SQRD=CSQRT(DIF)
      CXC=REAL(ZM*(((1.-SQRD)/(1.+SQRD))*CR+CMPLX(0.,1.)*((DIF-SQRD)
     1/(DIF+SQRD))*SR)*CMPLX(CR,-SR))
      RIN=R11+CXC
      EFF=0.
80    RAIN=120.*(ETHTA1*ETHTA1+ETHTA2*ETHTA2+EPHI1*EPHI1+EPHI2*EPHI
     12)/RIN
C
C     NORMAL EXIT
C
82    IGAIN4=1
      RETURN
C
83    IGAIN4=2
      RETURN
C
C     ERROR EXIT
C
87    IGAIN4=3
      RETURN
C
      END
                                SUBROUTINE MUTUAL
      COMMON /CON/ D2R,DCL,GAMA,PI,PI2,PIO2,R2D,RO,VOFL
      COMMON /MUT/ CFAC,CT,H2,PROD1,RHI2,R21,X21,Y0,Z0
      EXTERNAL REACT,RESIST
      XCON=-0.0001*VOFL
      CT=COS(RHI2)
      PROD1=-SIN(RHI2)
      X21=XCON*AGAUSS(REACT,S,H2)
1     R21=XCON*AGAUSS(RESIST,S,H2)
      RETURN
      END
                                                                                                                                                                                          FUNCTION AGAUSS (XFUNCT,S,H2)
      COMMON /WATES/ HH(48),XI(48)
      DATA  TESTD/5.0E-08/
      EXTERNAL XFUNCT
      AGAUSS=0.
      IF (H2.EQ.0.) GOTO 6
      CHECK=1000.
      ANS=0.
      M=1
1     AGAUSS=0.
      DO 3 L=1,M
      FL=L
      FM=M
      BOLIM=-H2+2.0*H2*(FL-1.0)/FM
      UPLIM=-H2+2.0*H2*FL/FM
      SUM=0.
      DO 2 I=1,48
      S=0.5*((UPLIM-BOLIM)*XI(I)+UPLIM+BOLIM)
2     SUM=SUM+HH(I)*XFUNCT(S)
      SUM=0.5*(UPLIM-BOLIM)*SUM
3     AGAUSS=AGAUSS+SUM
      TEST=ABS((AGAUSS-ANS)/AGAUSS)
      IF (TEST.LE.TESTD) GOTO 6
4     IF (M.GE.10) GOTO 5
      CHECK=TEST-TESTD
      ANS=AGAUSS
      M=M+1
      GOTO 1
C
5     IF (TEST.GT.CHECK) AGAUSS=ANS
6     RETURN
      END
                                                                                                                                                                                                                                                                                                    FUNCTION ONEJ (X)
      COMMON /CON/ D2R,DCL,GAMA,PI,PI2,PIO2,R2D,RO,VOFL
      R135=PI*3.0/4.0
      IF (X.GT.4.0) GO TO 1
      T=X/4.0
      Y=T**2
      ONEJ=(((((((-1.289769E-4*Y+2.2069155E-3)*Y-2.36616773E-2)*Y+0.1777
     1582922)*Y-0.8888839649)*Y+2.666666054)*Y-3.999999971)*Y+2.0)*T
      GO TO 2
1     T=4.0/X
      Y=T**2
      PSUM=(((((4.2414E-6*Y-2.0092E-5)*Y+5.80759E-5)*Y-2.23203E-4)*Y+2.9
     1218256E-3)*Y+0.3989422819)*2.50662827
      QSUM=(((((-3.6594E-6*Y+1.622E-5)*Y-3.98708E-5)*Y+1.064741E-4)*Y-6.
     13904E-4)*Y+3.74008364E-2)*2.50662827*T
      TX=COS(X-R135)
      TY=SIN(X-R135)
      TS=SQRT(2.0/(PI*X))
      ONEJ=TS*(PSUM*TX-QSUM*TY)
2     RETURN
      END
                                                                                                                                                                                                                                                                                                                       FUNCTION REACT (S)
      COMMON /CON/ D2R,DCL,GAMA,PI,PI2,PIO2,R2D,RO,VOFL
      COMMON /MUT/ CFAC,CT,H2,PROD1,RHI2,R21,X21,Y0,Z0
      SZ=S*CT
      SY=S*PROD1
      TERM=Y0+SY
      RHO2=TERM**2
      CA=Z0+SZ
      CA1=CA+H2
      CA2=CA-H2
      R=SQRT(RHO2+CA**2)
      R1=SQRT(RHO2+CA1**2)
      R2=SQRT(RHO2+CA2**2)
      CR=COS(PI2*R)/R
      FACX=2.0*CFAC*CR
      CR1=COS(PI2*R1)/R1
      CR2=COS(PI2*R2)/R2
      REACT=(((CR1*CA1+CR2*CA2-FACX*CA)*SY)/TERM+(FACX-CR1-CR2)*SZ)*SIN(
     1PI2*(H2-ABS(S)))/S
      RETURN
      END
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                FUNCTION RESIST (S)
      COMMON /CON/ D2R,DCL,GAMA,PI,PI2,PIO2,R2D,RO,VOFL
      COMMON /MUT/ CFAC,CT,H2,PROD1,RHI2,R21,X21,Y0,Z0
      SZ=S*CT
      SY=S*PROD1
      TERM=Y0+SY
      RHO2=TERM**2
      CA=Z0+SZ
      CA1=CA+H2
      CA2=CA-H2
      R=SQRT(RHO2+CA**2)
      R1=SQRT(RHO2+CA1**2)
      R2=SQRT(RHO2+CA2**2)
      SR=SIN(PI2*R)/R
      FACR=2.0*CFAC*SR
      SR1=SIN(PI2*R1)/R1
      SR2=SIN(PI2*R2)/R2
      RESIST=(((SR1*CA1+SR2*CA2-FACR*CA)*SY)/TERM+(FACR-SR1-SR2)*SZ)*SIN
     1(PI2*(H2-ABS(S)))/S
      RETURN
      END
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        