/* 
This software is being provided to you, the LICENSEE, by the
Massachusetts Institute of Technology (M.I.T.) under the following
license.  By obtaining, using and/or copying this software, you agree
that you have read, understood, and will comply with these terms and
conditions:

Permission to use, copy, modify and distribute, including the right to
grant others the right to distribute at any tier, this software and
its documentation for any purpose and without fee or royalty is hereby
granted, provided that you agree to comply with the following
copyright notice and statements, including the disclaimer, and that
the same appear on ALL copies of the software and documentation,
including modifications that you make for internal use or for
distribution:

Copyright 1992,1993,1994 by the Massachusetts Institute of Technology.
                    All rights reserved.

THIS SOFTWARE IS PROVIDED "AS IS", AND M.I.T. MAKES NO REPRESENTATIONS
OR WARRANTIES, EXPRESS OR IMPLIED.  By way of example, but not
limitation, M.I.T. MAKES NO REPRESENTATIONS OR WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE
OF THE LICENSED SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD
PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.

The name of the Massachusetts Institute of Technology or M.I.T. may
NOT be used in advertising or publicity pertaining to distribution of
the software.  Title to copyright in this software and any associated
documentation shall at all times remain with M.I.T., and USER agrees
to preserve same.
*/
/*
 * Gregory D. Troxel
 */

/* program is written as if these values were manifest constants */

typedef struct config_s
{
  /* SIMULATION control parameters */
  ntp_t sim_begin;		/* start at ? */
  #define SIM_BEGIN config.sim_begin
  ntp_t sim_incr;		/* advance by ? */
  #define SIM_INCR config.sim_incr

  /* PREDICTION control parameters */
  int extent_min;		/* examine back at least ? */
  #define EXTENT_MIN config.extent_min
  int extent_max;		/* and at most ? */
  #define EXTENT_MAX config.extent_max
  double config_systematic; /* update sys offset estimate? */
  #define CONFIG_SYSTEMATIC config.config_systematic

  /* number of times in a row we have to get same time to move earlier */
  int hourly_earlier_count;
  #define HOURLY_EARLIER_COUNT config.hourly_earlier_count

  /* minimum time span for integrated data to use integrated result */
  ntp_t integrated_min_time;
  #define INTEGRATED_MIN_TIME config.integrated_min_time

  /* OUTPUT control */
  int output_min_points;	/* min points to write data */
  #define OUTPUT_MIN_POINTS config.output_min_points
  int output_shownextphase;	/* print phase of this fitseg at next begin */
  #define OUTPUT_SHOWNEXTPHASE config.output_shownextphase

  /* ANALYSIS control */
  double freq_bogus;		/* max frequency estimate */
  #define FREQ_BOGUS config.freq_bogus
  double aging_bogus;		/* max aging rate estimate */
  #define AGING_BOGUS config.aging_bogus
  int aging_time_min;		/* shortest segment we allow aging */
  #define AGING_TIME_MIN config.aging_time_min

  int config_trim;		/* use trim? */
  #define CONFIG_TRIM config.config_trim
  int config_delay;		/* use low delay selection? */
  #define CONFIG_DELAY config.config_delay
  int config_sdev_adj;		/* adjust weight by sdev? */
  #define CONFIG_SDEV_ADJ config.config_sdev_adj
  int config_autocorrelation;	/* compute autocorrelation? */
  #define CONFIG_AUTOCORRELATION config.config_autocorrelation

  /* parameters for trimming */
  int trim_points;		/* punt runs with < ? points */
  #define TRIM_POINTS config.trim_points
  ntp_t trim_time;		/* punt runs with < ? time */
  #define TRIM_TIME config.trim_time

  /* parameters for delay computation */
  double delay_base;		/* order statistics for delay computation */
  #define DELAY_BASE config.delay_base
  double delay_add;
  #define DELAY_ADD config.delay_add
  double delay_mul;
  #define DELAY_MUL config.delay_mul
  ntp_t delay_decay;		/* age low-delay samples over ? */
  #define DELAY_DECAY config.delay_decay

  double highdev_ratio;		/* allowable sdev relative to median */
  #define HIGHDEV_RATIO config.highdev_ratio

  double OUTLIER_SELFS_RATIO;	/* outlier #sdev wrt short segs */
  #define OUTLIER_SELFS_RATIO config.OUTLIER_SELFS_RATIO

  double OUTLIER_SELFL_RATIO;	/* outlier #sdev wrt long segs */
  #define OUTLIER_SELFL_RATIO config.OUTLIER_SELFL_RATIO

  /* ratio of max combinable segment to median */
  double config_combine_ratio_prediction;
  #define CONFIG_COMBINE_RATIO_PREDICTION config.config_combine_ratio_prediction
  double config_combine_ratio_analysis;
  #define CONFIG_COMBINE_RATIO_ANALYSIS config.config_combine_ratio_analysis

  int config_optimize_piecewise; /* optimize joining? */
  #define CONFIG_OPTIMIZE_PIECEWISE config.config_optimize_piecewise

  int break_points_min;		/* segment at least ? points */
  #define BREAK_POINTS_MIN config.break_points_min
  int break_points_max;		/* segment at most ? points */
  #define BREAK_POINTS_MAX config.break_points_max
  ntp_t break_time_max;		/* segment at most ? time */
  #define BREAK_TIME_MAX config.break_time_max

  /* to be included in integrated, clock must ... */
  int hourly_integrated_limit_n; /* have > ? valid points */
  #define HOURLY_INTEGRATED_LIMIT_N config.hourly_integrated_limit_n
  ntp_t hourly_integrated_limit_te; /* cover ? time */
  #define HOURLY_INTEGRATED_LIMIT_TE config.hourly_integrated_limit_te
  ntp_t hourly_integrated_limit_tr; /* have valid point within ? hours */
  #define HOURLY_INTEGRATED_LIMIT_TR config.hourly_integrated_limit_tr
} config_t;
extern config_t config;

void config_init();

void config_readfile(FILE *fp, FILE *flog, FILE *ferror);
