/* 
This software is being provided to you, the LICENSEE, by the
Massachusetts Institute of Technology (M.I.T.) under the following
license.  By obtaining, using and/or copying this software, you agree
that you have read, understood, and will comply with these terms and
conditions:

Permission to use, copy, modify and distribute, including the right to
grant others the right to distribute at any tier, this software and
its documentation for any purpose and without fee or royalty is hereby
granted, provided that you agree to comply with the following
copyright notice and statements, including the disclaimer, and that
the same appear on ALL copies of the software and documentation,
including modifications that you make for internal use or for
distribution:

Copyright 1992,1993,1994 by the Massachusetts Institute of Technology.
                    All rights reserved.

THIS SOFTWARE IS PROVIDED "AS IS", AND M.I.T. MAKES NO REPRESENTATIONS
OR WARRANTIES, EXPRESS OR IMPLIED.  By way of example, but not
limitation, M.I.T. MAKES NO REPRESENTATIONS OR WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE
OF THE LICENSED SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD
PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.

The name of the Massachusetts Institute of Technology or M.I.T. may
NOT be used in advertising or publicity pertaining to distribution of
the software.  Title to copyright in this software and any associated
documentation shall at all times remain with M.I.T., and USER agrees
to preserve same.
*/
/*
 * Gregory D. Troxel
 */

#include "pd.h"

void
ds_init(dataset_t *ds)
{
  if ( ds->dptr != NULL )
    panic("ds_init already initialized");

  ds->n = 0;
  ds->dptr = NULL;
  ds->lim = 0;

  ds->weight = 1.0;
}

void
ds_free(dataset_t *ds)
{
  if ( ds->dptr )
    {
      free(ds->dptr);
      ds->dptr = NULL;
      ds->lim = ds->n = 0;
    }
}

#define DATA_INC	256

void ds_grow(dataset_t *ds, int n)
{
  void *ptr;

  while ( ds->lim < n )
    {
      ds->lim += DATA_INC;

      if ( ds->dptr == NULL )
	ptr = malloc(ds->lim * sizeof(datapoint_t));
      else
	ptr = realloc(ds->dptr, ds->lim * sizeof(datapoint_t));
      
      if ( ptr == NULL )
	panic("ds_grow: realloc returned NULL ptr");
      ds->dptr = (datapoint_t *) ptr;
    }
}

/* clear valid points of all dp in ds, in preparation of
   another run through dat */
void
ds_reinit(dataset_t *ds)
{
  int i;
  for ( i = 0; i < ds->n; i++ )
    ds->dptr[i].valid = VALID_OK;
}

