/* 
This software is being provided to you, the LICENSEE, by the
Massachusetts Institute of Technology (M.I.T.) under the following
license.  By obtaining, using and/or copying this software, you agree
that you have read, understood, and will comply with these terms and
conditions:

Permission to use, copy, modify and distribute, including the right to
grant others the right to distribute at any tier, this software and
its documentation for any purpose and without fee or royalty is hereby
granted, provided that you agree to comply with the following
copyright notice and statements, including the disclaimer, and that
the same appear on ALL copies of the software and documentation,
including modifications that you make for internal use or for
distribution:

Copyright 1992,1993,1994 by the Massachusetts Institute of Technology.
                    All rights reserved.

THIS SOFTWARE IS PROVIDED "AS IS", AND M.I.T. MAKES NO REPRESENTATIONS
OR WARRANTIES, EXPRESS OR IMPLIED.  By way of example, but not
limitation, M.I.T. MAKES NO REPRESENTATIONS OR WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE
OF THE LICENSED SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD
PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.

The name of the Massachusetts Institute of Technology or M.I.T. may
NOT be used in advertising or publicity pertaining to distribution of
the software.  Title to copyright in this software and any associated
documentation shall at all times remain with M.I.T., and USER agrees
to preserve same.
*/
/*
 * Gregory D. Troxel
 */

#include "pd.h"

/*
 * examine points covered by fs, but not its children
 * mark invalid (with valid_code)
 * return number of points invalidated
 */
int
Invalidate_all(FILE *finfo, fitseg_t *fs, int valid_code)
{
  int i;
  dataset_t *ds;
  datapoint_t *dp;
  int begin, end;
  int ninvalid = 0;

  ds = fs->sp->ds;
  begin = segment_begin(fs->sp);
  end = segment_end(fs->sp, 1);

  fprintf(finfo, "invalidating segment %d-%d (time %u %u)\n",
	  begin, end, Trun2unix(begin), Trun2unix(end));

  /* iterate over points */
  for ( i = begin; i <= end ; i++ )
    {
      dp = &ds->dptr[i];

      if ( dp->valid != VALID_OK )	/* don't bother if already invalid */
	continue;

      dp->valid = valid_code;
      ninvalid++;
    }
  return ninvalid;
}

/*
 * examine points covered by fs, but not its children
 * mark invalid (with valid_code) those more than tolerance
 * greater than sdev
 * return number of points invalidated
 */
int
Invalidate_self(FILE *finfo, fitseg_t *fs, double tolerance, int valid_code)
{
  int i;
  dataset_t *ds;
  datapoint_t *dp;
  int begin, end;
  double errval;
  int nok, ninvalidated;

  nok = ninvalidated = 0;

  ds = fs->sp->ds;
  begin = segment_begin(fs->sp);
  end = segment_end(fs->sp, 1);

  /* iterate over points */
  for ( i = begin; i <= end ; i++ )
    {
      dp = &ds->dptr[i];

      if ( dp->valid != VALID_OK )	/* don't bother if already invalid */
	continue;

      errval = fit_param_residpoint(dp, fs->fp);
      if ( fabs(errval) > tolerance * fs->fq->sdev )
	{
	  ninvalidated++;
	  dp->valid = valid_code;
	  if ( flags.debug > 1 )
	    fprintf(finfo, "point %d invalidated err=%f\n", i, errval);
	}
      else
	nok++;
    }

  if ( flags.debug > 0 && ninvalidated > 0 )
      fprintf(finfo, "OK %d INVALIDATED %d\n", nok, ninvalidated);

  return ninvalidated;
}
