'\"
'\" Copyright (c) 1998-2000 by Scriptics Corporation.
'\" All rights reserved.
'\" 
'\" RCS: @(#) $Id: profiler.n,v 1.3 2000/03/09 00:07:41 ericm Exp $
'\" 
.so man.macros
.TH profiler n 0.1 profiler "Tcl Profiler"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
profiler \- Tcl source code profiler
.SH SYNOPSIS
\fBpackage require profiler ?0.1?\fR
.sp
\fB::profiler::init\fR
.sp
\fB::profiler::dump\fR ?\fIpattern\fR?
.sp
\fB::profiler::print\fR ?\fIpattern\fR?
.sp
\fB::profiler::reset\fR ?\fIpattern\fR?
.sp
\fB::profiler::sortFunctions\fR \fIkey\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fBprofiler\fR package provides a simple Tcl source code
profiler.  It is a function-level profiler; that is, it collects only
function-level information, not the more detailed line-level
information.  It operates by redefining the Tcl \fBproc\fR command.
Profiling is initiated via the \fB::profiler::init\fR command.
.SH COMMANDS
.TP
\fB::profiler::init\fR
Initiate profiling.  All procedures created after this command is
called will be profiled.  To profile an entire application, this
command must be called before any other commands.
.TP
\fB::profiler::dump\fR \fIpattern\fR
Dump profiling information for the all functions matching
\fIpattern\fR.  If no pattern is specified, information for all
functions will be returned.  The result is a list of key/value pairs
that maps function names to information about that function.  The
information about each function is in turn a list of key/value pairs.
The keys used and their values are: 
.RS
.TP
\fBtotalCalls\fR
The total number of times \fIfunctionName\fR was called.
.TP
\fBcallerDist\fB
A list of key/value pairs mapping each calling function that called
\fIfunctionName\fR to the number of times it called \fIfunctionName\fR.
.TP
\fBcompileTime\fR
The runtime, in clock clicks, of \fIfunctionName\fR the first time
that it was called.
.TP
\fBtotalRuntime\fR
The sum of the runtimes of all calls of \fIfunctionName\fR.
.TP
\fBaverageRuntime\fR
Average runtime of \fIfunctionName\fR.
.TP
\fBdescendantTime\fR
Sum of the time spent in descendants of \fIfunctionName\fR.
.TP
\fBaverageDescendantTime\fR
Average time spent in descendants of \fIfunctionName\fR. 
.RE
.TP
\fB::profiler::print\fR ?\fIpattern\fR?
Print profiling information for all functions matching \fIpattern\fR.
If no pattern is specified, information about all functions will be displayed.
The return result is a human readable display of the profiling
information.
.TP
\fB::profiler::reset\fR ?\fIpattern\fR?
Reset profiling information for all functions matching \fIpattern\fR.
If no pattern is specified, information will be reset for all functions.
.TP
\fB::profiler::sortFunctions\fR \fIkey\fR
Return a list of functions sorted by a particular profiling
statistic.  Supported values for \fIkey\fR are: \fBcalls\fR,
\fBexclusiveTime\fR, \fBcompileTime\fR, \fBnonCompileTime\fR,
\fBtotalRuntime\fR, \fBavgExclusiveTime\fR, and \fBavgRuntime\fR.  The
return result is a list of lists, where each sublist consists of a
function name and the value of \fIkey\fR for that function.
.SH KEYWORDS
profile, performance, speed
