/*
 This file is part of GNUnet.
 (C) 2011, 2012 Christian Grothoff (and other contributing authors)

 GNUnet is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published
 by the Free Software Foundation; either version 3, or (at your
 option) any later version.

 GNUnet is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with GNUnet; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 */

package org.gnunet.util;

import org.gnunet.construct.Message;
import org.gnunet.construct.UInt64;



/**
 * Representation of an AbsoluteTime object, to be sent over the network.
 */
public class AbsoluteTimeMessage implements Message {
    @UInt64
    public long value;

    public AbsoluteTimeMessage() {

    }


    public AbsoluteTimeMessage(final AbsoluteTime t) {
        if (t.equals(AbsoluteTime.FOREVER)) {
            this.value = -1;
        } else {
            this.value = t.getMicroseconds();
        }
    }
}
