/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gr_firdes.h>
#include <atsc_root_raised_cosine.h>
#include <atsc_consts.h>
#include <vector>
#include <stdio.h>

using std::vector;


int main (int argc, char **argv)
{
  double symbol_rate = ATSC_SYMBOL_RATE/2;	// 1/2 as wide because we're designing lp filter
  double sampling_rate = 2 * ATSC_SYMBOL_RATE;

#if 0
  atsc_root_raised_cosine	rrc1;
  vector<float> rrc1_taps = rrc1.taps (sampling_rate);
#endif

  int	ntaps = 279;
  vector<float> rrc2_taps =
    gr_firdes::root_raised_cosine (1.0, sampling_rate, symbol_rate, .1150, ntaps);

  for (int i = 0; i < ntaps; i++){
    printf ("%16.10e\n", rrc2_taps[i]);
  }

  return 0;
}
