#include "Channel.h"
#include <qwt_plot.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qlabel.h>

Channel::Channel(const char *labelText, QWidget *p, const char *name) :
  QWidget(p, name)
{
  QBoxLayout *layout = new QHBoxLayout(this);
  layout->addSpacing(10);
  
  label = new QLabel(labelText, this);
  label->setAlignment(AlignCenter);
  label->setFixedSize(100, 60);
  layout->addWidget(label);

  plot = new QwtPlot(this);
  plot->setFrameStyle(QFrame::NoFrame);
  plot->setFixedSize(250, 150);
  plot->enableTitle(false);
  plot->enableAxis(QwtPlot::yLeft, false);
  plot->enableAxis(QwtPlot::xBottom, false);
  plot->insertCurve(1, "Plot");
  plot->mapCurve(1, QwtPlot::yLeft);
  plot->setAxisScale(QwtPlot::xBottom, -7500, 7500, 500);
  plot->setAxisScale(QwtPlot::yLeft, 100, 300, 0.25);
  plot->setCurvePen(1, green);

  double temp = 0;
  plot->setCurveData(1, &temp, &temp, 1);

  layout->addWidget(plot);

  QBoxLayout *blayout = new QVBoxLayout();
  layout->addLayout(blayout);
  layout->addSpacing(10);
  blayout->addStretch(1);

  left = new QPushButton("L", this);
  left->setToggleButton(true);
  left->setFixedSize(30, 30);
  blayout->addWidget(left);
  
  right = new QPushButton("R", this);
  right->setToggleButton(true);
  right->setFixedSize(30, 30);
  blayout->addWidget(right);
  blayout->addStretch(1);
  
  layout->freeze();

  connect(left, SIGNAL(clicked()), SIGNAL(leftClicked()));
  connect(right, SIGNAL(clicked()), SIGNAL(rightClicked()));
}

void
Channel::setLeftOn(bool on)
{
  left->setOn(on);
}

void
Channel::setRightOn(bool on)
{
  right->setOn(on);
}

void
Channel::setData(int n, double x[], double y[])
{
  plot->setCurveRawData(1, x, y, n);
  plot->replot();
}
