#!/usr/bin/env python

from gnuradio import gr, eng_notation
from gnuradio import audio
from gnuradio import usrp
from gnuradio import blks
from gnuradio import tv_rx
from gnuradio.eng_option import eng_option
from gnuradio.wxgui import slider
from optparse import OptionParser
import sys
import math

from gnuradio.wxgui import stdgui, fftsink
import wx


class wfm_rx_graph (stdgui.gui_flow_graph):
    def __init__(self,frame,panel,vbox,argv):
        stdgui.gui_flow_graph.__init__ (self,frame,panel,vbox,argv)

        RF_freq = parseargs(argv[1:])
        print "RF_freq ", RF_freq
        adc_rate = 64e6

        which_side = 0
        decim = 250
        quad_rate = adc_rate / decim               # 256 kHz
        audio_decimation = 8
        audio_rate = quad_rate / audio_decimation  # 32 kHz
        
        # usrp is data source
        if which_side == 0:
            src = usrp.source_c (0, decim, 1, 0xf0f0f0f0, 0)
        else:
            src = usrp.source_c (0, decim, 1, 0xf0f0f0f2, 0)

        # set up frontend
        dboard = tv_rx.tv_rx (src, which_side)
        self.dboard = dboard

        (success, actual_freq) = dboard.set_freq(RF_freq)

        assert success
        IF_freq = -5.75e6 - RF_freq + actual_freq
        src.set_rx_freq (0, IF_freq)
        print "actual freq ", actual_freq
        print "IF freq ", IF_freq

        guts = blks.wfm_rcv (self, quad_rate, audio_decimation)
        
        # sound card as final sink
        audio_sink = audio.sink (int (audio_rate))
        
        # now wire it all together
        self.connect (src, guts)
        self.connect (guts, (audio_sink, 0))

        if 1:
            pre_demod, fft_win1 = \
                       fftsink.make_fft_sink_c (self, panel, "Pre-Demodulation",
                                                512, quad_rate)
            self.connect (src, pre_demod)
            vbox.Add (fft_win1, 4, wx.EXPAND)

        if 1:
            post_deemph, fft_win3 = \
                         fftsink.make_fft_sink_f (self, panel, "With Deemph",
                                                  512, quad_rate, -60, 20)
            self.connect (guts.deemph, post_deemph)
            vbox.Add (fft_win3, 4, wx.EXPAND)

        if 1:
            post_filt, fft_win4 = \
                       fftsink.make_fft_sink_f (self, panel, "Post Filter", 
                                                512, audio_rate, -60, 20)
            self.connect (guts.audio_filter, post_filt)
            vbox.Add (fft_win4, 4, wx.EXPAND)

        vbox.Add(slider.slider(panel, 0, 115, self.set_gain), 1, wx.ALIGN_CENTER)
        vbox.Add(slider.slider(panel, -200, 200, self.set_offset_i), 1, wx.ALIGN_CENTER)

    def set_gain (self,gain):
        self.dboard.set_gain(gain)

    def set_offset_i(self, offset):
        self.u.set_adc_offset(self.which_side*2+0, offset)

def parseargs (args):
    nargs = len (args)
    if nargs == 1:
        freq1 = float (args[0]) * 1e6
    else:
        sys.stderr.write ('usage: wfm_rcv freq1\n')
        sys.exit (1)

    return freq1

if __name__ == '__main__':
    app = stdgui.stdapp (wfm_rx_graph, "WFM RX")
    app.MainLoop ()

