/* initialization routines for Grader
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

/*
 * grader.init.c
 * Guy Albertelli II 1996
 */
#include <stdio.h>
#include <tk.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
#include <grader.h>
#include <common.h>

Tcl_Interp *gInterp;

int Grader_Init(Tcl_Interp *interp)
{
  char buf[BUFFER_SIZE],*argv;

  gInterp=interp;
  Tcl_CreateCommand( interp, "getHeader", capaGetHeader, (ClientData)NULL, 
		     (Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "getStudents", capaGetStudents, 
		     (ClientData)NULL,(Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "dateUpdate", capaDateUpdate, (ClientData)NULL, 
		     (Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "findSection", capaFindSection, 
		     (ClientData)NULL,(Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "getReportInfo", capaGetReportInfo, 
		     (ClientData)NULL,(Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "getSetSummary", capaGetSetSummary, 
		     (ClientData)NULL,(Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "getTermSummary", capaGetTermSummary,
		     (ClientData)NULL,(Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "enscriptParse", capaTclParse, (ClientData)NULL, 
		     (Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "setupGAnswer", capaSetupGAnswer,
		     (ClientData)NULL,(Tcl_CmdDeleteProc *)NULL);
  Tcl_CreateCommand( interp, "saveGAnswer", capaSaveGAnswer, 
		     (ClientData)NULL,(Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "capaExcuse", capaExcuse, (ClientData)NULL, 
		     (Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "createSummary", capaCreateSummary,
		     (ClientData)NULL,(Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "getQuestionTypes", capaGetQuestionTypes,
		     (ClientData)NULL,(Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "setHandGrade", capaSetHandGrade,
		     (ClientData)NULL,(Tcl_CmdDeleteProc *)NULL); 
  Tcl_CreateCommand( interp, "setScore", capaSetScore, 
		     (ClientData)NULL,(Tcl_CmdDeleteProc *)NULL); 

  sprintf(buf,"%s.%s",MAJORVER,GRADERMINORVER);
  Tcl_SetVar(interp,"gVer",buf,TCL_GLOBAL_ONLY);
  sprintf(buf,"Compiled on %s",COMPILE_DATE);
  Tcl_SetVar(interp,"gCompileDate",buf,TCL_GLOBAL_ONLY);

  argv=Tcl_GetVar(interp,"argv", TCL_GLOBAL_ONLY);
  if (argv!=NULL && strlen(argv) > 9 && 
      argv[0]=='-' && 
      argv[1]=='c' && 
      argv[2]=='o' && 
      argv[3]=='p' && 
      argv[4]=='y' && 
      argv[5]=='r' && 
      argv[6]=='i' && 
      argv[7]=='g' && 
      argv[8]=='h' && 
      argv[9]=='t' ) message();

  return TCL_OK;
}

int Grader_InitStandAlone(Tcl_Interp *interp)
{
  return Grader_Init(interp);
}

int Grader_SafeInit(Tcl_Interp *interp)
{
  return Grader_Init(interp);
}

