## Copyright (C) 2021 David Legland
## All rights reserved.
## 
## Redistribution and use in source and binary forms, with or without
## modification, are permitted provided that the following conditions are met:
## 
##     1 Redistributions of source code must retain the above copyright notice,
##       this list of conditions and the following disclaimer.
##     2 Redistributions in binary form must reproduce the above copyright
##       notice, this list of conditions and the following disclaimer in the
##       documentation and/or other materials provided with the distribution.
## 
## THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ''AS IS''
## AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
## IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
## ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
## ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
## DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
## SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
## CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
## OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
## OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
## 
## The views and conclusions contained in the software and documentation are
## those of the authors and should not be interpreted as representing official
## policies, either expressed or implied, of the copyright holders.

% MATGEOM Geometric Computing Toolbox
% Version 1.0 26-07-2017 .
%
%   MatGeom Provides low-level functions for geometric computing. It is
%   possible to create, display, compute intersections... of various
%   geometrical primitives, in 2D and 3D.
%
%   The library is organized into several modules:
%   geom2d              - General function in euclidean plane
%   polygons2d          - Functions operating on point lists 
%   graphs              - Manipulation of geometric graphs
%   polynomialCurves2d  - Representation of smooth polynomial curves
%   geom3d              - General function in 3D euclidean space
%   meshes3d            - Manipulation of 3D surfacic meshes
%
%   Type 'help(MODULENAME)' for further info.
%
%   To install the library, with all sub-directories, run the script
%   'setupMatGeom'.
%
%   More information on the project homepage:
%   https://github.com/mattools/matGeom
%
%   Online documentation:
%   https://github.com/mattools/matGeom
%   
% ------
% Author: David Legland
% e-mail: david.legland@inra.fr
% Created: 2011-03-21,    using Matlab 7.9.0.529 (R2009b)
% Project homepage: http://github.com/mattools/matGeom 
% http://www.pfl-cepia.inra.fr/index.php?page=geom3d
% Copyright 2011 INRA - Cepia Software Platform.

help(mfilename);
