#line 2 "fonts.c"
 /* -*- c -*- */
 /*
  * Lexer for afm files.
  *
  * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
  * Copyright (c) 1995, 96, 97, 98, 99 Akim Demaille, Miguel Santana
  *
  */

 /*
  * This file is part of a2ps.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the Free Software Foundation; either version 3, or (at your option)
  * any later version.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License
  * along with this program; see the file COPYING.  If not, write to
  * the Free Software Foundation, 59 Temple Place - Suite 330,
  * Boston, MA 02111-1307, USA.
  */

 #include <config.h>

 #include "a2ps.h"
 #include "routines.h"
 #include "message.h"
 #include "hashtab.h"
 #include "jobs.h"
 #include "pathwalk.h"
 #include "fonts.h"
 #include "psstat.h"
 #include "pair_ht.h"
 #include "dsc.h"
 #include "quotearg.h"

 /*
   What this file is in charge of?

   Its main responsabilities are:

   - to be able to provide, given a font name and an encoding vector,
   to return an unsigned int array [256] of the width of each char.

   - to be able to dump the requirements (the needed IncludeResource: font)
   so that we have a correct PS-3 file.

   - to download a font file

   To acheive this goal, the main task is reading the AFM file of a font,
   to store what it has learnt into a hash table storing any pertinent
   info read in previous AFM files. (We may need this info several times,
   and we do not want to waste time).

   This file is decomposed into several parts:

   0. Handle the fonts.map files

   1. The lexer of afm files.
   The format is simple enough so that we do not need a parser.

   2. The cells (of type struct font_info) handling.

   3. The hash table maintenance.
   This hash table is, as usually, stored in the a2ps_job so that it
   does not pollute the space, and make liba2ps still "clean".

   4. Download a font file
 */

#line 79 "fonts.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer afm_create_buffer
#define yy_delete_buffer afm_delete_buffer
#define yy_scan_buffer afm_scan_buffer
#define yy_scan_string afm_scan_string
#define yy_scan_bytes afm_scan_bytes
#define yy_init_buffer afm_init_buffer
#define yy_flush_buffer afm_flush_buffer
#define yy_load_buffer_state afm_load_buffer_state
#define yy_switch_to_buffer afm_switch_to_buffer
#define yypush_buffer_state afmpush_buffer_state
#define yypop_buffer_state afmpop_buffer_state
#define yyensure_buffer_stack afmensure_buffer_stack
#define yy_flex_debug afm_flex_debug
#define yyin afmin
#define yyleng afmleng
#define yylex afmlex
#define yylineno afmlineno
#define yyout afmout
#define yyrestart afmrestart
#define yytext afmtext
#define yywrap afmwrap
#define yyalloc afmalloc
#define yyrealloc afmrealloc
#define yyfree afmfree

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define afm_create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer afm_create_buffer
#endif

#ifdef yy_delete_buffer
#define afm_delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer afm_delete_buffer
#endif

#ifdef yy_scan_buffer
#define afm_scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer afm_scan_buffer
#endif

#ifdef yy_scan_string
#define afm_scan_string_ALREADY_DEFINED
#else
#define yy_scan_string afm_scan_string
#endif

#ifdef yy_scan_bytes
#define afm_scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes afm_scan_bytes
#endif

#ifdef yy_init_buffer
#define afm_init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer afm_init_buffer
#endif

#ifdef yy_flush_buffer
#define afm_flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer afm_flush_buffer
#endif

#ifdef yy_load_buffer_state
#define afm_load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state afm_load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define afm_switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer afm_switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define afmpush_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state afmpush_buffer_state
#endif

#ifdef yypop_buffer_state
#define afmpop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state afmpop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define afmensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack afmensure_buffer_stack
#endif

#ifdef yylex
#define afmlex_ALREADY_DEFINED
#else
#define yylex afmlex
#endif

#ifdef yyrestart
#define afmrestart_ALREADY_DEFINED
#else
#define yyrestart afmrestart
#endif

#ifdef yylex_init
#define afmlex_init_ALREADY_DEFINED
#else
#define yylex_init afmlex_init
#endif

#ifdef yylex_init_extra
#define afmlex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra afmlex_init_extra
#endif

#ifdef yylex_destroy
#define afmlex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy afmlex_destroy
#endif

#ifdef yyget_debug
#define afmget_debug_ALREADY_DEFINED
#else
#define yyget_debug afmget_debug
#endif

#ifdef yyset_debug
#define afmset_debug_ALREADY_DEFINED
#else
#define yyset_debug afmset_debug
#endif

#ifdef yyget_extra
#define afmget_extra_ALREADY_DEFINED
#else
#define yyget_extra afmget_extra
#endif

#ifdef yyset_extra
#define afmset_extra_ALREADY_DEFINED
#else
#define yyset_extra afmset_extra
#endif

#ifdef yyget_in
#define afmget_in_ALREADY_DEFINED
#else
#define yyget_in afmget_in
#endif

#ifdef yyset_in
#define afmset_in_ALREADY_DEFINED
#else
#define yyset_in afmset_in
#endif

#ifdef yyget_out
#define afmget_out_ALREADY_DEFINED
#else
#define yyget_out afmget_out
#endif

#ifdef yyset_out
#define afmset_out_ALREADY_DEFINED
#else
#define yyset_out afmset_out
#endif

#ifdef yyget_leng
#define afmget_leng_ALREADY_DEFINED
#else
#define yyget_leng afmget_leng
#endif

#ifdef yyget_text
#define afmget_text_ALREADY_DEFINED
#else
#define yyget_text afmget_text
#endif

#ifdef yyget_lineno
#define afmget_lineno_ALREADY_DEFINED
#else
#define yyget_lineno afmget_lineno
#endif

#ifdef yyset_lineno
#define afmset_lineno_ALREADY_DEFINED
#else
#define yyset_lineno afmset_lineno
#endif

#ifdef yywrap
#define afmwrap_ALREADY_DEFINED
#else
#define yywrap afmwrap
#endif

#ifdef yyalloc
#define afmalloc_ALREADY_DEFINED
#else
#define yyalloc afmalloc
#endif

#ifdef yyrealloc
#define afmrealloc_ALREADY_DEFINED
#else
#define yyrealloc afmrealloc
#endif

#ifdef yyfree
#define afmfree_ALREADY_DEFINED
#else
#define yyfree afmfree
#endif

#ifdef yytext
#define afmtext_ALREADY_DEFINED
#else
#define yytext afmtext
#endif

#ifdef yyleng
#define afmleng_ALREADY_DEFINED
#else
#define yyleng afmleng
#endif

#ifdef yyin
#define afmin_ALREADY_DEFINED
#else
#define yyin afmin
#endif

#ifdef yyout
#define afmout_ALREADY_DEFINED
#else
#define yyout afmout
#endif

#ifdef yy_flex_debug
#define afm_flex_debug_ALREADY_DEFINED
#else
#define yy_flex_debug afm_flex_debug
#endif

#ifdef yylineno
#define afmlineno_ALREADY_DEFINED
#else
#define yylineno afmlineno
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE yylex.
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-yylineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < yyleng; ++yyl )\
                    if ( yytext[yyl] == '\n' )\
                        --yylineno;\
            }while(0)
    #define YY_LINENO_REWIND_TO(dst) \
            do {\
                const char *p;\
                for ( p = yy_cp-1; p >= (dst); --p)\
                    if ( *p == '\n' )\
                        --yylineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;
int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 10
#define YY_END_OF_BUFFER 11
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[57] =
    {   0,
        0,    0,    0,    0,   11,   10,    2,   10,    8,    9,
        8,    8,    8,    8,    0,    2,    0,    0,    0,    7,
        0,    0,    0,    4,    0,    7,    0,    0,    5,    0,
        6,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        3,    0,    0,    0,    1,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    2,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    1,    2,    2,    1,    1,    1,    1,    2,
        2,    1,    2,    2,    5,    1,    2,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    1,    2,    1,
        1,    1,    1,    1,    1,    1,    7,    1,    8,    1,
        1,    1,    1,    1,    1,    1,    9,   10,    1,    1,
        1,    1,   11,    1,    1,    1,   12,   13,    1,    1,
        1,    1,    1,    1,    1,    1,   14,    1,   15,   16,

       17,    1,    1,   18,   19,    1,    1,    1,    1,   20,
        1,    1,    1,   21,   22,   23,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const YY_CHAR yy_meta[24] =
    {   0,
        1,    2,    2,    2,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1
    } ;

static const flex_int16_t yy_base[62] =
    {   0,
        0,    1,   10,   20,   83,   79,   84,    2,   84,   84,
       77,   60,   75,   65,   74,   84,    5,    1,   60,    0,
       71,   12,   68,   67,   65,    0,   65,    6,   64,   42,
       53,    7,   44,   13,   36,   21,   47,   18,   35,   31,
       28,   33,   28,   23,   29,   34,   32,   35,   23,   38,
       84,   39,   41,   40,   84,   84,   61,   63,   65,    0,
       67
    } ;

static const flex_int16_t yy_def[62] =
    {   0,
       57,   57,   58,   58,   56,   59,   56,   59,   56,   56,
       56,   56,   56,   56,   59,   56,   59,   56,   56,   60,
       56,   59,   56,   56,   56,   60,   56,   59,   56,   56,
       56,   59,   56,   59,   56,   59,   56,   59,   56,   59,
       56,   59,   56,   59,   56,   59,   56,   59,   56,   59,
       56,   59,   61,   61,   56,    0,   56,   56,   56,   56,
       56
    } ;

static const flex_int16_t yy_nxt[108] =
    {   0,
       26,   56,    7,    7,   16,   23,   24,   16,   16,   16,
        8,    8,   10,   34,   16,   16,   11,   12,   22,   13,
       16,   14,   10,   16,   17,   16,   11,   12,   32,   13,
       36,   14,   28,   16,   38,   16,   16,   16,   40,   42,
       16,   16,   55,   55,   51,   46,   49,   47,   45,   44,
       43,   41,   52,   50,   48,   39,   37,   35,   31,   33,
       53,    6,    6,    9,    9,   15,   15,   54,   54,   29,
       31,   30,   24,   29,   27,   25,   16,   21,   20,   19,
       18,   16,   56,    5,   56,   56,   56,   56,   56,   56,
       56,   56,   56,   56,   56,   56,   56,   56,   56,   56,

       56,   56,   56,   56,   56,   56,   56
    } ;

static const flex_int16_t yy_chk[108] =
    {   0,
       60,    0,    1,    2,    8,   18,   18,   17,   28,   32,
        1,    2,    3,   32,   22,   34,    3,    3,   17,    3,
       38,    3,    4,   36,    8,   44,    4,    4,   28,    4,
       34,    4,   22,   40,   36,   42,   46,   48,   38,   40,
       50,   52,   54,   53,   49,   44,   47,   45,   43,   42,
       41,   39,   50,   48,   46,   37,   35,   33,   31,   30,
       52,   57,   57,   58,   58,   59,   59,   61,   61,   29,
       27,   25,   24,   23,   21,   19,   15,   14,   13,   12,
       11,    6,    5,   56,   56,   56,   56,   56,   56,   56,
       56,   56,   56,   56,   56,   56,   56,   56,   56,   56,

       56,   56,   56,   56,   56,   56,   56
    } ;

/* Table of booleans, true if rule could match eol. */
static const flex_int32_t yy_rule_can_match_eol[11] =
    {   0,
1, 1, 0, 0, 0, 0, 0, 0, 1, 0,     };

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "fonts.l"

#line 80 "fonts.l"
/*			fonts.map handling				*/
/************************************************************************/
struct pair_htable *
fonts_map_new (void)
{
  return pair_table_new ();
}

static inline void
fonts_map_add (struct pair_htable * fonts_map,
	       const char * alias,
	       const char * key)
{
  pair_add (fonts_map, alias, key);
}

/*
 * What is the short name used for the font file corresponding
 * to FONTNAME
 */
static const char *
fonts_map_resolve_alias (struct pair_htable * fonts_map,
			 const char * fontname)
{
  char * res;
  res = pair_get (fonts_map, fontname);
  if (res)
    return res;
  else
    /* The fonts has not been declared.  Try its full name */
    return fontname;
}

/*
 * Read a sheets map file
 */
static int
load_fonts_map (struct a2ps_job * job, const char * file)
{
  return pair_table_load (job->fonts_map, file);
}

/*
 * Read the fonts.map file
 */
int
load_main_fonts_map (struct a2ps_job * job)
{
  char * file;

  /* System's */
  file = xpw_find_file (job->common.path, "fonts.map", NULL);
  load_fonts_map (job, file);
  return 1;
}

/************************************************************************/
/* Defining the structures, and lexer of afm files			*/
/************************************************************************/
/* Definition of the structure that retains the wx information */
struct wx_entry
{
  char * glyph;
  int index;
  unsigned int wx;
};

struct font_info
{
  char * key;
  struct hash_table_s * wx;
};

/*
  The following variables are global because I see no other
  means to share information with the lexer.
*/

/* Last WX and index read */
static unsigned int last_wx_read;
static int last_index_read;

/* the current font info being filled */
static struct font_info * font_info_being_parsed = NULL;

static void wx_entry_add (struct hash_table_s * table,
				  const char * glyph,
				  int the_index, unsigned int wx);

int yylex (void);

#line 934 "fonts.c"

#line 936 "fonts.c"

#define INITIAL 0
#define STATE_CHAR_METRICS 1

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput ( int c, char *buf_ptr  );
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 182 "fonts.l"


#line 1157 "fonts.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 57 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 84 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < yyleng; ++yyl )
				if ( yytext[yyl] == '\n' )
					
    yylineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 184 "fonts.l"
{ BEGIN STATE_CHAR_METRICS; }
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 186 "fonts.l"
{  /* Ignore */; }
	YY_BREAK
/* string of characters */
case 3:
YY_RULE_SETUP
#line 190 "fonts.l"
{ /* return the string */
    /* There is nothing more we want to know, but return to
    * the INITIAL state for the next call... */
    BEGIN INITIAL;
    /* Cut parsing right now (speed up) */
    yyterminate ();
  }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 198 "fonts.l"
{
    char *cursor = yytext + 3;

    last_index_read = yytext[2] - '0';
    while (*cursor)
      last_index_read = 10 * last_index_read + *cursor++ - '0';
  }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 206 "fonts.l"
{
    char *cursor = yytext + 4;

    last_index_read = yytext[3] - '0';
    while (*cursor)
      last_index_read = 10 * last_index_read + *cursor++ - '0';
    last_index_read = - last_index_read;
  }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 215 "fonts.l"
{
    char *cursor = yytext + 4;

    last_wx_read = yytext[3] - '0';
    while (*cursor)
      last_wx_read = 10 * last_wx_read + *cursor++ - '0';
  }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 223 "fonts.l"
{
    char *cursor = yytext + 2;
    wx_entry_add (font_info_being_parsed->wx, cursor,
		  last_index_read, last_wx_read);
  }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 229 "fonts.l"
{ /* Ignore */; }
	YY_BREAK
case 9:
/* rule 9 can match eol */
YY_RULE_SETUP
#line 230 "fonts.l"
{ /* Ignore */; }
	YY_BREAK

case 10:
YY_RULE_SETUP
#line 233 "fonts.l"
ECHO;
	YY_BREAK
#line 1308 "fonts.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(STATE_CHAR_METRICS):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 57 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 57 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 56);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp )
{
	char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (yy_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

    if ( c == '\n' ){
        --yylineno;
    }

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	if ( c == '\n' )
		
    yylineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    /* We do not touch yylineno unless the option is enabled. */
    yylineno =  1;
    
    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 233 "fonts.l"

int
yywrap (void)
{
  return 1;
}

/************************************************************************
 * hash tables associating a glyph name to the corresponding wx		*
 ************************************************************************/
/*
 * Basic routines
 */
static unsigned long
wx_entry_hash_1 (struct wx_entry *wx_entry)
{
  return_STRING_HASH_1 (wx_entry->glyph);
}

static unsigned long
wx_entry_hash_2 (struct wx_entry *wx_entry)
{
  return_STRING_HASH_2 (wx_entry->glyph);
}

static int
wx_entry_hash_cmp (struct wx_entry *x, struct wx_entry *y)
{
  return_STRING_COMPARE (x->glyph, y->glyph);
}

/*
 * For sorting them in the order of their index
 * (or `code', i.e. 32 for space)
 */
static int
wx_entry_hash_index_qcmp (struct wx_entry **x, struct wx_entry **y)
{
  return ((*y)->index - (*x)->index);
}

/*
 * Create the structure that stores the list of wx_entrys
 */
static struct hash_table_s *
wx_entry_table_new (void)
{
  struct hash_table_s * res;

  res = XMALLOC (struct hash_table_s);
  hash_init (res, 8,
	     (hash_func_t) wx_entry_hash_1,
	     (hash_func_t) wx_entry_hash_2,
	     (hash_cmp_func_t) wx_entry_hash_cmp);
  return res;
}

/*
 *  Add a wx_entry, with your own allocation for them.
 * It GLYPH is yet used, override its wx with WX
 */
static void
wx_entry_add (struct hash_table_s * table,
	      const char * glyph, int the_index, unsigned int wx)
{
  struct wx_entry * item, token;

  token.glyph = (char *) glyph;
  item = (struct wx_entry *) hash_find_item (table, &token);

  if (item) {
    /* This is abnormal.  There is a problem in the afm file
     * (several definition of the same glyph).
     * Since there is a bug in Ogonkify's AFM files, just shut up. */
    return;
  } else {
    item = XMALLOC (struct wx_entry);
    item->glyph = xstrdup(glyph);
    item->wx = wx;
    item->index = the_index;
    hash_insert (table, item);
  }
}

/*
 * Get the wx associated to GLYPH in TABLE
 * Return NULL upon error (this means that it is not
 * valid to enter NULL as a wx)
 */
static inline unsigned int
wx_entry_get_wx (struct hash_table_s * table,
		 const char * glyph)
{
  struct wx_entry * item, token;

  token.glyph = (char *) glyph;
  item = (struct wx_entry *) hash_find_item (table, &token);

  if (item)
    return item->wx;

  return 0;
}

/*
 * Getting the glyphs in the order of the index
 */
static inline struct wx_entry **
wx_entry_get_in_index_order (struct hash_table_s * table)
{
  return (struct wx_entry **)
    hash_dump (table, NULL,
	       (hash_cmp_func_t) wx_entry_hash_index_qcmp);
}

/************************************************************************
 * A font (not encoded)							*
 ************************************************************************/
/*
 * Basic routines
 */
static unsigned long
font_info_hash_1 (struct font_info *font_info)
{
  return_STRING_HASH_1 (font_info->key);
}

static unsigned long
font_info_hash_2 (struct font_info *font_info)
{
  return_STRING_HASH_2 (font_info->key);
}

static int
font_info_hash_cmp (struct font_info *x, struct font_info *y)
{
  return_STRING_COMPARE (x->key, y->key);
}

/*
 * Create the structure that stores the list of font_infos
 */
struct hash_table_s *
font_info_table_new (void)
{
  struct hash_table_s * res = XMALLOC (struct hash_table_s);

  hash_init (res, 8,
	     (hash_func_t) font_info_hash_1,
	     (hash_func_t) font_info_hash_2,
	     (hash_cmp_func_t) font_info_hash_cmp);
  return res;
}

/*
 * Create and return a new font_info cell, with key = KEY
 */
static inline struct font_info *
font_info_new (const char * key)
{
  struct font_info * res = XMALLOC (struct font_info);

  res->key = xstrdup (key);
  res->wx = wx_entry_table_new ();

  return res;
}

/*
 * It need JOB for the lib path, to look for the afm file.
 */
static void
font_info_finalize (struct a2ps_job * job, struct font_info * font)
{
  char * file;
  const char * filename;
  FILE * stream;

  yylineno = 0;

  /* Find its AFM file: first resolve its font file name */
  filename = fonts_map_resolve_alias (job->fonts_map, font->key);
  file = xpw_find_file (job->common.path, filename, ".afm");

  /* Go for it */
  message (msg_font | msg_file | msg_parse,
	   (stderr, "Parsing file `%s'\n", file));
  stream = xrfopen (file);

  /* Prepare the global var that encloses the hash table.
   * WARNING: this is not reentrant... */
  font_info_being_parsed = font;
  yyrestart (stream);
  yylex ();

  fclose (stream);
}

/*
 * Create a font_info for font KEY and store it in the hash table
 * And register in the DSC requirements
 */
void
font_info_add (struct a2ps_job * job, const char * key)
{
  struct font_info * font;

  /* Create, fill and store the font_info structure */
  font = font_info_new (key);
  font_info_finalize (job, font);
  hash_insert (job->font_infos, font);

  /* Register the font for the DSC */
  add_required_font (job, key);
}

/*
 * Retreive.
 */
static inline struct font_info *
font_info_get (struct a2ps_job * job, const char * key)
{
  struct font_info token, * res;

  token.key = (char *) key;
  res = (struct font_info *) hash_find_item (job->font_infos, &token);
  if (!res) {/* Require loading of the font's info */
    font_info_add (job, key);
    res = (struct font_info *) hash_find_item (job->font_infos, &token);
  }
  return res;
}

/*
 * For instance Symbol is not to reencode => don't put it
 * in the encoding specific dictionary
 */
int
font_is_to_reencode (PARAM_UNUSED struct a2ps_job * job, const char * key)
{
  return !STREQ (key, "Symbol");
}

/*
 * Return a WX array that reflects the font KEY according to
 * the encoding VECTOR
 */
void
font_info_get_wx_for_vector (struct a2ps_job * job,
			     const char * key,
			     char * vector [256],
			     unsigned int * wx)
{
  struct font_info * font_info = font_info_get (job, key);
  struct wx_entry ** sorted_by_index;
  int c, the_index;

  if (font_is_to_reencode (job, key))
    {
      /* This is a regular font, such as Courier, which needs to
       * be recoded according to the current char set */
      for (c = 0 ; c < 256 ; c++)
	wx [c] = wx_entry_get_wx (font_info->wx, vector [c]);
    }
  else
    {
      /* This is a font such as Symbol, which has its own char set */
      for (c = 0 ; c < 256 ; c++)
	wx [c] = 0;
      sorted_by_index = wx_entry_get_in_index_order (font_info->wx);
      for (c = 0 ; sorted_by_index [c] ; c++)
	{
	  the_index = sorted_by_index [c]->index;
	  if (0 <= the_index && the_index < 256)
	    wx [the_index] = sorted_by_index [c]->wx;
	}
    }
}

/*
 * A font exists iff a KEY.afm file exists
 */
int
font_exists (struct a2ps_job * job, const char * key)
{
  const char * filename;

  filename = fonts_map_resolve_alias (job->fonts_map, key);
  return pw_file_exists_p (job->common.path, filename, ".afm");
}

/*
 * Dump the setup of all the fonts not to be reencoded
 */
void
font_info_table_dump_special_font_setup (FILE * stream,
					 struct a2ps_job * job)
{
  struct font_info ** fonts;
  int i;

  fonts = (struct font_info **)
    hash_dump (job->font_infos, NULL, NULL);

  for (i = 0 ; fonts [i] ; i++)
    if (!font_is_to_reencode (job, fonts [i]->key))
      fprintf (stream, "/f%s /%s findfont def\n",
	       fonts [i]->key, fonts [i]->key);
}

/************************************************************************
 * Downloading of PostScript font					*
 ************************************************************************/
/*
   This is according to
   << Supporting Downloadable PostScript Language Fonts >>
   by Adobe
 */

/*
 * Read and dump a segment
 * Returns:
 * - 0 something was read
 * - 1 nothing had to be read
 * - 2 an error occured
 */
static inline int
binary_font_dump_segment (FILE * in, FILE * out)
{
  enum segment_type
  {
    ascii = 1, binary = 2, end_of_file = 3
  };
  enum segment_type segment_type;
  int magic;
  size_t length, read_length, length_to_read;
  char buf [BUFSIZ];

  magic = getc (in);

  if (magic != 128)	/* This is most weird! */
    return 1;

  /* The type of the segment */
  segment_type = (enum segment_type) getc (in);

  /* Four bytes for the size of the segment */
  length  = getc (in);
  length += getc (in) * 256;
  length += getc (in) * 256 * 256;
  length += getc (in) * 256 * 256 * 256;

  switch (segment_type)
    {
    case ascii:
      while (length)
	{
	  size_t i;
	  /* Don't read more than the length of this segment */
	  length_to_read = length < sizeof (buf) ? length : sizeof (buf);
	  read_length = fread (buf, sizeof (char), length_to_read, in);
	  if (!read_length)
	    /* Error */
	    return 2;
	  length -= read_length;
	  for (i= 0 ; i < read_length ; i++)
	    switch (buf [i])
	      {
	      case '\r':	/* eerk: Mac eol. */
		putc ('\n', out);
		break;
	      default:
		putc (buf [i], out);
	      }
	}
      break;

    case binary:
      while (length)
	{
	  size_t i;
	  /* Don't read more than the length of this segment */
	  length_to_read = length < sizeof (buf) ? length : sizeof (buf);
	  read_length = fread (buf, sizeof (char), length_to_read, in);
	  if (!read_length)
	    /* Error */
	    return 2;
	  length -= read_length;
	  for (i = 0 ; i < read_length ; i++)
	    {
	      fprintf (out, "%02X", buf [i]);
	      /* Don't make too long lines */
	      if (!((i + 1) % 32))
		putc ('\n', out);
	    }
	}
      break;

    case end_of_file:
      /* Nothing more to do */
      return 1;

    default:
      abort ();
    }
  /* Finish with an eol (because it does not look good without */
  putc ('\n', out);
  return 0;
}

/*
 * Dump onto OUT a binary segment from IN
 * Returns true if success, false if error occured
 */
static inline int
binary_font_dump (FILE * in, FILE * out)
{
  int status;

  while (!(status = binary_font_dump_segment (in, out)))
    /* Again */;

  if (status == 2)
    return false;
  else
    return true;
}

/*
 * Put onto OUT the description of the font file IN
 * Returns true if success, false if error occured
 */
static int
internal_font_file_dump (FILE * in, FILE * out)
{
  int c;

  c = getc (in);
  ungetc (c, in);
  if (c == 128)
    {
      /* This a font file a` la IBM-PC */
      return binary_font_dump (in, out);
    }
  else
    {
      streams_copy (in, out);
      return true;
    }
}

/*
 * Dump the font definition files for the fonts
 */
void
dump_fonts (FILE * stream, struct a2ps_job * job)
{
  FILE * fp;
  char * filename;
  const char * fontname;
  char ** fonts;
  int i;

  /* Get all the fonts used that need to be downloaded
  * (Care: there can be 0) */
  fonts = required_fonts_get (job);
  if (!fonts)
    return;

  for (i = 0 ; fonts [i] ; i++)
    {
      /* This font is not known: include its definition file */
      fontname = fonts_map_resolve_alias (job->fonts_map, fonts [i]);

      /* First, find where is the correct file.
       * pfb first, then pfa, finaly gsf. */
      filename = pw_find_file (job->common.path, fontname, ".pfb");
      if (!filename)
	filename = pw_find_file (job->common.path, fontname, ".pfa");
      if (!filename)
	filename = pw_find_file (job->common.path, fontname, ".gsf");
      if (!filename)
	{
	  /* Repeat the same message to avoid too much work to
             translators */
	  char * file;
	  astrcat2 (file, fontname, ".pfb");
	  error (0, 0, _("cannot find file `%s'"), quotearg (file));
	  strcat2 (file, fontname, ".pfa");
	  error (0, 0, _("cannot find file `%s'"), quotearg (file));
	  strcat2 (file, fontname, ".gsf");
	  error (1, 0, _("cannot find file `%s'"), quotearg (file));
	}

      /* Open it */
      fp = xrfopen (filename);

      /* Dump it */
      message (msg_font | msg_file, (stderr, "Dumping file `%s'\n", filename));
      fprintf (stream, "%%%%BeginResource: font %s\n", fonts [i]);
      if (!internal_font_file_dump (fp, stream))
	error (1, 0, "bad PostScript font file `%s'\n", filename);
      fprintf (stream, "%%%%EndResource\n");

      /* release */
      fclose (fp);
    }
}

