#include "available-stubs.h"

#include <nlist.h>
#include "checker_api.h"

/* compiled from: . */
#ifdef HAVE_nlist
/* From `/usr/include/nlist.h:27'.  */
int chkr_stub_nlist (const char *filename, struct nlist *nl)
     __asm__ (CHKR_PREFIX ("nlist"));
int
chkr_stub_nlist  (const char *filename, struct nlist *nl)
{
  struct nlist *nl1;
  int res;

  stubs_chkr_check_str (filename, CHKR_RO, "filename");
  for (nl1 = nl; ; nl1++)
    {
      stubs_chkr_check_addr (&(nl1->n_name), sizeof (nl1->n_name),
			     CHKR_RO, "n_name");
      stubs_chkr_check_addr (&(nl1->n_value), sizeof (nl1->n_value),
			     CHKR_WO, "n_value");
      stubs_chkr_check_addr (&(nl1->n_scnum), sizeof (nl1->n_scnum),
			     CHKR_WO, "n_scnum");
      stubs_chkr_check_addr (&(nl1->n_type), sizeof (nl1->n_type),
			     CHKR_WO, "n_type");
      stubs_chkr_check_addr (&(nl1->n_sclass), sizeof (nl1->n_sclass),
			     CHKR_WO, "n_sclass");
      stubs_chkr_check_addr (&(nl1->n_numaux), sizeof (nl1->n_numaux),
			     CHKR_WO, "n_numaux");
      if (nl1->n_name)
	stubs_chkr_check_str (nl1->n_name, CHKR_RO, "n_name");
      else
	break;
    }

  return nlist (filename, nl);
}
#endif /* HAVE_nlist */

