#include "available-stubs.h"

#include <stdio.h>
#include <sys/mnttab.h>
#include "checker_api.h"

void stubs_chkr_check_struct_mnttab (const struct mnttab *ent, int right);
void stubs_chkr_check_struct_mnttab2 (const struct mnttab *ent, int right);
void stubs_chkr_set_right_struct_mnttab (struct mnttab *ent, int right);

#ifdef HAVE_chkr_func
void
stubs_chkr_check_struct_mnttab (const struct mnttab *ent, int right)
{
  stubs_chkr_check_addr (&ent->mnt_special, sizeof (char *), right,
			 "ent->mnt_special");
  stubs_chkr_check_addr (&ent->mnt_mountp, sizeof (char *), right,
			 "ent->mnt_mountp");
  stubs_chkr_check_addr (&ent->mnt_fstype, sizeof (char *), right,
			 "ent->mnt_fstype");
  stubs_chkr_check_addr (&ent->mnt_mntopts, sizeof (char *), right,
			 "ent->mnt_mntopts");
  stubs_chkr_check_addr (&ent->mnt_time, sizeof (char *), right,
			 "ent->mnt_time");
}

void
stubs_chkr_check_struct_mnttab2 (const struct mnttab *ent, int right)
{
  if (ent->mnt_special)
    stubs_chkr_check_str (ent->mnt_special, right, "ent->mnt_special");
  if (ent->mnt_mountp)
    stubs_chkr_check_str (ent->mnt_mountp, right, "ent->mnt_mountp");
  if (ent->mnt_fstype)
    stubs_chkr_check_str (ent->mnt_fstype, right, "ent->mnt_fstype");
  if (ent->mnt_mntopts)
    stubs_chkr_check_str (ent->mnt_mntopts, right, "ent->mnt_mntopts");
  if (ent->mnt_time)
    stubs_chkr_check_str (ent->mnt_time, right, "ent->mnt_time");
}

void
stubs_chkr_set_right_struct_mnttab (struct mnttab *ent, int right)
{
  stubs_chkr_set_right (ent->mnt_special, strlen (ent->mnt_special)+1, right);
  stubs_chkr_set_right (ent->mnt_mountp, strlen (ent->mnt_mountp)+1, right);
  stubs_chkr_set_right (ent->mnt_fstype, strlen (ent->mnt_fstype)+1, right);
  stubs_chkr_set_right (ent->mnt_mntopts, strlen (ent->mnt_mntopts)+1, right);
  stubs_chkr_set_right (ent->mnt_time, sizeof (ent->mnt_time), right);
}
#endif /* HAVE_chkr_func  */

/* compiled from: . */
#ifdef HAVE_getmntent
/* From `/usr/include/sys/mnttab.h:46'.  */
int chkr_stub_getmntent (FILE *fp, struct mnttab *mp)
     __asm__ (CHKR_PREFIX ("getmntent"));
int
chkr_stub_getmntent (FILE *fp, struct mnttab *mp)
{
  int res;
  stubs_chkr_check_struct_mnttab (mp, CHKR_WO);
  stubs_chkr_check_addr (fp, sizeof (FILE), CHKR_TW, "fp");

  res = getmntent (fp, mp);
  if (res == 0)
    stubs_chkr_set_right_struct_mnttab (mp, CHKR_RW);
  return res;
}
#endif /* HAVE_getmntent */

#ifdef HAVE_getmntany
/* From `/usr/include/sys/mnttab.h:47'.  */
int chkr_stub_getmntany (FILE *fp, struct mnttab *mp, struct mnttab *mpref)
     __asm__ (CHKR_PREFIX ("getmntany"));
int
chkr_stub_getmntany (FILE *fp, struct mnttab *mp, struct mnttab *mpref)
{
  int res;

  stubs_chkr_check_addr (fp, sizeof (FILE), CHKR_TW, "fp");
  stubs_chkr_check_struct_mnttab (mp, CHKR_WO);
  stubs_chkr_check_struct_mnttab (mpref, CHKR_RO);
  stubs_chkr_check_struct_mnttab2 (mpref, CHKR_RO);

  res = getmntany (fp, mp, mpref);
  if (res == 0)
    stubs_chkr_set_right_struct_mnttab (mp, CHKR_RW);
  return res;
}
#endif /* HAVE_getmntany */

#ifdef HAVE_hasmntopt
/* From `/usr/include/sys/mnttab.h:48'.  */
char *chkr_stub_hasmntopt (struct mnttab *mnt, char *opt)
     __asm__ (CHKR_PREFIX ("hasmntopt"));
char *
chkr_stub_hasmntopt (struct mnttab *mnt, char *opt)
{
  stubs_chkr_check_struct_mnttab (mnt, CHKR_RO);
  stubs_chkr_check_struct_mnttab2 (mnt, CHKR_RO);
  stubs_chkr_check_str (opt, CHKR_RO, "opt");
  return hasmntopt (mnt, opt);
}
#endif /* HAVE_hasmntopt */

