/* Calculate the size of physical memory.
   Copyright 2000 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* Written by Paul Eggert.  */

#if HAVE_CONFIG_H
# include <config.h>
#endif

#include "physmem.h"

#if HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Return the total amount of physical memory.  */
double
physmem_total (void)
{
#if defined _SC_PHYS_PAGES && defined _SC_PAGESIZE
  double pages = sysconf (_SC_PHYS_PAGES);
  double pagesize = sysconf (_SC_PAGESIZE);
  if (0 <= pages && 0 <= pagesize)
    return pages * pagesize;
#endif

  /* Guess 64 MB.  It's probably an older host, so guess small.  */
  return 64 * 1024 * 1024;
}

/* Return the amount of physical memory available.  */
double
physmem_available (void)
{
#if defined _SC_AVPHYS_PAGES && defined _SC_PAGESIZE
  double pages = sysconf (_SC_AVPHYS_PAGES);
  double pagesize = sysconf (_SC_PAGESIZE);
  if (0 <= pages && 0 <= pagesize)
    return pages * pagesize;
#endif

  /* Guess 25% of physical memory.  */
  return physmem_total () / 4;
}
