/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.io;

import gnu.prolog.io.OperatorSet;
import gnu.prolog.io.ParseException;
import gnu.prolog.io.ReadOptions;
import gnu.prolog.io.parser.gen.TermParser;
import gnu.prolog.io.parser.gen.TokenMgrError;
import gnu.prolog.term.Term;
import gnu.prolog.vm.Environment;
import java.io.FilterReader;
import java.io.Reader;
import java.io.StringReader;

public class TermReader
extends FilterReader {
    protected static OperatorSet defaultOperatorSet = new OperatorSet();
    TermParser parser;

    public TermReader(Reader r, int line, int col, Environment environment) {
        super(r);
        this.parser = new TermParser(r, line, col, environment);
    }

    public TermReader(Reader r, Environment environment) {
        this(r, 1, 1, environment);
    }

    public Term readTerm(ReadOptions options) throws ParseException {
        try {
            return this.parser.readTerm(options);
        }
        catch (gnu.prolog.io.parser.gen.ParseException ex) {
            throw new ParseException(ex);
        }
        catch (TokenMgrError ex) {
            throw new ParseException(ex);
        }
    }

    public static Term stringToTerm(ReadOptions options, String str, Environment environment) throws ParseException {
        StringReader srd = new StringReader(str);
        TermReader trd = new TermReader(srd, environment);
        return trd.readTermEof(options);
    }

    public static Term stringToTerm(String str, Environment environment) throws ParseException {
        StringReader srd = new StringReader(str);
        TermReader trd = new TermReader(srd, environment);
        return trd.readTermEof();
    }

    public Term readTermEof(ReadOptions options) throws ParseException {
        try {
            return this.parser.readTermEof(options);
        }
        catch (gnu.prolog.io.parser.gen.ParseException ex) {
            throw new ParseException(ex);
        }
        catch (TokenMgrError ex) {
            throw new ParseException(ex);
        }
    }

    public Term readTerm(OperatorSet set) throws ParseException {
        ReadOptions options = new ReadOptions();
        options.operatorSet = set;
        return this.readTerm(options);
    }

    public Term readTermEof(OperatorSet set) throws ParseException {
        ReadOptions options = new ReadOptions();
        options.operatorSet = set;
        return this.readTermEof(options);
    }

    public Term readTerm() throws ParseException {
        return this.readTerm(defaultOperatorSet);
    }

    public Term readTermEof() throws ParseException {
        return this.readTermEof(defaultOperatorSet);
    }

    public int getCurrentLine() {
        return this.parser.getCurrentLine();
    }

    public int getCurrentColumn() {
        return this.parser.getCurrentColumn();
    }
}

