/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.io.parser;

import gnu.prolog.io.Operator;
import gnu.prolog.io.OperatorSet;
import gnu.prolog.io.parser.TermParserUtils;
import gnu.prolog.io.parser.gen.Token;

public class NameToken
extends Token {
    public Operator fxOp;
    public Operator xfOp;
    public String value;

    public String getValue() {
        if (this.value == null) {
            this.value = this.image.charAt(0) == '\'' ? TermParserUtils.convertQuotedString(this.image, '\'') : this.image;
        }
        return this.value;
    }

    public final boolean isOperator(OperatorSet set) {
        this.getValue();
        if (this.fxOp == null) {
            this.fxOp = set.lookupFx(this.value);
        }
        if (this.xfOp == null) {
            this.xfOp = set.lookupXf(this.value);
        }
        return this.fxOp != Operator.nonOperator || this.xfOp != Operator.nonOperator;
    }

    public final boolean isNonOperator(OperatorSet set) {
        return !this.isOperator(set);
    }

    public final boolean isOperator(OperatorSet set, int priority, int specifier) {
        this.getValue();
        switch (specifier) {
            case 0: 
            case 1: {
                if (this.fxOp == null) {
                    this.fxOp = set.lookupFx(this.value);
                }
                return this.fxOp != null && this.fxOp.priority == priority && this.fxOp.specifier == specifier;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (this.xfOp == null) {
                    this.xfOp = set.lookupXf(this.value);
                }
                return this.xfOp != null && this.xfOp.priority == priority && this.xfOp.specifier == specifier;
            }
        }
        throw new RuntimeException("invalid specifier");
    }

    public final boolean isFxOperator(OperatorSet set, int priority) {
        return this.isOperator(set, priority, 0);
    }

    public final boolean isFyOperator(OperatorSet set, int priority) {
        return this.isOperator(set, priority, 1);
    }

    public final boolean isXfxOperator(OperatorSet set, int priority) {
        return this.isOperator(set, priority, 2);
    }

    public final boolean isXfyOperator(OperatorSet set, int priority) {
        return this.isOperator(set, priority, 3);
    }

    public final boolean isYfxOperator(OperatorSet set, int priority) {
        return this.isOperator(set, priority, 4);
    }

    public final boolean isXfOperator(OperatorSet set, int priority) {
        return this.isOperator(set, priority, 5);
    }

    public final boolean isYfOperator(OperatorSet set, int priority) {
        return this.isOperator(set, priority, 6);
    }
}

